<?php 
defined('MOODLE_INTERNAL') || die();
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 4.8.3
*/function
adminer_errors($Ec,$Gc){return!!preg_match('~^(Trying to access array offset on value of type null|Undefined array key)~',$Gc);}error_reporting(6135);set_error_handler('adminer_errors',E_WARNING);$cd=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($cd||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$Li=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($Li)$$X=$Li;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection(){global$g;return$g;}function
adminer(){global$b;return$b;}function
version(){global$ia;return$ia;}function
idf_unescape($u){if(!preg_match('~^[`\'"[]~',$u))return$u;$se=substr($u,-1);return
str_replace($se.$se,$se,substr($u,1,-1));}function
escape_string($X){return
substr(q($X),1,-1);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes($wg,$cd=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($y,$X)=each($wg)){foreach($X
as$je=>$W){unset($wg[$y][$je]);if(is_array($W)){$wg[$y][stripslashes($je)]=$W;$wg[]=&$wg[$y][stripslashes($je)];}else$wg[$y][stripslashes($je)]=($cd?$W:stripslashes($W));}}}}function
bracket_escape($u,$Oa=false){static$xi=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($u,($Oa?array_flip($xi):$xi));}function
min_version($cj,$Fe="",$h=null){global$g;if(!$h)$h=$g;$qh=$h->server_info;if($Fe&&preg_match('~([\d.]+)-MariaDB~',$qh,$C)){$qh=$C[1];$cj=$Fe;}return(version_compare($qh,$cj)>=0);}function
charset($g){return(min_version("5.5.3",0,$g)?"utf8mb4":"utf8");}function
script($Ah,$wi="\n"){return"<script".nonce().">$Ah</script>$wi";}function
script_src($Qi){return"<script src='".h($Qi)."'".nonce()."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($P){return
str_replace("\0","&#0;",htmlspecialchars($P,ENT_QUOTES,'utf-8'));}function
nl_br($P){return
str_replace("\n","<br>",$P);}function
checkbox($D,$Y,$eb,$oe="",$wf="",$ib="",$pe=""){$I="<input type='checkbox' name='$D' value='".h($Y)."'".($eb?" checked":"").($pe?" aria-labelledby='$pe'":"").">".($wf?script("qsl('input').onclick = function () { $wf };",""):"");return($oe!=""||$ib?"<label".($ib?" class='$ib'":"").">$I".h($oe)."</label>":$I);}function
optionlist($Cf,$jh=null,$Ui=false){$I="";foreach($Cf
as$je=>$W){$Df=array($je=>$W);if(is_array($W)){$I.='<optgroup label="'.h($je).'">';$Df=$W;}foreach($Df
as$y=>$X)$I.='<option'.($Ui||is_string($y)?' value="'.h($y).'"':'').(($Ui||is_string($y)?(string)$y:$X)===$jh?' selected':'').'>'.h($X);if(is_array($W))$I.='</optgroup>';}return$I;}function
html_select($D,$Cf,$Y="",$vf=true,$pe=""){if($vf)return"<select name='".h($D)."'".($pe?" aria-labelledby='$pe'":"").">".optionlist($Cf,$Y)."</select>".(is_string($vf)?script("qsl('select').onchange = function () { $vf };",""):"");$I="";foreach($Cf
as$y=>$X)$I.="<label><input type='radio' name='".h($D)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>";return$I;}function
select_input($Ja,$Cf,$Y="",$vf="",$ig=""){$bi=($Cf?"select":"input");return"<$bi$Ja".($Cf?"><option value=''>$ig".optionlist($Cf,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$ig'>").($vf?script("qsl('$bi').onchange = $vf;",""):"");}function
confirm($Pe="",$kh="qsl('input')"){return
script("$kh.onclick = function () { return confirm('".($Pe?js_escape($Pe):lang(0))."'); };","");}function
print_fieldset($t,$xe,$fj=false){echo"<fieldset><legend>","<a href='#fieldset-$t'>$xe</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$t');",""),"</legend>","<div id='fieldset-$t'".($fj?"":" class='hidden'").">\n";}function
generate_linksbar($A){$Ae="<p class='links'>";foreach($A
as$y=>$_){if($y!==key(array_keys($A)))$Ae.="<span class='separator'>|</span>";$Ae.=$_;}$Ae.="</p>";return$Ae;}function
bold($Va,$ib=""){return($Va?" class='active $ib'":($ib?" class='$ib'":""));}function
odd($I=' class="odd"'){static$s=0;if(!$I)$s=-1;return($s++%2?$I:'');}function
js_escape($P){return
addcslashes($P,"\r\n'\\/");}function
json_row($y,$X=null){static$dd=true;if($dd)echo"{";if($y!=""){echo($dd?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?'"'.addcslashes($X,"\r\n\"\\/").'"':'null');$dd=false;}else{echo"\n}\n";$dd=true;}}function
ini_bool($Wd){$X=ini_get($Wd);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$I;if($I===null)$I=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$I;}function
set_password($bj,$M,$V,$F){$_SESSION["pwds"][$bj][$M][$V]=($_COOKIE["adminer_key"]&&is_string($F)?array(encrypt_string($F,$_COOKIE["adminer_key"])):$F);}function
get_password(){$I=get_session("pwds");if(is_array($I))$I=($_COOKIE["adminer_key"]?decrypt_string($I[0],$_COOKIE["adminer_key"]):false);return$I;}function
q($P){global$g;return$g->quote($P);}function
get_vals($G,$d=0){global$g;$I=array();$H=$g->query($G);if(is_object($H)){while($J=$H->fetch_row())$I[]=$J[$d];}return$I;}function
get_key_vals($G,$h=null,$th=true){global$g;if(!is_object($h))$h=$g;$I=array();$H=$h->query($G);if(is_object($H)){while($J=$H->fetch_row()){if($th)$I[$J[0]]=$J[1];else$I[]=$J[0];}}return$I;}function
get_rows($G,$h=null,$m="<p class='error'>"){global$g;$zb=(is_object($h)?$h:$g);$I=array();$H=$zb->query($G);if(is_object($H)){while($J=$H->fetch_assoc())$I[]=$J;}elseif(!$H&&!is_object($h)&&$m&&defined("PAGE_HEADER"))echo$m.adminer_error()."\n";return$I;}function
unique_array($J,$w){foreach($w
as$v){if(preg_match("~PRIMARY|UNIQUE~",$v["type"])){$I=array();foreach($v["columns"]as$y){if(!isset($J[$y]))continue
2;$I[$y]=$J[$y];}return$I;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$C))return$C[1].idf_escape(idf_unescape($C[2])).$C[3];return
idf_escape($y);}function
where($Z,$o=array()){global$g,$x;$I=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,1);$d=escape_key($y);$I[]=$d.($x=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):($x=="mssql"?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($o[$y],q($X))));if($x=="sql"&&preg_match('~char|text~',$o[$y]["type"])&&preg_match("~[^ -@]~",$X))$I[]="$d = ".q($X)." COLLATE ".charset($g)."_bin";}foreach((array)$Z["null"]as$y)$I[]=escape_key($y)." IS NULL";return
implode(" AND ",$I);}function
where_check($X,$o=array()){parse_str($X,$cb);remove_slashes(array(&$cb));return
where($cb,$o);}function
where_link($s,$d,$Y,$yf="="){return"&where%5B$s%5D%5Bcol%5D=".urlencode($d)."&where%5B$s%5D%5Bop%5D=".urlencode(($Y!==null?$yf:"IS NULL"))."&where%5B$s%5D%5Bval%5D=".urlencode($Y);}function
convert_fields($e,$o,$L=array()){$I="";foreach($e
as$y=>$X){if($L&&!in_array(idf_escape($y),$L))continue;$Ha=convert_field($o[$y]);if($Ha)$I.=", $Ha AS ".idf_escape($y);}return$I;}function
cookie($D,$Y,$_e=2592000){global$ba;return
header("Set-Cookie: $D=".urlencode($Y).($_e?"; expires=".gmdate("D, d M Y H:i:s",time()+$_e)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).($ba?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
restart_session(){if(!ini_bool("session.use_cookies"))@session_start();}function
stop_session($id=false){$Ti=ini_bool("session.use_cookies");if(!$Ti||$id){session_write_close();if($Ti&&@ini_set("session.use_cookies",false)===false)@session_start();}}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($bj,$M,$V,$k=null){global$mc;preg_match('~([^?]*)\??(.*)~',remove_from_uri(implode("|",array_keys($mc))."|username|".($k!==null?"db|":"").session_name()),$C);return"$C[1]?".(sid()?SID."&":"").($bj!="server"||$M!=""?urlencode($bj)."=".urlencode($M)."&":"")."username=".urlencode($V).($k!=""?"&db=".urlencode($k):"").($C[2]?"&$C[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
adminer_redirect($B,$Pe=null){if($Pe!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($B!==null?$B:$_SERVER["REQUEST_URI"]))][]=$Pe;}if($B!==null){if($B=="")$B=".";header("Location: $B");exit;}}function
query_redirect($G,$B,$Pe,$Gg=true,$Lc=true,$Vc=false,$ji=""){global$g,$m,$b;if($Lc){$Ih=microtime(true);$Vc=!$g->query($G);$ji=adminer_format_time($Ih);}$Dh="";if($G)$Dh=$b->messageQuery($G,$ji,$Vc);if($Vc){$m=adminer_error().$Dh.script("messagesPrint();");return
false;}if($Gg)adminer_redirect($B,$Pe.$Dh);return
true;}function
queries($G){global$g;static$Ag=array();static$Ih;if(!$Ih)$Ih=microtime(true);if($G===null)return
array(implode("\n",$Ag),adminer_format_time($Ih));$Ag[]=(preg_match('~;$~',$G)?"DELIMITER ;;\n$G;\nDELIMITER ":$G).";";return$g->query($G);}function
apply_queries($G,$S,$Hc='table'){foreach($S
as$Q){if(!queries("$G ".$Hc($Q)))return
false;}return
true;}function
queries_redirect($B,$Pe,$Gg){list($Ag,$ji)=queries(null);return
query_redirect($Ag,$B,$Pe,$Gg,false,!$Gg,$ji);}function
adminer_format_time($Ih){return
lang(1,max(0,microtime(true)-$Ih));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($Tf=""){return
substr(preg_replace("~(?<=[?&])($Tf".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
pagination($E,$Qb){return" ".($E==$Qb?$E+1:'<a href="'.h(remove_from_uri("page").($E?"&page=$E".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($E+1)."</a>");}function
get_file($y,$Zb=false){$bd=$_FILES[$y];if(!$bd)return
null;foreach($bd
as$y=>$X)$bd[$y]=(array)$X;$I='';foreach($bd["error"]as$y=>$m){if($m)return$m;$D=$bd["name"][$y];$ri=$bd["tmp_name"][$y];$Eb=file_get_contents($Zb&&preg_match('~\.gz$~',$D)?"compress.zlib://$ri":$ri);if($Zb){$Ih=substr($Eb,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$Ih,$Mg))$Eb=iconv("utf-16","utf-8",$Eb);elseif($Ih=="\xEF\xBB\xBF")$Eb=substr($Eb,3);$I.=$Eb."\n\n";}else$I.=$Eb;}return$I;}function
upload_error($m){$Me=($m==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($m?lang(2).($Me?" ".lang(3,$Me):""):lang(4));}function
repeat_pattern($fg,$ye){return
str_repeat("$fg{0,65535}",$ye/65535)."$fg{0,".($ye%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
shorten_utf8($P,$ye=80,$Ph=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$ye).")($)?)u",$P,$C))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$ye).")($)?)",$P,$C);return
h($C[1]).$Ph.(isset($C[2])?"":"<i>…</i>");}function
format_number($X){return
strtr(number_format($X,0,".",lang(5)),preg_split('~~u',lang(6),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~[^a-z0-9_]~i','-',$X);}function
hidden_fields($wg,$Ld=array(),$og=''){$I=false;foreach($wg
as$y=>$X){if(!in_array($y,$Ld)){if(is_array($X))hidden_fields($X,array(),$y);else{$I=true;echo'<input type="hidden" name="'.h($og?$og."[$y]":$y).'" value="'.h($X).'">';}}}return$I;}function
hidden_fields_get(){echo(sid()?'<input type="hidden" name="'.session_name().'" value="'.h(session_id()).'">':''),(SERVER!==null?'<input type="hidden" name="'.DRIVER.'" value="'.h(SERVER).'">':""),'<input type="hidden" name="username" value="'.h($_GET["username"]).'">';}function
table_status1($Q,$Wc=false){$I=table_status($Q,$Wc);return($I?$I:array("Name"=>$Q));}function
column_foreign_keys($Q){global$b;$I=array();foreach($b->foreignKeys($Q)as$q){foreach($q["source"]as$X)$I[$X][]=$q;}return$I;}function
enum_input($T,$Ja,$n,$Y,$Ac=null){global$b;preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$He);$I=($Ac!==null?"<label><input type='$T'$Ja value='$Ac'".((is_array($Y)?in_array($Ac,$Y):$Y===0)?" checked":"")."><i>".lang(7)."</i></label>":"");foreach($He[1]as$s=>$X){$X=stripcslashes(str_replace("''","'",$X));$eb=(is_int($Y)?$Y==$s+1:(is_array($Y)?in_array($s+1,$Y):$Y===$X));$I.=" <label><input type='$T'$Ja value='".($s+1)."'".($eb?' checked':'').'>'.h($b->editVal($X,$n)).'</label>';}return$I;}function
input($n,$Y,$r){global$U,$b,$x;$D=h(bracket_escape($n["field"]));echo"<td class='function'>";if(is_array($Y)&&!$r){$Fa=array($Y);if(version_compare(PHP_VERSION,5.4)>=0)$Fa[]=JSON_PRETTY_PRINT;$Y=call_user_func_array('json_encode',$Fa);$r="json";}$Qg=($x=="mssql"&&$n["auto_increment"]);if($Qg&&!$_POST["save"])$r=null;$rd=(isset($_GET["select"])||$Qg?array("orig"=>lang(8)):array())+$b->editFunctions($n);$Ja=" name='fields[$D]'";if($n["type"]=="enum")echo
h($rd[""])."<td>".$b->editInput($_GET["edit"],$n,$Ja,$Y);else{$Ad=(in_array($r,$rd)||isset($rd[$r]));echo(count($rd)>1?"<select name='function[$D]'>".optionlist($rd,$r===null||$Ad?$r:"")."</select>".on_help("getTarget(event).value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($rd))).'<td>';$Yd=$b->editInput($_GET["edit"],$n,$Ja,$Y);if($Yd!="")echo$Yd;elseif(preg_match('~bool~',$n["type"]))echo"<input type='hidden'$Ja value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$Ja value='1'>";elseif($n["type"]=="set"){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$He);foreach($He[1]as$s=>$X){$X=stripcslashes(str_replace("''","'",$X));$eb=(is_int($Y)?($Y>>$s)&1:in_array($X,explode(",",$Y),true));echo" <label><input type='checkbox' name='fields[$D][$s]' value='".(1<<$s)."'".($eb?' checked':'').">".h($b->editVal($X,$n)).'</label>';}}elseif(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$D'>";elseif(($hi=preg_match('~text|lob|memo~i',$n["type"]))||preg_match("~\n~",$Y)){if($hi&&$x!="sqlite")$Ja.=" cols='50' rows='12'";else{$K=min(12,substr_count($Y,"\n")+1);$Ja.=" cols='30' rows='$K'".($K==1?" style='height: 1.2em;'":"");}echo"<textarea$Ja>".h($Y).'</textarea>';}elseif($r=="json"||preg_match('~^jsonb?$~',$n["type"]))echo"<textarea$Ja cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';else{$Oe=(!preg_match('~int~',$n["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$n["length"],$C)?((preg_match("~binary~",$n["type"])?2:1)*$C[1]+($C[3]?1:0)+($C[2]&&!$n["unsigned"]?1:0)):($U[$n["type"]]?$U[$n["type"]]+($n["unsigned"]?0:1):0));if($x=='sql'&&min_version(5.6)&&preg_match('~time~',$n["type"]))$Oe+=7;echo"<input".((!$Ad||$r==="")&&preg_match('~(?<!o)int(?!er)~',$n["type"])&&!preg_match('~\[\]~',$n["full_type"])?" type='number'":"")." value='".h($Y)."'".($Oe?" data-maxlength='$Oe'":"").(preg_match('~char|binary~',$n["type"])&&$Oe>20?" size='40'":"")."$Ja>";}echo$b->editHint($_GET["edit"],$n,$Y);$dd=0;foreach($rd
as$y=>$X){if($y===""||!$X)break;$dd++;}if($dd)echo
script("mixin(qsl('td'), {onchange: partial(skipOriginal, $dd), oninput: function () { this.onchange(); }});");}}function
process_input($n){global$b,$l;$u=bracket_escape($n["field"]);$r=$_POST["function"][$u];$Y=$_POST["fields"][$u];if($n["type"]=="enum"){if($Y==-1)return
false;if($Y=="")return"NULL";return+$Y;}if($n["auto_increment"]&&$Y=="")return
null;if($r=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?idf_escape($n["field"]):false);if($r=="NULL")return"NULL";if($n["type"]=="set")return
array_sum((array)$Y);if($r=="json"){$r="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(preg_match('~blob|bytea|raw|file~',$n["type"])&&ini_bool("file_uploads")){$bd=get_file("fields-$u");if(!is_string($bd))return
false;return$l->quoteBinary($bd);}return$b->processInput($n,$Y,$r);}function
fields_from_edit(){global$l;$I=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$D=bracket_escape($y,1);$I[$D]=array("field"=>$D,"privileges"=>array("insert"=>1,"update"=>1),"null"=>1,"auto_increment"=>($y==$l->primary),);}return$I;}function
search_tables(){global$b,$g;$_GET["where"][0]["val"]=$_POST["query"];$mh="<ul>\n";foreach(table_status('',true)as$Q=>$R){$D=$b->tableName($R);if(isset($R["Engine"])&&$D!=""&&(!$_POST["tables"]||in_array($Q,$_POST["tables"]))){$H=$g->query("SELECT".limit("1 FROM ".table($Q)," WHERE ".implode(" AND ",$b->selectSearchProcess(fields($Q),array())),1));if(!$H||$H->fetch_row()){$sg="<a href='".h(ME."select=".urlencode($Q)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$D</a>";echo"$mh<li>".($H?$sg:"<p class='error'>$sg: ".adminer_error())."\n";$mh="";}}}echo($mh?"<p class='message'>".lang(9):"</ul>")."\n";}function
dump_headers($Jd,$Xe=false){global$b;$I=$b->dumpHeaders($Jd,$Xe);$Pf=$_POST["output"];if($Pf!="text")header("Content-Disposition: attachment; filename=".$b->dumpFilename($Jd).".$I".($Pf!="file"&&preg_match('~^[0-9a-z]+$~',$Pf)?".$Pf":""));session_write_close();ob_flush();flush();return$I;}function
dump_csv($J){foreach($J
as$y=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$J[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$J)."\r\n";}function
apply_sql_function($r,$d){return($r?($r=="unixepoch"?"DATETIME($d, '$r')":($r=="count distinct"?"COUNT(DISTINCT ":strtoupper("$r("))."$d)"):$d);}function
get_temp_dir(){$I=ini_get("upload_tmp_dir");if(!$I){if(function_exists('sys_get_temp_dir'))$I=sys_get_temp_dir();else{$p=@tempnam("","");if(!$p)return
false;$I=dirname($p);unlink($p);}}return$I;}function
file_open_lock($p){$pd=@fopen($p,"r+");if(!$pd){$pd=@fopen($p,"w");if(!$pd)return;chmod($p,0660);}flock($pd,LOCK_EX);return$pd;}function
file_write_unlock($pd,$Sb){rewind($pd);fwrite($pd,$Sb);ftruncate($pd,strlen($Sb));flock($pd,LOCK_UN);fclose($pd);}function
password_file($i){$p=get_temp_dir()."/adminer.key";$I=@file_get_contents($p);if($I||!$i)return$I;$pd=@fopen($p,"w");if($pd){chmod($p,0660);$I=rand_string();fwrite($pd,$I);fclose($pd);}return$I;}function
rand_string(){return
md5(uniqid(mt_rand(),true));}function
select_value($X,$_,$n,$ii){global$b;if(is_array($X)){$I="";foreach($X
as$je=>$W)$I.="<tr>".($X!=array_values($X)?"<th>".h($je):"")."<td>".select_value($W,$_,$n,$ii);return"<table cellspacing='0'>$I</table>";}if(!$_)$_=$b->selectLink($X,$n);if($_===null){if(is_mail($X))$_="mailto:$X";if(is_url($X))$_=$X;}$I=$b->editVal($X,$n);if($I!==null){if(!is_utf8($I))$I="\0";elseif($ii!=""&&is_shortable($n))$I=shorten_utf8($I,max(0,+$ii));else$I=h($I);}return$b->selectVal($I,$_,$n,$X);}function
is_mail($yc){$Ia='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$lc='[[:alnum:]](?:[-[:alnum:]]{0,61}[[:alnum:]])';$fg="$Ia+(?:\\.$Ia+)*@(?:$lc?\\.)+$lc";return
is_string($yc)&&preg_match("(^$fg(?:,\\s*$fg)*\$)i",$yc);}function
is_url($P){return(bool)preg_match('~^
			https?://                 # scheme
			(?:
				# IPv6 in square brackets
				\[(?:
					(?:[[:xdigit:]]{1,4}:){7}[[:xdigit:]]{1,4} |             # 1:2:3:4:5:6:7:8
					(?:[[:xdigit:]]{1,4}:){1,7}: |                           # 1::                             1:2:3:4:5:6:7::
					(?:[[:xdigit:]]{1,4}:){1,6}:[[:xdigit:]]{1,4} |          # 1::8            1:2:3:4:5:6::8  1:2:3:4:5:6::8
					(?:[[:xdigit:]]{1,4}:){1,5}(?::[[:xdigit:]]{1,4}){1,2} | # 1::7:8          1:2:3:4:5::7:8  1:2:3:4:5::8
					(?:[[:xdigit:]]{1,4}:){1,4}(?::[[:xdigit:]]{1,4}){1,3} | # 1::6:7:8        1:2:3:4::6:7:8  1:2:3:4::8
					(?:[[:xdigit:]]{1,4}:){1,3}(?::[[:xdigit:]]{1,4}){1,4} | # 1::5:6:7:8      1:2:3::5:6:7:8  1:2:3::8
					(?:[[:xdigit:]]{1,4}:){1,2}(?::[[:xdigit:]]{1,4}){1,5} | # 1::4:5:6:7:8    1:2::4:5:6:7:8  1:2::8
					[[:xdigit:]]{1,4}:(?::[[:xdigit:]]{1,4}){1,6} |          # 1::3:4:5:6:7:8  1::3:4:5:6:7:8  1::8
					:(?::[[:xdigit:]]{1,4}){1,7} |                           # ::2:3:4:5:6:7:8 ::2:3:4:5:6:7:8 ::8
					fe80:(?::[[:xdigit:]]{0,4}){0,4}%[[:alnum:]]+ |          # fe80::7:8%eth0  fe80::7:8%1     (link-local IPv6 addresses with zone index)
					::(?:ffff(?::0{1,4})?:)?
						(?:(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])\.){3}
						(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])
						(?<!\b0\.0\.0\.0) |                                  # ::255.255.255.255  ::ffff:255.255.255.255 ::ffff:0:255.255.255.255  (IPv4-mapped IPv6 addresses and IPv4-translated addresses)
					(?:[[:xdigit:]]{1,4}:){1,4}:
						(?:(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])\.){3}
						(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])
						(?<!\b0\.0\.0\.0)                                    # 2001:db8:3:4::192.0.2.33  64:ff9b::192.0.2.33 (IPv4-Embedded IPv6 Address)
				)\] |
				# IPv4
				(?:(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])\.){3}
					(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])
					(?<!\b0\.0\.0\.0) |                                      # 0.0.0.0 excluded for URLs
				# domain
				[_[:alnum:]](?:[-_[:alnum:]]{0,61}[_[:alnum:]])?
					(?:\.[_[:alnum:]](?:[-_[:alnum:]]{0,61}[_[:alnum:]])?)*
			)                         # host
			(?::(?:[1-9]\d{0,3})?\d)? # port
			(?:/[^\s?\#]*)?           # path
			(?:\?[^\s\#]*)?           # query
			(?:\#\S*)?                # fragment
			$~xi',$P);}function
is_shortable($n){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea~',$n["type"]);}function
count_rows($Q,$Z,$ee,$ud){global$x;$G=" FROM ".table($Q).($Z?" WHERE ".implode(" AND ",$Z):"");return($ee&&($x=="sql"||count($ud)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$ud).")$G":"SELECT COUNT(*)".($ee?" FROM (SELECT 1$G GROUP BY ".implode(", ",$ud).") x":$G));}function
slow_query($G){global$b,$ti,$l;$k=$b->database();$ki=$b->queryTimeout();$yh=$l->slowQuery($G,$ki);if(!$yh&&support("kill")&&is_object($h=connect())&&($k==""||$h->select_db($k))){$me=$h->result(connection_id());echo'<script',nonce(),'>
var timeout = setTimeout(function () {
	ajax(\'',js_escape(ME),'script=kill\', function () {
	}, \'kill=',$me,'&token=',$ti,'\');
}, ',1000*$ki,');
</script>
';}else$h=null;ob_flush();flush();$I=@get_key_vals(($yh?$yh:$G),$h,false);if($h){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$I;}function
get_token(){$Dg=rand(1,1e6);return($Dg^$_SESSION["token"]).":$Dg";}function
verify_token(){list($ti,$Dg)=explode(":",$_POST["token"]);return($Dg^$_SESSION["token"])==$ti;}function
lzw_decompress($Sa){$ic=256;$Ta=8;$kb=array();$Sg=0;$Tg=0;for($s=0;$s<strlen($Sa);$s++){$Sg=($Sg<<8)+ord($Sa[$s]);$Tg+=8;if($Tg>=$Ta){$Tg-=$Ta;$kb[]=$Sg>>$Tg;$Sg&=(1<<$Tg)-1;$ic++;if($ic>>$Ta)$Ta++;}}$hc=range("\0","\xFF");$I="";foreach($kb
as$s=>$jb){$xc=$hc[$jb];if(!isset($xc))$xc=$qj.$qj[0];$I.=$xc;if($s)$hc[]=$qj.$xc[0];$qj=$xc;}return$I;}function
on_help($sb,$vh=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $sb, $vh) }, onmouseout: helpMouseout});","");}function
edit_form($Q,$o,$J,$Oi){global$b,$x,$ti,$m;$Uh=$b->tableName(table_status1($Q,true));page_header(($Oi?lang(10):lang(11)),$m,array("select"=>array($Q,$Uh)),$Uh);$b->editRowPrint($Q,$o,$J,$Oi);if($J===false)echo"<p class='error'>".lang(12)."\n";echo'<form action="" method="post" enctype="multipart/form-data" id="form">
';if(!$o)echo"<p class='error'>".lang(13)."\n";else{echo"<table cellspacing='0' class='layout'>".script("qsl('table').onkeydown = editingKeydown;");foreach($o
as$D=>$n){echo"<tr><th>".$b->fieldName($n);$ac=$_GET["set"][bracket_escape($D)];if($ac===null){$ac=$n["default"];if($n["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$ac,$Mg))$ac=$Mg[1];}$Y=($J!==null?($J[$D]!=""&&$x=="sql"&&preg_match("~enum|set~",$n["type"])?(is_array($J[$D])?array_sum($J[$D]):+$J[$D]):(is_bool($J[$D])?+$J[$D]:$J[$D])):(!$Oi&&$n["auto_increment"]?"":(isset($_GET["select"])?false:$ac)));if(!$_POST["save"]&&is_string($Y))$Y=$b->editVal($Y,$n);$r=($_POST["save"]?(string)$_POST["function"][$D]:($Oi&&preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$Oi&&$Y==$n["default"]&&preg_match('~^[\w.]+\(~',$Y))$r="SQL";if(preg_match("~time~",$n["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$r="now";}input($n,$Y,$r);echo"\n";}if(!support("table"))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",$b->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($o){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"])){echo"<input type='submit' name='insert' value='".($Oi?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($Oi?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}}echo($Oi?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":($_POST||!$o?"":script("focus(qsa('td', qs('#form'))[1].firstChild);")));if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo'<input type="hidden" name="referer" value="',h(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"]),'">
<input type="hidden" name="save" value="1">
<input type="hidden" name="token" value="',$ti,'">
</form>
';}if(isset($_GET["file"])){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");if($_GET["file"]=="favicon.ico"){header("Content-Type: image/x-icon");echo
lzw_decompress("\0\0\0` \0(\0Z\n|\"ј^=HdR9\$M'J\$hV-9K%\0	)NgS}?P@`:^\\2-K T*VWVdRDM=e	{F-KMjo\\hRD/~%kd^V.KR՝݂bqX9/c\neԳ4B\0=&G/K3/5XX4۽^UإaDTegeKާVu/6ߒT{ը@r>	/]b\0VܼOsrJ@b^>>aiP\nN%^q%	xx)\n:bAaC*T0ic)b'x	y,AhGX%*ZS<.T/j^kH)x_'xԗP/.\nBiy#F)7@I`*iy7Saʗ\"\0HIDu%t{%K'xiL9(%_A:4UH-G/X_<W=ixO@B;|u\n^`6:^t%\"^襏`?%\0\0-Zȥ@!L)at\n\r◎iyҗbX?xPix|d%JX>p(s2(^^'^dB*NXvj~@@y_pI\"_I%nI|J^\"cgahsR^;IxƔu*^o%vy%:XJ+Ua%pI2^C%z_>id[%Jn,wؖc;^h%p?y/aq[k\r}O%֋tXإ8z;8k֏i`9֒+.Ic&*^IvZp	ljdKKJ%HX!88@f`I`%QrX-G\0K	//BXyD\0ļ_?<'!X\"/H֒˔:\r\$v\$j'KǢ,İ)\0Zhh5KG&aKɉ,a<BAIxu%ᄗH8-E bI`%_d\0-JZ,\nT,wK:Z7)I:K|2XSD%Uʠ[+iҺX_ R^q/%\$0DDV;AhF҉6r0-h0fݛ⬗^RA/\n~pVKLSzlCq/\n~?/3B|\$TI%qIccŻ\"Bg&BX.y,ld\$K-nhNK(I9|ؗ^(!}.EgBV-+<Y9R\\uULh,dRIxf-焺4K]\nPRi,?9+,fN*w@Z HhV\"F`k\$w\\-sBY\0Du5`	*ig8_E!ơL<`ΝD%HlEQ!:\r~?\$K7D!q`5XUwIІ	xsA<Ka/ʖ@q-P^Wk-@b\"B/\0Q󰚨}y,dKp-.e1s	.%]0jjKA/1H2_\"kۛ3n&3`ضA(3	`,Hۡ%LxiG>u\\-6,6Mz\\Ϝ\r\$(-q#	2<EAhKjıȢ.	\$^rxx-+:X-Zw<O1.Ue(-?/0ZۏDpjZ^ZZDf݌GxA,_L ZAhYSУDK+TYYkt2p&_`57lS\"K,Ǆ#ɛsT\"5 Ak#ƣxľЙxn@`(/`Lܨn \$Kf,IUV߬藊_KDŦİ=B_AAWN,`vnKT8v^xiSvßjk%̡SZ&z}if=_\"\r!@^gAyoM]-_?ZwZKZﻞ̒|?Cx\0\0@?<x?\0?|p?CX//o`~\0!p0~>Ͻ}]/\0!'kj\0k		p	\"j|\0\0a\0/x\r o/!#\0q*Oo|\0\0\0P\0\0\0a\0a|");}elseif($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("\nCo6C(\"#Ha1#yd1٘n:#(b.\rDc)a7Elñi1Ύs54f4ngsIhMдi:`,]YtL0hD*B0\rF&3xs'[Ʉtv4S%0XLW5)Yf\r^=~9g0\\@rQNn^yNj{opC%ʋGSZh5Z|>:'b{J)Ɠєt1*uS=^2*8t(0R,8j:x@9\n@1\nJ#4BRJFƋ>#J`HaahbC0\r4Ar&\nB54\$>+QA2DoMEL\"48=s5DLW7JGf**HjEK16ڸ,oLtJA\\\$Q|9-H@0\nxtV(o.+ܮ;1D8e*c\rT䍣B2܍z\n83=Ktƻu(kmׅ.G;+:2)cn<s5:6\nԡ)_\\6YL\"VV`c\$L;k&\$?XAWU48	Bޡڮz*[O24<?{36%;VV:\\A䎈	xnpxF<[xoW.U[Ãsd7rF&	bÒ]t*7ji=dZֹYy4:ieup\\6bHCxf׳Ɓ䎁sr8KrJp\$|;-9(?O2zĐߋO~o(;{]d%&Dy8EaM&\\ta<\0A8s@NC@(Y=OйҞB6x1]k44\"b(`A;8c<eBw*\\B٢0\n0 /ll˩\rC_*2~X-I\\ybfe@`u\"̆5hs@T;>Cphk%'\$ᰂI;R|`]FB\n.[r2/`\rҢ\rCKeF2[r%)Y,5&ڸpMe=(N@+9e8fnu:܋T}ԎGC\rNsg%>ÔP6Hʒl?τ_>hee,3F n9eFhaM),_#a-HiB-(vb&rJ1HhUiy\0#SM˵IS`-MTV}\"UH,  #ֵֹ;-\"ы\rt2\nFLؖu-5S_+y50Q/3E|%}AC&tGk2JiokbHjQQ\"x_B<A8'ṋbVx[\0:(ڃp)Nag(6#@d8w?l.H9ޫF~!%D-&geaZrr̆%aPMV>mq\r1P	ę-tZ :lx5&PZ6pfDg)pPLA,\\\rȮ7j1Hۿ.r&AdDHJTlɆJ @8\nI)Yf`<]fJ@8kW1v3\$k\$3v8:{}r.IiJ,nR@ٔ^AyeUpҢ:ӇkZV9[zP@{T;VA>Y=e97m^6[D\rDAp@[:*ee;pVi@!0` pN`	mnPh8^g0e/*伟Y(h.<@Pxx\0dt1\0r6ӈpPt<@~34a|{ \0mT]ht dA.1j7 RWwQ nEȾ eK`xSz׋%tb\rh3@ӹފ\r2\$0o04\0xԌ\r</`<Ex_<P1\r%up0-n!0PtPa>}`fzw@RWgZ#x6x-bdrOvin0\$&\0`P\\J& @&Nid%΄/bdmqrnE\r8d\\/\0N.\r^O@n,#D 褗	@0o\n\"^/lrc\0D/IPȭpc\00NP\n	`[oNE\rn@pfnP΀AoF2(l@VP(nI`bd pn0XHPhOOxbaϳ(znQΊΐ	`fd^%P\0dp/(x`BQ^@09^[ȯVo\"O@0. 2%V\0 jrR?.CΖ=\"W^P\rFe\$\"c nxQ\$Q nO@z `D1y	c%`nP,,`pqPRzz02D.Nio#+0X iI1Բ1grDD1)1np\"WҗΒ^\\@\r؄\0JdrV#ζ(@^>Sc6`N3x|jp?vCs\r~1epNn\r/Ai#L98%@1@O8<\$ҿ3Z;OOE@<3!Om/ M0&AlEo\"\0@%#6E50L;&6\r@*ToA3p>^`pR\0#'tT@b\"TJBhp\\SG+@Ps?C<%<E\$&:dFo@O	/#D\"aQ5Q;\0003CP\$ba-p[.	ogCDU΃1UR%Vn\"HnoDe:ϿCRR5wRuLfq_SOaNyO8R@=.uQ(/Bdi u\\OH\nZC{Ok	o[1!Pҭ&QQ4/^P+lP\n-`r,V2zr;U\npA4=W^2NdP,!PP	,Oi`cT^ҽ!UND_pHnS^TPHlϠSum1EbhQ01	 b!. PA*qQSϧ\\5M]kQ`Rq[nXQRLWc	1pȠkd@i̏qEOL#mUownqO4OC\0qc_yNpj\r1Ѝfe\npWw(N-z5<no.uIuwWh`cuhwIv\0nRC6t\nr?2hfO7jcir\"rou1*хg7\r0BbROuqV6o'e2&X{ϥЩq%0\0gzc{3`\r3e6m:suMM\rHI\0Is99:Ss:{A9z8G4v\0O;ύط/It\"/{uO{V;W\$KttP\0j)eEFyq}ؽB?)3gnt5,9CMZy&u- WwqaE.jFNN`ېpp@gvY&Y_DUU9}P=IYyI` D\"؊\0*PS(``JXb^KY>0y\r9>43++-Q5hԎK3ICGm>CL7-ۺt]\rխ.V-ۦmC\0N*; vu XB`zNn`ɝD\0V7\nplERVc9.HN.Rp@D#;:Zӱ>L:\"bZ9:;#:q;x㫧x[Jy?{%'4\$@Qn\0xɶ[Xǵ\r/sidC\rnƗew[ivQ{{K`,q=N;zѾՙ;0 m[9O@Gp\0pF3b#Bq\0dbKGH]b-ݥ_ĪI-yţM܃!Z:LZߺ.)BխZ߮A-Xi\n)|ǰmSAHMAr%03}E8;T\\\0G[S{<_ϻbi΁;wA _\0uo,I/-Aw]OĆDuqn&O-e`E}\0PCj\r}iqSRf(DD|/\"zN?\$\rd5=ĚogmMŧ2MhHFi	cNC\$_nEztꜗɺɬZ:׮O9^'˜ ;	<ͭ.jsfg|ϲT\rл'/<6}2Y]8ka\"?;]m[p+>;+9N[6QosnH;ǹϰH>;	uu}Le껢d/,/#\r1I>{_[˿\0=PFlHxWt1(RerVJ,*T?'Rp\0?2L`'p_e@u9#|?F>ɴv<zRS?d6@'i̾O\0F.B׾UM䐨pj]\r42mF4Aq&`01|cgߒ剸\0jIz_셧oN.VAl\0XkfFSKMPlF\ru\r.L>hCCIW&?+F2Q	JPVX	d\$9pv\n& 5V\"؟ð8\$*iEf,g,5DS\rh<%\raM	*MI/vg?ph`RQrľB:hY2e\nbp\0y4ZN\0T|}Gn8iHv5܎*0{ɨ0}\\%OAnS\raL4Ɏ=j՗9 Ok|-ixkܮ嶹H.\\kXa`Y\noSS7Ms`N-0琅=)o;mK:!箊z\"&Q\"6ҍgZ;֛w\n%͊o\0ٖ\$3LD\rOu%-ΊX\$)Mo\"Xܣ\\12*l.n6yI[y\"\$.%g:<M!b'ۋsޮ\n&\r҉l]b>\rCo\\!\"7AZQg)c&pFZ2'f21lP\rrP0\nhR}F6AM\0007mwjᑖƉD58 X2/#c@%ذq_cHf\0*,u> ;îx\0xP'X 1\0?G|\rqd+q(xC~S8\"B~p	efm`)Q*=!!bP[QSFr\0\"\r|AhXM\"(@*;m(dz+x}y\00022vd\0\"IGd&h*cfH-M!EH1ےđc[Ry'	NQ\\@<`\$t'e:i)CZVQYKJ<2r\0\0/rQ)IVT_üIZ\"V2QK̢`}J^U;VeDȀ84@`TGJVc|e-:W2PQ-Wݗ)y\0u]%^P/~]@Ċ>fXrYVRT?\n\\YeJaᮗܻ&xV\\S(cKra,=2YY^-~`\n/2Tz8Q?NJ,V䑖2yIn]B	-&:L2]G 71LM\"^K|Ԧ4ial)|	#3V̄Z,f|R/zhsI%Df/MkQ\$f4Ida@,J6l+TiLV'^`y`Mud&7^r_)x]9)N^nzKZ!aO'S1\\&2e5\0MQ(&A	zu=Įr5\"BcƗt&;mJy0@/0O:d2឴\n=ÎV`p<=OD4	/ieԶ?~|ֹUИ@	ϼ\rm7e*MS%\0K~R%pM(cQU50l%J*aW%lFǁi¡cAmfAևҏ>YQSLg)#Kj|}\n\$&˕g-(\nz(#,	PT5:Qj4fTeG*zϣ/\n^	wl`(\0)Z4.S-[2'Р;0\r0j_7Mt6!(Oq8R\r@&H(\$\n]HX%e%?a31");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("f:gCI\n83)781x:\nOg#)r7\n\"`|2gSiH)NS\r\"0@)`(\$s6O!V/=' T4=iS6IOG#XVCsZ1.hp8,[H~Cz2lc3sIb4\nF8TIU*fzr0EyfY.:I(c΋!_l^^(N{S)rqYl٦33\n+GyixV3wuh^ra۔c\r(.Ch<\r)ѣ`743'm5\nP:2Pq C}ī38B0hRr(0b\\0Hr44B!p\$rZZ2܉.Ƀ(\\5|\nC(\"P.NRTΓ>HN8HP\\7Jp~2%OC1.C8·H*jS(/6KU<2pOI`ⳈdOH5-4pX25-Ңۈz7\"(P\\32:]U߅!]<Aۤiڰl\r\0v#J8wmɤ<ɠ%m;p#`XDiZN09占`wJD29t*yNiIh\\9:xﭵyl*ȈY8W?ޛ3!\"6n[\r*\$Ƨnzx9\r|*3ףpﻶ:(p\\;mz98Nj2\rHH&(z7ik cet2:SHȠ/)x@tri98yҷV+^WڦkZYlʣ4Ƌ\\E{7\0pDi-T0l%=˃9(5\n\nn,4\0a}܃.Rs\02B\\b1S\0003,XPHJspdK CA!2*W2\$+f^\n1zE Iv\\2.*AE(db܄9Dh&?HsQ2x~nÁJT2&eRGQTwݑP\\)6sh\\3\0R	'\r+*;RH.!['~%t< pK#!lLe,&\$	`CXӆ0֭:Mh	ڜG!&3D<!23?hJe h\rmNiNHl7vWI.-5֧ey\rEJ\ni*\$@RU0,\$UEªu)@(tSJkp!~d`>\n;#\rp9jɹ]&Nc(rTQUS\08n`ybLO5,>xf䴒+\"I{kM[\r%[	ea1! ԮF@b)R720\nWLܜҮtd+0wgl0n@ɢiM\nAM5n\$EױNl%1 AkriFBol,muNx-_֤C( fl\r1p[9x(iBҖzQl8C	XU TbI`p+V\0;CbX+ϒs]H[kxG*]awn!6mSIK~/ӥ7eeNS/;dA>}l~ %^fآpڜDEat\nx=kЎ*dTj2j\n ,e=M84aj@Tsnf\n6\rd0Y'%ԓ~	Ҩ<AHG8΃\$z{u2*a>(wK.bP{o´z#28=8>A,e+Cx*-b=m,alzk\$W,mJiʧ+0[.RsKXZL2`(CvZ\$׹,D?HNxX)M\$,*\nѣ\$<qşh!SxsA!:K}RA2kXp\n<l3VV}g&Yݍ!+;<YYE3rَCo5ճkkۣtU)[}ul:D+Ϗ _oh1400bK㬒lG#|UdIK7^@O\0HHi6\r\\cg\02B*e\n	zr!nWz& {H'\$X w@8DGr*H'p#Į\nd,,;g~\0#E\rI`'%E.]`Л%&m\r%4Sv#\nfH\$%-#qBQ-c2&] qh\rl]sh7n#-jEFrl&dzF6\"|s@z)0rpڏ\0X\0|DL<!o*D{.B<E0nB( |\r\n^ h!r\$(^~/pqBO,\\#RR%dHj`̭ V bSdiEohr<i/k\$-\$o+ŋlO&evƒijMPA'u'( M(h/+WDSo.n.n((\"h&p//1D̊j娸E&⦀,'l\$/.,dWbbO3BsH:J`!.,F7(Կ1ls ҎŢqX\r~R鰱`ҞY*:RrJ%L+n\"\r͇H!qb2Li%Wj#9ObE.I:67\06+%.a7E8VS?(DGӳB%;/<\r >M@HDsZ[tHEnx(Rx@GkjW>#T/8c8Q0_IIGII!YEdE^tdth`DV!C8\rb3!3@33N}ZB3	330M(>}\\tffI\r337 X\"td,\nbtNO`P;ܕҭ\$\nZѭ5U5WU^hotPM/5K4EjKQ&53GXXx)<5D\rV\nr5b܀\\J\">1S\r[-Du\r)00Yˢk{\n#\r^|uܻU_nU4U~Yt\rI@䏳R 3:uePMS0TwWXDKOU;U\nOYYQ,M[\0_DWJ*\rg(]\r\"ZC6u+YY6ô0q(8}3AX3Th9jjfMtPJbqMP5>Yk%&\\1dE4 Yn\$<U]Ӊ1mbֶ^\"NVppeMWܢ\\)\n \nf7\n2r8=Ek7tV7PLa6v@'6ij&>;`a	\0pڨ(J)\\nĬm\02eqJPtfj\"[\0X,<\\+md~s%omn),ׄԇ\r48\rmEH]HWM0D߀~ˁKE}|f^\r>-z]2sxDd[stS\0Qf-K`twT9Z	\nB9 Nb<BI5ooJpJNd\rhލ2\"xHCݍ:9Yn16zr+z\\m T @Y2lQ<2O+%.Ӄh0AZ2R1/hH\rXaNB& M@[xʮ8&LV͜v*jۚGH\\ٮ	&s\0Q\\\"b	\rBsw	BN`7Co(\nè19*E SU0U t'|m?h[\$.#5	 	pyB@R]@|{P\0x/ w%EsBdCU~O׷P@X]Z31{eLYڐ\\(*R`	\nQCF*霬pX|`N\$[@UZ`Zd\"\\\")I:toD\0[-g*`hu%,I7īHm6}Nͳ\$MUYf&1e]pzImG/ w !\\#54IdEhqѬkx|kqDbz?>:[LƬZX:jw5	Y0 \$\0CdSg{@\n`	C M# t}xN{۰)CFKZj\0PFYBpFk0<>D<JEg\r.28U@*5fkJD4TDU76/@K+J@=WIOD85MN\$R\05\r_EIϳNly\\qUQ\n@ۺpP۱7ԽN\rR{*qm\$\0RԓqÈ+U@BOf*CˬMC`_ ˵NT5٦C׻ \\We&_X_؍hB3%FW|Gޛ'[łV#^\rGRPFgYi z\n+^/\\6bdmh@qAh),JWcmem]ӏekZb0Y]ymfeB;OwapDW{\0-2/bNsֽ޾RaϮh&qt\n\"iRmhzeFS7PP䖤:BsmY d7}3?*tlT}~=c	3;TL5*	~#Asx-7f5`#\"NbG@e[s-M6qq he5\0Ң*bISFή9}p-`{ɖkP0T<Z90<՚\r;!g\r\nK\n\0*\nb7(_@,e2\r]K+\0p C\\Ѣ,0^MЧ@;X\r?\$\rj+/BPJ{\"a6䉜|\n\0\\5	156 .[Uد\0d8Y:!=X.uC!SopB7ůRh\\hE=y:< :u280siTsB@\$ @u	Q.T0M\\/d+ƃ\n=dA)\r@@h38.eZa|.7Ykc'D#Y@Xq=M44B AMdU\"Hw4(>8C?e_`X:A9øpGGy6FXrl1ػBÅ9RzhB{\0^-0%D5F\"\"i`nAf \"tDZ\"_V\$!/Dᚆ٦̀F,25jTy\0Nx\rYl#Eq\nB2\n64!/\nQ*;)bRZ0\0CDo˞48e\nS%\\PIk(0u/G\\}4FpG_G?)got[v\0?b;`(یNS)\nx=+@7j0,1Åz>0GcLVX%Q+oFܶ>Q-clwz5G@(hcHr?Nb@lx3U`rwUt8=l#l䨉8E\"O6\n1e`\\hKfV/зPaYKO x	OjĨpML\r%\"B	H1\$o	hI&\r!)! 2\0Fˠ,|GE1OHKI\0Ä&\\&IQD\r'?('RWd):=@O!JDcJ濓!MB\n\"l\"0E\$BH&Eb0evW`2C&WT?650\rҧ@\$FKr}{xn:LByW@+I˼o:\$E+r89f\"(&\nP/5> &MgQCИD0J0ЎŘd/_\0cu@\\'XQ!-ibB(XT}8MHLxN8 >\0d@M6i	5\0O7Hb/(D[(3B' {K-	lKvQҀt,3LQJ4'=SG%zVs)Cq81oi#]Й\0jjDC^N.o48 rU,@kmSe!dfc,VI\0,Cd<DWH@ѣ%>w!2h[<POEPo>Jx\$\\^99F1zFy\"q'ۀ/6\r҂2S\\\\\\/=`6Oqqj#T+y\r2\n/\$h5hɟVz&Y,C[(ʒGH1z`	ؑAZi8#;*eTW*lRVs:,,yx+\\eX4 ,Ho8NI	%9pTw[^gh(V~\0P>s'hAk=3.\"2@G?O>u(7\0j3~@CA| /*!jU(8!\$!r@ZjE4j' \rKG0\"Y jP@b5{xT/| # 	D@Vwr#M\$X v@E'DP\r\\iJL`9 .bix21\r/X6r*`yb&)~`c}1H&`\nNftPn)9֊ \rO\$<y*e	hv!ZyP^ OȰFpI<DfmD\06f|21¢G3da\n\nԃpwG1IA5Ԫ!EP(GjziM¬3,\\7H1o\$sqb#VdHjB&<U<BǠ9.4'd@oC7=-[-XYse3T2\nHEFYTځf\0UyAvq\n~(%l8X}]Q M~13<q		?!T3#B[2tt(unHPDhgmqak[72&BYu.-{hO<\"8<\r|2j}^UX?_ĦT_u/ӀIȷl\n֗efkF=rE,6%?lX;'WMela.R3	cÂe,H XRS\nU\".2B`)[;dNdDR2INzV8PluA^똘76qn׍UniZvR@)*㌁qƒ<d7^iISf!QAi2:'!1N0	;AFF<ķݨ\\VΖ܆qֺI-xu/dOC_sm<gx\0\"\n@EkH\0\\ȭ8(mmS4\nYFkLr=hZv@=AAbЩ趑R;V<\$!ۧ;	%ʨ(|X\0]c1=0a\"\"=)(F=Iৢ7-\0tb[`l	FJ\\4g]mV^j¤\\U{pKR٢(yn|}GbP@RS rWmŹ\0t`53p%HD*Qwn,(@E	UKȄh3\0'1[B\0]Nz;e&k+VZ_(yZ<:`d0HfߋxYdp0GZ`,=9pZ	j\0/Ԛ/q>udS#*ŮeG+K-	uW8KԸDyq0E\${͚\\RHBsQlX.}#_ZhZ~0YzWߌ~F:2DPY(\nLvl_Ն\09`b+\$1^nAB4D@6Ia7	\$TS~`ňV::/'mfqDA\rPGX#HՈخ&Rt{fapdy?\nJmΦk3sv֝dĵNl؝7+tDXn@8U6l?aw,X|`\\\$t&JZ;@!W.cRD2Su\$Hyv	'\0c##P\\#D>vV(Hc9k>'T\rʧ:ٯ3ҘPAMXd<筋j1XOPX/nOw't`@ovE\"QWU-*[=	\nzZ%^Mc%H@Z[ڔ(02@W\\,v!M\0r;YcɠE+̝2\rgd]\$:H|qDU:>	=>AX[.l<^(a@.%:@%\0sWb˂Q@j}Ve\$@͕H3:`h^PbAq^C5Ro//Yb\$Nqys\"]3%L&ČJIs`VU\n=(GBBOH\0)\$	ҕk\n;/]	'Zg̨t GVP=&ߒ\\>SH\ndChb7+\$5QcZTu*H\$\nZj;PB\0]K\\8''9//ԏ)Vo=@5Vd,RT,)3g	!Ƙx_&VDOmq'CUA:@P)\0,6?@nFh|BQ 5ҚDʬtN@·fC\03NB)xhl?0?#\"abI8Ax[Xe3B`Ƕ+	5S>+#xy~/az1Tj܍9 [ٴIzRH)eQ1\$8 HRJ{tǮqr81_܆cR6_ƜNzBh\"Iif/@X6x\0=IXzcHyr`g@ -aOf%#.S><hw0n\$P 0DPI|feH@mLGn}h2\\]/'[7ܽ9\0\\G(w[P4Sትݯl%%m(:4#km]tݸnA=6	\0cnx(D0'C\08wM D.k:SWuUv\r@c#7Ҳ_	qQ=C>2\$r@,قgn\"ۢ{v(rضIjHj]@7?9 OIы*c!!olrSN{AѦup-.5dX[~L\$8h\$=؄jGl%	oHվ7B0@>5'X1޺CH+'e`CBmxR`o6haZcȹ68b'o;{)58~M\\Dz4T{lB4LpB;x+1ҾhPɭ\nkt5#8\$Zw`nC(Ur)a'E(bv`\nD:iX\\)8CPܗ+iϷ!B`p7&&JROܖn<B|ӥKQ\n[\n,<3S\$<*Jۦ;;\0'IWPq)%q҂켜N#zEXSo\n\0EO`Sa9*t q\rjAX<	]/DI&!	!^BSdf\nesQLfu#(H|h:H+81OzsC]_p	;!3kD XVbYERk5.W\n#G^ɁI#l8aX8dh2]jS\n#-a\r'\$Cocݪk-tuߟƅ\\˸ԗNϲ\$l%ൣF]5MG2RA2ur)9-#4z,NPeǮr2ǘ=iSH\rH7+x<C69)`EY\$BONӞ<Iw \r3(rDZB[]@L3Fhvnv3ڦNq۶-H\$':^idU(ZM:Ht\$4GtRȌ])},[kI2i̻h|ֶ|0|I!̾yRSR=稉(Meiʯʦ.译i)-D|q\$4Y)2K)*Oٳg2h{=KRR;8i\0t+!#G{~!b~Nւc\n{'8Jy1,hvfq(	/w8_R2KP\0=zuazhqab_pضq?!BxG9<irҊNk/#[N\"rW6DoID'X=Fp1y/\$>|->Rb^S~%??\0(/4PHK2o׋Ėz~53^ cHZ&c<,xeЯHn8N)=	C7'KDnSPY!&G8'	S`o#IFSAAlNM)%`<@g|;@#)N<uQ~ͮJIy吕(@@l~a3Dq|t[_!~LcVV#Y`5_uHH(?\r8D_n)'&Z j).esNJ. wE*n=\nIlsb:\\[uuXp_\"\0002ݤ`{(`1}Ś \0'dG\$J\n-t`+!tT3>7@fHt4hy)E8 H\0Ԧ]XEZ\0)5n 2:`l_\"a!:Ȃ[<V&plHiy֥ >	@UCꑔ4+](\n	<-H=Q\"Xm`4pD21EC'JN/VI(SPJaS/l\0AcS\0\0HhwPW3 \0; zN\$\nHxt<\$Q/5hoC)oC881B_B#P1A4\0vCg\$:+l@Hq\0{!@`	e+PA<ؕAPr	g0q\0[P.wAAD |APiP#[Di , c\0e̆I\rA\"L\rmxМ4C\r[VAk\$T&l.d\np9&PB)9eB6!f05YP?1@,#}:УBă|%\0>A[A\\S.<;p]0s\\(¡ =`2>w)c<B.E%B*40p\0O@@q:H,}@*t3NCdN1\"\n<'\0[vCr\r`20%2ejU\\c@d\0S@aZ	Ia5\0Pí*%\r|<(#-4u#Z*0MsҢ1CFIʇN(xqH`b:Pt(p/QXK0{\n	!l1PZ1AR41j:Dߟ쑋áfgII<	OfDn֮	10	yB`Ҋ`+:\n;f N፪:~k'\$ʈjPJ CAa|\n`#SP61F@A[Nn(0<QE)2мOƀAqAJ<P\0\0Q@8E2VQHQJ)Ђsq0<D#,EB\\84Gs<j(*tI|#TID;f/Cx#N\rMݐ");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0\0Dbc!Q7Шd8~N)Eг`Ns`S)O/<x9o3n2!r:;+9CȨ\n<`b\\?`4\r#`<BeB#N \r.D`j4par㢺>8\$c1cc{n7ANRLi\r1!(j´+62X8+.\r!xh'6S\0RO\n1(W07q:NE:68n+մ5_(s\r/m6P@EQ9\nV-\".:J8weq|؇X]Y XezW 7Z1hQfuj4Z{p\\AUJ<k@ɍ@}&L7UwuYh2@u P7Ah3ÛXEͅZ]l@Mplv) HWy>Y-Y/hC[*F#~!`\r#0PC˝f\\^%B<\\fޱ&/OL\\jFjZ1\\:ƴ>NXaFAfh{\"s\n64?8^p\"띰ȸ\\e(PNq[gr&}PhW*r_sPh\nom#.\0@pdW \$ҺQ۽Tl0 HdH)ۏ)PHgUBe\rt:\0)\"t,[(DO\nR8!Ƭ֚lAV4hSq<@}gK]]=90'wA<a~WD|A2XU2yŊ=p)\0P	sn3rf\0FvGI@%+_I`\r.NKI[ʖSJaUfSzM%\"Q|9Bcaq\08#<a:z1Uf>Zle5#U@iUGn%Ұs;gxLpP?BQ\\b龒Q=7:ݡQ\r:t:y( \nd)\nX;CaA\rPGH!@9\n\nAl~HV\nsիƯbBr3\rP%ф\r}b/Α\$5PC\"wB_UgAt夅^QUjBvh졄4)+)<j^<L4U*Bg*nʖ-	9O\$طzyM3\\9.oE(i7	tߚ-&\nj!\ryyD1g]yR7\"~)TZ0E9MYZtXe!f@{Ȭyl	8;R{8Įe+UL'F18PE5-	_!7[2J;HRǹ8p痲݇@0,ծpsK0\r4\$sJ4DZI'\$cLRMpY&iz3GzҚJ%P-[/xT{pzCv:V'\\KJaM&Ӿ\"eo^Q+h^iT1ORl,5[ݘ\$)jLƁU`S`Z^|r=n登TU	1Hykt+\0vD\r	<ƙjGt*3%kYܲT*|\"ClhE(\r8r{0D_.6и;rBjO'ۜ>\$`^69#4Xmh8:c0;/ԉ;\\'(t'+̷^]Nv#,vOiϖ><SA\\\\!3*tl`u\0p'7P9bs{v{7\"{ra(^Eg/U9g/`\nL\n)(Aa\" 	&P@O\n師0(M&FJ'! 0<H*|*OZm*n/b/.o\0dn)i:RP2m\0/vOXFʳψ\"000bgj\$n0}	@=MƂ0nP/pot.̽g\0)o\n0\rFbio}\n̯	NQ'xFaJL\r\r0'd	oep4Dʐq(~ \rEprQVFHlKjN&j!H`_bh\r1n!Ɏz\\\r`V_k\"\\ׂ'V\0ʾ`ACV`\r%\rk@NB횙 !\n\0Z6\$d,%%laH\n#S\$!\$@2I\$r{!J2HZM\\hb,'||cj~gr`ļ\$+A1E <L\$Y%-FDdL焳\n@bVf;2_(Lп<%@ڜ,\"dNer\0`Z4'ld9-#`Ŗj6ƣvN͐f@܆&B\$(Z&278I P\rk\\2`\rdLb@E2`P( B'0&{:dB1^؉*\r\0c<K|5sZ`O35=@5C>@W*	=\0N<g6s67Sm7u?	{<&L.3~D\rŚx),rin/O\0o{0k]3>m1\0I@9T34+ԙ@eGFMC\rE3Etm!#1D @H(n <g,V`R]@3Cr7s~GIi@\0v5\rV'P\r\$<b%(DdPWbfO x\0} lb&vj4LSִԶ5&dsF M4\".HM01uL\"/J`{xǐYu*\"U.I53Q3QJg5s&jьu٭ЪGQMTmGBtl-c*\rZ7*hs/RUVBNˈԊiLk.t龩rYi-S3\\TOM^G>ZQj\"iMsSS\$Ib	fu:SB|iY¦8	v#D4`.^HM_ռuUz`ZJ	e@Cea\"mb6ԯJRT?ԣXMZІpQvjjV{C\r7Tʞ 5{P]\r?QAA2񾠓V)Ji-N99fl Jm;u@<FѠejĦI<+CW@Zl1<2iF7`KG~L&+NYtWH飑w	ls'gq+LzbizŢ.ЊzW zdW(y)vE4,\0\"d\$B{!)1U5bp#}m=@w	P\0\r`O|	ɍYJՂEOu_\n`F`}M.#1f*ա  zuc xf8kZRs2ʂ-Z2+ʷ(sUcDѷX!u&-vPر\0'LX Lo	>Վ\r@P\rxFEȭ%=5N֜?7NÅw`hX98 qzd%6̂t/Ll,KaN~,'ǀM\rf9w!xx[ϑG8;xA-I&5\$D\$%xѬ´]&o-39Lzy6;uzZ 8_ɐx\0D?X7yOY.#38ǀeQ=؀*Gwm Y]YOYF)z#\$e)/z?z;^FZg`^e#?eM3u偃0>\"?@חXv\"*Ԣ\r6v~OV~&ר^gđٞ'f6:-Z~O6;zx;&!+{9Mٳd \r,9Wݭ:\rٜ@睂+]-[gۇ[s[iiqyx+|7{7|w}EWWk|J؁xmq xwyj#e(ߞþ {ڏyM@ɂY(g͚-J(@;y#SYp@%so9;+	;ZNٯº kVu[x|qON?	`u6||Xس|Ox!:ϗY]c\rh9n8'\rS.1USȸX+z]ɵ?C\r\\\$`)U|ˤ|Ѩx'՜<̙e|ͳLMy(ۧlкO]{ѾFD}yuĒ,XL\\x;UWtv\\OxWJ9ȒR5WiMi[Kf(\0dĚ迩\rM7;6KʦI\rxv\rV3ɱ.R|^2^0߾\$Q[Dܣ>1'^X~t1\"6L+AeI~@pM>m<SK-HT76SMfg=GPʰP\r>2Sb\$C[()%Q#G`uGwp\rkKezhjzi(rOT=7~4\"ef~dVZU-b'VJZ7)T8.<RM\$'by\n5_wU`ei޿JbguS?`+ Mg7`\0_-_?F\0X[J8&~D#{P4ܗ\"\0@ғ\0F ?*^wО:u3xK^w߯y[Ԟ(#/zr_g?\0?1wMR&M?StT]ݴG:I)B v1<t6:W{x:=ޚ:!!\0xq&0}z\"]ozjw6JP۞[\\ }`S\0qHM/7BP]FT8S5/I\r\n O0aQ\n>2j;=ڬdA=pVL)X\n¦`e\$TƦQJk7*O .ġ\r\$#pWT>!v|}נ.%,;f*?焘\0pD! #:MRcB/06	7@\0VvghZ\nR\"@F	+ʚEI\n8&2bXPĬͤ=h[+ʉ\r:F\0:*\r}#!\"c;hŦ/0ޒEj]Z\0@iW_h;VRbP%!b]SBUl	r\r-\0\"Q=Ih	 FLFxRэ@\0*j5k\00'	@ElOHCx@\"G41`ϼP(G91\0\"f:Qʍ@`'>7ȎdR41>rIHGt\nRH	bҏ71fh)D8B`(V<Q8c? 2E4j\09\r͐@\0'FD,!H=*E(?Ѫ&xd_HǢE6~uG\0RXZ~P'U=@l+A\nhIiƔPGZ`\$P.;E\0} Q%jAWإ\$!3r1 {Ӊ%i=IfK!e\$80!h#\\HF|i8tl\$lli*(GL	 \$x.q\"Wzs{8d`&W\0&E15jWbćVR-#{\0Xig*7VF3`妏p@#7	0[Ү[éh˖\\o{T]Ŧᑀ8l`f@reh\nW2*@\0`K(L̷\0vT\0c'L: 0@L1T0bhW|\\-DN\ns3\"`Ǣ肒2&\rU+^ReSni0u˚b	J2sps^n<♱Fla\0\0mA2`|؟6	nr\0Dټ7&mߧ-)\\݌\n=;*b蓈Ty7c|o/:tP<Y:K&C'G/@Q*8v/&W6p.\0u3Bq:(eOPp	駲\r0(ac>N|	t\n6v_e;y6fgQ;yβ[S	gǰOuddHH=Z\r'qC*)gEO \"!k('`\nkhT*s5REa\n#!1\0;Siȼ@(lI v\rnj~63ΈI:h\n.2pl9Bt0\$bp+ǀ*tJsJQ8;4P(ҧѶ!.Ppk@)65!(\n+{`=H,Ɂ\\Ѵ4\"[C1-luo4[E%\"w] ( ʏTe)KAE={ \n`;?-G5I.%q%EsgFs	KGn4i/,i0ux)73SzgV[hDp'L<TMjP*o≴\nH\n4M-WNA/@8mHRptpV=h*0	1;\0uGT6@s\0)6ƣT\\(\"U,C:5iKlۧE*\"r.@jRJQ/L@SZP)(jjJL*\0\r-Q*Qڜg9~P@H\n-e\0Qw%^ ET< 2H@޴e\0 e#;ITl+A+C*Yh/D\\!鬚8»3AЙEE/}0tJ|1Qmn%(p!\n±U)\rsEX5u%B- w]*E)<+qyV@mFH BN#]YQ1:V#\$<&Xxt@]GԶj)-@qL\ncIY?qC\rv(@X\0Ov<R3XQJ99lxCuīd vTZkl\rJ\\o&?o6Eq\r'3ɪJ6'Y@6FZ50VTyC`\0VS!&66rDf`ꛨJvqzF@ݵ҅Z.\$kXkJ\\\"\"֝i:E\roX\0>PPmi]\0aV=I6jK3ZQmEb0:32V4N6!l^ڦ@hhU>:	E>j0g\\|Sh7yބ\$,5aė7&:[WX4q Jׂc8!HVDĎ+D:9,DUa!X\$ЯڋG܌Bt9-+otL}ĭqKx6&%xtR\"πRIWA`c}l6~*0vkp68z+qXw*EIN*qPKFO\0,(|k *YF5;<6@QU\"\rbOAXÎvv)Ho`STpbj1+ŋe ʀQx8@5\\Q,ĉNޘb#YHp1kB8NoX3,#Uک'\"销eeH#zq^rG[:\rmng5V]-(W0~kh\\Z`lk ojW!.hF[tAweM૫3!nK_SFj-S[r̀w0^hf-?X5/IY V7ad 8bqbn\n1YRvT,+!NT2I߷K`K\"O)\nY4!}K^D@na\$@ \$Aj\\D[=	bHpSOAGho!F@lU`Xn\$\\͈_˘`HB]2\"z0i1\\w.fy޻K) p0XS>1	*,]\r\"<cQ\$tq.	<+t,]L!{gX\$6v %GHEX*0ۊ)qnC)I\"툳`KF@d5Ap{\\pɾNr'S(+5Њ+\"ĀU0iː!nMbrK6úr|a@x|ka9WR4\"?5pۓkrĘߒ7Hp5YpWG#rʶAWD+`=\"}@H\\pЀߋ)C3!sO:)_F/\r4<A\nn/T3f7P16OYлϲq;؁aXtS<9nwsx@1Ξxs?3Ş@54oȃ0pR\0yqL&S^:Q>\\4OInZnv33+PL(.x\$«CCnAkc:L6rwhnrZ==jђ6}MGu~3bg4s6sQ#:3g~v3<+<a}ϧ=e8'n)ӞcCz4L=h{iJ^~wgDjL^=6ΧNӔ\\DNE?h:S*>+uhh҅WE1jxt't[wS9T[,jvtA#T枂9jK-ޠYiQe?4Ӟ_Wz@JkWYhpuj|z4	im	O5\0>|9ז轠gVyu=}gs_Vsծ{k@r^(wH'a=iN4_{6tϨϗe[h-Ul?J0O\0^Hl\0.Zxu\"<	/7 i:\nǠ;!3_0`\0H`2\0H#h[P<עgm@~(\0ߵkYv#>\nz\n@Q\n(G\n'k5n5ۨ@_`Ї_l1wpPw\0coEl{ݾ7o0Ibϝnz﷛ {8w=|/y3a߼#xq@ka!\08dmR[wvǋRGp8v\$Zmtǽuop`2m|;#xmn~;VE3O\r,~ow[N} clyO;?~^j\"Wz:'xW.	u(Ýq<gvhWq\\;ߟ8)M\\5vڷx=hib-|bpyDЕHh\rcey7pxG@D= 1!4Ra\r9!\0'Y@>iS>oofsO 9.\"Fl20E!QːD9dBW4\0y`RoF>Fa00	2<IP'\\I\0\$\n RaU.sЄ\"1ІeY砢Zq1|#G!PP\0|HFnp>W:`YP%ď\na8P>`]4`<r\0Îz484`mh:ΪHDj+p>*8ՠ08A:с]wúz>9\n+:iiPoG01)ZږneR֖gMgsLCr8Ѐ!3R)00sIJVPpK\n|9e[ˑD0z4ϑo,N8ns#{蓷z3>BS\";e5VD0[\$7z0=8	T 3Q'RnLyŋ'\0o,\0:[}(|X>xvqW?tBE1wG;!݋5΀|0JI@#uņI\\p8!']߮l-lSB,ӗ]1ԕHN8%%	/;FGSh\\لct2|W\$t<hO+#BaN1{yw2\\Z&)db',Xxm~H@:d	>=-lK܏J\0́@rϥ@\"(AZ7h>\\#>\0XrYYxŝq=:Թ\rlomgbD_TxC0.yR]_ZǻWIG	Mɪ(|@\0SOs {@k}FXSb8=_l\0=g{HyG s_J\$hkFqd4ω'>vϏ!_7Vq@1zuSejKdyuS.2\"{K?s˦hRd`:yGھ\nQow'hS>LX}eG@9퟈W|Ϲ@_uZ=,!}\0I@#\"'Y`\\?p,Gל_'G	T#oH\r\"o}?O鼔7|'=8MQyaH?߮ \0bUd67I O\"-2_0\r?hO׿t\0\0002~° 4K,oh	Pcz`@\"H; ,='S.bSCc욌R,~X@ '8Z0&(np<pȣ32(.@R3@^\r+@,\$	ϟEtB,⪀ʰh\r><6]#;C.Ҏ8P3;@L,+>p(#-f1z,8ߠƐP:9R۳)e\0ڢR!\nr{eGA@*nD6N\rR8QK0颽>PNIQ=r<;&fNGJ;UAAP&`);!s\0pp\rn(@%&	SdYuC,8O#oRv,#|7\"CpB`jX3~R@v9B#@\n0>T-5/= E\nd\"!;p*nZ\08/jX\r>F	Pϐe>OLO0\0)k㦃[	ϳ'L	1 1\0C1T`RʐzĚp< .>5\0> Bnˊ<\"he>кîs!H{ܐ!\r\r\"|>R1d\"U@D63>o\rvL:K2+0쾁>\0 B{!r*Hy;`8\0دd\r02A?+\0Å\0AwSl\r[ԡ6co=0z/J+ꆌW[~C0e30HQPDPY}4#YDp)	|@&-/F	T	aH5#H.A>0;.Yġ	*D2=3	pBnuDw\n!zCQ \0HQ4D*7\0J%ıpuD(O=!>u,71TM+31:\"PRQ?P+11= M\$ZlT7,Nq%E!S2&U*>GDS&ozh8881\\:Z0hT C+#ʱA%D!\0XDA3\0!\\#h9bT!dYj2S\nA+ͽHwD`(AB*+%EX.ˠB#ȿ&XeEo\"|r8W2@8Da|NhJ8[۳Wz{Z\"L\0\0Ȇ8x۶X@ Eh;af1;nhZ3E0| 옑AtB,~W8^Ǡ׃<2/	8+۔O+%P#ή\n?߉?e˔O\\]7(#D۾(!c)NMFE#DXg)0A\0:rB``  QH>!\rB\0V%ceHFHm2B2I`#D>n\n:L9C0\0x(ޏ(\nL\"G\n@`[\ni'\0)y)&(p\0N	\"N:8.\r!'4|ל~ʀ\"cDlt0c5kQQר+ZGk!Fc4Rx@&>z=\$(?(\n쀨>	ҵCqیt-}G,tGW xqHfb\0\0zT9zwЅDmn'ccbH\0z3! HHz׀Iy\",-\0\"<2'#H`d-#cljĞ`i(_dgȎǂ*j\r\0> 662kj<Cq9ĐI\r\$CAI\$x\rH78 ܀ZpZrR_U\0l\rIRXi\0<r~xS%^%j@^T33ɀGHz&\$(q\0f&8+\rɗ%2hCxIlbɀ(hSY&B`fxvn.L+/\"=I0d\$47rA(42gJ(D=F(-'ĠXG29Z=,r`);x\"8;>&',@2pl:0lI\rrJDhAz22p`O2h8HĄwtBFg`72{,Kl߰%C%om+X41򹸎\n2p	ZB!=VܨȀ+H6*\0k%< K',3rI;8\0Z+Eܭ`+lW+Yҵ-tfbQ_-Ӏޅ+ 95LjJ.Gʩ,\\ԅ.\$2J\\-1-cˇ.lfxBqK,dˀ8AKo-3Kr/|/\\r,HϤ!Y10@.&|+J\00P3J-ZQ	\r&\nL*jĉ|#Ծ\"˺A/8)1#7\$\"6\n>\n7L1h9\0BZd#b:\0+A22'̕\nt̜O2lʳ.LHC\02+L\\rKk+˳.ꌒ;(Dƀ1sds9P4쌜@.AnhJ13K03J\$\02Lk3Q;3n\0\0,sI@u/VA1UM<Le4D2V% Ap\nȬ235A-Tu53۹1+fL~\n	-> ҡM4XLSdٲ͟*\\@ͨYkSDM5 XfDsUs%	̱p+K6/ݒ8Xނ=K6pH%3ͫ7lIK0LDu`P\rSO͙&(;L@ψN>S28(`JErF	2SEMM\$qE\$ã/I\$\\ID\"\n䱺w.tS	ђP#\nW-\0Cҵ:jR^S8;d`5ԪaʖE+(XrM;3;B,*1&2XS)< L9;RSNgIs+ӰK<sLY-Z:A<OO*2vW7+|˻<T9hy\$<#ρ;v\$O\0 ,Hk-Ϛ\rϣ;O>7>3@O{.4pO?Tb..~O4S>1SS*4Pȣ>3\0W>2><P?4@t\nNAxp%=P@C@R˟?x\n0NwO?TJC@#	.dMt&=\\4A:L\$N:\rI'Arግ;\r/CBӮi>L7:9|C\$)z@tl:>C\nBi0G,\0FD%p)o\0\n>`)QZIKG%M\0#\0DQ.H'\$E\n \$ܐ%4ID3o:L\$m 0	B\\(8通hDCsDX4TK{x`\n,\nE:p\n'>o\0tI` -\0D/KP`/H\$\n=>UFP0UG}4B\$?E%TWD} *H0T\0t\"!o\0E7R.tfRFu!ԐD\n\0F-4VQH%40uN\0DQRuE	)I\n&Qm)ǚm #\\D(\$̓x4WFM&ԜR5H%q[F+IF \nTR3DLoy4TQ/E[ў<t^F)Q+4QI#IF'TiѪX!ѱF*nR>5pKm+sIRE+ԩM\0(R?+HҀJ\"TD\$	4wQ}Tz\0G8|xR6R	4XR6\n4ymNQNM&RH&2Q/7#қ{'ҍ,|\n	.\0>{o#1D;?UҕJ9*jFNщJ #~%-?CL3@EP{`>QȔ%O)4R%I@%,\"I<\$ԉTP>\n\0QP5DkOFTY<oQ=T\0x	5D,0?i?x  mE}>|[\0&RLHS9GI1䀖M4VHoT-S)QGF [TQRjN#x]N(U8\nuU\n?5,TmԞ??@U\nu-R9U/S \nU3IEStQYJu.QFo\$&i	KPC6>5G\0uRu)U'R0ЀDuIUJ@	:V8*Rf%&\\RMU9RfUAU[TUQSe[\0KeZUaUhmS<,Rs`&Tj@G!\\x^0>\0&p΂QQ)TUPs@%\0W	`\$(1Q?\$CQp\nOJX#V7Xu;!YBSc+V#MUWHURǅU-+VmY}\\OKM\$SeToVHT!!<{RZA5R!=3U({@*Ratz\0)QP5H؏հN5+P[9V%\"\nGSL9l\rVؤ[ouUIYR_TYp5O֧\\q`U[Bu'Uw\\mRUԭ\\Es5K\\V\\S{AZ%O\$F>5EWVm`Wd]& \$Ό!RZ}ԅ]}v5ZUgQ^y` !^=FR^vUKex@+r5#@?=uΓsץYNsS!^c5\$.u`\0XE~19JUZ@#1_[4J2\n\$VI4n\0?4aR!U~)&B>tRI0_EkTUS|Uk_8&E(‘?@J5JUBQT}HVjQx\neVsU=VN4ղؗ\\xR34GD\":	KQ>[\rY_#!#][j<6خX	c#KL}>`'\05XcU[\0(Wt|tR]p/]H2IQO1SQjZHm)d^SXCY\rtu@Jp%M?UQ\n=Rar:ԿE-G\0\$d]meh*QWtc`AY=S\r	m-=MwH]J\"䴏f\"{#9TeMcNIDU6g2ݝeaLQ&&uTX51Y>S֊Q#Ij\0WP?ub5FULn)V5R@\$!%oP'EUP-Bp\nF\$S4tUF|{qȓ0Umjs\$ڛjcڐ֫aZI5Xj26&>v\n\r)2_kGTJeQ-cZVMֽz>]acc`tHj6+kM\0>##3l='^6\0èvZ9Se\"bΡB>)/T=9\0`P\$\0]/0ڪ䵏k-6{k[F\r|SѿJMQD=/WXVa'atol冶Xj}C@\"KPom3\0#HVv~{?gx	n|[?U[rhG`3#Gk%L\0I`CD	 \"\0ŧ#cN6ڹfzێ;ѤeeF7/N\r:QG9	\$Iռ]TWGsdWMIfBcۤ!#cnu&(S_wSf&TZ:0CSLN`ܳYj=>ŲZ!=rV]g	ӣrXl-.U'uJuJ\0sJ'W%\\>?BVj4J}I/-ҝrRLS3\0,RgqӭTf>1\0_\\V8Ztc耆<^\\llj\0T]CwΓzIZwNpVWjvY>2	o\$|UWL%{toX3_RJ5~6\"Zl}`kceR=^UԎ1ѽw7edvb=\0f,m)Gp-Ӽ)9L>| \"@5`:\0,t@xlJb6aA\0ػAR[A0\$qoAS@<@y\"as.V^讥^\0H[H@bK)z\r=^zB\0No<̇t<x\0ڬ0*RI{^E:{KՐ1E0Y/c\"\04F7'\n0`UT?MPl4r(	Z|&t\"ILw+m}Wi\r>U__u63y[8T-V}x_~%7{jMo_E~]P\$JCaXG9\0007Ń5A#\0.\r˴_%\n\r#<MxJ|2\0;o^a+F笀Lk;_#M\\pr@õOR~zANEYO	(1N׉R8Cn?O)1ADo\0\rǢ?kJ\",OFa-b6]PS)ƙ5xC=@jLL:\"胻Ίl#Bk@N:>|B9	:N\$S CB:j6ΉJkuK_W͢ØI=@Tv\n0^o\\Ӡ?/&u._\rC+c~Jb6e\0yѡ\0wxh8j%SVH@N'\\ۯN`n\runKqUB+f>G\r=@Gd\n)FO hʷÈfCɅX|I]3auyUi^9y\no^rt\r8͇#N	VY;c*%V<#h9r\rxcv(\ra(xja`g0V̼Qx(glհ{gh`sW<Kj';)Gnq\$p+Ɍ_d^& Dx!bv!EjPV'(=b\r\"bL\0bt\n>J1;ۈ4^sQp`fr`7xE<l	8s'PTֺ˃z_T[>:`1.;7@[>6!*\$`\0`,@?m>>\0LCǸRn/+`;C\0*<F+q M;1K\n:b3j1l:c>Yhގ#;3ֺ85:\\\0XHaM1\\L[YCvN\0+\0t#\$!@*l	FdhdF&Ƙf)=04x\0004ED6K䢣\0nN];q4sj-=-8\0sǨDf5p4J^'Ӕ[H^NR FKwz EgF|!codbx\0-6,E_3up /wz(exRaHYce59d\00@2@ҐYfeyYcMוh[ez\rv\\0e\\cʃ[ueNY`ۖ]9h姗~^Yqe]qe_|6!u`fJ{7M{YهjeCS6\0DuasFL}\$ȇ(MbƤ,0Buίт2gxFљ{an:i\rPjerrGBYM+qiYd˙`0,>6fo0o Xf\0VL!fl6 /1e\0>kbf\r!uf<%(r˛a&	Y!mBg=@\r; \r5phI9bm\$BYˋgx#@QEOm90\"!tˉЇO* \0>%\$orN&s9f4g~jMfwygy\\`X1y5x^z_,& k|1xA6 \no蔻&xgg{r?緛-|t3}gHgK9J<CC197gh6!0HcdyfDA;9T0\0p! 6^.S²?E(PΈ .5hEPJv.+\$5>P+?~g6\rhpz(W`\"y:FadŬ6:fi\0A;e^wf >y`-\r\0hr\rr8i\"_	9CIfXˈ2\"ŢhL~\"%V:!%xyizygvx]}qgZi|`+ _g٣譞6PAʀ\$=9h|p!.!i^iˢ8zVCZ\"(9U)!DgU\0j?`4LTo@BNa{r:\n̟E8æ&=E*Z:\n?g̊h.N5(Shi2*cf@7z\"|rP.ǀL8T'k:(q2&ED2~ر9v8@^X=X`qZQ֮`9j5^@竸nqv3(I6jdT\\ 3,hk3(3PuV|\0阮Uk;JQ.	:J\r1nBI\r\0ɬh@?N\nsh\";r~7O\$(5R	ʽjFYFܔ~x޾f\"vۓo˨º#aP<h-3麝/Gxni@\"G?,ZpxX`v4X[I7åXc	!b}j_95qti6fٞ5FƹiѱpX'2r0ƺD,#GU2؏I\rl( 챣=Aa쩳-8dbS4~H;06b{޺Rs3zNބ`ˆ+4<^ay	}ryk&4@?~cE@LS@z^qqN</Hj^sC`sbgGy^\nN\n:GN}c\n +=p1NTB[dЋܹ`noj;jěwhc9p̡[y405͋N+ο`Xda/zn*P#t赸~9W	V~=#n)	2;j:JkC!>x5==2.|'[';v;:SA	&[men˵<6ma=Y.神:g腀;I߻x[IJ\0~zaYwT\\`V\n~P)zJQ@[{rʉDBv|i-EK;^n{:Nh;2ƀpѴ6罘99XhQ~iA@D j}ozLVѳ~	8B?#F}FTdezcFg7Η 6#.E££S.J35KɥJ;n5:ySCvoս.{	d\\0?W\0!)'Eg;+\0YNtbp+c\0B=\"cT:BcPIDV0!ROlON~aF|%ߺ)O	WoQw:ٟl0h@:օ8Q&[nFp,æ@JTw9(<{ƐO\r	ڂ\$m/HnP\$o^U\"{Ė<.nq8\r\0;n硟+޳3n{D\$7,Ez7\0l!{8x҂.s8PAFxrQۮ1̅p+@d9OP5lK/\\msqvQ/	!z7oEǆ:qV5?GHOO\$l+,\r;~Ač錳{`7|Ăr'Ji\rc+|#+<&қ<W,>^P&nJhe%dCizXA'D>ΈEk@Bw(.\n99AhNckNd`p`%23Hb2&<9R(tTH	z' o>4?\rZwӂ4`Ї鍆NӀ'-I0(Srw,Kr'-2Hlo-U_'W#'/H֟j6̉ȫ\0<j1EQTTrBcm16͈g٫:w6ͯh@1I:2pL/w:őK<E<J76Ӏs.̲sZ/\$AsEyϜrr:w?Չ!?ǙZM9՝\01?ARͦ%7>MARr}sr)\\t-8=ЎU,WOCsՆ#w5ERlM*D1>]gKV\n\\s܇8͹seͧ9so~w4xf@D96\0	@.@9\0C;Ky+J٥u<\\`c{ӋE>yJ=l/-7Z46uC5PΩRVʳlVaNx`մ?U7(HP}jVJzNQJSs-gQ!aV_SwRO3amZXwZo'waOoZ![\n<ZOҶ'Omo[a=Q>:T\n\0=mjATRbu(I:\$vWuS\\V8v\\g!Mжu_&is\\CRVM]tXT7\\UoTo_ԯݛS?alS-LutZGei`	}XZi}QyW[iTYo(ZE\\}nٍifڋWd%Tpu3uTf5)v]UR3VEY]X\n^VqSS}XiGfv>SvJMQvڕ\\g]QYEݵ#1Vl5UEK]\0SU?\\BwSU7mZV5\\Wfէ[eUr{G\\U,W[]xVj5mTVj~u7\0VU'tw?ms5Vvݏq}u-Uq]ݗc]W]Tt:fMke][-p}^I[XDYVdO]	seNZWY[tV?3ǵMݙ`t^wd:qTL@@>]j\rFqv-LvGKwiLwIPMoǹMgv[Uss~	w:BANE{!-do\0}&hXA5%٣fzLH5d Y_%vә!m]%=B>E [#^}hYFa>{gSp[FDa6nx98LI㈫Na=S@bPk.NHl\0:2#Θ;vO}9ik]	&{ 2|a&Q)oفǸ:&.\05q\0JL64hy3ޢaރIzOﮈ\"yBʳ{3%5r(mx.7rb%^eM2\0x!b}.Y6\$qS\"^|xEaXǡ59'TR	c9W1AΔP؏h6'o-pT(\nn\rŐ1RRUgxPe#*kT<<>b;\0gL.<kZvz8~y7Yȁ7wOdn><E3wSۆ@ oW1Һze޽1z\0f=c㊤g{>np\0Α:HBn6FBrW=C>M.1~@3G98q<S|Y8QP`L[qz۫PN<{_-ٮdOd-NB74BN.V9ƨQ3{IcP\$h<R yy?G:ng;Ah!&+>ˀ;Mˌ	6SNڌ=#`T#+n;r,X|#\r#?\nD>|VSeϗ~Jm99\ns{S|r],~˹ qI?\"|w%|j\0rE,kSnqƕd8B.1\"/|؃]EϜNlxI IcŸ.|\$8DFPK3\\jxUC/җA{eܾ\rpU\n՟Wlo­Y{`]'s/|o3r};[nOM7ߣؼqq(_lqsNy;igt:ՙqk{?zMȗo'jcy߄ggkwf8Vc7fAY+Kx=gKAkT,95rd+Gٯ[%Aw柞7ଅ%{m8%_mqV˨_%!Ei~h~C߭~%_rLkDy~?p1O!?v\\Pm\"<E6 EVzk9z~/պ!Q>ONm3r Fle;M߷Ͻ_a!~Cfb}3 Kf. 	}.DX	i5|?=\0???@Õfu~a^nyQ;q)sS,\"G\nu%UYAKl\nBI86VCcO\0`}.x,-N@~TG'dJy1zlæfgABa!M\\<gʃz4ƿ@/CÂ@	Qq)x/.7inD#= *79cFd2(.V3\$g`A᧋rl|mb/qEô!bU@9i;ppdפ=1yxx	=v=(vs_Boɂց#K\r n\\# fPXu-3&	J&,F(9v0&@khZygCԋz Áhi=s9T eT>g3dtF2b&:\0PB-Q8~LSMڷcgTh'f(\$.EVLAIߌrg\r0T1P`1d\r4=6@F F=ɂ6A>NAV	(\$A/;?gf^	\n&KOn{]g˛8cўϷ\n7Lt:ѠhFVO\rJ)b(\"OBm	o\$]TSHZ^Kw\\[A9('لcۑb0 KsrBx\n*Baz6o\ry&tX1p'^M<Cg`48GHzd?gX.@,7w۞:+TiUX16Ls:\rL6fr\r`t67~gxgH9JO=-\$4?r٪4O:z{D`21Fܵ(DM;&́ڭU>I6c߸@\r//ԕ_H\n7z 7aɻ[9D'}BORݟB#s]z!(D@L^	x@ouOD!e`\nak>0`-*8EZ6=f%c㛰K=F\rShyN[v*v\r@#߸퉁Ah*L\$AA\\%*	p\r*==8\$W\r [Jx0yZ+&YHA~A\n,\\(p!F<6S&IP`6Xz+df\rJ£is+&5/rEM^\$R(RQEw3lH*m\0BqarLBQz6~lB\rI®GXٸXVbsmBHc_K\$p-:8Nj:х-#F	\0aiBs\\)<.!\\NbIw8͹tPjW`y\0&0i?Ҕ:Ia)=C,a&Mapƃ\$IIFc\0!Yxa)~C1PZL3TjC\0y`\\W\\t\$2\n+a\0aKb\n]C@?I\rHヮKs%N^9CL/=%ۨh:?&PEY>5n[Gْ%V*w<gJ]*wd]B5^֢OQ>%s{ԅ畫;WzGi*RnG9E,(u*Ւ×XsR:5;)RNvK(RMb_{F<<3:%HVYS\n%L+{o.>Z(QkN!,:rH}nRNkI		[ӧg֤;mYҳg%9V~-J_g\\ɮQ\n!t\\UY-tZnd:Bʽ*]')twɫ[BUm*r4ؖ*yvvZչ+GHZnP܅|\nT %#\\AX\0}5b+wrXwܲ1u%Cg=Iv`cre0`..<h+H̝^\\jyF%]B\0r+>%Zx %C.`Vn1KSk\rX|[;6H	U@D:޻Mj	Ε?]ڤbA+G\0thxbL`64MޛY#hfD=ew=c+H:.%^\$DZrAzjfLl7o\0-Edމyz'V ӞW	ZK+d(AfyP?xR^h'A\0:p\rd(Vdt	SFcHȟ]rrCHY	X_/fͽ 4 7e6D{,<<Z^j\"	\n+ƀMY9A(<Pllp	,>Ѐ{E9&Ghh{(Agg8(@jTngZŰJx@icՋ(p'oJ0MnĀ&\r'\0Ց\rqF4)cL_oJ}5co|6m}Q4Qb[xm( &@;+򘥮f|IR48 {	`k`ur`W㸱`\")fI\n;8Zjg~AΈ!j%TE\\\r3EjjFXZ	AykHXdgCQ΀0dt	zk`@\0001\0nH\04\0g&.\0\0O(P@\rE\0l\0X\rE8x@ԋ\0^z@E\0.^Qq\"YD_p&3\0mZ.Pp\rEϋsv\"0`w,_`\rc/]xq3\0q.pq\0002_iъE\0a1bwJ \0l\01,`1y\09#?0T^q\$F6/\$dFDyJ0b\0	W\0.c{c E\0s3l]@\rbF\"\02`\"7/\0a	^04eQ{c<ьj/_ѐc\0001*28BA\0000xƔiؾ1F50ljH\"F30\\_q\0fTl_0тBEČ#3]sƽ64_X1\0ƽd``\rS_JMV/f1\0005I6tf4F34fF-6d\"4k\$h±#Ě\06_01c@F/d]XQ#G\n5gqEF\nm\\DnqYFv1/4`q4=8bq|\00043mX1e\0.\\QcI	.7\\x`\"\0i^3(籒\"Ev4l_q\$FoȾ\r#UE䍩^9t.\03|r1\069l^xѼPF-]\n0vQy\"G2,sxQq#F+\0/Diq}8[6,j\0cmoN5ehQvGLH<T_Q?Fɋ..\$fyEC2l1s#EDlohѲj8eűbF!9`xqC7hx٣Ŏ7^xK<h	,u鱑G);lu#Eߎ<kb\0sR.wֱ#z~w2|x(\0001':v\0001G挿?|` .2X#G8K@<z1ƹ\"9|j	G/6qGs7/\0001bߍ:|8Q#~FW4g#<F\r 2XQ#Fvk7x1#Ǝ@rhFZ;frcy!\r	_x1\"H10Twٲc\rF1 \n8dXrԌ2Db{d4HrA<~1dBHI[J?q~k0t#F\r#0\\h\rGEttc7U!=D_cN\0y6a Fg!v1q1KǇ@eѳcGo\n/ƲE\"3t`#cH<cqF%?Tb蹱d) r0qcE>3\$tyQңECl`9)VFHMJ7f\$HHQ ;ri7#F-FHQ#\0G!1^&4vG&7gృ\$\0G\rr/dR(s6@'RAǬ&g\0k z=|Hٱ^J]sd,\$1<cqǦJ_bGQvJرH5FpIc[@rvH%3Dc<I\$M.dr1c=F.4c2bG.!L|{Xѳ{INFdxqscݍ#Ea)#GJm.\$=GhAN=sŤE͑GG\\a10HF.tg8ä[Idn8F.TF3E6riqsF6xrL=nFTod>-3|2\$0= :xcHI\"NP\$bQ\$F DĂ}F%?(G3\$O\$^x2T0R#D:E|i/2XG8-\$Hv=d `:laxI:XRJRmxJ#\nGG9!N{cI&IR=I\r&j:8g#H'3_xbH}>7cُ\"&K<x2H\"6@db뱭e;)!.]/dm*f6,vɪL(qAI87d9TtcULX%HI*z:|IXqs-Bq^(Raq(~e9JU+-eq*nT>\$ѫerαp\nռ\$es+VIbeq:#]cc7r\nf,gYTC%	}\0\\*EWPa:E,&Wp)xlM3\0t\0/IipD'\0	k\$TF]fdMȀK\$H(@ɔ(znWҤ_Mݔ*\0elF^H	W*BZPe֘R/dRRʅ\0Ku,yH)\"SXI'Z=LR3\n'[k6@;}RI_)w[ \nnʓbBrl,\$v԰H\\s*.QtBdb@?3S`a@K\\.~f),?|&ӶKZ9.X+S|\0PʼEe/\0V^K\0\n-	:Sز)ת0j9TXBK\"ů²,2'2P,xpKꗪ\"D#TVD1Ao;ؕ/9TH%V`WJ<9aeʰK/V^/Q\nBZ\"9XүM~\$5\$0dIU2^X\n*E7I\nV3+aIiNKKg0az*V#bJyMҦeZ V`U1C.\rF-j&LUp9s鹊+Q&1RmӱgZ	,.XryZ첰032A1ւeN(?Al ,Nue\$|r_%E05E}\$X2%Ze \n\";<9ah㶥a]8*uLdR0+Qm.,GM_2edBݸ,S2>U԰4vl~e22eĵYg2nf=\$%ٖFfa)fTƶGg2W,[X>)tA]R*&Z6j2|\0(p	9 uҪ?`n-lZn!H9zL9VLϹyݢZJhRgEfLU~`4Yx)\$BQR#ÕS,6i#Y,;Cri&X]\nw54Kx\n*&TW+SлqNcyIW\0W5cɫ&+Vr)Kg? |gRhR%K)Z#5,ֵk漻`l:LsC[MUB6ldѓJ1nl:jLߖ\0h *)p/ާ5\\<9V/ޫhTdjrMbx\n]RWR MaU3=`0o,Zl}m월lmLS6\\tΙL\\%JK7oѩefMoCYv慭NV4=RsJ*hhn-m44yHM|isU=A\$ڭiϙ>ppQfq,5sUL8}ݬ٪#XHI9U8c:If7kl5}fLYN2ް}&	ic,I3R6r؉3b͍6>lXYfL)+S,ى*elU\"ed\"Zږ6ZDE9%΂Y9rmtE'.M[4^ɷ;Mw59av+70ld%<3_<lN(v+7YRl΅Ӫ].4I)=փNT]۹'U^?S7XCũӨ1u9EߙkL;NhSqNXk;1[LgpVB1_gs;RlENT8w,s1Pxrq3(;Z	yӾ'{O	_rȪMg|I92eLfO\rYnkuSNv9Vk	3ǧ.̛v9zyd)NY&s\$jd'6͔Q<V)e+:جYjtpu<ʖ3]qMY:9XSgIÝ*mCvGR@֯jT=:e(\0_Vn,?p	3'Π\r|\"igTnP皤\nӔq,Sf.YQ AA,ZeSsE\rvTQZ\"pIsUAϛ\0vZ}rKtfPf9疮{^Jς\n0%NGګ*~lD.Ke6[,%O՘-~쵕jRO;@	˨enb_%sKŜYY0LWjrՐφ!BPvfwګMR22z4rh;#M@}\0|M\0=ځ=f-!6pg[P4C[5:\rCtàu@ۺ<ifNun[!u8j{&9KuFQlRi(CA䮙s4\0Y;fB<{嘼R_I~6|MWTA]4e@JeP|[r5*OΠBt)%-\0Pjm	us}ИBi^*z0YK.`[Y2Ы|XB(?З.\$l,XD\njOD->_<֝\0sh\\ea\\\0e䑙Y`7U\"eCYTzt:V9P_aЕF;݀\0M2eHCZ?V'}cYa脬?Qh8	0QCM`6,JeZZ\"GWuu\r>49KI%LV9։Z{VEOX;oagP\$\nRX@}!-SiRqz	ITH.\nk\n\ndϮT>\n?E`5D+f?#zIZ7T[Qs#D\$PI	3*:9YIHHX0D!u7JmYB}E简r8Q\n}'PS	Q\$`R)^(OP\0aKm3\$H.X)V`9 .Y18eU`X9	\\LcjIE N鍫6WDXB	Z:|Ϥ:	E-P-&)*l)Puy|RLh.p_*QA@ ?,ƧY)tч<P*jVuQ:2\0L?J,TPHLE%\0yP(YJZTHX\r	Q4hO;\\vV#TWw\\`Oҡ?JR2=F]I5TMjI9,(ƤDv|t)Wy-]zea,pQ6\$I-g=%SW#TPܐ)T&]X15jB8Vӥ\nem yh*d4ςbd!0gRJ\\ Mt1R\n\nx._u+Ƽ;*4θ)]\\l(m\"QnT(*\0`1H@2	6hYcH_f?a7=KKdetH2\0/\062@b~`\0.\0v) !~JPĝTO{t\0005/ீ\rJ^0a!)8%KޘPP4~H\r+Lb/24)GKe0eS1B	-0jfSwLΙid L\r1hȩS MJJht)+?Le5n|FHMN5jɩSHL4=TDMn6Zm@I@S`)'7fzSzx~OU1kSFMOU4p٣2\000076k#xSl'K77\nlxSuLR77stxS}GM78*qt#xSOM\"78u)ӏ\09r)Sr2;)7Njm/xӿsNڞ:jy4SgO:1=\ncTSͧ;{Sȧ/ORH\r=tTIݧO\\zx4SM>j|TiSO~\$lO}t٧Oz*%]PPvU\"ݧK@\nojH;P>1FdP.5Bظ\r3uB<L#<QPECʁu*\nۨyPNl\r6?KmBZijHO2}1JM_MmD&KQ6Fzv6ӹQj;jj)*mEʌ9FdQv5eGɵdԄEM\0+D\"j)SDQҤpZfƂmR&HUہ%{Rv0m0z䧟Lƥ@'ER?eJ>ԝMIYTR/Bʕ.UTYRΡL:jNԅRL5ji&,OmJD5,9Q1hTfNޥQ'7Lih\rcjԝSzu\0nԺg9@c\rT%LAfTMT9uQ\n)USuD:jU	ƨPږq*EڪKSbl\\ڤFŪGTzgJHSF	\"Q:1;RꦵL*~EߪoTҦ\\z:]SꕱBU^JuR*kE	TQtRg2UjV\$_SmPHU\\T[Uʫ5Jhٵ\\UpV7a_*=R>\0I*VX:hU8jTKZ\\:)jT8	WZUbJ8R=YUVUR\\:-jѫiV.[zҪ-{TZuojU3 [>E %\\h#bՅWZ-\\CW>]ںg4#KTrZʤwj\$z-RjtjU*Wtp\n4'NMxUX32[x+\$BUS*qUͪqXZ}Sx@-W\n5XZՅJU2=\\F+V0]XXU0-VJ+/Zʮ5sjDU޲%bɵV%Y^u@dբW愔ŲRk&YR\\ŒRkYcVO-\\	kdKoXK/9]VO-U<@嬥Vγ[6U=eϵo4TݭY0eHդ\r96(󮝕+7ybrI |\0:Fz\n|s<R%J]F3jΣYZ^<5XIJM`nO\\B&rsQuzx	TVwJ5g	?vqF49ӝ6zjOV\ru=@ʒfT͚y	֫pKaXU9m\nekMo5\nhTꦦVv:s\\p>L:)O=nk}jS&֮~yeܚZֵ)jtVRVsr:+ao,!TlUϕ*n5\\Udv+M\\)]B|Jl;45pLӵئ7Li[~bmtSe\"Bvd@ͧS4)ؒZ\$)5ic!Ό\\R*SDw\$9tS\nGfPԛʸ*	KDVy5uȦJב\\C\$W,M\\5k^Vs5kֻM^{uϤwFQJHgWNk8ʉ+1br˕VX]dLjYTv6twy˕kvx=5h8]˷x\"c|ufU\0ҧ5jȩ}Pkn̚Rlf٪+ۣ>c4W+TDoqSXb}}hn&<?/3-áhqn	p%)SyP\r͵m-f5[\\=T}y )Ydؤ46#Y>3נm\n09h;40+ae\nȃİȞ!)@xx}\$AFÑ0N R	ӄiܥU?b5!+׭\0Gw{ӤlI )w-4;p8ؤ;@\r\n\rN5ƅF\\ӹhgPE il0X%)\nLk^2<5FdI<FjbMd'	ƲDBmaOYXgg8ZV%mf%F-,\naFwfs0G乑Z\n	1;J1\"iPByCtzӉ;l4ҡJmLX+lᘪ{8\"\nV(\$Y\0d\\݆6D9BHd%16f \"TJ`/>C=c쨱?e!k*3l~i,Az/dMoڲn\"ɽzTr}eٌ{MaC7fiT/6WP8Fa`5Mf2V]['}cn4]heZŧ\r2XllGa`((\0_lOf&f1c8D{Q	S6p\0Y\0\rq3m&*f;p6r^cϳ`ɵ&zn^ڱ;DSoj^=L'g5&Ef&|\nK 6?bX*.fψE~&9!dk@v\"FGx\\=E7XP2[:\0׎X~7X64(\";B\nXhy&DֈZl\nKCp`mS	2U;G8{-WBm\$F\rl&BY2\rmAőwZ6RВ%d_T5``BaGcXK\r\0gN\\;Ns^\nuѲVwzUF\"\0T-,^\02 / EW/\0¼ľ4;\"K-NZMcλRVNeZwj6aÿKVlN?jt2T/[Nj|0t% #\0`5F<X@\nӢZF\\-mcd2p5Gv'B'7{k*'LAZ|Ik\n-.C6k-Sk]_\$+Gנ[^z]k8\\F|?B^B̎|@BzPW/R?[!bBkѠ'	(e:xfr7\r_qMa\0#7|Q&\0Ɂ@)1뮆LA[Pt\0`6\\ezxS݀vՈπU:ڱTϗ>f\nql+K(|\\ѠGU؋@(*iS%F\rR\$CL;dļg-\$m?lhʝ3?PY\0");}else{header("Content-Type: image/gif");switch($_GET["file"]){case"plus.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0!M*)o) qe#L\0;";break;case"cross.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0##\naFo~y._wa1JGL6]\0\0;";break;case"up.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 MQN\n}a8yaŶ\0\0;";break;case"down.gif":echo"GIF89a\0\0\0001\0\0\0\0\0!\0\0\0,\0\0\0\0\0\0 M*)[W\\L&ٜƶ\0\0;";break;case"arrow.gif":echo"GIF89a\0\n\0\0\0!\0\0\0,\0\0\0\0\0\n\0\0iӲ޻\0\0;";break;}}exit;}if($_GET["script"]=="version"){$pd=file_open_lock(get_temp_dir()."/adminer.version");if($pd)file_write_unlock($pd,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}global$b,$g,$l,$mc,$uc,$Dc,$m,$rd,$xd,$ba,$Xd,$x,$ca,$re,$uf,$hg,$Mh,$Bd,$ti,$zi,$U,$Ni,$ia;if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];$ba=($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure");@ini_set("session.use_trans_sid",false);if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");$Uf=array(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",$ba);if(version_compare(PHP_VERSION,'5.2.0')>=0)$Uf[]=true;call_user_func_array('session_set_cookie_params',$Uf);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$cd);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("zend.ze1_compatibility_mode",false);@ini_set("precision",15);$re=array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lv'=>'Latviešu','lt'=>'Lietuvių','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);function
get_lang(){global$ca;return$ca;}function
lang($u,$jf=null){if(is_string($u)){$kg=array_search($u,get_translations("en"));if($kg!==false)$u=$kg;}global$ca,$zi;$yi=($zi[$u]?$zi[$u]:$u);if(is_array($yi)){$kg=($jf==1?0:($ca=='cs'||$ca=='sk'?($jf&&$jf<5?1:2):($ca=='fr'?(!$jf?0:1):($ca=='pl'?($jf%10>1&&$jf%10<5&&$jf/10%10!=1?1:2):($ca=='sl'?($jf%100==1?0:($jf%100==2?1:($jf%100==3||$jf%100==4?2:3))):($ca=='lt'?($jf%10==1&&$jf%100!=11?0:($jf%10>1&&$jf/10%10!=1?1:2)):($ca=='bs'||$ca=='ru'||$ca=='sr'||$ca=='uk'?($jf%10==1&&$jf%100!=11?0:($jf%10>1&&$jf%10<5&&$jf/10%10!=1?1:2)):1)))))));$yi=$yi[$kg];}$Fa=func_get_args();array_shift($Fa);$md=str_replace("%d","%s",$yi);if($md!=$yi)$Fa[0]=format_number($jf);return
vsprintf($md,$Fa);}function
switch_lang(){global$ca,$re;echo"<form action='' method='post'>\n<div id='lang'>",lang(19).": ".html_select("lang",$re,$ca,"this.form.submit();")," <input type='submit' value='".lang(20)."' class='hidden'>\n","<input type='hidden' name='token' value='".get_token()."'>\n";echo"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];$_SESSION["translations"]=array();adminer_redirect(remove_from_uri());}$ca="en";if(isset($re[$_COOKIE["adminer_lang"]])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ca=$_COOKIE["adminer_lang"];}elseif(isset($re[$_SESSION["lang"]]))$ca=$_SESSION["lang"];else{$wa=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$He,PREG_SET_ORDER);foreach($He
as$C)$wa[$C[1]]=(isset($C[3])?$C[3]:1);arsort($wa);foreach($wa
as$y=>$_g){if(isset($re[$y])){$ca=$y;break;}$y=preg_replace('~-.*~','',$y);if(!isset($wa[$y])&&isset($re[$y])){$ca=$y;break;}}}$zi=$_SESSION["translations"];if($_SESSION["translations_version"]!=2638827313){$zi=array();$_SESSION["translations_version"]=2638827313;}function
get_translations($qe){switch($qe){case"en":$f="A9Dy@s:G(ff	:Sa2\"1..L'Im#s,KOP#I@%9i4o2ύ,9%Pb2ar\n2NC(r41C`(:Eb9Ai:&㙔yFY\r\n 8ZS=\$A`=܌0\ndF	n:Zΰ)QmwOmfpQ΂qaį#qw7SX3o\n>ZMzis;̒_:#|@46:\r-z|(j*0:-h/̸8)+r^1/Лη,ZӈKX9,p:>#(6qB742Lu*/h\nHh\n|Z28\0Cz7JH\nj=-B6pʥ):81#<Ђ9XЀD49Ax^;rA473\0_AУJ\0|63,bׇx481Oӈ#c:9;̶T*<Ua/8&!ˣCv8HL\$#΁!-w7\0ؗ˂.lhL0h\r0:Vltxè^@3c2DN1\0S<=T~9΍c%̸_acCj\n\"`@_dp\0PZ6\\jKN@!,,#<{&(2L2\$Yh<N2Z/ON!5&˩WXI|Ȧg H	YR[D3Gm1-P\0P7RqD:fs-7t<!q\nwAN`M:6X	Sr	?)ΰgQMݟW4&3L}C;=֔%R5RJGԚErRJQK):iSP*'(\rzUMujSEiKɀ>W,vOKuxg䦡h@L.CX\$hHCfko5;gmM4|Rl0r~܉iP@@PAhPPI\" \$cDJ\0n7`C H\$-ԟLIEFrtxdO}<2Ҥ!ɞ M4nQ!aL)es\ni8zL%\$|Щ/S	ONEx[}	 A1w\$1Ȕhq6eD2`@es2CxS\n\\0ФMV,EfL9ᛐ5ʼ@k#c49s\$	1NI\"\n2d#HӞq7n2KCUq2p'@BD!P\"j E	5޽iIƝ( K9I\0003XLLj^5E\0lGHz%rw1f\$`TlI^Q<'MOQAY%y?\$0\$N0a3c|,ȼxŤᘀ6Je3uFyɯjΥ@^+Thvz5m!Y@+l֪7G*Z\nd9'Kg[U/ɔ2jVhe,PZ`V+-&U%Fo̓9-h'+r40cM<\"	:T!\$	_tsR.Nیw]< ^a0Đ3\nz=]RBZxX:;x\0N1/ˏ<l1:ŦCcy Lu;dWJ\$ȗS#[ܐv,kuˏ&D'r%L~ʎ5B4ޤ%\0CITdZ-\r:\\.D㸰&\rg,\$Im	&t}]N?9Uxv#Zj!7e5w\\(bM6J:Yrg4Mkl[5*N(eaL0	qkÊ!u4ث3'ݵgxꕌ^cB}\\ZH 삆uUC@)-<ӡ@vfW6;\$-[Q;.Nu%oʸY'5Q\\m)	Bl	4ݒщ5XaD͏Ϙ	\nXWdy|/=\\|eW@i` {>{skb\"q6|K\0MOȆ* ^\"*!v\n~f\n^/X(W7\n{]w+w̩MZ!/6.,.Ѹ'YXcs~{	:aS}v._u`e1\$j<yd:}9-|DҎlzl{.Au.M/Rϼ/\$,~NXDjb2+V!)_dHosNZ)WP%/eJO.nW/pd,OD4ؾd*Oھ\r\np\0.~BIp#I`Do`\07Q\n\$\n\r\\\r><D\0J\n\0\0\r@08\rbL,xQN7\r<7Rw2.\"	qmY\nج[ nB\0e\r \ro4\$m#Z\r/'()Z59o}BZnlqb\"g36cN	h\r1lÎd&6\r#h.ĿhUj\\iвǼeXkK\"@fd:+b@OpȺebڲM\r¹͸*0\"r5\"V\\#bMw#2<(L/nZKn*<\0@	g2gfJ@-l^%|HY\"vk=u@ĬQdr)YĨ,Ĕз@K pP&o`)DIZKLi*L/\0R6s";break;case"ar":$f="CPl*\r,&\nA(J.0Se\\\rb@0,\nQ,l)µAj_1CMeS\ng@OgXDM)0cAn8e*y#au4 Ir*;rSUdJ	}*zU@X;ai1l(n[ydu'c(oFe3Nbp2NSӳ:LZzP\\bu.[Q`u	!Jy&2(gTSњMx5g5KK¦0ʀ(7\rm87(9\rf\"7N9 4x荶x;#\"2ɰW\"J\nB'hkūbDi\\@pyf9V?TXWF{3)\"W9|eRhUҪ1P>\"o|7LQi\\ H\"#1|t\n|!Ҝ'e:\n&T=)VKvҨ2\rTBPOp6#oPhYh޳\02\0yq3:x}\rcAPHp_pBJ`|6-+3A#kt4px!ŴUOL3jQ8ddmWKVɣn\"@P0Cucx<@6\r#7\",2U*?il-vpιZ!`%0d.;#`2b<|9piZԏ<dRYMtlO4c-mOyK#o#ch50ԢA\$'\"&-HqZ8P&SSΦIבYӱaoұlkȦ{źmiՙ=hFʪٶ]9vpý6+y7> Bl5lD7Ҕ@P(n,,C\rU2fsJ:gH43f)?iDXI\nsYWBU&4ZS{%6aWύA/PXuh3	<݇%W3\\4Db^z/eXဇ&X\$!`0Hm6PUp5k&kbHq1hp.@ʒjFTtL h4D:1cF8 f(\\!63y7s6荆*vc⍑oPeX¶aK,Ԇi?fIIgjBԙ=mDԚZk͋\\CPٛ*o\0r\\a0A5\r:ʈfaMμÛfۇT S9\r@!0UPZD[R0D3\$v^ilDʡԯ4''W8Vi\n:2BP)G>G,AF\n3VWE8LI&}dٮÚ 6 =)@L7	E鱄5(\nO\naPUV.f^^i(8ig!>ڵB=13M(qmO@\0vE6&\0k)\\a*iK=ok)bCAG㣢+cZ!\n6+FVA<'\0 A\nЈB`EjPֺRNDM\0.~ՋbJ`&JٲےOa%%&B\\ҺG&)(\0n1(/O	S\n\n0t_\nBXdp5 H/;.2gẃ\$Ĵ\\*Q՗(s103#iIq=TA`u&Q \\Mm.7Vȇ=A_5BdhH9\\M@L4\0d-pL2G!\"%H=w[VOP i5s\\5;;l\nDۊ;2Gj|DM*V.'x8dyGX1c67{)h~GI b(|h0DΌ9#pOk4b\n!Ac2T]\n&n\0M2^WsբIwe*{fn	4`ywtVtA.mELPTI/-!6.7<!a'd*U}5OM\"&P\\[i蝯vЋN}D=0\n	G}syU>M'ǕA	hTH-JyKKbڐx<IOlh+(\n.sb?*#g(\\ U_1n*_ׇtj+\$<	'h}_M~O'OBʤZ3}zNg<C>Å,e:&Xl:wܺH#(e*l`̎H Z/zj&+\$ڐhO%Opyľ˨\$/Fy^,g̩n8Lr|	LOͨ|/\0:Rj|E2.1+g m.M\n`ȭp&H\nPE.8m12&H1)t0ۍ Pc>/PB/fZ0oRcgPI*yȶ11NdOiX?v&	qpܤ	VMD=D<oSDVQd- aNOhflQ,͟!S!\r/!eEWO\"4P:r>Ԑ\"R9F^\"odg\\Snxf\"/u`F/O!!\r#(2121+2\$@l2'\0\"0.+ΰ(2Pn<H`r-%\$2:2 +2.{/r&RD P(dIq.Q\$*;,0R2S-߯G)3'>H0c3B+45L[#\"&Ԓ\rS.A3SSA1 ڎ>RL.ETt:fc+·X1ou-mL_'-En|*qfsm\"rx%X J\$)\n\rVj``ւ\\fox5 Ơ[fГj|Bt\np \r=o*R30u:k\$o\0	5@gxnG/%op( @R @DS?	k ]Ų8/I&%%QC3̫0r',zsEr2.Im\0tڇdNNR6O\n(6cD4r\n%4nȒfF/<T0CA]o&@5EF0tOBtBOQLgTFHv Z PL d8l:O\n4Ǵ1|PҀo\$xƬ;\\@޿@5cvQ5J*<Ol#	\0@	t\n`";break;case"bg":$f="P\rE@4!AwhZ(&~\nfaN`D4\"]4\r;Ae2a.arp@ד|.W.X4FP\$hRs}@ЗpДB4sE΢7f&E,iX\nFC1l7cMEo)_G_<Gӭ},k놊qPX}F+97iZ贚iQ_aZ*n^S9YV~]X\\R6}j}	l4v=3	\0@D|¤[^]#s.3d\0*X7p@2C9( :#9\07A8\\z8Fcm X4;r'HS26A>¦65	ܸkJ&j\"K9{.-^:*U?+*>S3z>J&SK&hR&:ɒ>IJLH,/\r/SYF.Rc[?ILθ/t#\nK<h=[DV9v))#1,գQBŤC*5\\ ʰ2\rHFuG#wπF|cƣ:\rx!9Db@2D49Ax^;pz^@]x729xDlW4V6H7x.6Г\\VdV쭰UN l<;ݴ;N<XPbUr\n7`7@:\r\06\r#7C\"02!R҉!/1Esj>M+{PHhtT4 sP3	8iqxk+3[K\rM'h+ڤy#yqL\"=wVZHy4Gٸ(@6?\\QHb~J\0WO\$܁>o\ni*'<*K\"iQG֩WDL!pdފx(cۊl˅9,W	\\=&\r\r9]\r*b\0oe\"sC81̮CaʵDLABF;݉.H4O4FZ,AUDQ)֫\nPD\r!j[+DBtu\"@eћV\$./e:/Cp.(iW )LLH<J#ADCNI\":+y^E,<x\$A.+@=&e^](izfgUp)qLQs1FLa4&n~kG0ZVpp^<\$bLlJM^P櫥I4))MASTJOl\$DVf̞@d2fPʙ`we{h͙ĒK3~\rBƨZ|GFV.1O>083U3pqTRCkWѷ*uXB5`!ѥ\"f` H8\"hes3I@䏘Ȇװ aAؒ:lˎcᑛ\$9ƞh,	{\$\$%ՠYcARvtBH\n	[p `h %EÆ`n`1 Li\$\$u obAYbX T9F3h816,R;<A40gdIC4OaY(4O!?gt2#6zKMe2bfnMfV`Rx)AE*Y&sHiXy)Nk=D5%Q\$zdoeuH@)\\J\0zZTTǧף\0_74\nn+zY˂-YXd4eWR򊈅qiswe1\nlFEuiu\$O\$]\\R祙o &M6zRJWeLtq'j2nlnJ%*\noJUSXX0½\r?h<X\"w-\\,킩WtB\$߄K'UอkZV?\"qrE;8UeF!V0I=:뀬cܭPcK4WywX&s[\$\$b')U\0hq#\0Ntuv\nplh*iAk=ϙy\"@yQ\nev|lwީ2_enBoj3wM>T>+0 ;g:Q>D\"gRv.}ܴv8ϵäAv.d:85\$m{ꈐVkB \n`\0P\r\$r`_GI(I%NBPj8ftI@r?':s>/#%ƣ+\$|im	M	fEPm\n<c^H+˰\"obZ{\"0 AP	p%+b^,K0@wΰ4x\0̈́&bjj>-Q1\nCRb\\Yjg,-ojj=G;V\nhzcNp)l\\1e~K>V;GL+'|XX&Ѧ@Bj!Bo-DиEv.1gХ*I}16']7g&0珂m*g\rMȀcRnK-䫑RDH8<de߱8\$))Hg+|D)hPE@B.fO*F**r-+MYG(e(Ϟ!qr,\\ Z#\n%J RV[Ȭ.w\$N291L -V;B2rd'm%5\ns93=\$W\$%C&3U1Sc1Xi\0#iF*3G5s63w3c5%`\"3ѧ0grP&P;Ю[B1:,l;;pbH+,8s<6M3BK2Q-g,	7fk/1n'jwE/=mZctヮ\0004&ZuLDJ7JJdkIB(+Ri7y4e3/\$r_-t:(fޯtMGbud\\4!5rUmN;L\n}Mt3743LqBH/~m)mtqLh3vPK\r%_QoQk19N~V'JοRP577Dx/_d3'X:ar70C]')6PlH%\r7:;25MQAAu6P@\r%2AN=uI5U4k3YOnCUoJPYK=\\'nNƬWZޯ*o+p\njOKLm,!?sMՑ13d,`#aZ	[4'ZOa֏xa'Z=\\#,`ed^uO-eV!e?(\n7NoNs\$BMĔML14TdE])fIPoJoȕ#Q\"|g-du#Vg/7յh['VĪUmmX^uRŤW04U1@abj6Z8mQhc\".!Jd7XU#db	O#9F7:o Q'\$Ss-nj^AR+Bђ80pKCw5Y u<pwdQ!yQ0i@\rV/&.HL,v\\U8qRؤ4bԆN@\nZ\\,ƩWWGۇPzÁ;Kiʗ|)̧#/T%2M6jAH{s?o7\\:XW\\JPmLϵi&@I\\Q%J6K8lqm0d_0.!n4	\rr[Z- ~VJ\r8یhH>q.8UǍ!=6kxA\nюCj-s8\"wOnŝ\nԳ;\$Dfa>HpDN\0c0ޯ=!C?mnVC.G\r<d|Gc/)AD y\$%t)vkOA9B\\f0wV瞖OQ|h\$9ȪjNatO\$\rE\0)amy6pe`SS\\Uwr4;w~#";break;case"bn":$f="S!\n\0@xJ_:6\0P\\33`\0!(l	MS,S,\$])d5s@qD<6(R\$i撦VI\nxʙ+\rBb\0!e4M*+Vp@%9;e2S'	`ObM^bS%UPH)x2S)zʞ4\0h3QL<We+lqr'PP~9.-Z!NEy@h0q@p9NƓae90X4\r/0OΛ(%\0QN!Ί6	Т'P\n5*\n`9z;{b껥D5đ;h&\r(%\"(@;sݮ<GC#pΩ0ȭjbVҨ1䖣*[;\09Cx佈0oX7`:\$OAR9zSE-<73S\"l:Ns	+Ĳˎ\$\nVr\r9mfSz9V;i0hjqֹqN-EDYYs)\n SwE咪ni!p6Tиkzl5~MTWG[5ʚDʷ\r[kv):)H.YBQY؄42e*niG6˳AEѯm 9T@0c9ˣ>LK#4C(C@:t:AC8^2},9^/A=rA\r\07^0SgVɑRHJEyLPJ3255Lwb\\K&)s4v\$8nc>?`q'DSBP0Cvcx<Op6\r#7\":2VM^jR&+shK)9n}XcV\n\nKXHm!,H6ȫs`paH`e^7P_UH\0bK-x7LCBΑLbtYWr(,p	[*r'i4	vb]ehF>1Q	+\ra0l.N @eR]!yS9Rb%1Z*wK&ҼTTF4,3eF!*4Gpيy(	ST\\h2UK8D5JK,Sіl BYpV&BKt`\" XzzOws<xe75G0+7B@!|7`peS92Ql0`8)q.hňs8.U2R\\#Z0!Mbr9Lm\0NHψ]U(TBM6W>immۋsnݼ(N	89'qmp9+_~TrD7E8b[R\$De;%hQ\n\0]\r1ܘrO0jZSЌ kYDk uNO@#DE\\=D]p籅sb'R;gtc(Cuv}/>|O>I ~P*l67pʦUOD 楚 (\rȆTdSV0^Hgn@CSJNS\nAxnyQLQ/2O9D)aC Z&L:K!IFWTWTDuPUU(D\$6k/SCWz;AٚLHCh4D+?-82\rV\r&,}C=YȤpO\naPȵRqs^Q WMς,:M-A1k{̉AHd7t#AGTm}j\0f> .v~潸tGA-PbIq0aO<N]^A.#9pz%832]Y`\"ա]I!`qx,,:.s<\$I\n<Yb=\$005V&S湱+k0F-xS|]T\nnP)\rL%+2*Ӥ'I-ΓG%1͉1'Zt\nE'S~z6e	{v:͡W{be1V|a#4C]!U|2xcJ)uUʟԯ#nRHzOT)x^;~%9JG@	>Ϥeܮ1Y;t/(\"*V@IDfKcNfoRDIBԩNf,%<Knx z؅7DϏ.!LXiFĀ+¦M^4\$0o2¦|8&l4랇p	 fNeTF;g栂\n 	\0@ѯQE\"@,A:K#NC%*G;Ne\0,úF*n2/Itwv9i+M1\$FbqFBP]>,.cEh#tCCمX<XD0GFNr%[q.\nLz9e琢\$O9&I?҉P	q,uݍP \$l/~j`+!&ђ߉ei\"qzAel!B^;\$QfX/!&fCbzz})bnr[ǈ03l.ru%dXj4`q@\$vG&qTdXd0dxEIo2zTqEnWA-GD.r8eEF!/RT9He 0xL̎Oy.X.%2>!g1S%3-3B3/Rs_54hΒ'ҮB FZbY/^vP 9,)fD9\"3n-\$.b:	):C szΚ.g0	1<bg#0S\0\"1&\0Q3dBN R:&.3>A23xUrv.\"dD4)5sCC.c=6)sDvI\"+XpG2sm.	:T!nBskPlXs+7x:9EpTGo3G̕q>N0rJ\\pP`rg>>,j1w=/ʗ-G3*1K)»LO4ytNI4K-8WJLG6wRET*IFFUSSŉT	I_OuD,Y	IeBRҀTX4aPr\"RH.bpzNnWeT_ޤsڛCWUR^A,	,dh1	Jd!lUMS<(5x7֚LMTI@-2CIgs\0h-V5vLwCB51.uOGSc4\n)BdTS6i3	04bԃSTev.a8>',eIcUgU>*UMhV+46Uv,veOi(6^IO(hc)X6JhlBlH:#Hve;c3o%=Sv@O!Tv%aO2pgHu6EfeIƆGcTI'6\nylUBOF*?q*s)st/RXSL\"u&^.T C'go2oH/xgxл	LԶGxQ,jQiqJ3yzTK6{P깃̷ID6BVmzo{/`[VyvOy~Fw''?C6eYWHز[6;3|/z'I̅35Mu!PO02G~vr4[b/Aste4i!uJkcHZw`WWCTV\rw}wÅ;\n򳊮+od'GhT'}_I{m\"犎5@CPV\"{Vy*R4#zط*)IlPYce}Gt--Q@\rV}``0jL=kƯRRJ \np`\rK5+u\rZ!]%hI9P%Q9Ηk9Ōb	\"(·q׭o<1}I_6}{eCX(8{XoTZ!D:#A2*⿋eB2~qkZ^oH7̊:\nkxcD1-55ty\";<8S]Gd-H3**D&in{7:R9X7./=Āp>hSUnCbeZݪs2'>t\$!D EjF|jkA7<*h9d@7rL9apʲEB'2tV62p/\nƠ\r&H#b	\0wMݩ׍xPD.{7NZ皰\\w(\r@;z	zKc\0V͏w)s:	\0t	@\n`";break;case"bs":$f="D0\reLS?	E34S6MƨAt7ptp@u9xN0V\"d7dp؈LAHa)̅.RL	p7LX\nFC1l7AGn7(UlbeēѴ>4)yFY\n,΢Af -e3Nw|H\r]ŧ43XݣwA!D6eo7Y>9q\$iMpVtbq\$٤\n%LITk)乪0h4	\n\n:\n:4P ;c\"\\&H\ro4x@,\nlEj+)\nCr5ү/~;.j&f)|0B87,	+-+;2t2Q9l:br܀\n@>,\nhԣ4cS=,##J<ծAЀ1mP梌oP\";C5OB#'\n\0xC@:t㽌4˘x	BJh|6hB3.cj>4px!=/	@Bè:! `EF;N2_\n6]'\rOԃ!8C~/=R5NRek]&)JD\r#x\r \0ZѭJ#0:-%ںB0l;A4^l058ɲ\nH+\rCjj1 {zl\$84scv踢&C4.Cw%0#	TLOGT=3e#\\8hPQPMX\"')2*c3ɂ䯼P/a]qCMk#hkVn)-+7Tw(	XS3l\\V%=bHe=%(,K\$5*deZӒP*4.U?803(WJ_,0wY)J,֋~7-\\hsD,(5	Pr\\EYrG*!d.LHk3kASrXc0*pF#(1RmP* o?*H(a1ɝւK2(\$?hHph@\$-)^R\\qVgFiM9Dt՛D\0oDG&qM\\Zj⟳dpphjpl0_H).B(M\$1/a|w C\naH#9-,ڕ(B[!Chu%SIkTk6`g'84\"ء hlޝj%I\"p҉u\rlٚ&CB\"|?ljMM2e@TtBG,c+ר3@Ѣ2&̰\$R\\3\r>\n.2kR]\0\n\$l,\"RsNZwOcrN`O[ЍLF\$)F#c:<'\0 A\nF@ܒ%d+(6AH\n\"Pm].Qwm0FγUynLK<88;fR|/4׋(ncQ8yv]rmxI\\sė,⇣qV|n]^\r,8jl\r6[Ou\"~1.ZQ\\-jf夶Ā4 !P7ⲛnrZ,sC<1&Zo	W\"pwɈ҆Py1&\0Zf;\nwAn%]40x!o˷n(f'@g@ߢN\nQEJMY\\\$|&Ē7mЮ^b<I{Ј/C	\0.&zÃdE\n,3h1/\"32FP0:RU@jG |I2+V_'aM\07kgx٘{;2w>!l\nC;,X-nv1B	8p2>߻pxӃA-0[+n37;Mb_B;1h9\$%Nhގ\$kU\rM\"D@_1Y/A4E\\Pϰ*:az	(nZydFga&|XoJ0x:kO#1˼Zs#F\\*y!>eUagAL[]m&J}.7G+XyVߘ3~ps:KPC''W|ˋ`eC\\#|\0t:ǲob|B\\w/\\P2&9P<M>'Lެ\rn\"tpGSmu0V+D\$HfEGt.(d8PXpЫ3	R#M		]\n.l.j '!QC6mc@T0Qb\r\rj\rFo BbI2k\r^\$l\nd,PиP>|061t_\$O0\n1B`*QP%ǤMBm&8!\nQnΑHylԐRцnbzqc~n\"1>\"V1.LF@]fӰe02=\".%)k_`4T/4Qkg0?_I>Ą%ˏ\"\$(/p#!Ǣ+8g2&D:!i\r#H&z\n^82\$#p9\0'лR\\D rkğMFnNb\rrv6r9\n\$;+%	Mvy\n41+'0@eA\rH\0h@r5NF\$hW.R(GrEABe#mc~e0bo!m3\"4M-2	.	6Kk/,(ojk#M\rBPB\0L\np}DHⰆ+hXjs6\$ڳ5	\$3j|FMͅ0'F1/1C/h6o3f\"F1MEI4D@=,&O?%M/++dgZj-83϶%&*t\$%t(dߦT6}0lgS9T4L,&:>\rwE8:C^7@Lb#%*~VJ\nOl/\0p/B.%K<K\02H2`I+td|@ς~ k\nb\"8k\$m.zbGc&;PH!lulk1b^N\0.\"h1 @@6NozI";break;case"ca":$f="E9je3NCP\\33ADis9LF(d5MC	@e6Ɠrd`gIhpL9Q*K5L S,W-\r<e4&\"Pb2ar\n1eyg4&Q:h4\rC MXa+\\>RLK&v3épt0Y\$l1\"P d\$Ě`o9>U^y==\n)n+OoM|*uNr9]x{d3jP(c2&\"::\0\rrh(8p\r#{\$j#Ri*hB8BDJ4hn{K !/28,\$ #@:.̀(p4h*; ppi{]\0RL\"r2qT;ÇBHPu&#p3Z&fRM,ը#P2&M\0c|>D\n0c27X44{WAÐD49Ax^;ځr?Rr3_J|63.xB)@X+7Bj/A`N:!L%l.57}\"1,[.+ui&#ٳp1\r(Ȇ\0<\0HKmH7ڽG)@KFl=WoBnx3,T\n;/cL#TIV.!(20؃6\ra;LY\r-B&ejmKKqTW,l#g03\n7[&.^7xITB_Xӆ8縌L2ﲇ=(\\ֵDjH]121]knxvNRcX.:̪?Mı:3&\"d:WhlL\0(њRJGCxfuOR`A8 <Sp@/rHI#\rCC!кr}\rbO\$ˁM\n*,rZKP;eH^V[nc`!gr}1FPOZAJuO4p^\$%8Ш 	 ET\ruX.쮜2#\09.HfHX@bo/]A	B3iP&;˘#2a2Deu/\n@P@]7\0PTAJ\0FYGq`e4a\$rj 9`	1DuXBՑ>u䀂>\0001j]dt¡C~C|i>) 8`MHZMn5Ĕeb:i3YCJtԝaH-\r!*hTII\"!L&c5;Gp@IQ\rQM9coSDl_y2'0A'`6u=HAkEԥ'I(kĂ䬄ΦDm\r!fZIb.єB\0F\nO3z2I#PL 9O# ECm.L'@BD!P\"<(L=%?2~d2Ň G̀O\r* B):d/0S3!O}\$֛I<MOKEީO!EVq.߽ݽ|M\n\n\0IV%TYtb`,+\"6Sĺ*-AfAnظEGJKGzkjZe\\WBLq15;+^b5T읥\r *`I\0q͍\\D\rhk	惔Hr#,F6]\$7hE5&G}aOZх@DqkE@z2;қ/P?`}PQWh+6f/\\3\$Ց.hnb;Zֺ0љC.*_2!8՜l =ٱ`ɇK	%ֺ`m}I6ےPm-ޯ<ʦ؄Ȟs) \$DLrLuF[hlHE=Rv&##S*O\0l'¸G RAu<W&lܴ}:M		a\$x=Z\rVw㢌!P'	q\n}V^~3[w|{>+i,]<6Y(~L9Q! 岓J%DD'勪Mf1MaP)(b.ͦS>\\(Y@\n´%2#xDԿf\$y/C˹Ǆo߱{/w|{wwOGG'i+M3&|G#m,I0K^B܅(l02pZͫ)08Pl	d|S.uhH2d%%9CH\0C+^gx+64l)m0)fml(LЗDh p]  /LXPIι_PPdb(> qE\0{(k&%˰m/~>0sogWc\nu2f\$^18?PqXiplx/\r&,VCiq.w2%Fĕ`>Ѷ.9}\nlC5kЄ #aQ\rюRqO\0  %!QFx\rR M\"\n)?#/!L#Э\"-3#Ot\n\$ qVcPbk![&\$'\nrYPU%.H#O\nr.9)-7*\0	f^м@B&/?@kbE,S,c0\"p# ֭^H/za2r--k0*b\n\0L\0jQlFF1g&(@Ĝ>\np~H 1hzL>m43		^A3cG\"Fs\"\$v`ѢPm/Y=c1mOqœ3 L*nj&`0tn2#hpR\r\rg|\r6F37d,NS0@7#SA7\\7\n0cPM^\r=l)AGF\rM^sIV<|zĘdq/qD<oqid/gApCknZDlV\0g;C=D/D;:C Bv  9+@qk2\\N~_M\nPA.pS\"x	O%id\0kB	\0@	t\n`";break;case"cs":$f="O8'c!~\nfaN2\rC2i6Qh90'Hib7ii6ȍA;͆Y@v2\r&yHsJGQ8%9e:L:e2Zt@\nFC1l7AP4Tت;j\nbdWeHa1M̬Ne^/J-{JplPDle2bcu:F\rbʻP77LDn[?j1F7I61T7r{FE3iǓ^0bbp@c4{2&\0r\"JZ\r(挥b䢦k:CP)z=\n 1c(*\n99*^:42Ya8 QF&X?|\$߸\n!\r)<iRB87x4ƈ65n\r#D8je)\ncʍ\r9(jF\$AH̐P\0(MRD9h*OkPI l=2Lȭxf!\02ÐL~0z\r8a^h\\05Tx9ㄜ9HJ|;&A(K7^0Xn=e#C{R#5]7CkH77`x.޶l:[7\\+0}Pʂ[>ײ49	@!%l0HKY}f#2`PY7,-4\$ˣb^\$4\"cp޿C#p>3@P2DI;OHJѓ`P2\"\$x:gbA˞FtbR(=XVC.Vl3JIB=9	a\n;<cc<}R4EeM#l\nňǦw.s\rB ~<;^@0L|/jP'#gNԬLɲ%OG0ԂJ(x3bXO8PB;@6ps.`*ҦWbCfĢl\r	\r:0(_+r#.TAXtДXD+#\$_N)#DH4#Hv8\\12o\r%:&MDTΑjH52FQBd4D!?j_%2YK1g-rZ`p Cr\\OE12xк^q2T\$JNE	;\\Hpl^M\$^BpN%n9s#t#8\r!.JEG#Xj&QF)\rb쟩9V^KfVgCd(3!TOH\n\0#(*\0\$ M茀r0C=jД^s Аm.f<M*aM#I)K= +W\0F	SNzSf	`עy+A69D%e<4P8okZ;O%\0ez hRTPʠ	^FkyFeMgl\r0l3xS\n\$_zHָ[LC4ppls5-I7y\0AGv)͹ҐIʵJ1@Hhm\r`H0zgAF{6(!L%IBHV8ҚEiVY&\r'an`*^bTNAJ䝚Msl^R \nfXw[WAF\\C)yYA[WɖDap쓓{i\0A/5/+TƐ:JPNG\"~yA<1W\"=cP*=YxJD(ǌBj_XO\0%]532yIY-B}K`jubQ;\r4-,ڃt۰HvAA	\0PZw=4cCɱ&%2ڧ]];(\n˪fj.7ᙲ	9%޽5Fz\0A\nP 0U&HN,~YȢE=1Hj55,#yܬ5v4m5%5\neni]Ϻuz21>`}a	_7WޤAʤgv\0zI΃3*ɫh!!ck<u}#9yl}t#]NpjrDCM1@IhjE\$qI`U/B(;RQOP)');90~~_+X1Pa{'czCc&熰^vϵ5jJb#'GVcG~7x*64HP`\$,%pbO诃w4\"0dN#xl,jưkAkCz*\nFH(KvZL<\"p\r(	fG\"np44he^zg\0PZc@S	*o*'J@\$U`\rF\0pkGQfʐ0|xb4n`*gy0D{By1|*44}g=\n P2 kd\0CJHtmE6#]`ˑdNL>~f.\r1`VbL̷,80F\rVmb7#/@!\\ɲd&'P!.JVF,D|x#(\nBgÚ&ʜV%J0\\C}gBB|QMKѿ!'/h.b&׍u1\01 Q'Qq.ga(M)1R~P7)p3\n*vΊ7+b2eR,&m<3dDh \"|^`lCHMk\$ng7o	*jq+ҋq&@@߆92+0kb̃{39C))1S?	 >2\n/ƈ\ndD(?\r?06@62Q7by7+,b6s4&R3C}48G7,S- RT7۳E'sȯ	;S*;ܳOĆIҩ,tF:n'Q~0G#v2'Ggf=\n/tBtFMH͈D\"5EGD:AQ	b2І*;\\#D(H:khEN5byе1fIG4Qe\rV;p71W\0Oj0?f}Dσ\"Q\"\$GafOd&\npSJ{#4K JO\$\\Q'FtiRqS1LB&\".\${ bB? g	b9\"G^G&BݮsV4FƪP'\$KfcLAcPJ(*\\{[X!\nΰ}@-̷m-\\'t}p(d]U^@^U\nH<\0U/`3#r5mt^9OC@\nH\$DM GDa5bG(rn-1eI1g`'IUE1f@\"2\"`#%aC\0yl&U]\r,:4\rDpF6\r^00lC7Sxrv1`@I@@";break;case"da":$f="E9Qk5NCP\\33AADeA\"o0#cI\\\n&Mpci :IMJs:0#sBS\nNFM,8PFY80cAn8h(r4&	I7S	|lIFS%o7l51r(6n713/)@a:0\n]te8g:`	hB\rgЛ)03h\n!pQTk7WX'\"h.e9<:t=3ȓ.@;)CbҜ)XbDMB*ZH	8:';M<9\r#jEBp:Ѡ欑#j\"<<crRbjhT	@-;\rȘޑ?X\0P\0P2(X j֡{0c.,Ob0;#7o2\0yI	CC.8a^H\\ȻγzC\r:0\"px!N+0cj2=@P5Ta\"0;\r#([RBpж+#`P7ap01\$\$WX&\rzcz>CIk7+Hūƞ0264#:aMgB2+l\r6+0VJ:^nঝ;@쳎k#4mjRE3\r3*)ьx3Hw8c\$\nbk\$<܄*.W%24D̷.hK\"	nC2>LԴ\\Կ#k9&P7\nl@V1ZwOZ(\"ڌj7 (擉2ePH3(338c6\\,`\rPyܦ >\\.ZL7@<\$#,BN/|IҜSʁQEHBUW%b˻w\\*GJs+d@s\"6ڬ>hC9:o.#%{89[P4p\r\\Rs:I¡3bjv?\$)`}P*32p@b2\r!6pFMᤶ\\ޒA锸>Da\$AȜ.f\0P	@Ɛ((K\nE2}={r\$\$:|V|-|;Ȁf*Ra(#n\nEJ+e,Ch\r!-c2hbRpRi4!) K	)oׯ3ӡ)O̕\\gFzWp&þvb4(LIO\0ŨOC,AL)k7r<:cN36{ jְHTp=E0Ք)I=B,4 g[FM3AY#xB\"Nimh5@@PEe4VJDֳAPP4W0B{	*\0BE@\"PkJ^ao%РbKit&QZ[N}ȼ#MYl]i*ز.B0jB)!\"BQF\"&mi,՟f+p!us@0+/gc[+'}ERq>G\0ޡr4/ۀQljzBVnjua\nԻ\0rFDu!8c\"	%p.%W5F\0ߥ\nȨ%VF-PNQն\"Z9\"IMIZ{>3ΰPRR00G QLnKBƂT!\$	X#?UC(j3Ե`\0\nLI3Ԓ<%sp\"HKp2fC3va9\\IismYh3iy\nKـi\\ϟtkDN5o)xBl.`?	G\$C@I\\KQ\$fR5SmKpHxEN-/>H 62OM\rM]	\" ]Jy7]F̷%mݷ{J6dG\"KszyaF4y1W}ęwraY8j%jE.\$o+IaK\rkccovoyps:O-7={Wev>D61o}jv4p1nq19'΁;s&vG{Ivhoo-<s(KZL\n_9ţ)?9AS@/*pqJ\\CUP?kR8Cx\n=>&w^g>gѡ{a\r:þ\\]ZENOX\"N]FRj|hN\0TC\nV\0n\rKT4050m\0R,jJ/ldȒTEONNso\"/NNV;@PB'xt	X[D>/es&m}p|P&4b^:אwbpk&\$DO\nCC 50/Bml{#@\"q.@K1ID;N@&c40pC\r Ql=Q\"˃	,AkdR-ӑ-a,d-ў˅#\r\nӑ 1Hd8\rV\rd\ro.o/P(W\n	;IN #b-9 !':ޢNJXn6Y,YИ/bfdT7D\$C~Lp4,5\r-0+>\$R#Fjƞ \0'0FNDn\nB\" .pm)hnP*jK*)Bmҥ#R1,Ҽ4%&#\"r%)kg괲2lJ='d&bw'E%\0FC࿭j3[' \$+r'@>p-cBرM\$ ?BzEQ*ҵɰ.0,bбO#\nԛF\".\r@";break;case"de":$f="S4@s4S%pQ \n6LSpo'C)@f2\rs)0aii6Mddb\$RCI[0cI S:y7at\$tCf4(e*,t\n%Mbe6[@rdQfa&7n9ԇCіg/* )aRA`m+G;=DY:֎QK\nc\n|j']C\\<,:\r٨U;Izdg#7%_,aa#\\\np7\r:Cx\$k6#zZ@x:x;C\"f!1J*n.2:8QZ,\$	00sΎH̀KZC\nTm{SC'9\r`P2lº\03#dr5\rZ\$4)hˌC/0\"눡DhB`3 U&9`2\r\npCTv1ij7mB4\r{ԔևBDxmZpP}R!xDlOF4^0cݎ5)C:C3+++C@ NHRb.2{.9c+9B8!\074Ìz!) yZ'I&'LP\rtq4s){&˄Jb\$\0P𷷢U03t:f*J*\$`RaH\r߉6b	f;/z1آ&^C~¤24]65˔'=lSס}6e	C\riwj0MKW6#mkX<x׊0nw=M5Fx4a'w¨aq,Zi=sWh3ٚLbOltIބ\r+;vBp D^I4LH	 NC`.0@C `gAO)De@pZ'\0A\n2'ru\0 @J^3)p`ሖPkyte\r\0<F\nz87qFVjEi5[ʹp%F##7.Coj87/eA\"Q|O&FjVBg9S '-ԙSe\$D\0hSWMM9lfZP\$ua92%~uWA:ee&bp\"9'O*@C1D0BS3+s^xet2&q}i@(ԠtR\$F6TcG*n&>eBP,xMN~^c.utCA^EcI&a) o4ǁ7)@#'>1;VʤJ'\$E|P2vIH|2%9;	/.BW#&:Ot+Vy,6D\"*+E(	T&U&a@'0[l&ML[RTYR9I)o(-rma߸8%l!-~sf`\0k){k#p*\"䨍C@E(le+H2#5@`T\\p \n@\"pB0\"vaMIV\$&ϺjuƦО&	ܞ&TǯB oCQW@F;hO,X7:#\0ʙYIT\0aK`\$~gnڟ@:`[FWE&\n|Y SB!\r#3mcKA)r%O:/H&d:@w7FRZ옐Ux\0@P`ldpY;.:g]iq\n`]LFs(,EuVYjH\nťo*0}m2)\".Aa lB+D7N1)-Vzf)'!g\rfӃ&b܇<g~\\dyt\\rc;KF-dnqw99\\]12X\"n]{2jTog]'7DlBt搿Z\"S	3jF%[|j*Uc)&IWcE`N`)wHH8AAg|z:#<NN Ѵ;yMI>2S!F^~db25q|b5['\"g'~Zz`[oJ\$8>rk5D0mLxĪ1Fdbxzc&mrq Z\n9o\0P	Z,Hlu#@>,ʧx/5ڴ\rRU2`{`xV3-PϾ.4ڣ\nM϶HLOn&@Ox.	6\rn#\r6w/;\r%P0`c\r0\0C@Q#>6tHB E #ZBiT`@K F6(ZBp#\rC-gf&a#.`ala,01\0tP(q\nqPubg# e,>6@Ǩƞ\r\r&r=\rPcn\$j	vЛmcL\r^rlZ1c&c'&6} 2 \rf\"e	8Q0{	%) 3*P2+R^9Rc'8q+RU R,2,͸UO.+/\"۲%f'/RrU|K%%ޭE#/oRDddߒ\nNRg2Pc	!fs%ڠ\n=`\r\$R`hg@A'etZe2,G6,WO)Vf	hoDE.N8=h%,\r#L'p\$hf\rW8J޷c`0}+\$F^} \np4ޕEl6&ng2n7.Jb;?s\nr.j\"NO&M5-0ho12Z#HX73C4^Bs%fa:#(SQ-FL:1ɏt#.l<'0\$RGnGOIs:\rfVGT0T\0ִKfVG%[\nt~\0)H.4o|8`άzyT\$M.(x#`PKM8H4y\"ʃ3@?\0\0_L0NtQ-0#5RC؉;HIH\rԒHOvc#,,N\n!F=g<\r0\rM,æ'2L%#I1@/b";break;case"el":$f="J=Z &r͜gY{=;	E30\ng\$YH9zXňUJfz2'gakxc7C!(@˥jk9sVz8UYzMI!U>PT-N'DS\nΤTH}k-(KTJח4j0b2as ]`株t0sOjC;3TA]ҺaOr4vOxB-wJ`#k4L[_\"h-2_ɡUk]ôu*\"Mn?O3)\\̮(R\nB\\\nhg6ʣp7kZ~A@ٝL&.WB\"@I1H@&tg:0Z'1vgʃCB5x7(9\r㒌\"#1#x929(Ȼ[yJx[ʇ+\\FOz\n]&,Cv,[WBk4F9~lD//!D((H@KC╖=APXJPHF[(eHBܚ;\\tC%%%%*d72PuhvĈ,͞,FuӼ4ȤdӇn@gAu0XZ^eAKq8\$􌄗era,# 49N=O\01sT4sl;#7OÝA\0y3:xﻅ}LAt3(;2\r,ߠ(4#x|5pSdqYR`aoF>RYD:>=cajvվ:Prs\$&rX+#ݨ#8!\074쌈C2!/hߔMc*51=qZCCf.*wD\$fEMPk6%To<8[\$0NV%,ҎkMehC)(HK;DAPRѩ7D6x(ݫ3N_t\0IaL(Aؒ!\r*AHn;cS U3ƥ\$Dh @N΋;1.R%Qx0)0R\\db[ȥ(Jw-;7idq7a LѻL@PDLWa44yt	06SܛA<?0ܰs.𔁰``tDI.gqTdFEzΙc?.؂N45?5(a=s@L,r܅ \$`gqc2͕3ѩZWН%BwVƦ;Z63YeƪvE+侔]J8&mS:Aex>DF5<]Ľ B0*lku+eF!'XI\041|.cGu-ٛCjm7&ݛzg37\$\r0}Rg\n1u0Ҟ*Siy.!mzGv0ErjEE<xWMgfM2vnщ\nkvT+\$Ҵ^`{KU05o	ȇ _xa9'Ӄ0u7vZ|W[PdpW0H)%kNb\$Gjyʼ,'CH`u@@P\0\\ϒ>ȩs/nj/ L'5Sok/`|P \r|9曜Zq8540gm	Cn.)R'x\"Z2+!0#W	>@fhHJjquŋ%k)怬؉5ʆX伈\rLm]ԹUC+!ȟRqQɣ	Ѧ*{]|b52ŬZРTEKLO\nƥRXd%)?rəan2vfX˨Q\"%N]E65\"jqer0TUԊ)MGV3t)\"/_+jo`T\n}r[HIqHYt(K	I8#Fuq`g#CۢG{EJJe<c1\rqF@e9M9~\nSvڡ`E@Mcd)砬O<d|ݩGhtW׬ӂ˭)穕P)_aԇTE^:΂BE.ϱ*FtXg}!\nx\$:&/FքNvvK,\"* .,GtU'\$C\$ň{Ծn\nc,Bǂ-n7kƚ(2T5I'(*_@BW/|'PuPuГpVxI\nxK'\nZ)hB((WƑ'Ĭô#j/n:jcb`Pt&I_3I\\Tl''F!e\$x\$\n\")1ɞ.fz \$p#g:'HtOؓbl \n`\0\r\$iLhO\$GPiINzbmpBJ.\0^ܫb\"X~Ǣ\"CE*bs?\\4'X5ꐦ\n1cQ\0005r(R\n !OF+V#-\"+1T_آLUb\"[b .5!1By&oQFHe\nvX<cB&b&lλU\0A\nEH!˶Ba^%R]P',,S-\"e*HβSOX)*yFd\0H*D-OZ`aCVlGn<4hU ǚzTzp-hkoEPvFlZ^I,2j[-agJ(D2h-ǤZTsIR<:;uXRp3<\":<9v=,\$>&E@ɳO??I?ޑS@S@88AF>\n`Ȋ(*pI\nb)xbf\n^~Z*p0(E\0f&W	pnE̙T\nAo-lPHmDn^&!C^O;P5 	L.`R\$%r;B)0T\$_B_=IRkO·toLDӽBY	TwNBtI!yԕP303g'j=Y6R}\":52*6+ !@DT3\"PuW\0O#_!+65-l 0R25LXYDPd)YItSrZZx;U;Q5)RUHQJ048R)'v%D0\$>߉7@`n<3P16wKơͳ_E\"\\\$i%+Y6\n	0eu[.YPYTcP&cD^MQ!c?Thw[2AU<6j\0u;O%\ne)3*;jsQֲֶx%XK	PQ\\h.5U.u3^l/VMlm#oi	Soh] 'qK\"(HWE(Tt.\0>._P5rT\"cVաo5NVrOijէ:q_\"	wqQTr)[IEy=nW3SzlĆ(ܰ)r7mI{C{ײ\"'x/^*tsVLRw#	\$]yxhmׇj[ǋrW(}W|j&Cm?Ul/a_B75pWA!!}'mu\$MQc@gRv牄R׳55pxw!\$~WGk2ĘHZo=9Hf(XQX?!\rUru'Ƙa|D7Ĳs#4CO\$X_uF'J%EtH~ӂ~22~𦢑RXZ!hT9Iȇani\0hagU{U3qU!5Y*q<YIRF)(\n\\i\rV|\n\rj7DFdVkj=%1S:WbKBCAf7}e{`@\nZEq-a>Ԧ2Tw\$Ugu0qjT5A韇fc|>dEf>w13IN6@;qBCz~;놮M.nԵ.LqR]y6aO:.jeq!3&H].ڌ^Dd2X^yTLETŰ4%/\")RZG?o`;+5#?^[C@ucD󉒸¡e	gJIhj1bR}9L.=&dhMm@GL lKyC¾IKQ5Ɍ[cm\\1on^ 1JnGoptc;]~F縚Hkch0{0PDs\0^TɝOONR&Dj9<\rL@\\1DCjw)yGQi+[/(3)";break;case"es":$f="_NgF@s2Χ#x%pQ8 2yb6Dlpt0h4QY(6Xk\nxE̒)te	Nd)\nrb蹖2\0d3\rFqn4U@Qi3L&ȭVt24&̆1)L(N\"-DˌMQvU#vBgSx#WЎu@R <fqӸprq߼n3t\"OB7(%vI U7{є9M	9J: bM;\"h(-\0ϭ`@:0\n@6/̂.#R)ʊ84	0p*\r(4C\$\\.9**aCk쎁B0ʗÎз PHP:F[**.<41h.o0x35>+̩L!ʢ7C|&\r7STyc*# ڴOP(2-Im*Rc:Jc	A#8410z\r8a^]Ts-8^\r9xDjܑ-#2ܜ x!h+F\r=7F4S7:c*,\nåM*0L#߶:<xUF<7(xCjdx:pTdNx7lf5Ԃ\"6@`H݈îTFeIYns!r/,B9;2BcUv:p<OlLnn\nz0☢&WViÇbU%?؂8X`p2h~ғ@P4LKA)*ܔ7b(ˌs2JP2`!&s*CA2)A#5*F8\\7fhD0f<ieBJAnjmBA&脋FqO*J{&LBa#hY 2dr\\o?s&F\0Tb241Y+-f֨wZTrrE5JWrb>mSC`#LDj2MhMĽ+K#>˸9\$fC4>@afi\n^RQp430cQrSِhZ\"b4@P 4\n\nP))0GCFGm0C4(24!­.a7s\"\$Q\$diLN:_Yw&7	\$FnzaL)c)9f8/&Dvq,5~9k>%!sWl\0D Jrj-=@DɛCpBsM1\"A[*Bz=@M5<'0/ҴKP=tN	<~D8:YRd֣4RC&b'>0иD Ú#I\\	\$jA*h0D&	0BT\n&B' pmS3ƏUˆ@XC).,(2\0,L1&,ƛh	Q)LRy6<lݺnfL-<%cA%w@0H\\7;&rP9)6Czqi0+(ޠ(`!XAbRՋV:\n_\$jR`L\"vHSۭ\rubn1b\rNj\na=8F=\$%bFC}+W4;ѻCF4ݩLYjX eFb]冩#g;\nκ3tIn&ْ ;̀%PԳ!ĘM|X9[xA\nR@y5W yMOB%5\$|_[%\0)7e{8foh3ӫv{!fs%;\\[zDkgcb ÷}{rhcJ:#kbn~C:H窸=SC\\m/娛o߻ow%C)98Wd+дOPҹ^Fhy&O!9㬡Aȳ(ZxJ0bdגT]UԁbHv`ma\nF6	Pa!72հ\nz-\$V#s׻ZN\" <kC.Zn:&)D@^ROfNhR_Hmr,YMULODZ\\-[A;Jɍ4>ntȗ9\r\0Q9U>P_`sOa5d<<G־ux^.<e*|	{-nͺ\r\".\r&m\0l,n\r,dx&p8Ф80Fp<	BF(-2Co4B\":B]BG Bv4\$IwY8چB1mܒ\$^bT'hmE\0`7mJLb0>e}H8B\0@bM\rLO&V-GZr-Z%Q6iBм\$-&c%xd7DcL29MKyqb0eOpnqeq!2ζv0ԑ\rhr:4qsg\"(k=j.hHn.'&9X1pJPq;\r{h!PqHpn\rpc mql?Da!e.%2 DU\"#Ѳ;\"20Pn;g&(9^DZ'i&24@/|.LiB<KCvND_&QNlD|VRfc\$ObP.Ҫ%gp0N)*ܐ2ƊL\0d0ɆB2#I&yC)D\nZ8c-BhBH12C2I^*#oI¾c0.쌼Qz=<.bҥ)Q/Rw4SPҤSh+?FyB\nSDI(3NO8CG#f#:<Ib/Ivc/:Æ\n\"#Q=/\$\"43ڏ#\$TAԗcJ0v1=`D\$82J9'Hl/6/qy't(C0d|\$>#.>77,\$?vKR1U\$8OEBf\$½=v\r1/#\\d]FNlmp	\0t	@\n`";break;case"et":$f="K0a 5MC)~\nfaF0M\ry9&!\n2IIنcfp(a53#tΧS%9pNS\$X\nFC1l7AGH\n7&xT\n*LP| j\n)NfS9f\\U}:Rɼ 4NғqUj;F| :/IIR7aýatpAߚ'#<{Л]a	U7spr9ZfC)2ӤWROcҽ	jx2nv)\nZގ~2,X#j*D(2<p,<1E`P:Ԡ88#(!jD0`P#+%	JAH#xR\"Z9D\$(\\ )07prr7rL/N3p:\"`޶\"	Nx QrP9<?Ä\0#'N@ߵkU	T	,`@7D3:xg#H|ׁxDjҔC26H7x&FMj'8*~¨Z,j߲I \"7_@P7H5P&N,!368C|<<9A8:</4D<ꄢB\"먄:.\$wu;Qf6Z`P5,уIc\0x̧\nH9/BsCH5˃G!q664˒\nlc\0(hN|£D77/zWTZF/+03G3خ.Q\rodEH\0\$P?(m޽Lyf\"cR u)} C(\r?MX*EE'S.IHo\0.\0p`2LPOL)F6u.{R@gAeQ_ 6{Cd4q\"\"bC)5&px~VX%e՞֊'jEBo.+Hwչ4.D{A=i0VJ)\$0:}J'nj1LCc.q9.`xf5*XxZM Z_4ƒIs&^x'R\\4dpӰy\0AH\n	XxaRH\$ՔA!],3АSHA90@*üE.\r4	Ǵ.@4>@\0;`)kX72\roF\0F(Tav\\݆tN	'ÒC#ayj,042I&YPm4jC1\r ({;Ok.\r\$i	P	L*k#dnT5Ƨ(Amt:Y\r6%&IPh\0`e)=ǳ~8 \nnpcDe@ RahŪQg S:-AHؑo	8PT@-I\0˨\"NhaSI[a^D̪18p!m >a	[vߓ\"EvH+6tv)FUݽ6#rN^\$Ȏ>Ɠ4 W۸⚡%ȁh^n5'κW6J0oa\0L1-`)cBQL=3S10E]\r8샚zp|Qc7(\$K|fceo4`z	EN0 rKYȕgIҠT\nA\$#pӟ/U\"yd9#%@(N\nM-^z<\nBHXMڑoBQr43 AUإWC\rLY~6uĥ%礧<\n& le]}[\\\rkYfà;Sx_b&;\01NOw\"0ۮHI%m1Fa?%\"-io2ԲQ}XR#z`dx#9WjM_N\0:q/qE\"ߘ9S@++Gq|B,scr7;v@]ծbofrϱIE{|P`+'\\BrK90GC ψp=B\"M]Ti@R>re'Ua#OCԢxEg2Z	W(w;G0o{>w|ǿ{]wsRΟ[\no|򾱴c},_wR\r\n4!\rۏVD0/d!j,#+0Ρj֒68P+\n5ZHtX6=⨏.BH]iЀ+vbhWjn:r ď8E/UBEmt2Px'P|-E^,6,Z.Vk;e`ĨaF0X?N>a&a!:%1	q\r`F0\rFM͑#5nxԇ\"@uF\$ @b\rN զ%<\0٦5|(:C_qt@pP`jqXt~-b\0PI٭rRH7>	R^/r vpK\0F9*<ppR.\$2\$4wRqe!-FzJrFjJ^q&rObݲdqRtQDk\n(@PM QTE7Oa+fE.:	,^\0 &#x`KQ11\n#Pf+*Ps ,1.>	o\rna0mϬ!.\rʘÐ0Pd\rV\rbfb!B?!KZ\np=lDt\"j*B8gM8vβm8)jd{MTrD],V\$\"!(eĜbHt&4b>;p&B\nbl4ƶo1orq,%d\nYRRg>T)1LТD #t\$C C23iBz\$DHH\n5Xmt!)/ %^Fkd1脅֦\$(8x~*`wJ^D<,tm`\$ƀ,&Opw2i#/<M@˜yx5YO40h>c O-CY!Bϣד0Z7ldԵ-	\0t	@\n`";break;case"fa":$f="B6P텛aTF6(J.0SeSěaQ\n\$6Ma+X!(At^.2[\"S-\\J)Cfh!(i2o	D6\nsRXĨ\0Sm`ۘk6Ѷmkvᶹ6	C!ZQdJɊX+<NCiWQMb\"*5o#dv\\%ZA#g+>mc[Pvrs\rZUs/Hr%)NƓqGXU+)6\r*<7\rcp;\09Cx0C2 2a:#c8AP	c2+d\"%e_!y!m*Tڤ%Br 9jS&%hiT-%,:ɤ%@5Qb<̳^&	\\z\" 72J&Y[MkLn 3XK#) \r*Fj/lN#鼩5(ƌZT3CTV2zK3 ( k°3\rðB#o`bBt!	B:\rx!F9ı8X90z\r8a^\\05x7ݺ9xDl\n=46H7x9Q5WU3d\$jB3M<\$kᐌ	DD.b,Ȯ0Cucx<c`8C~2\"#ɗ@HK>\$8o½\"%l>{zIL2Hl} \$[,~,cXiN+ML8(x0(i&J됉BU?n]fwJ&04\n03;SóU,\\U8ߕd	G4d\$zͮJ^eNz/D6ъWK1Iڳrdc٫x+&8{1w ih@6!BR\rR!3(xdG]jJd9@l\r%EX.5bXM\"N(CDp	%/T!F(Mp\"l (y9+BoR+\$\"BgQ>\$(gͤNI2=[\$t=K8^\$Gr\"*+8huJHݣZm!qJ2V'M 18uUf)KلGkq.E̺R]y/Et8._~BF*`a7\\\n1\"E9!7eIZDTJ<\"igJMjI*ShB:0\n`l\nmX0hFY:Р9Ij4F\ri2/\nCd'IE,ARbqȹΑO+u-HH\nRuN%\0da1=@cI낡B`\rb:&P(\nael4F\"Z 7\"&`4릅KuBux) YCZT4&)hCldO)	Ǵ~X3+(4G+K[IY.BmHyZT4esVZrfA!+,i	ja(!>@LO\r(?kPQ@UDڐB1d\r&R`<HIѼENGalMnE8w3\0(RP.MA FF*]T⫧2)ҖG T>zD\\ౘ('@BD!P\"L(LrHwvs)\0i#Ɗ١d]M%Ú<:1cG)/@a%'߲s U\$zlSuiI[|F\rO)Xe\"TOOǵnuT[}QL+7+e&ttǕI+DXArU[Q)\$\"kGB9\$={_)i)qNO%d5G+C8Tvu`,Tc|JD8b7\0?vD|K2GmxKrE¸83{4i7G5,g8#xҊT7с|v̽5NT!\$JX!懑-DƍTI-igj&;H-vc_OҐ,=r#hcnMXȥ^Aq+K6:l._(9/9s;tKMQ|NN!1s̞jq]pgs`#ڊd\n`?	aky{MZDO)7WkP7ԍc3dqi5CxusQ,_?NMtm8-7\"髈*rRcc8oaoA H~CJ0gJpcMKOBle\"Un6FIynDf\rF<ON\"kl\0Pn0d.,p})Gf\$\r6ՎC?.jU\rh;:߇|pڜ7\nz\$sNKFGH ',1n\rꢑ1\r!gSL]\nMDB{T,CSRFisP T2ènĠJElMҨ`HQR,N '?D;NHs8snf\r\r\0OmȌ+gUQL0z]H\rz\0UNg 6fF0>pDp􂸟Cc1 '\$1m%P|{;p|.CQm,}r^{h<p8'm\\LI)l*Q{lm;+\"K))M_&&H2f*)i,p+ƒ, &rJ0D>3(e1-D4GF&-OƖԅq6ǌOʅPHMtOGPH22XKh3TE@tSS6~5t dg9BWڿl/Jp@\rVi\rnЪ3D\nZ7,g2\\J>2%5?P7oPv\0'1_+.pVӯA-Or!(R 72s;b6k`/P\"lxV hT'^tm8RÏV02#O?\",J&T	ݬ\$<ZI\$4f*4qL-7ILs~VFtw\$\$Y:h\nY\nbpltÈGKA..rwK66F-UC''\rvSNXur1O.dѺԦ4°gJxhsKk_VQ\r@GGbJ6RQ-yF";break;case"fi":$f="O6Nxa9L#P\\33`d7Άi&H\$:GNal4ep(u:&蔲`t:DHb4oABbv?Kd3\rFqt<\rL5 *Xk:+dndj0IZAa\r';e KjINw}G\r,k2h@Ʃ(våap1I݈*mMqzaMC^mv;c㞄凃PFKuҡt2£s1eţxo}Z:L9-fS\\5\rJv)jL0M5nKf(ږ390`KPR2i<\r8'\n\r+9\0ϱvԧN+D #zd:'L@4*fŠA\0,0\rr䨰jj%-*%k(%r`AS#JlDp+p)+MM:BBX'9-tBN##L҇\0SH5\"@(@4Ry@sK\0悥#@6a\0x3Рt㽜\$\rzWJp|c|cN	C'Es7c(Hܶ\rc魷R׶,@:*\0Wlvc}`8H2!#^;HK%9C)@1jI-èxR\0a@77pB35`3Ϡ\r1e}09Bd(Ӿ\n挨:5=\nPp2\n%aEF%%`hkdj59l(j	#kr%.cl`LL=`7&İ\\1{>ػڦ(-	*,\n[1:<Խz\\5C5[hl<*ᐄ{ɯrm1e9h襌42\$/45P\n07h::E7)4PNB'E\nEhRH'\r*V۠AdI=\0\$\r S_b!	D@0l2Қɡ	f06A!\nFi&&,\nAq=:AxrDr\"3jO<!!&(倰\"Y)f,vKQk-ܶ\rd.i%+u=Zxd\$U7C Q@;03()}Zi!-E<\$;Rh=ňL;2J/2eJGb\$F&!74O@PBOiJAN*z;MaDC˱#D\"hAj?De`O	2<GfU >P (! r\"\n\"K-@Rtp 	i5j˻A.\n\"LX`i~I	hvG\n	FqNZ@ n=FR05CI S+H%i0b&!8'@(jbK(ͱ^Ni!P[Ho#@C99\$LS!2\"}dy+%V~):'\$I[C4YF^LIy)E͠\$\"v`P*[ E	2	9\0)8tAOAA0Řp,Rr	VtVgD̲XUC*66)4Ҳrsx;qGgU*4A8QVKOzO'՛yؤM˛)̖S9&9^6m\"c8I͘95Oŧ)IloFFL^<HnoҥW2f&7p4fc:C/0\r:h'h?&`kL\nQ(crJ:9acWK?юP 0㒑h2pd%\\rwiY9IG&Jx D4M3&\r+@`4B4bw\n^ޓ4tX\$vo܀o7jwɨM5ro^\n85,YiCqAn7gLr*2rWJm&N[\"2)8W'+奬Eե5u;36E8%%1 4>'E!M=z((+<:SUwϥ;KL\\\$*nL1uj؟=GUR[4PhpywP94@cL_yOuJ\nM-VwQN!>J\n74b},:/Ir?QC4[1nԠR wz?ⱤUUB?떥ST^mB!\0f;g8OSJ4I-x̂	DM(p\$i:B JE/_M>`i\0l\\mkOЄaHH\"		tfC@\$j(/j8df-<b8>C\$\nĵ\r@7FV\rhR@V=Fk'm.v/>1m9\n&fm\nӐo_M5OB\n	'J=	(~-!PЅN20G@@MpQf!@(b&	4i&c&hc%\"PL6ŏױS\0p5\0jf9Mv\"\$,m3rdLB4n\\fq@ǰ+ \$ z1:,zflQFA55# wR8mVHm[QN]%XA @RZզtU&b\$6n<g-]#(Җ˃U#Q@>I	n7l<1?xa.RCz\$!js6HdP;-?>sd\0pZ0C0o d\rV6咊kR0\$dǈlFD]m\0`p((S#RTSƖbi1\"lC0=)c]8/\n\$\$d8@D05\\GآKc\$/,e\0dhLW\rlnH\\Ǯ-Clhk'>OVnF>l%Pqo??F4(H19.\$f/~Ddʶ\"LSȈ(/\0\rj؂Rn\"o*&\$ј&u@E#nenOCrIp\n+,&T0f\0:@\"LcFOHBRh\\' +\$weu\"ФO#";break;case"fr":$f="E1iu9fSi7\n\0%(m8g3IeIcIiDi6Lİ22@sY2:JeS\ntLM&Ӄ PsLeCf4(iƓ<B\n LgStgMCL7j?7Y3:NxINa;OB',f&BuLK^\rfΈ9g!uzc7'z\\ήknM<303P퍏\"Lpp\0\0%\nJR̚£c\\ChڪQF2B:	;V:26\$*ȍ.*ʘ++B0es\nF0M'\rhʣ\$<D^ʁB4̀PɬIMN˒2ɦ<4\nc˞a\r)LC/1J,sl)4#T+TtW32䡰X j C> QRbӌc %\n60LTT\"DQPc(XʌD47xw\r{_pp_npJ|8\rBR2\\#px!t *b`BuNb.ES+@;@95DY0H2cc&Rvxcx\$\r=:\01C꺾\rd1J0|\$6T:L4(\0<+#&Fr23\n!0>3֓	5X%7e*J;pߠY蘖6`:qoY0%bzäaV((kк71vPRZhI	gc\"9n7v4|OgpKZЮPsH<@3C)C=vPMI'k\0(\"v *YAa.E=/H DtϝFD3aIt'@ёJ\r0kxU:i<ppqdNѤv&#1	)\"G\"eŲRҒUW>7heH2p\0IZ;[Ybz:V'E+p{\"L\\0r.eR]yGrvйC0\0p_\$=0\"|Zh^	(2-%٢E4hB#\$!	!x<(hYdpÓ*BX2mԆ4HBCk7F9P NX٫2OaָP	A2\0(*Pn\$\$ؕ@g\n5?d霎`ْZ\$p܁ fvJ̛5n]@M+7ȇL~j̄\$]WaL)cYP)I:24UFeԓ\nsL)BXClII䀧RdjSp	DRuFGSNjM]6_5yUe^;Gay+(ga~\0T'Ŏ38RCNb٠cVn*Sc'3c&\r&0SD4JTד3.8LXLo#J(yr0X̬B`Rm!D9)cej%u K	o	p \n@\"p&\\>ͅa\"ޓ`wRO5T'\\aIBXYNi=&~Ƀ?5ZW4\n^+JvkNp≠\nʊOwnAj8\"Y\nfDL#Pz%37U.;47rQʢrQ(\n]jM(68!Snf4=M}/|hKK Zt\n)[/yvf#&pZMlpACNyʨz,XM|qH>}N~6ԗ]WV@5JKˀ:0HvR3(M%Ӣ-Xx*#(gdlر3yA.?;A-T\0t\$\n+[j)nQ8D:VZߋ2nҢO(IrYε'V3`T>%˲U]Gku9KO^lc`3۵t~?xG`WVKHjE%kҕӅT\\&A#boa\\2/1ԘFD Wj64ӝhzŌPHESeltj4,ۯܻ	5wC>EIW帓//'o##ΧF*fOP\0?eb,#DL.B(k:m.L^x0,[\$Nt\0gX,\n\r;m&Z:0thxToxP\\Mo@ܥBlJ\00v#pذMϬP\0͏όř)fʣBhB0\r0\r	id{\0j|g}&\"wq(q\0`C\$';d9D/\"[D<`B1BW CN&.0!Is-PIp*YP~1/jMqыSB;JdRcp~ /˼TNIBh!T7B|JP(.6@PtF\"\rCƞ)Q9̐cFߪ1R\nIlqf,%Ť\"e;1em(%m\"@Z%\\48QC''\$Ҏo(RU&ѳ\0gL)>s+(g(nv	^Ih\"R`n~@/#crU(.RW13N+/*/*n'm#Ęjd'M䮓	's#fME#*w>#&//RZSP0[4511	5j372L3^u\rQ50601.1l~}SlN(pm(&K;-+i1;\r*s1Ǯe<S+;D\n]@K-Ss/cG.I@o\0O@Dk=?qℲ0z.3	\rr6y)BM!bF`i%TL#81N|DN.g0*3jC!4_/Ҙ/.b\rV`V3v6/sb+1jd\npU0쿪/η&LNBP4Btf=	1PxPS\rd@U @DCs9㈛QKR*I`H-H\0tbMNC83AM1!(ITB;'&1IptHx4*3\nh\0wXZP@ZWBBpPhöWͯ\n<P#Pr,̧Y#L&\nI>L q<4L Lu\n@B\ntV#.gX#\0\rQ\nͨˇâ̎,eF7el:%<\nshߧ	\\DDGJ>` ";break;case"gl":$f="E9jg:P\\33AADy@Tl2\r&a9\r1h2aBQ<A'6XkYx̒lc\nNFId1\0BM	h,@\nFC1l7AF#\n74u&e7B\rƃb7fS%6P\n\$ף]EFS'M\"cr5z;djQ0·[(p% \n#	ˇ)A`Y'7T8N6BiRhGcKz&Q\nrǓ;T*uZ\n9M=Ӓ4肎K9Ț\nX0А䎬\nkҲCIYJ欥r*40m4pꆖ{Z\\.\r/ \rR8?i:\r~!;	D\nC*(\$V60\0Q!X@1*JD7DP45**H <6<RB8cI+dǊ\nRsPjTM eB@0[Co\$#(]0X(͌D49Ax^;tiY)Ar3\0_ِp^*ڼp̼*r*|\nc*@1HqNb\r,:HK~&j5-bsp7Ș\n)7SPGRcc8722ҁ!.y4}&6jFa/	:2#7/jt\nˬ\$c(VQ\$#;63ƒXlz* jj0z9.2BdƦ;b*6y⠛YHDQ ok/	(U[êN.Tʩ_sݷ#2S0~7ߠrs؝\rCUbJI]1(V>~9 =mr.\"FA%XjG	V̘:ET)7LϙSFxT%\0JK#T\"<:Pj&A\$^ܖ|\"eUgɭ:N`P,C	\$0Aӑh@)簨A0iΑh\$EK\r1TDi	d(ZCpŲjBO&]O-[Kqo.\0\\t҇3]:WC\n_Ī&<	=MTR&F1a#Tc4\n`'0lSr\0f4!+ H!LMI)3,DyF DZ0TC+\0P	@ȇqVO84`F\$Ȋ`Yt5\$3̄UoWs7t.\$Hv)R%e0B*3zHCo\\C\naH#'(T@&57\$\$}L`g\nƺT%ypT5BG\"Jc2%!L#aP	NtRZUl*N+\$)0`ܤOҪLa@'0akr8xC u6T[!CdV-!\"3ؔRQ u1CHI;%j2\0'{䙱WJ̚/,cMC}e7xmd4<L#Kt&!@B`IA)&\0U\n @zB	6A<)+}D0\"E&ۨ%\n<IAL)ƹ2ROFcNA˄LmP^,լT1O:1NBC<\\w`f<]ƨPRIm?8s`)SnB6vrI*>7Vv{K!͸.5ȥ^;/9!Q p	<f1*ڕ\$Ȅ*W)ا7l64\nb4)Lz^2 ;`^>`Q̓[:ݓ~o:gscvɯQuXBP\nXY)U[ZMS`T <iDl@fu\\j.ÑH/Ιx h,󌳴S8ʃĨJ4+>%!2r'L9ApˑQΨ\"\"4*z\$D%Qw8ӼUhyNtʠAT}a.ReOS7KIWZQGj,G~V>rA>t~9A6n\\GĦ\$Mz_pp(CF>꽅FXxK	\n!K=\\oJ4\nKiSNLC\"d~OZF͢u&۱WtKL`d%nj庵槌aH:ӥ2:I(8\"bI1.~bQ^e{\"&<Ee3\$#ZcWtGM|iiC\n\r(\0C\n}L|0zʐF#KA,zXņ:h}NGy[3`0r2bx`搙\n\"	\njnZ5N.~E\n\rH0nbBϕ\rͫ,ںޒ\rnkwpb\"&3)6Y↘^Kj\" p(ɱdHѤҲHHC&De7例B+6\rl|-WF&2\$w\rqЃ	M=QQ͚7\rpQ2z`ðmj'F\$L7NqL\r\0iưǕ  Q\"RmR4(rn\"!r&il*3_^ :0RLxRq[%\r9RO%1&r^ްyQ% (&&#\rQҍRBot=7\r)|S+2ym)N*1-ċ*ѩ.H	&\0Pϑ2BqBX\r(b4.C085,ahbSNS;0%\\&xc`L fl%J4f%-9H\$PrgpOjȮ\nZ=Fm .#\09Lm2 MFKCQnPm<68f,6GlD˄g>Ύic03rO<P(.\nbC DACBEB+\r/aA*+ )7\0D_B^omV34>vJ9Ö|m\nbð09f^rTr/g Bޠ(pFb(TP6%/LPt.\02&CBL\\%EpEF_NTC&`/C`2s%07(sOo +";break;case"he":$f="J5\rtU@ ak(ffP<=R\rt]SFRd~kT-t^q `z\02nI&A-yZV\r%S`(`1ƃQp9'K&cu4Q K*u\ruIЌ4 MH㖩|Bjs=5.-uF}D 3~G=`1:F9k)\\N5%(n5spr9BQt0'3(o2dp8xY\"O{J!\ryRi&J \nҔ'**- ӯHv&j\nA\n7t.|Ģ6'\\h-,Jk(;.!Rc1)!+mzHiz.DZvGMzwpIHs(fLקr h7;s>1#3ѯsoh4@:@o\0D4C(C@:tt4\rp_RTÐJX|6Om3<Ck4px!9ړ8&)}؃!3PTIRI0Ap+#IB8!\074߀!1<զLO\"02Ҁi\$t&pNi_wn {Pd蹮S <O̩ĀN2#rtn<\$w;G=ڃ\nb\$\\5|k͉\\r7B7yO#qJMiTr̖a\"	H#ih+p|ʦ-|p5(9#cڥ7wx(:X9Lկc601ii2!B7OΜn'wl[rp:V-PU..bu|))\$H	M\$\$sNNAj?r`\\D	qzT6dt	U@V*`W\n;|X<2`Sأ[ktd /*tܓ.Hc؋[JErN{P\n\r#A2p`r>=H``o):£a1ȱcxa\r@ƍxII\"6\$\rqFH\n\0RiP`B8Ta4`<}Tg;s;qFgH	Vn\nQhh\r!4Քu=a{&sR\\eR\"ȁ\$v˒ 'jgajG\n#D\r^!^| /jPP=lOIkdO\$+8ӚdM/\"I4bBBO\naRJCE`\$D\rʩʁH\0-ɽ(\ngɄЌ%Y& bY<L\rM%/+DI)ezZݽT=nG89ɢLL֙yhȉ21tfB`N\n1 6F]u!dIݺM}[6Iw;	eqD^r\$dpKL9B(|!~%%>m,2\$4CaPkM-\$:jɈݓ9ܷderHR{M/Nđjѓek뾆K3JRkVk;!3V0ZcU0ݞH\$AVZTYFW8`΢1%N, Aa#7j`H3f8Q\0g	':H4e&TgX2	/TVN9 AP&i\r{/Ac43.*tCmP\0G-i\nHekH*p+0@hp'X1wY2뢃,xԵgMZ̶_0IyQigE-rL'gG7\rd@I⾐WF ja#S2YHބ7ih+\n\"n	j*f&\rSxC\"g0Ĩ(@厛[-\\sK\0001ulU2ۉǳ{Mu]nL\r6r]W	\\;fK.uq#`\\C䃆ƽ߈9\$v1yU{n@4nBcT`I9H!r|JQ<k[Ϝ\\YY=˘偄m1q\"g⍥{	:zhUp)b,GGt}Sfo,WCJ`mFCtM\n{ty}#<W\\d)09`|\"8 <#h@2\\PBub60*C^%اe\"o<C/JFjPkHOm<uOsvq60r:&>K \"1c7\n~`^ЫP оofKEO̊q4I,,j0w/^'\rWcnIFLciuAl]\0ájb˶ +l\\%f>1_FX/m*D\"R䎀VO.p<%O-k6Ȭ)'J,@Zx}F5Ffkd24Q-z\$Kj`^%xb@^:⊴\$#|`FK!>c\\\"L|2D&(o#P3\$Y%`_hdm:X|O/L2h6*@l=e*Uΐ;ZTL2Z8 gKHHg: K/%oD!(#k9r^r\\-zJM{/@\r;j2#bG\$* ";break;case"hu":$f="B4e7P\\33\r5	d8NF0Q8mC|e6kiL  0CT\\\n Č'LMBl4fjMRr2X)\no9D:OF\\@\nFC1l7AL5 \nLLtn1eJ7)F)\n!aOL5xLsTV\r*DAq2QǙdu'c-L 8'cI'Χ!!4Pd&nMJ6Ap<W>do6N\n\"a}c1=]\n*JUn\\t(;1(6B5x737I8Z7*9c;\"n̘RXҬL玊zd\r謫jmc#%\rTJe^D<cHα(-C\$M#*;9ʻF@ޠq<H(0S4Hd=?Af	IC\r\$	B8: P6 =))cj\rJP1l(&L 1BA\0\r=dC\02\0x\n@C@:t㽴N28^!xDl֮46H7x&X#bK5Lk'*i /n/!bM\rI\n:B7=x7rj\01\rȆ2h:!.s>}h P`C/&&ʌ#z䞩4\"0:!\0퀎(%o; cL58Τ+8V\0)B.z޼c[7K\\#~ŖR0X4#l˶գ7G∙b]z2C;GM\"h%\$=*~Jc㧂pW(6M3#ݼ	#m`x<}xGY7Rkx@{ȹ8RA8gt52(CY\r{2n\n	DcPhon>8@85\$BQ\rI|:,*CTN9Fsfsi)e,ŜZamuhU:KrA5r]8h~Hv^  E/Bsmʁ\$x [/`܊@g.E\\앣Y\rB9N6LY^ڣFCFI´V#B3G\0֝\$\"\r,\ryFM3̛.k9\rL\0&0gXW%i7ed\$2ʕp@̓6ݜ\npc`Aܹ/6R\$&!Y\r9,TBc\rH4uz&#0lrPіA) LyY@`lZ`(itO	@2%hΨ8V40:J˹3@t	I\"!Ӫk8PfAdRƙ5h!4Lb9\"\\\0¡0O\06&-rP?UAʈ0UҹgEj,&H ݰ\$CM)٦X Rt:rO_\\5VX@PI.ri5<W\"1r8ctnFiSX>dj^pF\rջjaz];u\nIϠ\n	)REyž'RU?%X\rታl&#nFo=+ֿ`< f,Y Ca~4rjLY3(dba0]Z)*d2(mL5f̴.X\"֛vNEa2g&2r:JKc7\$70#~yorp<Jg.Q<߻oJL5X\$3|k'5ӯ4PRj7<)CP,A@BHq\n+BC(n➜4w`jg-ǸLv\r{l5naql]gY-rB]'unaA;z^ck6Gۇ/oc0%k\r*xo#5D`!jd	&n5NY7<ÑoOd##dJ.9mtNl@C\0n8r3\0+Pt*((NՎޅ+m(\n,ͯȓV;`wl|nYs#L&#uEwXl5ʣاǌybnaa8_[cZ9ob_X)[p,?+t2L8|aDAau^>\r7ޏ/-+@]w0N}1f/ R\${G,@zs+ړK{b\nx48blz(&/\\PPyP<%o}fyj0?-dk.2`. ߎ&T@b\"P}J-e/	{ZЂ|+)6PK\rcpJp>\ni8CD`B3baulj)\re&0\$r i-j%	#!Qr8&Ή'edO#+Q\rr+(P/l\"~nQ&B-F;r&jFф)00员&\n'ą@DJuoaQp]zn#\rLx1~;+Fni4<!*\$*q˷	@3+j`y0T-fiR!P`Pnc؈aB#\"<nR4I2*G\$E\$W\nˮLTC%,A<VArm\"G}(\"R'/O)XbbOU+f#O*kr&F,'&\nQ(/8M?/m-RU:h-,N/2,\$%5F\0P}%R1\rxH.PפH3fo\n4\r4ؑ >RhVfhe;,\\ ʴB/5Zku6\"~ν6Y5s6C2@\n\"V>A|St&(;pf:nR./:G3n`fbkbblm(\"\\EnnJ\nZ s4sKCcíߴ\nV46}T#@\$BH\$Bfu^&1hs4	>\rbRB\"0HQZ<q@)BRv;(z>f]t@HCC7\0jðbeo:oqaRbB-8r\0J6/s\"|\"5Ll+	18*5cZ eT氃o-CNxvW&l3-<	A(-X/{4cLAl`V`\0`\"?#K\$ J	CW:%KyL'4#MMgW54\"o޸6BT֢\rK0m-af^@\r";break;case"id":$f="A7\"Ʉi7BQp 9A8Nig:@e9'1p(e9NRiD0I*70#d@%9L@tAP)l`1ƃQp93||+6bUt0͒Ҝf)NfS+Դo:\r@n7#Il2:c>㘺Mp*4Sq7hA]l7c''D\$H4U7zo9KHd7xNg3ȖC\$s**JH5mܽb\\Ϫˠ,R<Ҏ\0Ε\"IOA\0ArBS87 ڠ&#CSk\\1(DCN.\0P\\0\"(6( j\"nc`H@lp4lB6O4C(C@:t<(spܔ@}C ^)1@M\n|ҒPaH?0V˻z.@P7HI2d:Bd7778kH1\rȅ5cx G1#|+\$4!\0:H:,a\r\0P3)D!&4@̒BM܎ZQr(zl`@#P)BbS\rmr݋\\C9C]XBob,P Pս [M\r.9 PbN)#ܜ+&|<BK=c6bĦLp3MFzN)B[0ۮŌK@ɥ#8ҖbgU/G4+K4;O3{SUuQ#Xa83\ry_sr7޸gف2Dz 6*\nbMѠiĴ*C(*64O\0ÒLzLyOa4ڄZ0X:\r(%T Z9l0-&!6@P'HNAH%>!!r&u3*e\$2GTWwR)OP5j%j)V#H*nXhؚF @I\r3DX.\rV u\r(3Q,3zO̖@(\rP-	\$<<vS 2ҩP ǞMD#A]BnFL=(r(%٪.a)<'jD5Xpf\r\$!Ba4(&y}2U	J0,@0TDz\0@\"	AR\0HC	aVDp \n@\"@U0\"MPNʄ2Х&vmQu9S%*CeH\n\n90\$Yy:YDTIK;.N]cXqo6#KQl&bVd<AXk\r\"!XPe4\"&6- NHS\"0S3\$ȿ/]U,3/!.sVmբ3fu\\eHnJ:M^X2tZ͢-[,ȡUE\"%6;и\\RPJ1\nuJ2% \"i5I1pFPR6!mZz?)T&C	\0g6Lxo>9=#e@R[Q(M\r0S'J%G%[R(0zm\n-Ÿ{0ۊ<2q<܈^:D̀r	;W2&NCQw94%e):,u0Vd@jMr&#(fAt!L/aU9mnwy\\-=[KVU>[Zl4]:ҙQ/4Q[BȮZ`NêЂWTH-Ԁ:*\nyÂ!L\nVGڅAl:voDk.ʵͽDKƁI\"SWrZ[kdukUv.OP2rT}C9}=NN%կowN5\nmÂk-ɂN9FJh\\]\\a	MD;JQJΓ9G]ҹky._rlT@E(08Ě8 \rKKHj\$DǭMn-=^YrJMЪI.F:iйMS/>=uΘqo{:O%z^-'ئ'KU&u'0h!vZy}|+8/7}^Ikd}6C'7\"s3I2/?_`N%3!זc\rbFȲ/l64ZpO/\$ݐEjf`ҼJP=\\I\\X5\$CAdORPpE\\O.rO3p&/̆ap	ZhtNz>\rV]>\"ʡ.wD2%fe@]E%@(>@\npszNnF⮇K\ri&C;d&N,\$j[z7\"@(!\rD	^fŋ:(XJ HJKdJ\rh,ɏΒqё׎&'do	ok\0v]M\0ՑF%#ZeN8q)d:&g>2d\r\"KǅFxg\09ީj˝ @%lHh0TQA\" ̴9\"b_1EcX1\0fqQK\$!Z\r(4/fpv DdF\$F ";break;case"it":$f="S4Χ#x%(a9@L&)ol2\rp\"u91qp(ab㙦I!6NsYf7Xj\0BcH 2NgC,Z0cAn8S|\\o&N&(܂ZM7\r1Ib2Ms:\$Ɠ9[p&P;PmB@a3ڭÔu܄+َkٴrC\$6ӄbsächf)ek-f}(sNPM,3w#lԨɇY:七Ѫ8Ng{AZJ`5R#()*Z*J@eZ)2B82<7%q\n6R*-(B#B!;2ł87!=\r+k(\rB:,;ʢ-\n9f1>\0P\"ȔzԒr7Ep2\r[=&>#ã⡈?)ܾ2\0x\r\r(C@:tD39@a}xD]2p̴'3\\H|;~T[ށV+%Y)9=C/3*hV62k0MI\r܌Nr`1À7J287ؒ->7ރmۊLr1	.2KZW\nw]|M|-J/:740;\0R4XO:;3vV̶YR֪IYr2#&C.¼\rm\\C\$27\nCr2CWeP3L(6˓92K\\օ\" ﲣeqZ`Fе]%8 iIҖJ8RBv7+	)-.M3\\֥6&A􏣑\"ˍʵ\$7=^\0*x=Osr2ٜ{h'p+\n|gٝj(fk#3tSBP\\ï\"BJU)*D0z_C/Dt<\\3D7SF<d\$SJqO*D\"NU*(xKH\$7+%hÁ ]@2QC\" 0I3E0F\$](.F)tYXNg٪M0Aa N#+Ԍpil<lNd%<lcbLdg4bvB-\0B\n\n0)&.1:rKw0Ȝ! -RXcS6	)F`aMdrz2	iCtBJ\rT\rᬊ\0F5%6lY&jgK2;9Lg0a]1\" 2FR|40VZI!N:@u#G2@]Z&75\$`¤D\rדּ(hk쥏ҩa;f<Y(\"Gv	L\$-&Q&JF\nZ\nȃ=r8uPC\n29/3vO	*\0BEU@--Hpg#Ü[MQv82tY-5j<b\r5E:LAFN\0=*Y(.i\$N7p72vaBRf/u`XQb)/ve<(ɚ&4nȥۼlWTc{R\nD_0u	_e*Iub!M̓m25D\$zCпJSq[jETla%g`n3jҘK;1,^hh3Kh7ݮX2eyuo\"y;l-9/!;@BH\$Еn4<ff9c`0cۋ\n<Hɗ 	-HZʆ%gfZ𘶙\0004I;<ÜМ[nҒrX\$vvf@<Kj\n+\$>~4VF*TcɄʶ%d(b!= vrCUipoZkJ\\=\"\0u&nkYMK^)lA{Ka,:Hq7\nf2\rp&p-1欒Ff>.>4CEW\$%s@RA\r,d8.iݕ|r2qzKPÄn L@l!h-QZq,Hc9I\"mˁ{,&ߑpߢИ!r\\Bw&~ ާCu˗ZcȞ6-2[y\rcyd>w`,mـ9cDnHS;B7. ys*ձ3rJj8/*+41@ȑ^F];(6rwbq`JE`EqLٮMP\$8L,̤:b\0(oFf8k\nHڊ\\O*@N#`=e/l.&\0e,/`!#M{	dvZ5`3g8Pj&S5K66Q0q\r̳n#JD4m\\E,\0n'cOD7P37NdPm	d1 CB3-,hP<5,sgrD3k\"\"BK1\nn<uP%'D6L0p^`F@aPPb%e+lΨZk|..B0 \n/80mIB(\0ҥbb=ȋ\$W1᎞&Ú\rV_9\"JIЌxfA#>\np&d̃BCj̈e+r4bN.!r@*#ǱFQ='\ng#ԭأ8\r%nҒ\"F<K^Q&L*Kb1c(L..\",bb\\\$&LBIi-+֑.H^?.,2,q/r/.Z\$X	D\$0fp+\nKI6&f`/T%ζi,0K5\$Pkr2.tqҿZ&Z6cx \$(6q@SP9kHYnS^LƲ%'	/I\$H[diJ[ld\$`";break;case"ja":$f="W'\nc/ɘ2-޼Oᙘ@SN4UƂPԑ\\}%QGqB\r[^G0e<	&0S8r&#APKY}t Q\$I+ܪÕ8B0<h5\rSR9P:aKI T\n\n>Ygn4\nT:Shi1zRxL&g`ɼ 4NQ 8'cIg2Myd05CAtt0S~9s=O\\t\\mtTBЪOsW:QP\npp@2C99##X2\rZ7\0\\28B#bB >h1\\se	^1ReLr?h1FzP B**;@1.%[,;L)K2Aɂ\0MRrZzJzK12#eRiYD#|έN(\\#R8U8NOYsI%`j3A\$rsqP(VO,[(sDSUT\\yQJsøsQDYւR# 4@A\nBt3\r#܎w 7<1B-`45D12\0y|3:x\rrAt3(E\r[YrX#x}u=pANE\$ЎhK3J	seb*WjZt)MtxNA \n7^P7v׌c`8C~2\"C A>B14j>YhCZIFsQMg)\0\$	psOKG4ȲusZNiv]!GGU )1y	.l1I*[ȫJP:cv0P(Z8Oqɗ\"KEn;9UIUնG~t'XD}'<4z*Imj	Պ`J)WAX.Y)BI&VKY`(\"8 +r.yq* pRL<Q2:mIA r4|0x3z\\n>TQxAF0 *#0A7IS\"\ncVcZ1K1hu\nf}I\r\"pPltiaȕ0ba1<*dlXY;.`\$mk&Db\\54>\rF dn\$DeԁH2@gA^!ќeA\0b53P,\\a)\rU37u7se\rbA0ȖOQ3Ft#A,\0r0FH#zCAQ!(ҡHD2ē\$[TLѷ0ܹC\r]fmMepK:׃\rޡɰ_!/0A=#3\r:\n'a]	ßl:#A) JT[1C;\0 Nq!2	!5d2kMG>(\$~*t@IlhA\"|(vI(!	m+	5&A\$K]HiKnpqdAfДT}%(j I!G%Kv)e4AP,,*F0A>G@YK4\0Z)wcp`@` \0EP_\\Ÿ9^E \"\r@R!E;wÔ];p\0U\n @ &\\|\n/\"<AYzS̚O1=b(拄|E!AuM~Oa,Ҳj'0HX~9g:B|ݞVqGb6KVtiUǬ\naO([a\nhjB6&\rX(QGlzIK?S6ό1ۑI\"):Q\\D9xs9s._?2\"EPF\r!;F zW`Įs#5ם+IYF!\0Zbxe^	{ˈD&LZib\r`8z+HO0/\"}RQ!UCM/zC	\0 T]8X9l\n` 3}:f@JQhrD{iD}'9\"ơØ)y/]6\"ۄp<\n*ʔR-cTR	+[*ͻH#>ܙЅ쥊7ňCxz\re<>uob\0uEdr+]/@*8/XZՇ0G7;@F؛%\$G\"[SMxs	eFF\"@c,3\0-k~>,cp\$(hDmOpQdL2shXA@I ~X/G#ut.d#:ЀpxqLsCuI.k2-\\SHF/%|#`ψ^p mϦ&\"/(P{P؃CH^(P\nl|QN\nQ\n!x,\"(.I< JQPnő.hpα6RqnUj+>w0܃GU\nBk\"h0> ł蚢CD,fqp\nJ>1L0ƻK	\0RA	NJ(L6ޮLMiξrqm1\$i\$+#gRaht26?\"\0J&|0V}eRB(K)t\n jX0vb8Srf)hNrUI,RXm-\$P\n-b>2PRS\nhr;.00S/R\r1!2Ur%ZM%XDp\":h23:<\"B#1I3d2@WsFM`rX%\"I/N-!\r7©8w	8tN/+R9skrOgF'S2Y;D25s*	\"')ZH!3\\vڂP,+BL]+Bj!xe&0T'tTT!*\0FtA2j f\r \rhx@\nf`޷\0n\09ڭ2J@\npF%9\\'u?Aͦ!¦:d^S92mo)8T2#&!n.lEKaT%|> ~=c#Tbz'1j9 , \rǶ8R/J*+#vS0SN89TThG/p#\"@#t5#V&LKRF2OuMD\"m6%蛰O)HT0ߕ.ܼ4 6@^ P\0sLA\rQN!(bVt(R. BLFQ\r>yaU@'uP@6CQ2R#I#MKOALODX!";break;case"ka":$f="A 	n\0%`	jᙘ@s@1#		(0\0T0V4]AC%PjXP\n9=A`hJs!O­AG	,I# 	itAg\0Pb2as@U\\)]'V@h]'I.%ڳ:Bă UM@TzƕduS*wyyOd(OƐNo<ht2>\\r֥;7HP<6%Imswi\\:\rP3ZH>{A:P\"9 jt>Ms<.ΚJl*-;.JAJK ZmO1Kӿ2mpvK^(.䯴O!FLڪRkjA/9+e|#w/\n❓K+!Ln=,J\0ͭu4AݥN:<Y.\nJMxݯΓ,H00ө΢RvMXO,T[Sg#R8­ڜ֤EUau*s=@k;YOdA3 j+)+tKW[/:X@ h7re_R7pUV\\3ZJ(J\r3:xp9x79c~2@*N\nx8*uJJ.Sk4U\r{PBtV8-=\\[z9l8JVJpd/=\"8!\0740C\"\$2^MM<P\roM꡸Ե\$mKQo0e}Obm<Ե|;KWbMl\\Oqt%m^ZsfJWHPCޥy@+\nM,NNTd>\"\0vG|3`Wͼc\nR}+\n\$);}\n:.qq[(|!!|Enc}{qu(BoJt?VFYkY(Gd_(x2A\"/UJW18dѤ7\n'n)LX%s_«2̔\n/	e*D=!:'Nd{#y\0GҕoFetޅqۺSvkIدH\rݿTvnX˷lVWI_H%y2#)M06ަ&:\\O\"|P̧.jt|^%4VƥR1&47A^=2uɘ̙2X˙2fٜ3>h\r	Ps\r!4#V.y&BZ,T¿<A6&íx\nT3eP7E*XPHNCw9'%:\riDNLMQej}MIZASGO@gB,)3IM\"N\\=^Y.NS!8eȩ%*Y9otسA_&]\"\${@,KA\n&_0,Z vbmhbz芕R*.BM]6pZu03+JlAv\$zs	[\$f'R Ӝi9\0\"'ڇ:Qho]:wc5x]}@qwi\0\nc@g1uR}kC~%\r1̶Gk6.t'ڽYX\\OO\naR]Hٯb#&	tV䊞e+6Er^M}Y<K\03]\nztb2	)תh)ޓz\n˴P(0)CPևؤ4NjLw5W=ɓZv%ڞ(PZ3c?iRJ}ԟmV@*ܗw}mj8e.+@XIi\nb\"\rxun8O]{ݑVDQe]wiǪ[Znng̞muw:a@\$ha{rjl\$31UĊ -W3:/Tөrv	p=}nM1Tr9Zɮ޵Of1rFODd+Ɗx\$;2l=OFѮ-o5cfz`oRٽ }6g\\KEu}j.JTzًIل9@]ª-92ɗug u^( @BHaPbRnRYt~<m+G'T@^_>#٫BUU.{H#d,ʿ`[څH@o',h{Oڸo*MBoԀj>(o@<*گ<nX?MN=ꏥ!L,i*|L/:Y2+#4nN\r\"Nknbvv\\\rle*\$\rX\\OO^Tǲ]duN%B,h>L4.p=T̊\\Nn7np#.,BԞ}+vygoS	Ui5).+\"\$.~\$z{/c\rv8Š(ܨ-gS:.[\rS4,r[uEp3PM\0Sm3+t,i2>ۍQUN*1Ʊ p7b= ,0\04|RR0*ʑ	@vRDpp.m(\":侙 pTH8`-j!bqe8g0')R1?.\\ʪP@+\\7(**Rwb`iւLK,1R-N+OVqAXeŃ/4*\0Rw(rN/d*7,\$hW\$9<4ͬ.hhk66vNs\"(+r&8\\]oNm%m(B((}SdA8 ӷ(P2<*\$4\":=>G>:\$v7RBE'?r׍ْ_;\r&>{0w<-D]DS)'7@RWE\r&&n;4e1ӡ*mC/E-CHN93#EEP1fz􌺓_!D\$M#re*hbJ_K3iLI+L4	5N-&Dt4ƑJ8CMO]BTokIs784)5kMSEL[UOw6·UUgRԈ[+3RധO\niPRPʗ1 /<Y}SRNF\\/B+%rw\n@DYG\\mɘ4-\\E4cS[)ho5՜^/!2j\n\$Hjji*\rVLƵL0T7+&\n p4L<vQVvC(;	r_;6)%/igX+^4\"=Wz\\(p\"\ny}R^sQaғ)0*lf`\"G\rRAwMr)h,TDRoej(?\\^:6ZKhV4Ag-C\"eEwe.{~qXӳYBpҡdWoI\nu`-E;tvSem)shkWļFNe@t\0@eF`(8)К<64tA`7\rrhLLT.OS.v#:(nS?h:ڄEE*7LX|UNk2_s]spc)϶8)GkO@vWK_C^\ra@ҥ6kNe52Z\nQ,FΈ\$";break;case"ko":$f="EdHڕL@؊ZhR?	E30شDc:!#t+BuӐd<LJN\$HiBvrZ2X\\,S\n%ɖ\n؞VA*zc*D0cAn8k#-^O\"\$S6u\$-ah\\%+SLAv:G\n^в(&Mؗ-V*vֲ\$O-F+NR6u-tQ}K槔'Rπlq#Ԩ9NӤ#d`'cIϟV	*[6aM P7\rcp;\09Cx䠈0C2 2a:8H8CC	2JʜBvhLdxR@\0n)0*#Leyp0.CXu<H4\r\rA\0<\nDj /q֫<uz8jrLRX,SǅQvu	\\:ŝmvBZ!%)Sy!eLӚuv\$,5TjLŝu@@yE}GB6|;1K#H0c@98@0ð1\rC:\rxo`F`@]@2D49Ax^;piڰ\$3(2\r8А\r#x|-i[HP;#rD&XB\$Ei?ř\0cyeiU/1NF&%\$?j@cx<Cx@1H1\r61`KՅQ%;5dy2\0: 0OgDJbp³<\n9EBcDP).Ⓔ-KLt H #rd\r1#s(1Tm㹎rYﵵ/\\Tj4AYNDj̟*|y;~8G?b<(Ǵ(̓S2-y	8\$,J\n@\n~ȐnTD\r!!¨\rC\r(xYr2.ST9T;DeeG#VrZ3bTڌqtAl,N fd؅!&F	񰞜y	\nY_}JMCQ\r0^pxW`lXz\r<16*C\rHmD6`t=7ۙ8kdhyFA9aHITr%V[_&+Lɒ)jCfmp0\0l\rܼDZ+-Kjc\n (jtAT&:r#~+e|B<Yұm!Q9}jA=[ ޷:oFW@sEOpp^k@ia-@(qT72P\$01@<Kcp.A H*DhQ2GLJ2RaDțGȠ\n	H)lux)=,:W\r-m!/!_4HmJQ-j[oCtnPBO\naP>Ej,yV/fzf0h츤/u*.ÒKiL\01C0#@z+j!VZKɈH_@_D\\S\$6&08JQ2.X/;7jm7	SghJc=<IzX>@M)O8ǘQ9yBq˪D(\"8FNTggX\\YI&kE2+[NaDg'b(	QT_TN.)Qz9Id_ ԅؒ7R;k횏\nZ27B_D!\r?U2\nߞk\0*EHC82vBSLUjCWHV%blQ4+ǳ*j/l \"eGV?K!e,妊qPУEt,]\0T`c!P*A.uO\"&EQ~C#.щ	C!&d\rՎΏfr\$xLDLSR3>+;J%4>ΔԈWh	3gjy]P0bxPnǭi=8[<&\$bW\nX*HH㈝ImOknH2fkMr3mQ\0>w5ݬ9\rwou%#Dt_g\$c<_l.ƟcbUD\$ND=\$\"l#F8a7H*I0.1MiuMpL|5RNNlOwoflԱA|3h-hFl+I-lPN=r𰅐\n{0V!nBnJ`3n7\r Kg\r,Vϫ.?n\01P\n1\00J1!p:b%bq!2(VR6a:S,ɲa*{IhD=\"=TO\$+,!*fn0\0߇K>\nOJжPδ)	.I	b</pڙNN1H:8<3BZ}Ad2/\"cl|#.Ir(R&##P BO}9\$̐YQU0r]\nQ\"I2{'\r\$<R'3Kw/9%2y)#pOҖҺ\$%F^v.'A;&07\$+\nq*BE/\".)2%\02Eq.//ķ*3I2s7Q@CI\$8k<T[!Bަ7(F#\\!!1'J1!jB?-Ȩ8K8	:.Tɤ\rVn\n\rhpAr2C~z\r m( \r'Dğ\np@>#΢ȰӺ<#22Q3h6^gLi%N'bOhi\$C#'OD,Gf~!R5NGN.ɨWM6\0mЄH#sDN1\"~GVg^d5,P(TtÚbBt\\!QM+sHpM4HR/B\rCbp	ZF4=4<Qc̰԰u'VCE(n\"^vQV*PZx|JuRͨ%d+Hd?3p&2SL!NU˯R\"@dlb~lw\n\rYdqPaZ-'D&Rł0Gzt:!s/D";break;case"lv":$f="V0DCse1Mг~\nfaN2OFC)sC͐#&t&)2ӓFD	m 2!&r8	A\0BP\r&AeNgIt@\nFC1l7AGCF\"%I7C,.'ab:'#)D,<obٸu22Q@ S0MMө_i2|9R?0&[w0DL:N\n\rC(Ģ\rf!xbo|00Č0p@8#އ'H\"Cx@	b\n77P.T6j9)P!\r#֯#ϻ!mS44mZPCJO2BUjbC(6dBB=6@AL@p.2Ĳj#~k{7H(=\r:,3 r̡B7Ib+ÔB׫09\0x\rPC@:t㽌5\$p_\ncxDӼriH3/JAIB^0iZ_NEBd,c:@7\r(W<K&7v&P0Jbx\"-΄W%cx<Ƈ\r*2# AY4Ħ*H13zK5S ݎ|:l9%ÒU={gh:~\rwCgKP΅Xz{=P2C[	h^7-ŘBC<+'I>blf=0I∙	qZ<ޚ9Ñ8]&/aX\0З\r-s@z] 	#hc*搌x!=b>Nl\"ѱx@ PJT2H@o\r⺶8`tLY#2۴v,!.rK*5d9r*AH\\Ȓ !BL1Vd\$F\0&@ta1N,\\JL1%Fxrw.ࡑ(tD3Њ\$=\nLx9+TN*?.0AAVs)ӁDv<8i]0ĀbRxiUXZf\$j1>bҞI\$~BlҼWa,EBT49, 4\r0)m-ǲ+RP|.PE(-970AS!2H%PO \rD,1Dװg1W.Bf}*Tܵ#CJ%;!dLTj>@@P1&wff.ƤZAV2Ƌdk	 6*__*{*1B詌9Z\$Iy*(ehHg%) n?`5PQQ\"*j\$A>8>E(\$B!qBWQ|ulQpȇGb`UA>\ntguND!9V9ƕɁ\n!(b\r9	L*M-u9\0ԘrQLYL\n!60dƪM´\00i,}s'?f0gpZK4MfMIsPXJ^3,A\0\"嵴{a\n¨Onh%ԡ\"Gia`\nQntG!OڰD'GN&`3w1nPؼf1D445p'	ROBMU^Qd_!{!e4ecyC_dx+J:QR*WKRM*nۄ<.zjc	/2Y7)斆k?@G,ɜfVr-'	븂A#3Di\nzI1CM24#7\$I\n3XRfƺ1bwB\n;%On{%F7ijGYRrM}\$HUF0#)5;F T!\$Ji4H=>26v\\.SM&6|cryUZݘJ\"DV0=pg2\$6ǂ@,u1q۵hCqh|w wKKO\rw\\pxEA(@ ]Aj^:wiE@.y-a`()k\nCi!/i\$i7ǒX-t21tO	2D(]n&ȭ`F(Ϲ/R_靤tBtG5,5V-є27:T/dhNs/{bSIڪfj7|+ZCQ!j%kl-B=.\"Ê>VwHfKmfNhG(\nz\r!׮\"(FvhBP\$`CX-,By,:>ohpl\"t˰x0E'~0MRBL&	P^P̠S@ީ\r\0谖\n\r!VEَfNt{\r&1NK6&,	,hnN_#0R>lhXEjM@2)q&)BkqBi0dZ-f>Lp׬D!0HʣMzcBі~P\nhaό߮ʰ\"fz\nqGlPx\\(N`HLvR-P \n l׭S\rޒO,x\"b)\$x.bGU\"0`Фr2\r#q?!R\nRmBaG\$vArF4ot+|\nl+јx0G'2|Gdh*M^Q'rfH%\r*H+ۑ,\"mz1%2Hm/fJB=q>NPq'|(H/Q\$\r%ʐi.\$O4٣NpfRV 3kgn3DPBm4\0>B&%\0dƶg\rrx3:vd5WFv3./\"! c\0f7@@\0VBhfz)D])\nZV<d20\"%U8P7nL6s|e?r\$UvPS(#c16T#zӜ HރsHT&_DC(f_Ϛv_m\$\$(Hw=(E:QR-\$OȠ\$?/hwHTpss?%LgdX=m9m2h\0nl|\"\$sm<T\nuS@`=c6 0\$0<FCf#ü>\n4 Ԡd#!ԤAC69&D'L\".N}e\$۴;Hê@G~lukJf,M(JF	\\";break;case"lt":$f="T4FH%(e8NǓY@W̦á@f\rQ4k9MaŌ!^-	Nd)!BaS9lt:F 0cAn8Ui0#InP!D@l2Kg\$)L=&:\nb+ulF0jo:\r#(8Yƛ/:E@t4MHI'S9P춛hb&Nq|JPVuo^<k49`\$g,#H(,1XI3&U7spr9XC	X2k>6cF8,c@c#:Lͮ.X@0Xض#rY#z\"*ZH*Cд#RӍ()h\"<\rb	  2C+\n5Hh2l)ht2:H:Rdp;8ʕ4Qn)KP%_\r鬛8.1=-P43[\nB;%DK,Z jp<#ϥ.aTʎACAЀXD49Ax^;pR\\z(2t\r*Vpx!H dDTK_bckx 2a>\$.6͚C\n\nD8-:,17\"2K!.y&)`!KcB	#pN#\"\0b`2W`1ң}F3.0#*Z9B4*WCT⣔	V.,,ѤȔT@V6\r[Zʎc7;<ٶ@S4cC{݈/MSQ\r L#u#DxP6b'Qb_\r&4lꆉ#lB*Qn-?`:|.~r	.3Z<JNL嘲1EP35(K:&\n	L0\\w\r\$'e\rTPx4@]p2\"FITҨ\\=sPoNY&If,場[m-\rˊ3PsϤ8½KơD @JAM<9\\ S(@Cʢ4L&q Fh+\0ƽt#KҰߪd3g-ἳJ|i)KXbt0aG@CHo-s0&F(KY%v@PC=#PNI\$eJt!3X^jt;2046}MB\r,4w5/ZCU+&uD2\$ƙNHaL)fdFB&	Փ8K#ɻ<7j H(@o\"3䜔ZK˃P6XӋ;;ěD2MI;&TLw+\rA8ŵ2>~Ch T7ѓ\$HA{6<'0MEŋVBDL5`Jë<P+ mód*GV#8g1[#IKPUf+*CIҘ\n^uF@uqŠҹnb\nm5UjRH03yTt!\$69Kt0}.q۰H_5Ñ\\ix<Ӹyue£\rGիE/<b~IդhS%-?^;\roMboVaΧAL(KPKl8q,0Q=dqeҒRrY_fu/j	rHzm5\$/W\nsC˝ OBM-&Fq(`;,^nkcٴw37X1E,D)TXӉNgx_lS5]80_zћ2\$(R{!y+UdM\n&v IcB<QJ;a*@@ Zȁ.K`Q.)M8<>p,,~vmrf'yUVNHUD\naJdOEqSof!ȈGX\\Ř٦[tD_;2]͸/<ܳNS8B!ΚP۰.<O3rɉӲ]|g:-\$!DP.RWa=D b[ N! 3BGANi\r\r:ޥ\$XM\rL'J=舏10n3}I<ڰr)S6Ň긇~OwXnйX#+cWYmq`C)HAA\"W:@~ҡKRhg2\":jkl5@Psl+ֽQg|\"\"pt&*OO-Dl.&`BVYńؒ0iNdwm/KD\\.htnag,g	#0尜Њ#p\"/M#ƭKЩ\r-^J^JL\rDJ67:aj	6,z<kb\"#\0XhTP6\$i;ȪBBP~Nq0>(0\rj\"&:\"S/<ժ0b\rFCb;cUboX)&K*&[j|C,<.e:wf:u\n	`%	bvLu \"H	p\0#oc\"Bl_ D#r>2,9~3!;`a\no\0zPDbI#&d\rY'#\"evIF-i&,IjQ#\ne\0=r9jױ)D^,ď'R\"mx>(O+IbOdoFFM+\0P\0/	P~M#FiLaBNhe6q^S- d#4 s(3?!xDG3ޅN\nG@kSI2qb_rs\nNdS7W8.1@_fh\r \rh>F֐&f#'t\r\0\npQ\$\$x0 0M8NjD#v!0ĺXCŇl\$;\n\"b-T	-TÊ&&8'16B!Bc3ebQ*zrdWE<\0%JmFF`Fο,@ɴbN/Ϫ>J͢aF^RJԍ)1.T\n@c&IX.(P,D#J/Q<o'9A4WglfllÌAu+\$CkJQ-mIB^CPP\r	TԄ=-kT0vJ`w`IBS?CCCTqW,jMc\r.d\" k@Iأ\n2).`/c@";break;case"ms":$f="A7\"t4BQp 9S	@n0Mb4d 3d&p(=G#is4Nn30r5h	Nd))WFSQ%h5\rQs7PcaT4 f\$RH\n*(1A7[0!i9`JXe6鱤@k2!)Bɝ/Bk4C%A4Js.g@	œoF6sBe9NyCJ|y`J#h(GuH>Tk7r\":7Nqs|[8z,c*<⌤h7)Z\"íBR| 3P7z0Z%p\n,X0PA#Cd2\0P2ɳ'7E%a6\"x::`ޜ+7N6M06.\$/\0@J1IpOH4\r-- 44C(C@:t\\(x|	MC ^)AHB|Jr\nm8h%&5\$:B`'7̔78C|`2!c#\n<HKXC/#5H!\"Z|\r,7V31*2h`P&LT)qƨZɁL:,K+j'\nz\$w-jEӒÓ݊b77\nsJ͗4 %(nIѸ:4@#ňQкn5Z o Pi\r. >cxA]2]@<9r`)67-d?# ('#x3-K:2)o	N7-CLS|j#rrtaKH3+{xZX_L\n.d~AAgȞu|5Jc\$&K%:d2ONB*U*VbOW\\;B|b`\0r\\FЃ8eM\0 Yi>\$N\r!Pak(ݩGMX0`xr\"CHlM)&>PB|B+.\nI\$&(MQ (	KP-\"P3B#^A!IAzOo\nSATA7jMb6*W4RgT<Gt,V044fA7M}A(ϰ\"z4K:`L`Ҙaf!\r0Q dJ'nq5Y&li=!@3tl@Q!@'0s%zM4֑Mt-6!:ۃ9ںL+!v8JlRAE#22*Hhm-YLY-Ro̝8(j(3J4\\A<'\0 A\nPB`Ehf%a	j%E4=ƚZ<\\ЮP\"W<>Ѥ@Zw)(ў8	2ӷAJ2jn-k` 'ece\nCma0[un蟲0{[.u.dhV:0yXB(V\$	#Rs{&RHCM޽!L2mK/PZhC\r 4Zo:}\$q٦F:ڝP3B5XJ,5p\$D[YH513|t\$EW\\RI Ʀb|.5\\-c %eBkLҿʖAAIK\\aA+V%Bu:螣-;3Tw\\W99\nx \0Ørb^Mq7S>)tF#hФjϝ̺(hm;CsӚ 4vH\"8U֤vH9DYC\nV9D(ӃIט!D]\n\rzesVۙJM,wۡnG4Ud-'dcɤFdh3Pj.u(^c|wݎ\$ px*X-om[QqJJFuˍ)gY&]xĨB#?x1f\"L䑘1\$؃kM:? |XF	jLs-QnqlS؞,oȯp\\[uـ0JՎ_r|%׏<@;VbQƤhqWzHL&eWGBi,WL3z;\r=BsvtJR'وwP#<UsyїW;GAʯյNW2\\_dn\"\$h\"+\0jJ1L rJhGʩv4\"8e,5^Zxf&*\09ƈ0/:&fp<0nP[̐ng\ngDHPLP+\nB-Ɍ8&0	/C\rD FĦLD	FepKo@\$h`ͪHM~PnI., C~Chv3L-Z~E\$\" Jd>\rV_Ɍz5FL1d D2#8氈\"F\np\$Zb-JLW\0ㄔ jSш!.*N~LKt.BǍZmx-ddc(QTyZ\\(dg?!	> \"y.&2,e3bfQ\$fq}8-c fc\0vkQ.plirN&춂 T ;`@@&c'N&2	^#&#4B2#B+\$(2#CkDL;R4@à9h\"Ŭ0>~qd";break;case"nl":$f="W2N)~\nfaO7Ms)j5FSn2X!o0p(a<MSle2tI&#y+Nb)̅5!Qq;9`1ƃQp9 &pQi3M`(ɤf˔Y;M`@߰\n*э:|m0KĤ=BF'K.O8RxwEّʍ9C\rֿE#9oEhi?ȕ5u4>T@f7N%YXS)6!Bюh+âjH@M(j*%\n2Jנc2CbO3ІJPʙan\"X:#H\$#\"@ഃPïCr1kN.*.7(#\"#s҆Rȏl9/>\nhk9El`9x\n\\1?\0PdHԊ96Ib6Hh@M	[B~3:|754T2\0x00M܇Ax^;rcN/c\\zfmQMH2xAl51q3ƬH<\n\$my\0007`LҕXj	cxS'\0 cZ6T* CVFU)|*GѬ_</\rVc\$\\4᧱\"-'R;+覻^,3%PÌ\ri(@]ՌK*1&S9PKNkyC>m?^;P1@4oh;@\nW{Fȉ#h!<ucÂ5w:լ\"S40C^ȍ\n6C&OÛE`д1\ry#z(,0X{lk|Tσ8x?կ3g\\\nbGOcLH{(HT:]~]1(p`\">F\\)P s:&3)eMBMd#C[)d@6.qGrnP(rMҼ\r\n`,%@wYJmN場rBP4%I.3̕ʹ{\n4:{; 4@\"TNpH4&9pa e5R(`'1k@sТTI{*zM	J\$p^dKD(H\n	1Hph=*!\nIPxABǎ1!;^H\n6Hgc+DWIG8!ٮ7V58mM^(^HJ5#	\0F'(	IW \rp{@&ܜzs7%c҂\rmpT)%PNUYx%Hr(/S,_UQ	P	L*r!P)e6M&DKԬ 8pJj\"ޙTbF}2\0k6N@߂`-\rbpfRa6T]S^TUTCIF.ՠ3R@Uy0pP*[\\ E	ڀbi\nL0Bp@PL&m/EBNmu\"ݗIO~b_^I\$6Kҫi.K֜\n2R)\$X@0fD)dEwr9ef,4C)TƵ0koj`rSYDh%P9;~Ke<BLD`PI,adsy)؟\rjZ`oZ\n3bc3&f&D(GO	a\r,*-D*P?:dڞQzvE@BH:'N\r>VG\$D|!哂\0^5)eʙC`h+eX<6#W91>Մ'UEcN\rA󹗀XYFI!^:l2WqПlJm!lȅ-KI2%eKލgoQaڙ/ALM`mwP1paUmԔ}l\0005@.s}9S@#%2J*J\0e#K^hɨIUr]Jnvo8ҟcs\\܋Z1[gd#w!\r0ʳNόL\\gb]{\$価vGJh\n+ (''|Hpm\"SAԯ{t;D<RJy.Cqʹpst#=*j3k#)҉\r.Z[Ye:w˿?o-H*Y˜';\n6Bdؕ3RGrS2&@cJ#!KLҗDܮ+9ϘϜʣ#dp^NfC:\"_#XϿ-kM@9on?uBJ	#O0uЖQh	\$fu@K6O2\rbhlJ\\o*~;\r-\0Jxj n	\rlOotP%Qұ	P&\"&hP/Z4,16;/i1f}B<//klNlt~'DA8l8ϱqX]'bI`ΰ1&nLE!f.\$4j\r#P!J.2 lqwRa>*q\0^fDA2nPM0!*D0`\npj8.p\"89&n#8a^'d-Z(tu'\$B2#b:#C*\\Dt\"i8mq\$#BBR\r`DS25R.GbY	//B}LR͊ID;iL.DUDLGn#&<(\",G0:%w1\04c0I1!_,(01'F*R}40 _,k\nk2dL8,(R@LM޹fP9\$nS\n*t;cB_DT#mON)Fn3b.Q#b%bCS\$(igc]/D>vЮclj\r4C*]d\$H7MBT;/bf";break;case"no":$f="E9Qk5NCP\\33AADeA\"atl\\u6xA%kl9!B)̅)#I̦Zi¨q,@\nFC1l7AGCyo9Lq\n\$?6B%#)\n̳hZr&K(6nWmj4`qe>䶁\rKM7'*\\^w6^MҒa>mv>t4	j	Lw;iy`N-1B9{Sqo;!G+Da:]у!ˢgY8#ØH֍R>O6Lbͨ)2,\"8	ɀ= @CHצּL	;!N2\n86/˓69k[BC\"9C{f*R<HR;\rP\0s(-̢HS\"t)B6\n\"1o\r'(1>a\04@:Ԍ\09P XПD4&ÀxY]\0Ar3X_O#J(|6ĩ+>L}'7Bo:+RՎH;WT>-'.#\n7-8ipH1\rn`8F_bX(CP7\0 Ӄz50:p6Pp#n9n;-̨80\"H!8C;	ybׯh1L&^7\rSL8\"R:7I{ւcPȁBzF?\\/0k9@ܫ	#m߰*[Sm\rkS!0<!m_b\"/0f}0}<\$r\r-CMʠ:jf6Bv<7C0Ͳ*ӀT:Or{ 6#&05؝pZyts-080á)%eD9Հ\ni~ELRX+%h\nWj7+׈R<%X9^Y1\nZI\"c\rJpNY?ݟtmAНb0NvGF`(%!P̨f4Aa(vHa1Ca9e0eC=#`[Iq.e1N.T,dtBFnDAH\n\0Bb~PMp((VhC|+2f\r.d28PŹ(rɫ[jD9ac\rN\r1@:s6PIJIIi4ބ03\rL?jN{pD|RQ,%ABE07(_gkyT2JBI/l0\r&J[d8a1OܡCyAm\02iuC:{J^)j:N>BV▉0g\\y2O~8\$G7\$DRx-\$G@PFf4K)1Olc@nhP@ZZO	*\0BEq6\"PlKb}bgM!0ӥ[|ryBr@̓dFdZ.3^!%\$ԤkF)Ig`Dvfqt2[{\n\nA'H+/h\">\\)΁Ӻ\\FH9+!	Fv2\nYo	EAPU0TTkg,]\na=12\"Y6Nr0Na+s̺\0uEBߌ.%Liz9޽2K^zBʑƖJ\"\"xOE-O6Y))B^sr.@ Nu@T!\$\n*B1c7+6IA-5s0.Z8	-Q12D&>/F@bΒҔ ϛ>4d>UtE]lD<yJ\0JP\$dtVd8ek1 pbY@k,K{A|vBb7 2ь-z\rGOjÃEżL\$xI>!]Сx\$ 5mU>D^,\nYشn~F9oʃ:(ifрs1čmrV-E(%2L`)A:۵)& 7aLT1)c	='q[hܝ)|GjSW9.[:i4ioP-G]=yh' R1dXo+9docѭs?T{&P⁧*_0\$vPalZ@ܾxnThҕqIR'Ƌ}Sc>ch%L`]pLfllfL>P<\\@ot@6lPTÅ\$p@zS0(Lq0ZpbC~:8dLE6-fJD.^:LO<\"А	Y'JgM,d/c+u<Pж\\0\"y0\rC\rQ-Q(1\0x,c.Ei:]	\r|¤F,~8*AgPȱAGQJ\nllL2LOPml<3,\nT6:|)ze(k&;jBQ\"ˇ/ITBQb&L-N1\rsFҭM@1% D``A\" *^cJ4|>\"ϼK\n\r%1a\"<Hb&ݦh]S\rMC8D!@Z1Ç #X\"]6En[|Lk:@⸫c\\0\$nG@##{K+K*cn@2\\\\b+V&c\"r=-(p<_`Vΰ-#\"\n#xNTM ͮjrh0U2m\\˚Bw@f.*>-R`p\rD\0:Ҭd1&΃%	\nV36hcR0	!@-+N0Q\nqXz#\nz.\r ";break;case"pl":$f="C=D)eb)e7BQp 9s\r&ybob\$Gs(M0gin0!Sa`b!29)V%9	Y 4I0cAn8X1b2i<\n!GjC\r6\"'CD78k@r2юFF6ՎZB.j4 Ui'\nv7v;=SF7&A<؉rZpk'z\n*κ\0Q+5Ə&(y7r7C\r0c+D7`:#\09ȩ{<em(2ZNx! t*\n-򴇫PȠϢ*#j3< P:;=C;#\0/J9IB87#H{80\"S4H6\r)mcBNOc \$@Z0skr1\r3Ø幣\n寍d9T2.X#Ƃp(,S\0@Hp4\r`&420z\r8a^\\0ԒN?#8^pBAxD{ \r3򞎃H7x*cx04r)C#jKRRL	Ϣ2C\"40Όc||%cD8C~I\"LŎNkNu?*;BX6I\nm =Pa%bH1K<8эA6Ȱ]B0pD	>X3 bpc\n'`P	J:0H00R\0|':%0Bk49\nb@+nsߋ.Q􏁌t\\tYǕzO4sH<u\0!P\$w \"_W/6Ou=4y|8\0lr_\\2,`rIP	PAr^̛8nbb<1\"C+&͑C\$WA@ICVCP XKKAgja\\ade\\2g!ȳp0g\"!(ؖyF)Xo#Z'HCE^Ffm,9HI?!?*ˢd/%8^!q\0/H)AD\"KCtĮHI)(JY=h5ɗ[o\"h7.lppphabPPYdХQ%oj(t@\$ @@P&Q+ƽWB\r!6dCI%A9VJ3Z\nҵW~54i6A^xoD'@1ECΔҴO\0\n`f]@c,4BWAP1Rv Fu؜@h\rU\r?@<uvFph.\"@Te_װZjBE4]C:Ѡr9rf35 Y) ,x8Bx9Bmd1@k?	J=brN,ԩĉ)\$.ht\\l#&&I#%'4&5da1/r\\#!)MaN7HiOs\$Z),i[9Pxh	3q˛\r\0TA\\1K\rfڄɬL.A܎Zb:rPm@;Ĭ)̔Hxm&-TyܬQGqٗ20WuBIMU\"rcL9F\nIʕѲJ>\\rL91sul/94!wv3S2Rx18fmSaFh~o\nn99iabӯzo`6_!\nD5DL%j%!'!CmCcrt!9|P8b4C+^s>Xg~\nI9&Pk%/BlO'H7FX;|v~HX2#t\nVQsŝqayAԹPV\\\r\0f5\$9\$F؉iHxHR.4[X6-49#SE[cs*Cxk|O\";\0A\nP 0F&-H1Q`\$wȏR&́y^gl	3dPyݰg	8	]6)n^ק'O!9߉o!~VCǽ{\"|H|UwLe(c@eydCcpxLYlOٞǿS>I!,.H.ak ؑ2a#Z[Ds0:E*\\bЊ\0rA0SOI\rb \$gL[J(T\$0@	\rL?\$ȅlD0#c\"bFB.m\$/RC#8@-&&|ފN%HDڢNZ(,NmDpO;	pw?-\"(ll~G`uI(4mkl@oxpNd8*\$\nH8CNf9&LU6\0\rG\r'p嫯	G^ƌi\0ڝ`P&@RH̪HQx\nLЏ12{\rЅnpQe>1\n	]q1eo)zQCÄ1fXЯQ~ݧQxpT\nڵffP.:QXBOu(pGd1i+0%g0q@Q{pnhlfn1hʅ\nn:R(2\$âDi\"\$,Nr@%j<I'N8BY!Z\rdZCG	@eg\$ Q-M'xYN\"li\"	04r,c\$\"\rbE\ncO!.,y.q\nl\n F\$*9j\"W!m.N!\$E\r0311u1qi\n2%>z74-͘JHr%=C8\n@G4 tiE\n T`Q	.(Q/R'92#r\rc931/.S:Fz3;\0M&2\"hjk/Ss\rs4\nr}=ҭ>29p:d>;4@S!S?U:s;=Z\$B)Cm!2TF;GC)3r;:nQENUCTF\"|B\0J4CGƌBBѦPt~HtDӗH|锓~)HeNsQxH3rLc#7K&Ll(SV21Υ\nT\r4O=5l23bpfv΃aѱM˭-Zrd(TLIO4L@`*>sɶ\$)ú),f1,`)e,\$6)B/^`\np&-,\\k2r3kX5U\r\"@#	2`#i3V(-Np`PcXL9N5)D,Bk<*S9ef5#U`iQ'=cp7\" FTcbBĢZ>ڶ0buFT^գ+/-+N/SYDpie@s0rP8n{btV%\"@\n2(eN8VO[jT.H66't&f\rG-̂Ip,vt'fn-\nއ#:MAu̨cPJ>OMlL36ihp`Lb>nehñ	\r@JD\0;Z";break;case"pt":$f="T2Dr:OF(J.0Q97js9էc)@e7&2f4SI.&	6'I2dfsXl@%9jTl 7E&Z!8h5\rQz4Fi7MZԞ	&))8&̆X\n\$py1~4נ\"^&aV#'ٞ2Hd0vfβK\$Syx`\\[\rOZxN-&gM[<7ES<n5stIܰl0)\rT:\"m<#0;\"p(.\0C#&/K\$aR`@5(L4cȚ)ҏ6Q`7\r*Cd8\$jCCjPr!/\n\nN㌯%ln1/=m7lnP4ȃRR+1Oq4+J>++8jQRрP2\r\rSpr#<FS4VB)(9`@ C:3:xiѵB7 r3@^8BUJ|33.懁x'J2k;F҃R>]ılk+4kb`07̺϶PHpΊcx<h! @1(HY\r`Htp譠@ ok2c-{5˚ǈӳ Px+8cfQ{P[b9!)v#fc،[(ؓVz&\r➩\0(SC;R[<}uV\$9Msꀠa>O֍#b6HN0<zv\nV?xS;J#2]/#5C? w;\r\"l3JK8op@9FLL	'Uxs&\\r	6+	85Ldh4P/РΡeV:Yk5g֪THmܷC&5r.g\r{M^+̧\$LS)5upGH9<[8e	hOd154ss\ń5Ufh\"%NBցy.\\vϪN ȱ\rw(@hD/JX₂H\n5웃d\n\n)`AG\$\r歈Zq\r&3'l n\\HLISk.c0n\n. @2ee9.AC\n<7SRy7M%G(ִK3'rvypB}@Ws#\r_1H@!ZD42.DɤA	2P̕ɽ3ܯ!l@Ts>C!\0¢@ҰnF.@BqN6O)5Ls.LRVrde\r<o(Y\"\"y\0%]TiFpOr\$rHlY5W.nW\n	8PT@-Prj~X@@1E:e'L[b_dt91fQ\n3c\np%bEB7YZOB	JSA\$F)/2z{r#On(E \nSN汽DE(D̾sR\0PV ,@#h_e*\0UfQ]SѺCbk:PLbEKqHdIt^')\r\"IPeDqb6XuW\"SjQbefگ-vYْ{f0T09\\bRdF{'dx\rg5pWi.MI!}*vTʂ!P 0uAP\"&?dR13x̛Fn̟^J5W»K	k\"'bk}6Ne?`k@lf4ʔC%wlqZL8mv?F=sv\$wloTl0[]q:A;HQ)gd_S*mX\n;EBew+H(d;PŊft\"P2Kag?؊{sUďLǄSC:,ֶyFa)gsׯ[1Q܌,%iټ}QFNDDkϴCyTXs?}Dt˶f\\Ky3S-DXV\n죠rEU֠\n{Ȏ9og'w(Khb|\r{[IQ!sqxlmۻ?p2o?.+͝ʚ`*æ~Fk5\0Oc5,dPNØg.P9nJ9c6;I(fF /jDΥ&goP>̓#-4\rvC:iNZעk\0.cPp.a.\n{\0k)x%0C.\0'\0\rRn[i:.M:0i\"DlG*(G6%\0SFT>(#ҊB((:,P.n8p)M-\r\$5#,	.h/ZC\$}oFDnPNྱ %q1N2qb{m\"V\"V#0hJNp{Yml.h8qeFTpvA B'\"hPCPbP!%\"R(IQ@0d=<iD8ȯٱn2QɝB@r\\f_mu#h0B٥p3or`]H&\rVe`nx!D@]\"3(bNE4\r<AJ\np\$DKٰ~6'	B)8GJll0 a./3\"\"m@H#º/H4\0ed]\r4mdratkbt,O&;1#db@g! Re64.v0~e\0	\rcǼJ\"+C_99dÞT3(BОy\"(\n|_?20c\n\"H ֠\${#kyT'wL|:2p3n\$BS</\$1\$.\\S4{7%*cWk̻2dN.k&SʘSVM8&s";break;case"pt-br":$f="V7jm̧(1?	E30\n'0f\rR 8g6e6㱤rG%oihXj2LSIp6NLv>%9\$\\n 7FZ)\r9h5\rQz4Fi7M&)A9\"*RQ\$sNXHfF[\"MQ'Sfs!\r4g฽䧂fLo7TY|%7RA\\iA_fDIA\$QT*fyܕM8䜈;Kn؎v9Ȝ@35z7ȃ2k\nںR43Ґ 30\nD%\r:kCj=p3C!0J\nC,|+/╪r\00e;\nت.3>J,\$2SҼA#\n͉zz7M( 0AM!#!\0@;J\0TBI*9`@UCF3:xgU<ax	c ^+ѻp̾'|=T&O+ۼ*cb\rG	jH8_\07JB^7G\0P7rc7\"\"2!.Q Ⱦ66\nuXܜK,1y5桪cCC5=6٬6%hӌw(0I\r	VGn:4И*TwKBBk#bRM-5*&L[>c( H[!PaE=`O2c[+\$A7Fƛ\r#b<HS(3}z\\qhYwtOP\"@Wk+	V#q\r|:V9lxp3mSXx8\0IM)4)#z	,(¯CvQ.2cBXACFXkcVxwZ*t-Er^0p6	v.@Rpt(zRHX&nUbl52NBh;ʥuhT[\\Y/*\n`ba6\$`G\0tBazh%:2̌(DD)p\0sȔ TYdbPNXnSv>\r6̡Ss?z8G%p!KF.PRݑ'1_<yGy5JN|X?) SNq(ZuH{\r9FIQ:E::bQ\n4ETYǂ2L7&)I&DE\\T8&Ѷ̆9SMG#j G	myxS\n(z TP@C u!9I(\$UԔѕ2R/͙ÑZ	'Ȇ%2FPdr1\r&\nK\0F\nN\rƔ\"NѮ\$}HJqFNP*Ve E	ΑƬ{4f>G`K'`kp4eHear>p](C=WNӂrNl;\r*e^0	ޥ-\"Ңi@MsJXI~h+Y]U8zҞ5%RZQGXT Cs\r6&Nf\$\"L44ΦPmT2`yLv\$	0X>PV3初0iٷаBK[p/6`.UsJPb_Aǰ\0r\"2BPP*t\087(#.}tCy~]E&	C	\0):T1 8`Nyi*2Dieѱ3N̎G`X@<VbX {.2]TRɯZXdv>5t#ʪJhs͌aĔzensqݛwV{ZwM8w\"&0RfW!ºnSQ1q`'U6aDpy_*!\0Cy[M/_d!5ߧB2UBwE?2י&'ohsX7a[[V%xq7槯7rؓ&)UkI@(37i7l2\\z8pBH9?*vQ&/^@5Оn2XAqL!pY_2bFUx(67Lwvy|\0A޵N?K_.~Ӻ׷vL:: Gv߯XR#ߜXx2#\0׎h(ڎ֏͐\0-ߍ\0͆oM~O^+̀ʂ=,О:ͯ`AC`JF7\$2|%cG΁f*b pW|M%Epl0|:Bƪ^F\r0;N4KjQ~?\r\$MLƷҵ/Ok\nEl3<JѨ)I.M2oz:4v:*ЂcH,Sb8(`nOg>('Ep\0pflģGR`fg1Td(P\";'OBh pį1IURhqp' Co@aGg:\$20#81&u@A\$&F&]&\0 5X(P\"!q\$0Hī!P%/	\r䬗(6Ѹ\$q>pe-\0p+Fȿ+/j`nQipmdb7#0o:2\\oͲ-f'\$!\rmc\rV\0mB,\r\\9d4L :' \nq\nF2LN,3Rϭ/M8#@)l%#0fnĐK>:'.t\r0v#2R%:7Y;L=@(e&JF(ˢ6*l\n7/h1 fD>6/jd~LP6qH4\0T!Po?̚}4h8*b/C#DA.D>Me0%s#pUjiyo\$\"_ɪGψaZL[d#G8\"lDn@6#Nc3;32C62:<cf:/kQ B\\j|;\$DR,";break;case"ro":$f="S:VBl 9LSBQp	@p:\$\"cfLL#>eL1p(/iiLI@-	Nde9%	@nh|X\nFC1l7AFsyo9B&\rن7F԰82`uZ:LFSazE2`xHx(n9̹gIf;=,foNƜ :nN,h2YYN;΁ Af2r'-K !{:<ٸ\nd& g-(0`PތP7\rcp;)'#-@2\r1À+C*9Ȟ˨ބ:/a62āJE\nℛ,JhP#JhV9#JA(0\r,+ѡ9P\"ڐ./q) #x2l1	C0LK0q6%3̎A06IgA2/\0P!03@Ήxf*Έ*Zʝ\r>9+R9/9l,;CCefJ9`@%C3:xyR^Ar3_ZJ|6	3/\n,x9\$X.P#UBh̥C _<o.E\r93ɍ\rbANJ+r3`P7ˀcd1\rȉ\0ߋHK[EC[FHR̮QΈ(F\r쾎(3oJ|qhR-nhzC\\.úQ õo#Wԯ:?Τ4nv:0(̈{(\0㾎CnG(9^4䮻.,/SV4SuP=:l(2S7M3|@Έŗz2WWZUFʱs\ni'I}NQP1w=?elHڸj34zOBI&.1\"@L f1zSyC4\$\$XN1Kruñ;j+\\fL='5\nQ2:~I8ƹW:]kwת_/ܿC<񽂇0|Sylш8\"QjUbeV4\$rC(bu\$9r\\KB pĬN [2n`rOT0hcXalV8u'dy9/d#92HPdhA*drl ROZ8n}iHFRMj̧_ew(*=Cq,hqPn\$oEr	D!KaL)f!	HC\$1ȼ	H3DTRzF14&IYɭK5*:Ic+\$rrAAQx.M\r-Ud AN<IG\nX\0WC7LPO\naRcRJ)PA)\$^(\n!)%GJ%-*\"R\$'hbB\n `N)KN`\n97d#@G*|/}2Ur'k=BCGmH\"ӸPL%!%4pY71|MW(Ef&:'H)ućPu&A43*`Z-&\nO@cFb{iƎ_2#n`~@`M&\rRTY*th\n\nFR3Zg\0-9RD1:/ϴj C\$a@HS\$۲*^)_rU7a;p[[hɹ<cz뗼NﴋF|4F^s	3-2L#їr\0(0X7i\no#:UH~iSR.bF 6YV\0(\".mQ4T\n!t	5e\"	i\rGz,5Z`J\n.-*âk{x\"),'y=7%GwtkVӐ+'{7&(nݯn)CHm8GV YSfD6n`1*o3':\r(A?+cl		47[y8R\0ē\rxC߲ngx\n8.GFVR(6Fg?\r#xK|&AFk.t>\rC~zi輅;\$OLe=F\rK5`)/T_Z/vg=`әR\"Y\rGem*iWSCx[SBpXvםy3&Z(yt(fPC5UWF/+lg>y\n\"5E[\">,n,\$n,zP!0B|/c WC*: VMVAdNm.l0bPf#rFAM䠰eOZ2j|\"\"flc<\nkm\nF~%O&Wp+ Bb8\r :P>MKi&HyB\\\\\rc;\$d*,Bn02\"ǰ|7\n&4f;o|kmF3Xp|PfUO\r@&[H>PevD\nإ|t/\"/2BD&o\\ؑqbqoX<eـn\$#@R|&K<èٍvhGqdƧp2	!b\n3!o!P#ԖNECk\"{	,rL=L?\"l&\$QJ/'AV Aw\"P0Rq'E}'}(Ҳvr{'7\$C))'͖2+A+&2ɉM:KCn*ÀKR{/z6qX()/#/hӲr1RSpѠ\nI0:Ѯ@.L33/0.{2FLsE\rz	*z\"%J\nvc< Bf\"@P,?e%䠂w71s!\"ilWg2\"lki67m	-S\"s9Pvߢ\rVib\rq27. BhZcq\"G vb\nZt\$>>jIAM޵n\nB4#<bF*Mqf'wG<#4rHIC%G*5	J\$#u'+avFj㊸4heL'F/&U@\rkt1Fmp,se'K+KО_L<k-L	ѫ3#*)h6&WξMM\"qfXFn-ȟ@*Zn&؈4olDC01E6T/pb:DDu@i&Mq=Ĉf	OW̐%.dn3J	CQ\"8o',,y4M\rfpo(+R:Rއ\"mL	\0@	t\n`";break;case"ru":$f="I4Qb\rh-Z(KA{ᙘ@s4\$hX4mEFyAg\nQBKW2)RA@apz\0]NKWRiAy-]!&	pCE#yl\n@N'R)\0	Nd*;AEJKF\$V&'AA0@\nFC1l7c+&\"IIз>ĹK,qϴ.u9꠆L,&NsDMe!_ZG*r;i9Xpd'ˌ6ky}V\nPػN3\0\$,:)f(nB>\$e\nmz!0<=S<lP*Ei䦖;(P1WjtEk!S<9DzT\nkX]\$ٶj4y>N:D.1ܧ\r=T>+h<F.\"]-1d\nþ\\,3:Mbd5N(+2JUC%G#\nT,`#HkΖŵJLjm})TʣU%cĻ7\$qN\r9\0Gj\nu2N\$=\\R2OճuƌnT6HhԿ2O9r0wdVr# 4(`?3S\r\$Bb_EV۸A\rc[ЌG\0x0@2D49Ax^;pÓeP\\7C8^2x0cxD\rFPs臧)*D2\\x.#El@&.#	wd< ;3Urh_2:MZݻD2\$p6a?H5B;j@ÐýZ,\"rOmg9(\"C&vHKns{g3wB)2M/*(tR2H1LMX;۶:r2|\\\0{&%=:TMrDya\$\rHLIKpGPKzp+MBpM9-TLAA&SHŉh\"4@@W\\w\nZ+X*N%ls݁`()]fdZH)s۫] 6KXii(<`WejT kGR%ĐU3>L\n-IV)4ZHhFEiNh\$fLh)	#aLJ=@\"I %Q#AD|#4+2e=\$*\":aS	:C()LbTb\"y1P\0De(*5J4hIĕDqQo/B,,b&2bZOW/T;FH=ȬxH\$C-fa	%{ī=_B<g촟I:E\"1<'542\n}REѺ;<ERd3gxA\r2(PiрNbPi3-Z+<)t/4wy`O86\\P}WdDRRT*!q64e`ٱ_T֞ZUje־Hrlmha7۩;\"r+0fy\"mMLdiqS2bH8%O	uWLIβV붭L('f9:lfARmRXPc_*Sʑڄ'̪BY=ZyQcJˊ.M\$Ǡ@\n). 3 ;g.}΃>IɻmCB[HSwx	I{)53IlgXQIb\"EtLCfk{@\";k]%J`FI,*e0(I说h҇ R0+,P'y\rG\0%BbE='2OѕTg6B.!8#@J9'\$刿,IT8KlUQE\$m?ޣjo6=\"A\0P	L*F	gJʜH9c=b&9X]2=!l伷KԴ|VKd5#1;\rOcӷKXwYcJ\00T\n\n)'e\"hx_EaϤ )(wdPs\"_ m.C2BIX5\rq	tH&БvB:[xA)F\$g^-(zpK*Z,/e<}>ʃ?J^ϮH\"T{g}ynUh+o~1heP\rP`.v\n (hc48q,&YW9jt]\\:TNV;(K-hFZ%tЅZD*b)G踂\\6GɇBtngwhBtDWcG4'Ǆ\"sPn0oNC<@^L`u0vu~P\"̌D~\"ZC_o&fWp\n0H#!KCW\"J/X	Dh:PEW5N%RyiNU \n`\r\$enlcJ亅QG!\0^1**\$\rq1|^2͢cO+IpC\0d!єfkILk qeh&q%IDr!Ѧ\$nFK1e`ϣ]Exi*(c\$\n!:l\n\$7!q)*s!ˌo#\"R!#JrC\n|2WCF^Ѻb%\\/'1\"['%W(Cd(w.F2^(nP/xĠ#H**{(іNuk+vbLĦFѯ`'J\r.W<\0B,0obN%/aҬ.'NOK2*v-730`nd¨/\"Ѭ.'c5͘KT}l7q4@9(du~r}I9Xv3X)^s~c'\"3Kj#Zӟ9Ashe\$j̰pTvQ6Ҙl!+>,~CHJ\0RI.ac4a2JJTKi&C\$(C\\CL4DRQ8	*(B_7Q\"48*JO3StXK¯/G:yHb\0*r(4s#bJh#'di212E@R7493ɂKK^rALKhNTE/嶨8IMgMN.3Nj(NV74GrXm\$P,u'4*1RPDAS%!u=\"ȒTbe\\B\$E\$=R)#Fh>bb\\ns.)\"z|'\"K}@L5? KF*02:USRVU.huÌ00ģ:H	O1cRZ80M5,bQG-`K566/cwbsaBG%cHcH*AN6%3bs%bvF\n;bMIGel5*eOu_%[eviVhX'N퉛|}n8!A\rjBx5~Q&,DpT@4wTwf3?*M\rPLsLzqm4nUo5h/p-ov&	epC\$!BI_*4\\TAWfP)\rE!Ssgd0uKt萐UCܰvwumP֢QvORwwx%xiwyWxfmx:ObԄ8X05}tŐz~G.rcM;./GV\n.еCEa2чx3d17\0%gG	([PAx\r_u8!e/XWy?T*xA11|[UցSoW9qؒ2b-eOJO#a{Q/KO_Dq(*cMvǉ8C}>sl壛, 481GX-Gsx7,%2t;Qףa*q;%#\0\0a0X_+n&Sp\rv8x.Qmul>U)WxѠ@\n@q~oՖ'Ύ؊@+8uÚݙŤ^\r>E.RɈyu[U~>l.w6	7ZLk<ln\ncTrTuy׍42&V4-ks%( &P^夁|k{ 12BՔ7\"k5yDP&49m%DrFddқx6/g7ӦZ}dX*Ά69PVXXW5l2pFZo}FqN(+ZdDK,\\[uqS03T٪<:vͫp8p\$10ؤ-=TtG0%H&e{s}}N4I|Nye|<F\$tUSXI,<@";break;case"sk":$f="N0FP%(](a@n2\rC	l7&P\rhl25rxdB\$r:\rFQ\0B18-9H0cAn8)D&sLb\nbM&}0a1g̤k02pQZ@_bԷ0 _0ɾh\rY83Nbp/ƃNbaaWwM\r+o;ICv\0!F\"<lbXjv&g0<zn59\"iH0{TףC8@ØH\0oڞ>dz=\n1H5*j+P2`2I5eKX<b6 P+P,@P)`2h:3 Pʃu%4D999cʳ\$s@PHElP\$-64ɀr99#dN1Cp jLÜ ~9pִ):\r{TB2\0x\$(C@:t/09Ș!|)`ZC ^)ډ̉c7^0H&JNUk,J6X)LVПr6:Bv7c\\+mc|\$#4:2  AcC@<zj֎pbC1B	sJs4H:\0C.>:J:uJ:Xᆱ0Or\03;y|9@P2Ez~X=(J	u+kd*^5r6\rc\0!7!T-nd=.#l12oVN64B=eX	a~~R6傟ح'	Z`;#l\$\"x^RhĦRB!ύ*f+U	ٔ378ՕHIʟ`\"fRsuQ&tҘ0fg`ȧU[P*Z(bؐeP\\u*&\rZ	+UTF]BC=3JIYYV!CKmC+Yl6նV\\ksfr\r< W~6 MK0CZBg?Ꮷ9TA吜nNRI)\n'v\r5Òjh3\"(a@]YRTble6A^ GZr|)jΚ,u̱LEh2!NҚAj\n٬x\0()FXRҚpjZ35f+`ú%R\nEG8,hZ/si:g[Ҳbm&))MNy\"OC\naH#A1Ye2X>TE\"y%!^4b?(NO:h/+PS)Ĥ\$gih(#m-ଂ\0̀]Jҋ|PB\r;~xII	((x/mwdK'J*UھioA%bN(4cPd;p@k|X\0)(`nhĹP]MmTzPk'B&rɚ'\0 A\n\0B`Ei˶>!BK +N*g\$/ڊ#px\"5MEpV'X堐)1BS(	c>vMLg>B|ů=p1V<T02U\$ccO\"8H~Hva	\nv\nSV:\"~U!<1Eg4}nWC\0ʌ!\r! 3\0S|Xga0dN,CB1a陞)<EEs0ot]rSD\0PCEhŃXcx]}wk]#ԇ\${EHnqw73^3\0K+\$\"V8\$d4f #AFH T!\$\n祐\\&<8?*CA;3pL8mG8hd(-U\r7Qv0\0Vv/LԢѵσW|{8;r q\"ȱ\$+r9g.8~fy/\$QԩKl9gyŏ\"D:RϋvC*#?}KqL(	0:;/o=LU@܆IJ)ScC5IGBmY>KJ!B)ɜ2y{Gu܏s_S!##è:.D\r+Didn9%',;Pt1D쇓@˲&\"-\"\ns}<7rP,Q#xE~ݨJ3\$@g8(\"~HډҴ+)BW\0b  G 㖜ޅ2d	7>RB7mmV.pvDB|+k@ƞ t0D|ǞOk\0y\0I('/-	(\r\0		0P\n|M\"{Oƀg\rp|OCCm9&Ĩ.B쎠L\$\0GBK0\"anxȮQ!1(\$1.Τ˪zat8Ε\r\r\rImxS`PlQm0_j=-\\\reĔ\"'\n&|	2\"fI\n6&\\f&f}eKȬcg[B.VXkTB-nO\"Op̀-gvOfMja³fӭ>i鱎Qr3/ll#y\${pBHh;(\$0brh{'\r&cL}\rp9〺d(c&{-('G/@lEƸ	bL-:T\"u:Dn8l-1#ۑ;-p(q.P8	xp\0ePcz/Y02V(.}bJj%\rbzEr&-S0''[/03_33G.o.z4E1%434eQy-hq7N4U5F6s2F.m\$;7U9mVyDs827\"(/:e9Q;J'2ӭҢ9\$o=d=}3=M>щ/RR\"F\$BS.%5đ	#+o,+T ~aB&	,EOB5Nt4\r9<ۤF\$q G(%\n\n\$sT*cE\$#}\r	M`gB!Z8Z4\"eN:D~Dnt2BR˄J(ZEb6<ꆨW2\r0TBT	Mj~4tMB0:#ohqLIJ\$d5\"Ic6F\$0*AcDqE0<\n@\rt_jyYU2XFƲ #DD-슻Wd>U}G/X(pW@mYLc./9m\nB'V4zr\0`Edτ2##5\$22a0\0:@@ňp#YkR0vv1d5CZGN=RDP]\0\"f\rdC\ndTM9#}521%Z*âBVkX g9*ճ &9<6S/5\nTw\0oi\n\\K	\0@	t\n`";break;case"sl":$f="S:Dib#L&H%(6l7WƓ@d0\rY]0XI \r&y'̲%9JnnS鉆^ #!j6 !n7F9<lI/*LQZvccMQ3g#N\0e3Nb	Pp@sNnbf.Pl5MBz67Qfn_T9n3'Q(p]/SqwNG(.St0FC~k#?9)9ȗ`4c<Mʨ2\$R%Jp@*^;1!ֹ\r#b,0J`:B0H`&#x2!\"l;*1#Jh_!\\LLTA(\$izF()ϐ*5R<l|h jB?H~0r8@/ h\0C\$&`3:xY͵Ar43x^Q\0J@|8̍\rH7^0{,:%P7c\nDC;Z2KH[d]r.H77e&BR(78itK\nIa*5.x)\r85_\"T6(;ŠP%A## =2OfF8:|6U/0s-qNZ9'ӉE\r3&#~x	BIxqib6\rˢ\\-(PȃCX^bzhv\"}[<w8svnF=MP,5\n}tKܮ!tlh4dj;6\rx㗙TlS *#0̝*	x2No2n:yKz鲊<	`ث*zz\n<*%.Aӡ%4z@iU\nV*`Pj]ܯ^zb0|Chp2:-%XtShPά҈IY@7Da&ȣM\$\$(7v#^Q/\nmI2JioiZ!@Lsr:4d9zf!dzAM4(`\$Сqg4+\"J (\0PRI\$K8n*x0ee*(͚So-9-YK=pOꟂA9,:?KS䨖F|뛂H@8mh\0rYAN2FHJRC\$7\n&H|\0@%=ZL<NP}AC6ACI'38R=3(vVA@'0C\rG^C>ړdfuD#)I6!h,e&Ƌ` p2F\"`	F\ntD~@)\"fS\$Veg騃慍CylWpl\\088#&&i!LPn8&a8y4Vfh[*\\9>6&͓/E> cÕ|I\\@r<=dzd\0eR]Kroqܝ)>jr	t7'2fPZ&ŠEeӨL̄˳* +-\\K6\rſn\$2R*kB\0002uW|8s\r{6EHAȮ'i7@mbL%r(A2HlL+z!cKrb:pH\\˘\n0r|]4x30C	\0%^Ixt)%pLf4cKb},~yW֌h)MkҺH\0DK	?!BZ\rZ'2U֐k`߮5\nSkQSqR\\-u>kcP\rG#\$ɛ%9[s\"xǃhkW=Rf37\$Qټj\r(h7N\0T܅\"~{	\$:P(FbsY^om֦L҆S	@tNe·(tCr\n\"ZG`KڋoYCF,t}\rӾFx,9(?/R5v/-`}`@9Xwo/q~j7RZVΠIdZ;D=kC6'KkI	ozcTE 6rqire!OFH)&p;&|gyؚ`!÷OmZ0\0005g|ocTÏL\0L]\0t'G9&Te ݐyMMhٰ20İB(pI.mcـp6p=OAn=Z PpAN,LȪwB\0Oj*m\0TuĂ\$hj#p6LeT6hsCD._d\$*b&KCZØ6\0m+\nhDYm,TA䞩rِȐunǥwTPݨ(p[u\r\rELBb5kKq\rgA.lBLL*gXe΄eo\$R_1q[QOb%чq^Hij rRLGi(j	D/Z1e \rbf\r0DAS\$rVò_%R0G%2H- y'y% dEu\\l'ntp̻L1T+RRز;''M[,GR\$D*2I/*Q5	1¢x/cb-1:|f]eI	n=N2!D24ֳ\$Gp2S:#5SC3P)#3_%Lx\nq?vbq2sk_rٲ\nPM3Z8PNI8SSVc'9\rV4~b^̉Nch\nZ'R\"u7\nppN'>|Nl\r?kDA@\r\$[@m5DF#4]:5Դ\"@l<Id<dN|f[Bf/0\"6-;%\rY=G:\$pl*F.̺,̯̾:pD򨋗I^^DJȆT1}K'3c2\$O*w6&&yfŀC\ny\nqh xi%/QbuQlN*r,-:\np@xh@-PlhaZ0\"bx|6D2jO1\\Ђb-J( 2Q&Y\$W#v?+\0";break;case"sr":$f="J44P-Ak	@6\rh/`P\\33`hEC\\fLJⰦe_DehRƂhQ	jQ*1a1CV9%9P	u6ccUP/ABPb2as\$_TI0.\"uZH-0ՃAcYXZ5V\$Q4Yiqc9m:MQv2\ri;MS9 :q!:\r<˵ɫxbx>DqM|];ٴRTRҔ=q0!/kV֠N)\nS)H3<Ӛƨ2EH2	׊pp@2C9(B##2\rs78Frcf2-d⚓EDN+1\"&,n kBր4 ;XM`&	pIu2Qȧsֲ>k%;+\ryHSI6!,,Rնƌ#LqNSFl\$d@0\ne3jڱ{TR\n,!\"D	3FK,Вzs3UD<o>@2\r`G r#p|^#rP2\0y3:x\rwFp_#rLK@|6n\$3Fck4px!D3L[jh#4TM\0\\QRYr޾z8'6]tb9\rF!84߻Ȃ3:^3%ƧbrO_8գ3-h	^z03\"b6H#6,+m]R<C&3k+MR{'X팒lnOjC;l	T܉3{S۔? >D2m\nגja> ư36bRAL(Ħ*]m/`<ܜ6rd\\aU:֘m!Tۅ#4f44Ln\03]jm1pĀ=O+Yz #i0ט B\$\rM\$\nA@ Fh7GccyCk)IXpɻ_Z=`pe-by-6ȉ>5l<m[\"ۑf>\r̸q`]j[5,Jc`B	&Xsa4dĘci1@ș#&]e&VYde3PHm,6,x98kgI32M|1(*ĞE&-S56H\"ARA_!Ѡ\"` G8#xk!b%37t\$1:dΝȓ`deQI`_KrZOȅ@\$\nqLTTVX(M7IG8䜳 r<Hxw0Q`Ύ{i}\nnvYn#0ԗNc\r4v7H<nXբ\rA!) \0. H6VIHHtEK]k_YtO{iHhBơչ\n*4A+\nI!2H2-h`CA66}E7w_R9͸*9%VxS\nR3;-+*d2XK&k.KR)tPP`m+uYIhkDI9O\"nEN2f\0 X3rXXF\nx0gR`F֕0;+v\nۊQH'@BD!P\"\0Q.HY&/Uq*\0gP@(L?hDB*\"ǘfQ5r}*Ȥߙ{pĿ\"m`FlxUDJH2;PY5)VE+h)c5]ŨSN!-ȅ5T4ڄӺFqhCKPmI1>گ1s`(ض	ҕLI+kd(bS_R`&e\\Kn'\ro<]'܈BSxh\${C'\"<A>ǳiNN(e9uD.ڎ.g(syGYTGYnP{l wi\\9D(2q-u\$Ld\"%;oBT[\"oxB'oXtK uFS\\vb*eJU+#;]ӏm簨BH߮poA\$ޥn[ƶQ[U\r5?:w(JD)L\\ժ|mcUAp	?s(oXܩ~O&\no\"\$zWo-\n13\nk0HVaj(OH~T/oȅci0QrL`\"(.	@F@\$bJjmLYd/ׂP?,|.%y\0-^Rb(BN\"d*&1EI4yHQ	,2{,Ccބ0F}\$]eHjjmbOD7#LP@LBQxW\rzx)mQhh5b&OM}o}Te-YX:Tq<LN,X.dd	#D-|r5l)FQNs'Xߑ?O\$\"{Hs=>MA  3\rDZQeQo%V۩Y`ڑT1HrrJg(((rq\r2*qҏͽ+((\"Yn-I`k,QCFo-gmbaR/er00.r\0r	\"*Ļ3%\\z˜:=sA*34>,P5r-ڃƬ©7H+g30?C\n F\"Ƥ377䞔<\\S87 n)S|\"c@ u|-\0䦞73_39mq\\\$-d8/mmlzL1g),4js[g+M^3Bi%QBT@z<WAt&-Bt16m1RBFDm?11j#茊\">mHE.-eDeJ!<2aAR/i;Njxޔ\n-?;7Mxӝ8bH{N@vƈmR2VHKSEE)`6GR5A#IELHh>#\\)]G!U(t\"{R%D!#TdmTFӔ'5b}~Q5&	8/VQ9T\"O'EtAYVeW\"Wn)ը@O[!FS]EPXgU!uYMTI]1ZE^CBqW\"4s-Q-OЎ{-o5bj/8+1/coc`Hhr-c+^&0k\"u\0S\rvyshVP`@m^.tŢJ\",Jb̜\0+@\\\nZ`޽'BJkb[0pwn6'o0sȠKJJS	\r /%CA^mԡpCkjǯjQUk&Rpku2{'ǰbYEKvN(cnGm^#g'qCB4Wxy\$c'y?ohcR\\QAwI.Hw-2~+22C3Tߦ'O?C@`G&\0bvE8HI'\02vM~80B?J3oCo6\n\r2Cu2S2`\\Tx*4WD\n%=%zr[(v]!R44@8TQR>k#QkJYWOH.`";break;case"sv":$f="BCR̧!(J.! 3԰#IeLADd0i6MQ!3Β:3ybkB BS\nhFLqAd3\rFqt7ATSI:a6&<b2&')Hd7#qu]D).hD1ˤr46\\o0\"򳄢?ԍzM\nggfuRh<#mw\r7B'[m0\n*JL[N^4kMhA\n's5Nu)j\$ܢܐo*H#2J@)ʫ):O*O\$\"C8!`P:lb\"41rݵK!#P!셼8ʴз\r87#H;d<C*)r<Ql6P(O+%((!clB\",.6z(<4(B9wA>*-e\0\0x(CCD8a^\\Qszd;xDmSz7^06\rH\nHă:\05\\#P/+<+MR&cxz-\0& <Nah	c}+6;~( KCo)\r\$JЃ<GŃ\$T9-k@P:hF\"36i˄me2(画(:Ba2RfL5:(h׎e}K%݄%Дӓ&0;7sm6@Nms933I8#hᦹ(źp.z UlDq2C)`8B4\\!3u:);#r3-t	U!@6LoRǶf**K&3Ű䃖D܍I\\p_|&)D, A PO}'~r1P2au@'\$2&v̑?чG[)bhv'`E)T\"=J\nU:+dQ%^+ܯ2pc,:	4i-G:6-@\"Ff<l!~.Ŷx@\0L ;~)I`lE)vLoRѴ<\$gJ|BRFO%L/& <bI)A\0l!8,}Ed*@3c.Cĥx˙6Lt	#8FI`U>f0BEb^HOJ	H04\r(NdٽYDlMI9RfHL|PFclYjjCGG0k&4G̉E)uCu3\$T\"blA5l\" Tq(Ab	u\".9հqYGpTLHI6Kd%!*vs\\ĺdBFd	\0	1nsHDT(\0BE\nA\$'{AhO\nAP*eb]0PƤby.u8>rHhh,2&3䐢DV#[7亅z&K{ekQ	gZ[KutJad_Ba'%%Og)uH)'\rm|w-Iw(4	6d\"\n˯/C}o\$1EIPM#Ev;?!Qw^OvD ɳ,tncg=E\ng5QVp\n\nJZ)qaƢ`\$)	Eث^g@^4\$L8bu\0rFb߃P&hyjMk}cLiic][Z|Gh՚bޒښ?'*S\\|4JbfWyi*\rx04\$I<\0l+RV7[~y8i;3^ɚ{J1aa6K*m9Q.ǎL>ow\"&LtWv7<<shm\r32_#y\"0&Ol-]Y>uXͲu9oǳ\\04@࡮p\nQNq9	w(!88\"#.C(㼼dqz</|\n]>{%<msXA}gF9\rZlMͬ~xt>oe=W6K5-sw'\0(l<F5 ̔OТ:rcZ6Y6GT!lSАi>Mfʆܕ'͐^p6Ϡ/nbt%%\0\".&P+P[OSPZS\0eld\ne*HeC\0/V+3L),{A0#joo}͌ʢRpgEP2 rhpqb\\l\$AFR'F4LHIhPSD='c\"Z'?\n_ap&],m@@̑cNc^̱MqRQmeo\n}E\$ȄD\n3B.Ky1M1r㱤/G#np0R`>C\$<xOQQFQ0f-nԉKXC:QSb	doB'jHa,a\r r+/b&D`@\"o@Rb/p	O+F\n\r-f@ұ'Jqܪ㲆c p})v`u'ML 8\niԮ*r\"%Å&Xl2	@ E8M5\r|0h'Bj/-Ȅ'iLG)\"<AEo&z#d_ɱ0=C2_zF)1#:9Ć\$b>BBCl:kC.	(B@7MvH%Ѕ+(0kv:\n.d16&qg0Qćbx[@z<t\r@";break;case"ta":$f="W* iF\\Hd_+BQp 9t\\U@W(<\\@1	|@(:\r	S.WAht]R&\\I`DJ\$:TϠX`*rj1k,Յz@%95|Udߠj䦸Cf4~Lgp:E5e&@.quW[\"+@m\0,-һ[׋&a;Dxr4&)s<!:\r?8\nRl[zR.<\n8N\"0AN*Åq`	&B%0dBBʳ(BֶnK*9QāB4:Nr\$Ţ)20\n*[;\09Cx0o7:\$\n5O9PEȊRZĩ\0BnzAJ<>p4rK)TB|%(DFF\r,t]TjrD:=KW-D4:\0ȩ]_4b-,WBG \rz6O&r̤ʲpՊIG=:2F6JrZ{<CM,s|87-@Z6|YL\"#s*Myp& )#6jZdy*cLt2hZV'\n)IJ6l\"D,nrVYҲY%괙w)m;uucy%\0P2\rDNs<s#rOMKO?#44C(C@:td(3Pp_?tL\0|6O3MCkR\r^0&)X \n~\"-SernÎط%-_0S\rw)݀sZO\$B+3R[q7Wi ^PjR\\*B](W!7\$HBoPHpEȌ `Bj+M`Z:f僢\$\"'>#x~pu\r;C)_8K+[F1GHNZ^6PC8gtVs	}[.6%Iq'LG?̢9\\4PR۳]16{	\0c!\"R\"@}ǒd@rfJ,ZGU HSJof|KVkA'\ri0VIN8DC\nii?T/)Qfh+J##b5ADyH >d>rgT>\"j+=҂%kNX40MR16\\\"04ʩ'O8}DT<\nmQETD\nAsħRf\rX\n*wR3dK-8F0݄g7`3浽ɲg4*ֹW|*Ǜ%\0nRZD0#k}2of\n vtY)1MN99aaҨ7B+u.ֺbݫ~Mn;¨k#xRbitzOR*5s\r]e\n5&fǷ\\eĲ6>@xLvTʆjpL091XnC5O.)h\ngIQ\0ab1[c5faL\0QuHO&y1\0\nEҩv'+0Y\nCscza9C~ӳ;Up{4e?/(7\0\\1P KJC\naH#faCUB5\n2a\nfi9k\rX9X]8[]Nq\" [h6!\$*j-hւp[zns>\"pYhQ-}I5q~S%-5:1Ϩm\$L7pdޓ|(qdA{vAX^ӎ/		4ơ.Tܑ:2YP(E7)/u5Yn-Π	l3@P(f\r!:)\nC%{&;[]&RP+],9}OY=Nh#L.i=8 rhURiHI=~[O	*\0BE^(@/m\$tFdBkJu	LBecj+_-sS09B:R0Y_&tCQO~j\nQ	ZW)/s<<iꗝ6GshXޓ`-@\r/_B\"nd&؟><{\nj\\j}OI\$t0\n/ȆFjд@\"bγA\0Db\0lp?g\"BlSr{@PXVh=hK?\$ TGܯ~Zа0lf'tJ`g/7l\"Oد\n`H҅#N\n`=6BF4Pik%#\nJ\rʆn\nm4+r>an=@UVp||	 	 (~J3I	\0)&*J+OJNi̋,Qo|nnjns_-PLipVQDe-ɼ\njr+,gzǚ>rR,M`Ȥlm\"0FްxPF\nolYE(:oi\0 	\0@Q^N\$>R7%1V\"%0DHlAhz8,CK*FTca0bty+DC\rCM/\\2Fp4)-;i.-\r.ҿ,e1j1¿/LU,Gڦ֨	0(0]3ns!xe0=0!-S-.\r2kRHKW+1xȱ38S #c,4:s	r@M 	V+=H(̘09[sX(S*61a8E̕EsH?/RH6lo!@F\n\$CUS>FrdLJ(D*TPfbbްFL_Dn}t]@1T\"{2޴Z\0=Fg-x_s d{ciPo]fTW/G8oALOWI/S42d\nH	&n2Pi6%scCPt.kTsD/^L2O3yQtBTN.SN%P9-}hpZ<.ԻAhL'nJ	F*M ૢ5\"/SSuZ?3i]/RCYTC72պ'0RTY]5a]iU]ю @\nP+c'A;%c1ەU5'Sbsbsb^Ot85R6\$PɥdEwOUJOOv7^?bs:3eTeΛq2:	c55UUP@W&ih!9[iiH%=SS4Pn#Ӎ\$+n y(^dGU|R2qdgt(5AR3>K_n/eoD~Ch!o#gmntBT{oF~ӗp6nևmWh{uhVFvkw7RTi'7+PWxLTI@1sC	m5ypqY->\rH(QW*.c- Q`LzqhnztirA5);Kq?qzb`s]twxK\rϱe3,F6 ȗ iiwW^x.\nsDѯx27P-\0001'X(Jwz-SsmDickwij3	l	)mNvqUطjXdJmk7zRIrMWCzkH\0<+}65ӏj\$%*Ikwx8	Y!9%TTgxӎH\$铇钕/w9YjZ_c7TAR?\0lTÐ+g,/JLD1wuD,IXVݎ9سj_v\$\rحvQUmqߝ3MvkM8H䎌\$Loĥ:3WB\0lwkןvI*/o;whVbɜ/ˤ_zT9}yzQ1h9y1}iwpWzR渙;yS`Ykk	ZYχQTeQǭrq9/uQyVu甹gDWXyE\r}XS#OC =Az9O6^\\8xWPm-8F 0Cðz`2*%\nUrEpi;}qsyŸb\r\${0Z_5	mYN^Uaa+0o%O77nzH:{Tl5M1⹿rӶH-yA8O4T͚8dwtrcyS{Û+:ݨM͉pkӕ{s_ct;@e\rV`&sQJyXr¼Ҽ.O\r&`\npN\$+	uGO痻r׻70ρr+2ѼH2/\nQ7{5L<SQ[UKRܪ\"PGXFaM6	 O<^},dEYzᡷ|ADD2a:9dr\0	ǒrسz:_yËjzZRһ,Q#щTJ:vYN}@\\([yi!:c۞S]t}%'+ɺqco9˭\\5\n><-\${CQ<qe\0U\"s鉊\\{V7d&\"NhĄdqVs:'I&?Zi]]oo\$?@J:e\rAn'f\nlġ~ @Se)C\0QYb7	hsHAKH{暔.^*/T@h@=G:5X(޶/`	\0@	t\n`";break;case"th":$f="\\! M@0tD\0 \nX:&\0*\n8\0	E30/\0ZB(^\0AK2\0&b8KGn	I?J\\)b.)\\S\"s\0CWJ_6\\+eV6rJé5k]8@%994fv2 #!j65:i\\(zʳyW ej\0MLrS{q\0ק|\\Iq	n[R|馛7;Z4	=j.Y7D	 7i6LS0x4\r/0Oڶp\0@-pBP,JQpXD1jCb2α;󤅗\$3\$\r6мJ+.6Q󄟨1`P#pάP.JV!\00@P7\ro7(9\r㒰\"@`9 >xp89i؃+¿)ä6MJԟ1lY\$O*U@,8nx\\5T(6/\n58BNH\\I1rlHÔY;r|ՌIM&3I h_QB1,nm1,;,dE;&id(UZb!NTE^m0AIKW\0EV#*\\`e94t!J]ÕP+\"xvV;GM ֈg%'幧eӃ,Ŋg(# *>>38Pc0c9ʣ8@0S;;C#4C(C@:tL;v9N#8^2}9P^188 7^0-ޟKt\nd\\x+Uf\rˇ[2͌7WL1NEԵn#VK WgXps`(!Oa4\08d\$!4K;eh#sSP4ʠ7-l9\"vZmI5Ѽ=BDh#!6'C`u9,TX\nr<'!b35pcSShBVH+|艎:L\n8kq\"zrZdl5rv,OOT[a%R6V^[[uN%4L\r\0n\rhEQ	YD2KrBʉ_h륅&70/<)戄<\r`מaiP7&Ra/d{\n	PAAsG5MbxQdWت#Ē82՛	)N	\"͉&Rm\rU_QGC(x@<E~ϡz I`*& zT=3h(*))(\0ѹ+4SP\r܎ŔM+M4RU'\$,ioR6¸?jJ;W%`&tGݛrI<\0T[re͹>]tӇXsuRWb>	!8yvϸ8\rnBNptYų\n{kXUWVpa:U`@dG8&~!\0[f6Εn;\r0g\0c4\nNc\r:UguW)tX/qK5^;R(A*\nL`OI;>rW\\GO>	OTX\n)ޟ3~r\n*㠉jCHgsC*xyR-# aL)h:NIL,z%0ӿqWrWUijEXǭIaSdDXWKav8F63v`<k~zW`\$Pz[i@;N1H9̜h m5zxCBk8:{[+p]2)T=): Z9~j\"f<3epXJ'ՊgpP}A*b̓,% w0p4	vԡ')V.#Xͩ='2T(@PO	*\0BE<\"Py)fX4#	:f-Ezxpqwsh9\"ƖXնl*iE g<}(j0ǎ3R,l2:>A,pfmA\"D؊|\"JAS}Pz̩)!JIƖgrԓf\"#\$'I2Phl0>fm[XXQƄDr?+YܢtbДHzp6dU	`\07g:\"dxyUu\n~(8>~{\\&	}|~G0LEzoد8-\n\"| 	&n2	Jao%8Gͤ;'C>?j\\DE:<(X`;Fbm:O|\n\$^(Ì/>EhWc-D :J{fnjB,i\0\0 	\0@d\r\$LVP`Af݃nc<OH6I[&'e\\EZتR;dhT.nD8돖\n1OE\"B&+\0K\n1JT(`DQ.H\$FVqff	q`@N\0cC+evC2Hb}ԋ\$`,ηtW#΢9e]΂\nDiL܇&xBJeB') [vb[vB?zP9h\"Z9~G1[CPafJ9E	rlVi몙/QǶ<w²;\n/\0IeS \r.HъYe\r'G)r&%&Ҿ*<2)+'Ag\"*QM\0IO<ޅk#PVl+N\0W~+2@B:F+gS\")1cE*43&^)VT0@\"{gCf+,/Ki<3c3hXfe0\"RDp	0K/-¶:I70.OhӞS.6Й~8K<Ƒ5	SĪjR{:j=:DL95\$%?&i9\\\n\rBRs\rkx7OS>Q@BI;!D0X\\8`}4W:-.q1yABPB#>t(t|jԄ{tW@Ic013fý7i8%fCN)<+6ss>ɎEzVډ1\rMmt503N\$E\"	j<3FI΀,P<Tc5IqJ	/,:5tK#Rd*eކVbgQJTn}cC= 	GrHWn;w?UJWKpP\rs?WqZ05ft@B!ZT{\\\\E5Ԍz\\'<Z]	Y\$[0V6{\\l5F\"l[<#`ƓϮVU\nGnRB<6AWHI5od>C'Չ]X;5eК)B\r<xW>ĚB\rs54Ag~RPhr\$#[)QhaO1}J@|=yduȪVfo3XʧllcoV^UfmXTAgT'=pXun3[\nm4uIrNjrwj6iA;uJ9B ivrtsC+vg}qt:=6f7ke^VwnLevmTTwU>/Z AwpzMP<x_5aUuq\r7`FYyg7W\rGr\\g0~L/\\N\n:xBzb[SEkDI/Ml,%ErDNr.6g)ƒeo\rl'86_GDnU2DUEqkc\nröW\rV``۳I4\n8C,%b,O욼\0\np@\rp1m+Z*v+P&l28\r ./8fVr9 	܄8,fL6{pEM&fCyCjw].x>\0@8wg2pY6u'!E2{h>\$%%e2-Q=@gRuVTԪ+87Q-;]/{+\\=ɀv\n0m<5V56\nL\"2Dߧ2蘀>}j)/sts:\n8!'<\nE7%34ڍɘ4#Q@o\nEH-E:[z:#\"zdH;*;2eꆱ2Fv+9䠩9/1\r3	r9\r*@nT%v+{ab{kʫ@	\0t	@\n`";break;case"tr":$f="E6M	i=BQp 9 3!i6`'y\\\nb,P!= 2̑Ho<NXbn)̅'b):GX@\nFC1l7ASv*|%4F`(a1\r	!^2Q|%O3vKsfSdkXjyat5XlF:ډix\\Fa63]7F	ӺAE= 4\\KK:L&QTk78KH0Ffe9<8SpNÙJ2\$(@:N\r\nl40@50J	/㢐SB:/Bl-P45\n6iA`ЍH `P2`H<4m @3N)#:6c:T*Qb\nPB^-\\/#BJĦ.832 #r<790Ɏh03=p4@ި\"*C X90z\r8a^\\0Ј<\$8^3\r+\\,x:\r.x!O9#́B8'b=##C\"\rlDάrx*-rϰdX\"-.7@:.c8&Pȅ:!.:-H7+t[r'▸48C^)e8#8#Z6Qz2 P#떠P4-HϥpFԹbpSp'X&BrN7 7NB{|f)<`^\\w M:|6;(k/ 9)JV]Lp#[鈉(}o_+3ͺiuo\" ܂\$ƵJ\rb<Cri>wEP%FhHO'_8@3#	redͣla.>bppNr:ɢ\$@3Xy]}hrf uUa@̇ADa<XCz ̬1bX@oAp 0!44ޏy3dV^UV]\n\$c	ێ89S	9Lkmn4a%7\$uw/th	d_-f'̲0N))%D/:\$BdSDSB!2npCr]eԉHT1\n (%C)80rLXzʚJ-5D;h𚐂X#<4|`2fdPYJvԛ'u=&P\0(aL)ie b0hiKCoؤa,\0a@L\0M\$(Ҩ#ɥKq=ц\"x΃]L U/T5|*T`,t`t#dycCgLNaHpM*LH,Uκڈ)QÒgAj2HT5חG}eT@SUXP^0O	*\0BE! +q12qoh)WJPnۻŦaRA8|2ަN\\o)ᤥ``qII]( Yp)'ښ*xvBGRyn&I{a_ӛ]o!9ues\\4ż|5\$Q>1My@S.f)N90VQG1R`U̹5ѣj'&3c	\nl!p\rG&^[Ax<U\r\$}43%:9'\$z8:͒vTm%~k\"jcӥ79fj*qrz	H&dQW[GN@AVK1ɌMbTKQd@}S k\0ϰmrlX0@f%ϳU-1aw3\0p7<\na;XDp48]RVX5\n]PgpN\reQC}wd\"G_7/(ƨfȨI&d`^Mؖdpi)gDk霈+gEG!;@ܫwIj:@S޺ /E饍yy|	=\$d^#)210X\r:\\9SAkŏ_buSs?\$LaLEX\"5Ҟ&TkT#:\"jARoRb||q* /̗/S\0'@/vozoŐ\0n姈r',ʹ(q6SK/l,FMArb\$P#7P`P0&&\\v.lu<-	֭oM\n?	PKBk,7S qIbo:xW%cca9N&òLP(c~`d\r)D0ܜ֋v[f\r`qR-~\r4Lҍ2s0-.й=m	e͢0P1bbPQO-ee\0e+jvGGnHo0t>S0Yp-y\$;*[\$\0#I\$Hmq\$:qhâ81T`Ŀ#H/E%q]Ѻ:J2:1f!eH ofE\r-y6jE3@\$Dfq\$}4m	!Iz-WVF;j,-O'abRa|y%|\\;d,1L\0@\\͐TeȨY)h\"+bD8Z\"kbDfYr,D g(c.C8 c`%\0I`i/)K\npoA1A.N@sRE·	+,SM,gVL%F9%1'PGĂ,(:qSz}1ԗ\nbe7fi'\0bB(&Ov/\r+Z91ʵɑ9j(Y\">E,|r=Ȇ13jw0+_>\$_<\$ dK!p-@rF%0;n\0\0@V\rȈg@	\$\"6OoE\rگD\nÈe	[&55'#@^\rG*7Htfvg3Bh>>FJdj w#;!FH0\"1¦`";break;case"uk":$f="I4ɠh-`&KBQp 9	rh--}[ZH`RdbrbhdZGH\rMs6@Se+ȃE6JTdJsh\$g\$Gfj>Cf4jSdRB\rhSE6\rVG!TIV{ZLʔi%QBvUXhZk7*M)4/55CBhഹ	  HT6\\htvclVYj׶ԮpNUf@;If\r:bibﾦj i%lh%.\n{;y\$CCI,#DĖ\r5X?jвH)Lxݦ(kfBK{))ƯFHm\\F \$jH!d*B郴՗.C\$.)D\nlb9kjķ\\̐ʾD\rZ\rqd隅1#D&?l&@1M1\\`hr@:,΢[\nC*(kYCO9	\"%iKQ%\nYD!5ҰM.ȣD'-(b5jClhGUN/Ҙ;s?Kp h7*.6e,4ky2^8(|!\090z\r8a^\\08^\rp^8#; ^,f]Ԝ%/|\$i\rIq-}\r\0ըҡpjIP݄Yikؽ\r6\n&4 F\$Q,!x@1H1\r2\"c&F%HKA1wW)7١qe\nj Tz_13hݰ>u4xZs|MH3774*B+;Z5~>®תjF^\"mH%/Ԑ-VJO(M%mdh\$Aoh*\$H<(1	U Ժ%CL}eF@\\9io\rYY[cB)8X@ʊ3hh\nhA_F11E\rG~/Q'ҜG9Dcaz50JĒ 4)Gy[r#X BDfD\r!0 S hYO*eYg:4CxnPE&DZr~G\\/[AV6IlhIɩTe(ᐴURdd9\nSqY\0@~L\"2<%`B+&)aL\\}97;4#4qlAYS}f*Sg2Iʩz,8ORJgIfjNIV\\Ժ*):BƎOBK=Dàej,\$Jv.hU}!nr*bLt©I*LX]`:u,Mzy1:)Җ!Dw2eT7S2`̙6g3`rh4-%iMP9cLB)Ί󜄶F^O J&٠JI 'I(T^˒k6´Iz-g\n9SU\ni˜rEB\n1`YPj:J>gdzrXEUc2Zѹi=4QѾ?\r;\0mkWPYMb+&W\nJB0ŗ+.%<D*Qw9\0\$'@+6#S4\r|>a|Z\nJ%[562JغwXҌUv98P%6fJ~\r=e.01n/>pY]*A]%qޑk4C,!st::QJG7ީZԀ1	X\$R^ֱ9GrŜ\rkdVxHqWnXA'fdm[}Q(,htkMH\nHN:{e-e9W( t)`Z4JPJtYn/RWHJv&)SA\r	y%6}J\\Pbh׹AA\"`#@y#\"	6>NLĭh{{nkMbwdH\nO`(4`\"}_|1	^cBB΂fR),H5zGݤ\\1\$a!=˪S6wrڅ~Xc̒w!Lf}bC'metRMX@oR,H0|dD~8UUd`9,[RTP?h#**⟼S\\ԅq\\4=<Dh']1FyppQЩҸTG100O9քfdpg\n7npS\0!b/LU':>#AL\0JCo!nT壪'JgVNYk3hsFRtY-\\؍刲\"΢%Bs&~zh̑e&\\\\5\$V`\n 	}MhcJ4,:ćHg'b7)twQbEwxI^-#&˸)ȍuj)n*Cmi˦}NQ8b?JDOf*qQTxYNg}G7cxSL3ex&61V[#'Dz[1[kIel'qlq1ѹ^>1.|h\n';񐪂\nAlX\rw pp,e4lvqB!#ؠżg	nT!bmB#ozqPB`\"!Cc.ċɃ0:(`%t{Q(GHQnbt@RRrCK!zB\$R|W*\$+qȒR¨;rxq̓-rQ4Erf2G6ڑ%L3q\"n+t|c&R nh#*QQAx),%)Ｌ\"#5C\$%3`S1a<r,S,֮g.bZ4dJ!hP S6ER'W/ZBƄ<'2|/<Ȱ1,<;ȳ<,qA-ʎƋ<R,65s>ƿ?̓@03٫]^QCO\nS\nhLd8m?-0<T@0JI\naDE\nESBE;dTB!EDl4),]?@0ZXC.^}@ʉJR԰N\\4BJmԳL#K@' ʸlXHr@*ކ5?dcXdJ@4Ҕ\nk5Nq3.児m o%\n~2p{RNS.<QMA2E32WҝP`5!b:\0sJIB\0Y(XSA1ZG\rNJ1T9K[P\".u+t[`Y.1UC[[[?&Cu\\{鞉%]ǆ1L\npOg¹\n\"6?ԓFL@/c!FԖoERTJY>A?&rp5-dbos%v({`h6SD9KnE`.,6ðzHVMdvc\n@1u'F.ҳe\nݕe/g6GV,7i`LotojU]2]t.yB[fg|R\0gQv=qvmEsntWH+ir4mg0PyN:d'v)\\S^hca>Sx)xS//8[;xwFu-aJ>Sp?bVjRV~'\"hEbkcB78b~gq~4zHHE`yU_QB7wDfC	M(yAYDS-8M^}I`~@ t7*LFn|MP`nAb-/#/pP`4倪\nq9T=X5u,xX`	xZr6ՌN9NYg&I,~rg=GAd_t%2BTA^ZN\nmT3_،Trus,!SPX\$2خbwt{碑P/y(1/RtX`tYZU)8N2%0d\"Y-c\$hyNc?o#\\QPo*aZf\0uf`i4VAb-Q	.S9X D)oZ4@ \rŝ0<6|x#8WlQXm)=))I1k~,Zk1ʚ%E|ږ~\\#=jwGpϧ5ϼbp;&TzX";break;case"vi":$f="Bp& *(J.0Q,Z)v@Tf\npjp*VC`]rY<#\$b\$L2@%9IΓ4˅d3\rFqt9N1QE3ڡhj[J;o\n(UbdaI¾RiD\0\0A)X8@q:g!C_#y̸6:ڋ.K;.}FͼS06\\vN5n5x!r7C	1#(͍&:;#\"\\!%:8!KH+ڜ0R7wC(\$F]]+0Ҏ9jjPeFdc@J*#ӊX\n\npEɚ44K\nd@3&!\03Z09ʤH(\";mh#\njh-aC3&IO>%*l΢jVJzT\"Pib2dC&! bk:V\0P(2\raYSiD_+3## \$\rACPP1p0j;(:\"9pX90z\r8a^\\0Vcx7]9xDkc36LP|+T2\$Uh ƀaHl\nxYee|ú@P0Cucx3zUߤpȼ#aL\0PNh&	\r]Iĩ+F`zd;#`2Y+!HJpTcv'uc[_KKeS<erEzP<:Бdmm(i\$:D@L@j,<ċ`:eLL\"wtIJb06700ۡ*b']e0b9Y8٨ }/<sT.c5\$^fJT%R6%15JYe\$܄@uх{(\"nb)\0;P׃rEǆPh{B\r3*JXh;\"j'syy\n,s4j\"⍨Zc3@hq\$W&wPxElJ!*Lv9\$\$[4.gSjL	4-^z/e`	,Ó	al*saBL\$dVyba}`4!tZ#z2.<K_Zsay@a1C+[!CŤf6A!&\rς\n#\"BEThwwo]t@P&\\.B&MH!tQ.Eu vg+x\\\">s,f0sB+dUCpp]	!F!;Ya|*ɵtAC}!H#F0'cW\$ #B:ŗ.%͗4G%	1 \nbMwc+E	vZB!-J?\n~d/5\nIpI\"A'@ϒamluj2\n鬙|HjaRjJ̒<Q	`/\n<)Hwޱ9A\"O,GX[i3#hQ));ƿ.ω(v^6wnv]qI*R(`J}zG8X<rU=Uv\$8TzgIlFb%ViNc\0A\"e͑rSD>d.Bb5cCuI&I 䃵ʄ|Zd8+p\$'\"[B{&@'Rc83*\0aI*D]\0rGhQJ@Qs7'\$:I\r8n)E]f{6D\"k|eړb(\r3KAfDp\$ҘeC;A;vlǤ\$='(䭾TH]k^Nrk|U]NoQL\nD5W8Z޼	|5-\$2(%N6J,pTjDjҩe0T!\$FHZH5JB6RM,]!@@'[.E;|w8[ɞT+\"	2'EdYxd)]7>zV^3 F,.iYh(r(z>ndIXHJm?j^Ӓk_zpG-QyG})8eا[I/^n9\"`cwߐ\n\$n2%	eMO!@m%f~.%l:2GX١G~K-AIۅ)9ʺ><&%C`t&\\vƂAb-\0\\lre\"D Tmzm).\$D>0lO7!0Fzt\r&C'ԥ\"HB,}p&f9	0S\nƓ\$\nIV|IΎ4?Y~H#B\\\"ȶ<PĮ#-荍NkS9_P0#,\n3ZX\"v':X֭BSrEM-nv1e&PI	C&JYbM}|&l,DgJcMQK10qg}\nz~-\nf[h?ǯ\nq7&.:qN7.8DL\"jNAv,O:&j]ȁbgI1~\$0Y:0ؕRǲ6X!N\$RLq~ׅnf/c5hn\n,	/v[|-RG%#!(&&)+\n8?Ҳď+BXU*Bu)_-+(./r,/C\$X5e\nJȅ1-RMDXl(I2.MMx)&,rfP55w4VXq푕,/W2jBdy%j)RsnkM'|\\	:bО,2sI(ä&nA)\$z\$]/P4S\nZ62n@#ndU,Gh\nR'4/tZ2;%3n3b6?K\$u?\\XfNej(8\ny̆e(CFa/3OfPF9\07B.,YE-FϪoL\"H7E2gQɧ)#CNE4dΠfPI<7`<hws	k&UM!?C4Fla#>\$OarrKPp'4	j\0KA^0\$dIIHV\"J܃CPZ4iUG\$7\"7\r>ƽ'L. 1BAm>3Xs˧\nnCF* ";break;case"zh":$f="A*s\\r|%:\$\nr.2r/dȻ[8 S8r!T\\sI4brЀJs!J:2rST⢔\nh5\rSR9Q*-Y(eȗB+΅FZI9PYj^FX9P2s&֒E~yc~#}Krsk|i-r̀)c(Cݦ#*J!AR\nkP/WtZU9WJQ3Wq*'Os%dbʯC9Mnr;NP)Z'1T*J;)nY59XS#%Ans%O-30*\\OĹlt0]6r^-8\0J|r\nÑ)VYm*QBr.IlY,T^C@<# 4(tdlR>\\.D/r/i&\r3:xY\rBPp9x79cv2:e1AANIP|GI\0DYS1,ZZL9H]6\$O]&J6\r&דzi,Xur=ZScx<c`8Cx9xCAHqifTZYCG)DG۴Mro%L^ܖ7{BZH9i)\$B(esrZG0%p*Frlt%at]E,HHdT@;T4pQV&a(vD^;\rS}^\$:4יrsyHrO1t{&ʲaxR%G8\\hNd[q,,aJK!%A-x\\JdA/ٍ䖠'9M.E]C&ZFEb3:bMT1\$`X^+pB}:HD5]7+ż35<@piB\n>RTʡU*\\V\rB%t:+CzYAfAp<[ G&,ĩ6AAa`. F	d6/((H< >gƊH9n{X̄\0;gtspBDbJ`ę\0P.0ƙ-ޙpRGU6H\nF\$\$A<T	6xOa)R\0%əA*xƐ\"4.	g^??.yhb\\xŢ\"LH\"֓E0ȸD\0FRK9J_Hj](te/9.&Ro h¸ZFnRfP<D6x1JLav#4P{,DM\"Y\"tQpTxtH)J<>@tLEQW:D+Wk.vK'9F`!S	\$903\$ƙO0hlR	c֦ZcP*Z_ E	BŪj-\"<A.K\$:DNb_őf20.QvEڢ)Jsϻ61⮷ⶩ9z-9t&eF@&,CiB^րN\nA<D:&as8KEz:pM̚smѦr(9z]^\nuiç\"%HQ6\0qstUSIvii0\$S!޸S`KHDM&/q:/cʹBP63\"ӈԞ T!\$ct\n>&X 4Ȳ[dFh+b<Kb9cuQDL3g'Kpq-ctNnmјOP) \$Z|E[OtƉJUmLXpo1P^c<\$-nY#Ql9D\r@]VֺW^g=G/q06켗HV?Laxfhn|?mŕ8;W!-չ0	]zoCvEρ pE\nH:#c(EZ.:-,}.pȼeTP%VbM)KO\"ÒpĞ5t\r6%oG.Ǩ/ܗU?A, ,^\0F,kWr].7IKÌr)[zÖ0F\$T!orHHt{)TPxBH1c29JLBJr煌hd] ϓX޷=-'vvv?/xɥ7/J>䤼rsxpQv_`WgQ 'Fs\\O&\n}[?_dh<j\0Ov0\nhf~3Ja<.bv&J,vk6P<zpF`P4/ܫwa0BPl\\Zbư|L9_0ippGO	DMP	\r\0cĕ˲2A>M4+mP6+o\\*-!\n}\\'JPޙ\rL\0(@g\rz\$ 4. G&4@@\np6,M®	8)NKh#a!(4!^ۣp;( Cn/|	^a^zCjzh4~>-1*fJJ!.AA\0.eڣ.z!\n,GXM0MQώFqX`@TeL\r6vLX\rN\\6(RDApDM:\\@ \rp\$2,]:G^BbMqä	b@)rrn#r}fL%(> G.r";break;case"zh-tw":$f="^%ӕ\\r|%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	%cJe R)ܫ{	Nd TP\\Õ8Cf4aS@/%NNd%гCɗBQ+B_MK,\$uowfT9WKʏW2mizX:P	*_/g*eSLKۈι^9H\r7Zz>0)ȿN\nr!U=R\n^JTO](I^ܫ]EJ4\$yhr2^?[eCr^[#k֑g1')T'9jB)#,%')n䪪hVd=Oa@IBOs¦KJ12A\$&8mQdlYr%\0JԀD&Hi/\rUw.x].2ft(t	KS?2]*X!rB]# 4(tek\0Tr{4Ǒ42zF@4C(C@:t㽔49Ox3(9JP|t)!B1/B|GI\\CD=z%yRQ s-~W?JQ]\$:A(\\{1(MZScx<c`8Cx9xC2R\$~GTgANQD=VEx^\rF֭WIq^zd1H\ni N(k]g1Gʇ9{q\$iCA\0Q7\n(:I*[e2] \\Bk&o\$Gb&	{'1Iɫk`ؖ)Q_kvEwG֯|J\\R/CIws-^wŮW0S0lJA-VR}\\5CDB6,r2tD`B)UP>b%H+G4B\n),a\$\nC)8')gee[a7RH**ci#1tT,\\z\nXdrZ+Mjwps]p5Ƃ\"Ux/'%QIgDzBZC]HG\"DD*߂\rDR!J*fXh@iHBl9:P:	XT9D251!^Q\n#1qL(%CBRbk%YRbLPo\"\"XQ\n(LBYx.s\nxa>^a0+u)lnrM23!6) CxkZZj5DĿQ,+G\"dM	C¸Zq\n,Ġ8l\na9`噲+\nz::9kKĚ\"G4TtDeO\naP+QH	plpXr8\"*5h*i!rϐPp#@N(	:`N\rP<T@bL(XrL#EMP\0U\n @x &[l*B@FrfK{H-w\$ӖkLiӞtN'dT]AwBdƭoMI w!|qWobo<BdJq @o@K\\i	b\0sR_H.	j|d?,e]a\\CMAV3Z`^).A\\\"{ZBv^T%hx.S iV4U0LË߽XsADSa9W+̳i0a!2؝1{R҅!ODȼj=H9HPBzF0|J@]ll^ArYP 09OP\n]EHOX>gUJx fմP],L@'o3H^''Hv)'԰ZD@لFG]N%H/R|(#	\$\$'ql\$t\"rIZ!|sOEc{E@ lxYvbɭwc^Z%!˾%˝/ϱ24QhG73@earpf6+~瀗\"JiKsj#E7hwŽfŇȮi.l5ĸ,!Uk\"P~w[0!O<%v2\\ZyS`o+er:h2ٝsܬ%݊/L|ĺ:/]{΋ݽkLξO؟6H6B?#572bq}nQݶl_g_V`Xr#EAB#E*KŹr(Ul#K 5̸z#(\0*66ͯ/bcH4Da/0f%lDΰ\\NMϰa0pmuGOp0DAP^,F\nw:!Ɠb'^7bN&f&*a!M%&l&@'\rm\"a\r	%T#qGFzd#\rl	As/\rB0ǱЀG\$bq7ezOqLqxboQOqI⤚IұlGbqI	\r\0fo,\$4gNx0\rƐP@RDJ4H_AF0bۤ0#k.5\\F8iN h\r â9@'\\k2PDL*=\np8'-jLB:e\$|!ꫡZ8Ͳ.lTQ~(j)v:2u.~/p(,A%ޭ̏`_Rd/BV&Nf,gm[@@WEz\rfzhz%̼/o \"0rg+2a2n&.Ap)*K \r\$.\0 %.amJv\\.S+g+¼Rlǽ8-&vQ.HO%®BĜaL";break;}$zi=array();foreach(explode("\n",lzw_decompress($f))as$X)$zi[]=(strpos($X,"\t")?explode("\t",$X):$X);return$zi;}if(!$zi){$zi=get_translations($ca);$_SESSION["translations"]=$zi;}if(extension_loaded('pdo')){class
Min_PDO{var$_result,$server_info,$affected_rows,$errno,$error,$pdo;function
__construct(){global$b;$kg=array_search("SQL",$b->operators);if($kg!==false)unset($b->operators[$kg]);}function
dsn($rc,$V,$F,$Cf=array()){$Cf[PDO::ATTR_ERRMODE]=PDO::ERRMODE_SILENT;$Cf[PDO::ATTR_STATEMENT_CLASS]=array('Min_PDOStatement');try{$this->pdo=new
PDO($rc,$V,$F,$Cf);}catch(Exception$Jc){auth_error(h($Jc->getMessage()));}$this->server_info=@$this->pdo->getAttribute(PDO::ATTR_SERVER_VERSION);}function
quote($P){return$this->pdo->quote($P);}function
query($G,$Hi=false){$H=$this->pdo->query($G);$this->error="";if(!$H){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($H);return$H;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result($H=null){if(!$H){$H=$this->_result;if(!$H)return
false;}if($H->columnCount()){$H->num_rows=$H->rowCount();return$H;}$this->affected_rows=$H->rowCount();return
true;}function
next_result(){if(!$this->_result)return
false;$this->_result->_offset=0;return@$this->_result->nextRowset();}function
result($G,$n=0){$H=$this->query($G);if(!$H)return
false;$J=$H->fetch();return$J[$n];}}class
Min_PDOStatement
extends
PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch(PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch(PDO::FETCH_NUM);}function
fetch_field(){$J=(object)$this->getColumnMeta($this->_offset++);$J->orgtable=$J->table;$J->orgname=$J->name;$J->charsetnr=(in_array("blob",(array)$J->flags)?63:0);return$J;}}}$mc=array();function
add_driver($t,$D){global$mc;$mc[$t]=$D;}function
get_driver($t){global$mc;return$mc[$t];}class
Min_SQL{var$_conn;function
__construct($g){$this->_conn=$g;}function
select($Q,$L,$Z,$ud,$Ef=array(),$z=1,$E=0,$sg=false){global$b,$x;$ee=(count($ud)<count($L));$G=$b->selectQueryBuild($L,$Z,$ud,$Ef,$z,$E);if(!$G)$G="SELECT".limit(($_GET["page"]!="last"&&$z!=""&&$ud&&$ee&&$x=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$L)."\nFROM ".table($Q),($Z?"\nWHERE ".implode(" AND ",$Z):"").($ud&&$ee?"\nGROUP BY ".implode(", ",$ud):"").($Ef?"\nORDER BY ".implode(", ",$Ef):""),($z!=""?+$z:null),($E?$z*$E:0),"\n");$Ih=microtime(true);$I=$this->_conn->query($G);if($sg)echo$b->selectQuery($G,$Ih,!$I);return$I;}function
delete($Q,$Bg,$z=0){$G="FROM ".table($Q);return
queries("DELETE".($z?limit1($Q,$G,$Bg):" $G$Bg"));}function
update($Q,$N,$Bg,$z=0,$nh="\n"){$Zi=array();foreach($N
as$y=>$X)$Zi[]="$y = $X";$G=table($Q)." SET$nh".implode(",$nh",$Zi);return
queries("UPDATE".($z?limit1($Q,$G,$Bg,$nh):" $G$Bg"));}function
insert($Q,$N){return
queries("INSERT INTO ".table($Q).($N?" (".implode(", ",array_keys($N)).")\nVALUES (".implode(", ",$N).")":" DEFAULT VALUES"));}function
insertUpdate($Q,$K,$qg){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($G,$ki){}function
convertSearch($u,$X,$n){return$u;}function
value($X,$n){return(method_exists($this->_conn,'value')?$this->_conn->value($X,$n):(is_resource($X)?stream_get_contents($X):$X));}function
quoteBinary($dh){return
q($dh);}function
warnings(){return'';}function
tableHelp($D){}}$mc["sqlite"]="SQLite 3";$mc["sqlite2"]="SQLite 2";if(isset($_GET["sqlite"])||isset($_GET["sqlite2"])){define("DRIVER",(isset($_GET["sqlite"])?"sqlite":"sqlite2"));if(class_exists(isset($_GET["sqlite"])?"SQLite3":"SQLiteDatabase")){if(isset($_GET["sqlite"])){class
Min_SQLite{var$extension="SQLite3",$server_info,$affected_rows,$errno,$error,$_link;function
__construct($p){$this->_link=new
SQLite3($p);$cj=$this->_link->version();$this->server_info=$cj["versionString"];}function
query($G){$H=@$this->_link->query($G);$this->error="";if(!$H){$this->errno=$this->_link->lastErrorCode();$this->error=$this->_link->lastErrorMsg();return
false;}elseif($H->numColumns())return
new
Min_Result($H);$this->affected_rows=$this->_link->changes();return
true;}function
quote($P){return(is_utf8($P)?"'".$this->_link->escapeString($P)."'":"x'".reset(unpack('H*',$P))."'");}function
store_result(){return$this->_result;}function
result($G,$n=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->_result->fetchArray();return$J[$n];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;}function
fetch_assoc(){return$this->_result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->_result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$d=$this->_offset++;$T=$this->_result->columnType($d);return(object)array("name"=>$this->_result->columnName($d),"type"=>$T,"charsetnr"=>($T==SQLITE3_BLOB?63:0),);}function
__desctruct(){return$this->_result->finalize();}}}else{class
Min_SQLite{var$extension="SQLite",$server_info,$affected_rows,$error,$_link;function
__construct($p){$this->server_info=sqlite_libversion();$this->_link=new
SQLiteDatabase($p);}function
query($G,$Hi=false){$Ue=($Hi?"unbufferedQuery":"query");$H=@$this->_link->$Ue($G,SQLITE_BOTH,$m);$this->error="";if(!$H){$this->error=$m;return
false;}elseif($H===true){$this->affected_rows=$this->changes();return
true;}return
new
Min_Result($H);}function
quote($P){return"'".sqlite_escape_string($P)."'";}function
store_result(){return$this->_result;}function
result($G,$n=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->_result->fetch();return$J[$n];}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;if(method_exists($H,'numRows'))$this->num_rows=$H->numRows();}function
fetch_assoc(){$J=$this->_result->fetch(SQLITE_ASSOC);if(!$J)return
false;$I=array();foreach($J
as$y=>$X)$I[idf_unescape($y)]=$X;return$I;}function
fetch_row(){return$this->_result->fetch(SQLITE_NUM);}function
fetch_field(){$D=$this->_result->fieldName($this->_offset++);$fg='(\[.*]|"(?:[^"]|"")*"|(.+))';if(preg_match("~^($fg\\.)?$fg\$~",$D,$C)){$Q=($C[3]!=""?$C[3]:idf_unescape($C[2]));$D=($C[5]!=""?$C[5]:idf_unescape($C[4]));}return(object)array("name"=>$D,"orgname"=>$D,"orgtable"=>$Q,);}}}}elseif(extension_loaded("pdo_sqlite")){class
Min_SQLite
extends
Min_PDO{var$extension="PDO_SQLite";function
__construct($p){$this->dsn(DRIVER.":$p","","");}}}if(class_exists("Min_SQLite")){class
Min_DB
extends
Min_SQLite{function
__construct(){parent::__construct(":memory:");$this->query("PRAGMA foreign_keys = 1");}function
select_db($p){if(is_readable($p)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$p)?$p:dirname($_SERVER["SCRIPT_FILENAME"])."/$p")." AS a")){parent::__construct($p);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return
true;}return
false;}function
multi_query($G){return$this->_result=$this->query($G);}function
next_result(){return
false;}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$K,$qg){$Zi=array();foreach($K
as$N)$Zi[]="(".implode(", ",$N).")";return
queries("REPLACE INTO ".table($Q)." (".implode(", ",array_keys(reset($K))).") VALUES\n".implode(",\n",$Zi));}function
tableHelp($D){if($D=="sqlite_sequence")return"fileformat2.html#seqtab";if($D=="sqlite_master")return"fileformat2.html#$D";}}function
idf_escape($u){return'"'.str_replace('"','""',$u).'"';}function
table($u){return
idf_escape($u);}function
connect(){global$b;list(,,$F)=$b->credentials();if($F!="")return
lang(22);return
new
Min_DB;}function
get_databases(){return
array();}function
limit($G,$Z,$z,$mf=0,$nh=" "){return" $G$Z".($z!==null?$nh."LIMIT $z".($mf?" OFFSET $mf":""):"");}function
limit1($Q,$G,$Z,$nh="\n"){global$g;return(preg_match('~^INTO~',$G)||$g->result("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($G,$Z,1,0,$nh):" $G WHERE rowid = (SELECT rowid FROM ".table($Q).$Z.$nh."LIMIT 1)");}function
db_collation($k,$ob){global$g;return$g->result("PRAGMA encoding");}function
engines(){return
array();}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($j){return
array();}function
table_status($D=""){global$g;$I=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($D!=""?"AND name = ".q($D):"ORDER BY name"))as$J){$J["Rows"]=$g->result("SELECT COUNT(*) FROM ".idf_escape($J["Name"]));$I[$J["Name"]]=$J;}foreach(get_rows("SELECT * FROM sqlite_sequence",null,"")as$J)$I[$J["name"]]["Auto_increment"]=$J["seq"];return($D!=""?$I[$D]:$I);}function
is_view($R){return$R["Engine"]=="view";}function
fk_support($R){global$g;return!$g->result("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($Q){global$g;$I=array();$qg="";foreach(get_rows("PRAGMA table_info(".table($Q).")")as$J){$D=$J["name"];$T=strtolower($J["type"]);$ac=$J["dflt_value"];$I[$D]=array("field"=>$D,"type"=>(preg_match('~int~i',$T)?"integer":(preg_match('~char|clob|text~i',$T)?"text":(preg_match('~blob~i',$T)?"blob":(preg_match('~real|floa|doub~i',$T)?"real":"numeric")))),"full_type"=>$T,"default"=>(preg_match("~'(.*)'~",$ac,$C)?str_replace("''","'",$C[1]):($ac=="NULL"?null:$ac)),"null"=>!$J["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1),"primary"=>$J["pk"],);if($J["pk"]){if($qg!="")$I[$qg]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$T))$I[$D]["auto_increment"]=true;$qg=$D;}}$Dh=$g->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($Q));preg_match_all('~(("[^"]*+")+|[a-z0-9_]+)\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$Dh,$He,PREG_SET_ORDER);foreach($He
as$C){$D=str_replace('""','"',preg_replace('~^"|"$~','',$C[1]));if($I[$D])$I[$D]["collation"]=trim($C[3],"'");}return$I;}function
indexes($Q,$h=null){global$g;if(!is_object($h))$h=$g;$I=array();$Dh=$h->result("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($Q));if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$Dh,$C)){$I[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$C[1],$He,PREG_SET_ORDER);foreach($He
as$C){$I[""]["columns"][]=idf_unescape($C[2]).$C[4];$I[""]["descs"][]=(preg_match('~DESC~i',$C[5])?'1':null);}}if(!$I){foreach(fields($Q)as$D=>$n){if($n["primary"])$I[""]=array("type"=>"PRIMARY","columns"=>array($D),"lengths"=>array(),"descs"=>array(null));}}$Gh=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($Q),$h);foreach(get_rows("PRAGMA index_list(".table($Q).")",$h)as$J){$D=$J["name"];$v=array("type"=>($J["unique"]?"UNIQUE":"INDEX"));$v["lengths"]=array();$v["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($D).")",$h)as$ch){$v["columns"][]=$ch["name"];$v["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($D).' ON '.idf_escape($Q),'~').' \((.*)\)$~i',$Gh[$D],$Mg)){preg_match_all('/("[^"]*+")+( DESC)?/',$Mg[2],$He);foreach($He[2]as$y=>$X){if($X)$v["descs"][$y]='1';}}if(!$I[""]||$v["type"]!="UNIQUE"||$v["columns"]!=$I[""]["columns"]||$v["descs"]!=$I[""]["descs"]||!preg_match("~^sqlite_~",$D))$I[$D]=$v;}return$I;}function
foreign_keys($Q){$I=array();foreach(get_rows("PRAGMA foreign_key_list(".table($Q).")")as$J){$q=&$I[$J["id"]];if(!$q)$q=$J;$q["source"][]=$J["from"];$q["target"][]=$J["to"];}return$I;}function
view($D){global$g;return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',$g->result("SELECT sql FROM sqlite_master WHERE name = ".q($D))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($k){return
false;}function
adminer_error(){global$g;return
h($g->error);}function
check_sqlite_name($D){global$g;$Sc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Sc)\$~",$D)){$g->error=lang(23,str_replace("|",", ",$Sc));return
false;}return
true;}function
create_database($k,$nb){global$g;if(file_exists($k)){$g->error=lang(24);return
false;}if(!check_sqlite_name($k))return
false;try{$_=new
Min_SQLite($k);}catch(Exception$Jc){$g->error=$Jc->getMessage();return
false;}$_->query('PRAGMA encoding = "UTF-8"');$_->query('CREATE TABLE adminer (i)');$_->query('DROP TABLE adminer');return
true;}function
drop_databases($j){global$g;$g->__construct(":memory:");foreach($j
as$k){if(!@unlink($k)){$g->error=lang(24);return
false;}}return
true;}function
rename_database($D,$nb){global$g;if(!check_sqlite_name($D))return
false;$g->__construct(":memory:");$g->error=lang(24);return@rename(DB,$D);}function
auto_increment(){return" PRIMARY KEY".(DRIVER=="sqlite"?" AUTOINCREMENT":"");}function
alter_table($Q,$D,$o,$jd,$ub,$Bc,$nb,$Ma,$Zf){global$g;$Si=($Q==""||$jd);foreach($o
as$n){if($n[0]!=""||!$n[1]||$n[2]){$Si=true;break;}}$c=array();$Nf=array();foreach($o
as$n){if($n[1]){$c[]=($Si?$n[1]:"ADD ".implode($n[1]));if($n[0]!="")$Nf[$n[0]]=$n[1][0];}}if(!$Si){foreach($c
as$X){if(!queries("ALTER TABLE ".table($Q)." $X"))return
false;}if($Q!=$D&&!queries("ALTER TABLE ".table($Q)." RENAME TO ".table($D)))return
false;}elseif(!recreate_table($Q,$D,$c,$Nf,$jd,$Ma))return
false;if($Ma){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Ma WHERE name = ".q($D));if(!$g->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($D).", $Ma)");queries("COMMIT");}return
true;}function
recreate_table($Q,$D,$o,$Nf,$jd,$Ma,$w=array()){global$g;if($Q!=""){if(!$o){foreach(fields($Q)as$y=>$n){if($w)$n["auto_increment"]=0;$o[]=process_field($n,$n);$Nf[$y]=idf_escape($y);}}$rg=false;foreach($o
as$n){if($n[6])$rg=true;}$pc=array();foreach($w
as$y=>$X){if($X[2]=="DROP"){$pc[$X[1]]=true;unset($w[$y]);}}foreach(indexes($Q)as$ke=>$v){$e=array();foreach($v["columns"]as$y=>$d){if(!$Nf[$d])continue
2;$e[]=$Nf[$d].($v["descs"][$y]?" DESC":"");}if(!$pc[$ke]){if($v["type"]!="PRIMARY"||!$rg)$w[]=array($v["type"],$ke,$e);}}foreach($w
as$y=>$X){if($X[0]=="PRIMARY"){unset($w[$y]);$jd[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($Q)as$ke=>$q){foreach($q["source"]as$y=>$d){if(!$Nf[$d])continue
2;$q["source"][$y]=idf_unescape($Nf[$d]);}if(!isset($jd[" $ke"]))$jd[]=" ".format_foreign_key($q);}queries("BEGIN");}foreach($o
as$y=>$n)$o[$y]="  ".implode($n);$o=array_merge($o,array_filter($jd));$ei=($Q==$D?"adminer_$D":$D);if(!queries("CREATE TABLE ".table($ei)." (\n".implode(",\n",$o)."\n)"))return
false;if($Q!=""){if($Nf&&!queries("INSERT INTO ".table($ei)." (".implode(", ",$Nf).") SELECT ".implode(", ",array_map('idf_escape',array_keys($Nf)))." FROM ".table($Q)))return
false;$Ei=array();foreach(triggers($Q)as$Ci=>$li){$Bi=trigger($Ci);$Ei[]="CREATE TRIGGER ".idf_escape($Ci)." ".implode(" ",$li)." ON ".table($D)."\n$Bi[Statement]";}$Ma=$Ma?0:$g->result("SELECT seq FROM sqlite_sequence WHERE name = ".q($Q));if(!queries("DROP TABLE ".table($Q))||($Q==$D&&!queries("ALTER TABLE ".table($ei)." RENAME TO ".table($D)))||!alter_indexes($D,$w))return
false;if($Ma)queries("UPDATE sqlite_sequence SET seq = $Ma WHERE name = ".q($D));foreach($Ei
as$Bi){if(!queries($Bi))return
false;}queries("COMMIT");}return
true;}function
index_sql($Q,$T,$D,$e){return"CREATE $T ".($T!="INDEX"?"INDEX ":"").idf_escape($D!=""?$D:uniqid($Q."_"))." ON ".table($Q)." $e";}function
alter_indexes($Q,$c){foreach($c
as$qg){if($qg[0]=="PRIMARY")return
recreate_table($Q,$Q,array(),array(),array(),0,$c);}foreach(array_reverse($c)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($Q,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($S){return
apply_queries("DELETE FROM",$S);}function
drop_views($ej){return
apply_queries("DROP VIEW",$ej);}function
drop_tables($S){return
apply_queries("DROP TABLE",$S);}function
move_tables($S,$ej,$ci){return
false;}function
trigger($D){global$g;if($D=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$u='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$Di=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$u\\s*(".implode("|",$Di["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($u))?\\s+ON\\s*$u\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",$g->result("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($D)),$C);$lf=$C[3];return
array("Timing"=>strtoupper($C[1]),"Event"=>strtoupper($C[2]).($lf?" OF":""),"Of"=>idf_unescape($lf),"Trigger"=>$D,"Statement"=>$C[4],);}function
triggers($Q){$I=array();$Di=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($Q))as$J){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$Di["Timing"]).')\s*(.*?)\s+ON\b~i',$J["sql"],$C);$I[$J["name"]]=array($C[1],$C[2]);}return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id(){global$g;return$g->result("SELECT LAST_INSERT_ROWID()");}function
explain($g,$G){return$g->query("EXPLAIN QUERY PLAN $G");}function
found_rows($R,$Z){}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($gh){return
true;}function
create_sql($Q,$Ma,$Nh){global$g;$I=$g->result("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($Q));foreach(indexes($Q)as$D=>$v){if($D=='')continue;$I.=";\n\n".index_sql($Q,$v['type'],$D,"(".implode(", ",array_map('idf_escape',$v['columns'])).")");}return$I;}function
truncate_sql($Q){return"DELETE FROM ".table($Q);}function
use_sql($Ub){}function
trigger_sql($Q){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($Q)));}function
show_variables(){global$g;$I=array();foreach(array("auto_vacuum","cache_size","count_changes","default_cache_size","empty_result_callbacks","encoding","foreign_keys","full_column_names","fullfsync","journal_mode","journal_size_limit","legacy_file_format","locking_mode","page_size","max_page_count","read_uncommitted","recursive_triggers","reverse_unordered_selects","secure_delete","short_column_names","synchronous","temp_store","temp_store_directory","schema_version","integrity_check","quick_check")as$y)$I[$y]=$g->result("PRAGMA $y");return$I;}function
show_status(){$I=array();foreach(get_vals("PRAGMA compile_options")as$Bf){list($y,$X)=explode("=",$Bf,2);$I[$y]=$X;}return$I;}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
support($Xc){return
preg_match('~^(columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Xc);}function
driver_config(){$U=array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0);return
array('possible_drivers'=>array((isset($_GET["sqlite"])?"SQLite3":"SQLite"),"PDO_SQLite"),'jush'=>"sqlite",'types'=>$U,'structured_types'=>array_keys($U),'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL"),'functions'=>array("distinct","hex","length","lower","round","unixepoch","upper"),'grouping'=>array("avg","count","count distinct","group_concat","max","min","sum"),'edit_functions'=>array(array(),array("integer|real|numeric"=>"+/-","text"=>"||",)),);}}$mc["pgsql"]="PostgreSQL";if(isset($_GET["pgsql"])){define("DRIVER","pgsql");if(extension_loaded("pgsql")){class
Min_DB{var$extension="PgSQL",$_link,$_result,$_string,$_database=true,$server_info,$affected_rows,$error,$timeout;function
_error($Ec,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
connect($M,$V,$F){global$b;$k=$b->database();set_error_handler(array($this,'_error'));$this->_string="host='".str_replace(":","' port='",addcslashes($M,"'\\"))."' user='".addcslashes($V,"'\\")."' password='".addcslashes($F,"'\\")."'";$this->_link=@pg_connect("$this->_string dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->_link&&$k!=""){$this->_database=false;$this->_link=@pg_connect("$this->_string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->_link){$cj=pg_version($this->_link);$this->server_info=$cj["server"];pg_set_client_encoding($this->_link,"UTF8");}return(bool)$this->_link;}function
quote($P){return"'".pg_escape_string($this->_link,$P)."'";}function
value($X,$n){return($n["type"]=="bytea"&&$X!==null?pg_unescape_bytea($X):$X);}function
quoteBinary($P){return"'".pg_escape_bytea($this->_link,$P)."'";}function
select_db($Ub){global$b;if($Ub==$b->database())return$this->_database;$I=@pg_connect("$this->_string dbname='".addcslashes($Ub,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($I)$this->_link=$I;return$I;}function
close(){$this->_link=@pg_connect("$this->_string dbname='postgres'");}function
query($G,$Hi=false){$H=@pg_query($this->_link,$G);$this->error="";if(!$H){$this->error=pg_last_error($this->_link);$I=false;}elseif(!pg_num_fields($H)){$this->affected_rows=pg_affected_rows($H);$I=true;}else$I=new
Min_Result($H);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$I;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$n=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;return
pg_fetch_result($H->_result,0,$n);}function
warnings(){return
h(pg_last_notice($this->_link));}}class
Min_Result{var$_result,$_offset=0,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=pg_num_rows($H);}function
fetch_assoc(){return
pg_fetch_assoc($this->_result);}function
fetch_row(){return
pg_fetch_row($this->_result);}function
fetch_field(){$d=$this->_offset++;$I=new
stdClass;if(function_exists('pg_field_table'))$I->orgtable=pg_field_table($this->_result,$d);$I->name=pg_field_name($this->_result,$d);$I->orgname=$I->name;$I->type=pg_field_type($this->_result,$d);$I->charsetnr=($I->type=="bytea"?63:0);return$I;}function
__destruct(){pg_free_result($this->_result);}}}elseif(extension_loaded("pdo_pgsql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_PgSQL",$timeout;function
connect($M,$V,$F){global$b;$k=$b->database();$this->dsn("pgsql:host='".str_replace(":","' port='",addcslashes($M,"'\\"))."' client_encoding=utf8 dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'",$V,$F);return
true;}function
select_db($Ub){global$b;return($b->database()==$Ub);}function
quoteBinary($dh){return
q($dh);}function
query($G,$Hi=false){$I=parent::query($G,$Hi);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$I;}function
warnings(){return'';}function
close(){}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$K,$qg){global$g;foreach($K
as$N){$Oi=array();$Z=array();foreach($N
as$y=>$X){$Oi[]="$y = $X";if(isset($qg[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($Q)." SET ".implode(", ",$Oi)." WHERE ".implode(" AND ",$Z))&&$g->affected_rows)||queries("INSERT INTO ".table($Q)." (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).")")))return
false;}return
true;}function
slowQuery($G,$ki){$this->_conn->query("SET statement_timeout = ".(1000*$ki));$this->_conn->timeout=1000*$ki;return$G;}function
convertSearch($u,$X,$n){return(preg_match('~char|text'.(!preg_match('~LIKE~',$X["op"])?'|date|time(stamp)?|boolean|uuid|'.number_type():'').'~',$n["type"])?$u:"CAST($u AS text)");}function
quoteBinary($dh){return$this->_conn->quoteBinary($dh);}function
warnings(){return$this->_conn->warnings();}function
tableHelp($D){$A=array("information_schema"=>"infoschema","pg_catalog"=>"catalog",);$_=$A[$_GET["ns"]];if($_)return"$_-".str_replace("_","-",$D).".html";}}function
idf_escape($u){return'"'.str_replace('"','""',$u).'"';}function
table($u){return
idf_escape($u);}function
connect(){global$b,$U,$Mh;$g=new
Min_DB;$Nb=$b->credentials();if($g->connect($Nb[0],$Nb[1],$Nb[2])){if(min_version(9,0,$g)){$g->query("SET application_name = 'Adminer'");if(min_version(9.2,0,$g)){$Mh[lang(25)][]="json";$U["json"]=4294967295;if(min_version(9.4,0,$g)){$Mh[lang(25)][]="jsonb";$U["jsonb"]=4294967295;}}}return$g;}return$g->error;}function
get_databases(){return
get_vals("SELECT datname FROM pg_database WHERE has_database_privilege(datname, 'CONNECT') ORDER BY datname");}function
limit($G,$Z,$z,$mf=0,$nh=" "){return" $G$Z".($z!==null?$nh."LIMIT $z".($mf?" OFFSET $mf":""):"");}function
limit1($Q,$G,$Z,$nh="\n"){return(preg_match('~^INTO~',$G)?limit($G,$Z,1,0,$nh):" $G".(is_view(table_status1($Q))?$Z:$nh."WHERE ctid = (SELECT ctid FROM ".table($Q).$Z.$nh."LIMIT 1)"));}function
db_collation($k,$ob){global$g;return$g->result("SELECT datcollate FROM pg_database WHERE datname = ".q($k));}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT user");}function
tables_list(){$G="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support('materializedview'))$G.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$G.="
ORDER BY 1";return
get_key_vals($G);}function
count_tables($j){return
array();}function
table_status($D=""){$I=array();foreach(get_rows("SELECT c.relname AS \"Name\", CASE c.relkind WHEN 'r' THEN 'table' WHEN 'm' THEN 'materialized view' ELSE 'view' END AS \"Engine\", pg_relation_size(c.oid) AS \"Data_length\", pg_total_relation_size(c.oid) - pg_relation_size(c.oid) AS \"Index_length\", obj_description(c.oid, 'pg_class') AS \"Comment\", ".(min_version(12)?"''":"CASE WHEN c.relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\", c.reltuples as \"Rows\", n.nspname
FROM pg_class c
JOIN pg_namespace n ON(n.nspname = current_schema() AND n.oid = c.relnamespace)
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
".($D!=""?"AND relname = ".q($D):"ORDER BY relname"))as$J)$I[$J["Name"]]=$J;return($D!=""?$I[$D]:$I);}function
is_view($R){return
in_array($R["Engine"],array("view","materialized view"));}function
fk_support($R){return
true;}function
fields($Q){$I=array();$Da=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT a.attname AS field, format_type(a.atttypid, a.atttypmod) AS full_type, pg_get_expr(d.adbin, d.adrelid) AS default, a.attnotnull::int, col_description(c.oid, a.attnum) AS comment".(min_version(10)?", a.attidentity":"")."
FROM pg_class c
JOIN pg_namespace n ON c.relnamespace = n.oid
JOIN pg_attribute a ON c.oid = a.attrelid
LEFT JOIN pg_attrdef d ON c.oid = d.adrelid AND a.attnum = d.adnum
WHERE c.relname = ".q($Q)."
AND n.nspname = current_schema()
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$J){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$J["full_type"],$C);list(,$T,$ye,$J["length"],$ya,$Ga)=$C;$J["length"].=$Ga;$db=$T.$ya;if(isset($Da[$db])){$J["type"]=$Da[$db];$J["full_type"]=$J["type"].$ye.$Ga;}else{$J["type"]=$T;$J["full_type"]=$J["type"].$ye.$ya.$Ga;}if(in_array($J['attidentity'],array('a','d')))$J['default']='GENERATED '.($J['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$J["null"]=!$J["attnotnull"];$J["auto_increment"]=$J['attidentity']||preg_match('~^nextval\(~i',$J["default"]);$J["privileges"]=array("insert"=>1,"select"=>1,"update"=>1);if(preg_match('~(.+)::[^,)]+(.*)~',$J["default"],$C))$J["default"]=($C[1]=="NULL"?null:idf_unescape($C[1]).$C[2]);$I[$J["field"]]=$J;}return$I;}function
indexes($Q,$h=null){global$g;if(!is_object($h))$h=$g;$I=array();$Vh=$h->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($Q));$e=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $Vh AND attnum > 0",$h);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, (indpred IS NOT NULL)::int as indispartial FROM pg_index i, pg_class ci WHERE i.indrelid = $Vh AND ci.oid = i.indexrelid",$h)as$J){$Ng=$J["relname"];$I[$Ng]["type"]=($J["indispartial"]?"INDEX":($J["indisprimary"]?"PRIMARY":($J["indisunique"]?"UNIQUE":"INDEX")));$I[$Ng]["columns"]=array();foreach(explode(" ",$J["indkey"])as$Td)$I[$Ng]["columns"][]=$e[$Td];$I[$Ng]["descs"]=array();foreach(explode(" ",$J["indoption"])as$Ud)$I[$Ng]["descs"][]=($Ud&1?'1':null);$I[$Ng]["lengths"]=array();}return$I;}function
foreign_keys($Q){global$uf;$I=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = (SELECT pc.oid FROM pg_class AS pc INNER JOIN pg_namespace AS pn ON (pn.oid = pc.relnamespace) WHERE pc.relname = ".q($Q)." AND pn.nspname = current_schema())
AND contype = 'f'::char
ORDER BY conkey, conname")as$J){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$J['definition'],$C)){$J['source']=array_map('idf_unescape',array_map('trim',explode(',',$C[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$C[2],$Ge)){$J['ns']=idf_unescape($Ge[2]);$J['table']=idf_unescape($Ge[4]);}$J['target']=array_map('idf_unescape',array_map('trim',explode(',',$C[3])));$J['on_delete']=(preg_match("~ON DELETE ($uf)~",$C[4],$Ge)?$Ge[1]:'NO ACTION');$J['on_update']=(preg_match("~ON UPDATE ($uf)~",$C[4],$Ge)?$Ge[1]:'NO ACTION');$I[$J['conname']]=$J;}}return$I;}function
constraints($Q){global$uf;$I=array();foreach(get_rows("SELECT conname, consrc
FROM pg_catalog.pg_constraint
INNER JOIN pg_catalog.pg_namespace ON pg_constraint.connamespace = pg_namespace.oid
INNER JOIN pg_catalog.pg_class ON pg_constraint.conrelid = pg_class.oid AND pg_constraint.connamespace = pg_class.relnamespace
WHERE pg_constraint.contype = 'c'
AND conrelid != 0 -- handle only CONSTRAINTs here, not TYPES
AND nspname = current_schema()
AND relname = ".q($Q)."
ORDER BY connamespace, conname")as$J)$I[$J['conname']]=$J['consrc'];return$I;}function
view($D){global$g;return
array("select"=>trim($g->result("SELECT pg_get_viewdef(".$g->result("SELECT oid FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema()) AND relname = ".q($D)).")")));}function
collations(){return
array();}function
information_schema($k){return($k=="information_schema");}function
adminer_error(){global$g;$I=h($g->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$I,$C))$I=$C[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($C[3]).'})(.*)~','\1<b>\2</b>',$C[2]).$C[4];return
nl_br($I);}function
create_database($k,$nb){return
queries("CREATE DATABASE ".idf_escape($k).($nb?" ENCODING ".idf_escape($nb):""));}function
drop_databases($j){global$g;$g->close();return
apply_queries("DROP DATABASE",$j,'idf_escape');}function
rename_database($D,$nb){return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($D));}function
auto_increment(){return"";}function
alter_table($Q,$D,$o,$jd,$ub,$Bc,$nb,$Ma,$Zf){$c=array();$Ag=array();if($Q!=""&&$Q!=$D)$Ag[]="ALTER TABLE ".table($Q)." RENAME TO ".table($D);foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$c[]="DROP $d";else{$Yi=$X[5];unset($X[5]);if($n[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$c[]=($Q!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$c[]=($Q!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($d!=$X[0])$Ag[]="ALTER TABLE ".table($D)." RENAME $d TO $X[0]";$c[]="ALTER $d TYPE$X[1]";if(!$X[6]){$c[]="ALTER $d ".($X[3]?"SET$X[3]":"DROP DEFAULT");$c[]="ALTER $d ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}}if($n[0]!=""||$Yi!="")$Ag[]="COMMENT ON COLUMN ".table($D).".$X[0] IS ".($Yi!=""?substr($Yi,9):"''");}}$c=array_merge($c,$jd);if($Q=="")array_unshift($Ag,"CREATE TABLE ".table($D)." (\n".implode(",\n",$c)."\n)");elseif($c)array_unshift($Ag,"ALTER TABLE ".table($Q)."\n".implode(",\n",$c));if($ub!==null)$Ag[]="COMMENT ON TABLE ".table($D)." IS ".q($ub);if($Ma!=""){}foreach($Ag
as$G){if(!queries($G))return
false;}return
true;}function
alter_indexes($Q,$c){$i=array();$nc=array();$Ag=array();foreach($c
as$X){if($X[0]!="INDEX")$i[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$nc[]=idf_escape($X[1]);else$Ag[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q)." (".implode(", ",$X[2]).")";}if($i)array_unshift($Ag,"ALTER TABLE ".table($Q).implode(",",$i));if($nc)array_unshift($Ag,"DROP INDEX ".implode(", ",$nc));foreach($Ag
as$G){if(!queries($G))return
false;}return
true;}function
truncate_tables($S){return
queries("TRUNCATE ".implode(", ",array_map('table',$S)));return
true;}function
drop_views($ej){return
drop_tables($ej);}function
drop_tables($S){foreach($S
as$Q){$O=table_status($Q);if(!queries("DROP ".strtoupper($O["Engine"])." ".table($Q)))return
false;}return
true;}function
move_tables($S,$ej,$ci){foreach(array_merge($S,$ej)as$Q){$O=table_status($Q);if(!queries("ALTER ".strtoupper($O["Engine"])." ".table($Q)." SET SCHEMA ".idf_escape($ci)))return
false;}return
true;}function
trigger($D,$Q){if($D=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");$e=array();$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($Q)." AND trigger_name = ".q($D);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$J)$e[]=$J["event_object_column"];$I=array();foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement" FROM information_schema.triggers '."$Z ORDER BY event_manipulation DESC")as$J){if($e&&$J["Event"]=="UPDATE")$J["Event"].=" OF";$J["Of"]=implode(", ",$e);if($I)$J["Event"].=" OR $I[Event]";$I=$J;}return$I;}function
triggers($Q){$I=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($Q))as$J){$Bi=trigger($J["trigger_name"],$Q);$I[$Bi["Trigger"]]=array($Bi["Timing"],$Bi["Event"]);}return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($D,$T){$K=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($D));$I=$K[0];$I["returns"]=array("type"=>$I["type_udt_name"]);$I["fields"]=get_rows('SELECT parameter_name AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($D).'
ORDER BY ordinal_position');return$I;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($D,$J){$I=array();foreach($J["fields"]as$n)$I[]=$n["type"];return
idf_escape($D)."(".implode(", ",$I).")";}function
last_id(){return
0;}function
explain($g,$G){return$g->query("EXPLAIN $G");}function
found_rows($R,$Z){global$g;if(preg_match("~ rows=([0-9]+)~",$g->result("EXPLAIN SELECT * FROM ".idf_escape($R["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$Mg))return$Mg[1];return
false;}function
types(){return
get_vals("SELECT typname
FROM pg_type
WHERE typnamespace = (SELECT oid FROM pg_namespace WHERE nspname = current_schema())
AND typtype IN ('b','d','e')
AND typelem = 0");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){global$g;return$g->result("SELECT current_schema()");}function
set_schema($fh,$h=null){global$g,$U,$Mh;if(!$h)$h=$g;$I=$h->query("SET search_path TO ".idf_escape($fh));foreach(types()as$T){if(!isset($U[$T])){$U[$T]=0;$Mh[lang(26)][]=$T;}}return$I;}function
foreign_keys_sql($Q){$I="";$O=table_status($Q);$gd=foreign_keys($Q);ksort($gd);foreach($gd
as$fd=>$ed)$I.="ALTER TABLE ONLY ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." ADD CONSTRAINT ".idf_escape($fd)." $ed[definition] ".($ed['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($I?"$I\n":$I);}function
create_sql($Q,$Ma,$Nh){global$g;$I='';$Vg=array();$ph=array();$O=table_status($Q);if(is_view($O)){$dj=view($Q);return
rtrim("CREATE VIEW ".idf_escape($Q)." AS $dj[select]",";");}$o=fields($Q);$w=indexes($Q);ksort($w);$Db=constraints($Q);if(!$O||empty($o))return
false;$I="CREATE TABLE ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." (\n    ";foreach($o
as$Zc=>$n){$Wf=idf_escape($n['field']).' '.$n['full_type'].default_value($n).($n['attnotnull']?" NOT NULL":"");$Vg[]=$Wf;if(preg_match('~nextval\(\'([^\']+)\'\)~',$n['default'],$He)){$oh=$He[1];$Ch=reset(get_rows(min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q($oh):"SELECT * FROM $oh"));$ph[]=($Nh=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $oh;\n":"")."CREATE SEQUENCE $oh INCREMENT $Ch[increment_by] MINVALUE $Ch[min_value] MAXVALUE $Ch[max_value]".($Ma&&$Ch['last_value']?" START $Ch[last_value]":"")." CACHE $Ch[cache_value];";}}if(!empty($ph))$I=implode("\n\n",$ph)."\n\n$I";foreach($w
as$Od=>$v){switch($v['type']){case'UNIQUE':$Vg[]="CONSTRAINT ".idf_escape($Od)." UNIQUE (".implode(', ',array_map('idf_escape',$v['columns'])).")";break;case'PRIMARY':$Vg[]="CONSTRAINT ".idf_escape($Od)." PRIMARY KEY (".implode(', ',array_map('idf_escape',$v['columns'])).")";break;}}foreach($Db
as$_b=>$Bb)$Vg[]="CONSTRAINT ".idf_escape($_b)." CHECK $Bb";$I.=implode(",\n    ",$Vg)."\n) WITH (oids = ".($O['Oid']?'true':'false').");";foreach($w
as$Od=>$v){if($v['type']=='INDEX'){$e=array();foreach($v['columns']as$y=>$X)$e[]=idf_escape($X).($v['descs'][$y]?" DESC":"");$I.="\n\nCREATE INDEX ".idf_escape($Od)." ON ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." USING btree (".implode(', ',$e).");";}}if($O['Comment'])$I.="\n\nCOMMENT ON TABLE ".idf_escape($O['nspname']).".".idf_escape($O['Name'])." IS ".q($O['Comment']).";";foreach($o
as$Zc=>$n){if($n['comment'])$I.="\n\nCOMMENT ON COLUMN ".idf_escape($O['nspname']).".".idf_escape($O['Name']).".".idf_escape($Zc)." IS ".q($n['comment']).";";}return
rtrim($I,';');}function
truncate_sql($Q){return"TRUNCATE ".table($Q);}function
trigger_sql($Q){$O=table_status($Q);$I="";foreach(triggers($Q)as$Ai=>$_i){$Bi=trigger($Ai,$O['Name']);$I.="\nCREATE TRIGGER ".idf_escape($Bi['Trigger'])." $Bi[Timing] $Bi[Event] ON ".idf_escape($O["nspname"]).".".idf_escape($O['Name'])." $Bi[Type] $Bi[Statement];;\n";}return$I;}function
use_sql($Ub){return"\connect ".idf_escape($Ub);}function
show_variables(){return
get_key_vals("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
show_status(){}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
support($Xc){return
preg_match('~^(database|table|columns|sql|indexes|descidx|comment|view|'.(min_version(9.3)?'materializedview|':'').'scheme|routine|processlist|sequence|trigger|type|variables|drop_col|kill|dump)$~',$Xc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){global$g;return$g->result("SHOW max_connections");}function
driver_config(){$U=array();$Mh=array();foreach(array(lang(27)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(28)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(25)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(29)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(30)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"txid_snapshot"=>0),lang(31)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),)as$y=>$X){$U+=$X;$Mh[$y]=array_keys($X);}return
array('possible_drivers'=>array("PgSQL","PDO_PgSQL"),'jush'=>"pgsql",'types'=>$U,'structured_types'=>$Mh,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","~","~*","!~","!~*","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL"),'operator_regexp'=>'~*','functions'=>array("char_length","distinct","lower","round","to_hex","to_timestamp","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("char"=>"md5","date|time"=>"now",),array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",)),);}}$mc["oracle"]="Oracle (beta)";if(isset($_GET["oracle"])){define("DRIVER","oracle");if(extension_loaded("oci8")){class
Min_DB{var$extension="oci8",$_link,$_result,$server_info,$affected_rows,$errno,$error;var$_current_db;function
_error($Ec,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
connect($M,$V,$F){$this->_link=@oci_new_connect($V,$F,$M,"AL32UTF8");if($this->_link){$this->server_info=oci_server_version($this->_link);return
true;}$m=oci_error();$this->error=$m["message"];return
false;}function
quote($P){return"'".str_replace("'","''",$P)."'";}function
select_db($Ub){$this->_current_db=$Ub;return
true;}function
query($G,$Hi=false){$H=oci_parse($this->_link,$G);$this->error="";if(!$H){$m=oci_error($this->_link);$this->errno=$m["code"];$this->error=$m["message"];return
false;}set_error_handler(array($this,'_error'));$I=@oci_execute($H);restore_error_handler();if($I){if(oci_num_fields($H))return
new
Min_Result($H);$this->affected_rows=oci_num_rows($H);oci_free_statement($H);}return$I;}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$n=1){$H=$this->query($G);if(!is_object($H)||!oci_fetch($H->_result))return
false;return
oci_result($H->_result,$n);}}class
Min_Result{var$_result,$_offset=1,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$y=>$X){if(is_a($X,'OCI-Lob'))$J[$y]=$X->load();}return$J;}function
fetch_assoc(){return$this->_convert(oci_fetch_assoc($this->_result));}function
fetch_row(){return$this->_convert(oci_fetch_row($this->_result));}function
fetch_field(){$d=$this->_offset++;$I=new
stdClass;$I->name=oci_field_name($this->_result,$d);$I->orgname=$I->name;$I->type=oci_field_type($this->_result,$d);$I->charsetnr=(preg_match("~raw|blob|bfile~",$I->type)?63:0);return$I;}function
__destruct(){oci_free_statement($this->_result);}}}elseif(extension_loaded("pdo_oci")){class
Min_DB
extends
Min_PDO{var$extension="PDO_OCI";var$_current_db;function
connect($M,$V,$F){$this->dsn("oci:dbname=//$M;charset=AL32UTF8",$V,$F);return
true;}function
select_db($Ub){$this->_current_db=$Ub;return
true;}}}class
Min_Driver
extends
Min_SQL{function
begin(){return
true;}function
insertUpdate($Q,$K,$qg){global$g;foreach($K
as$N){$Oi=array();$Z=array();foreach($N
as$y=>$X){$Oi[]="$y = $X";if(isset($qg[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($Q)." SET ".implode(", ",$Oi)." WHERE ".implode(" AND ",$Z))&&$g->affected_rows)||queries("INSERT INTO ".table($Q)." (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).")")))return
false;}return
true;}}function
idf_escape($u){return'"'.str_replace('"','""',$u).'"';}function
table($u){return
idf_escape($u);}function
connect(){global$b;$g=new
Min_DB;$Nb=$b->credentials();if($g->connect($Nb[0],$Nb[1],$Nb[2]))return$g;return$g->error;}function
get_databases(){return
get_vals("SELECT tablespace_name FROM user_tablespaces ORDER BY 1");}function
limit($G,$Z,$z,$mf=0,$nh=" "){return($mf?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $G$Z) t WHERE rownum <= ".($z+$mf).") WHERE rnum > $mf":($z!==null?" * FROM (SELECT $G$Z) WHERE rownum <= ".($z+$mf):" $G$Z"));}function
limit1($Q,$G,$Z,$nh="\n"){return" $G$Z";}function
db_collation($k,$ob){global$g;return$g->result("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT USER FROM DUAL");}function
get_current_db(){global$g;$k=$g->_current_db?$g->_current_db:DB;unset($g->_current_db);return$k;}function
where_owner($og,$Qf="owner"){if(!$_GET["ns"])return'';return"$og$Qf = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($e){$Qf=where_owner('');return"(SELECT $e FROM all_views WHERE ".($Qf?$Qf:"rownum < 0").")";}function
tables_list(){$dj=views_table("view_name");$Qf=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$Qf
UNION SELECT view_name, 'view' FROM $dj
ORDER BY 1");}function
count_tables($j){global$g;$I=array();foreach($j
as$k)$I[$k]=$g->result("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($k));return$I;}function
table_status($D=""){$I=array();$hh=q($D);$k=get_current_db();$dj=views_table("view_name");$Qf=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($k).$Qf.($D!=""?" AND table_name = $hh":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $dj".($D!=""?" WHERE view_name = $hh":"")."
ORDER BY 1")as$J){if($D!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($R){return$R["Engine"]=="view";}function
fk_support($R){return
true;}function
fields($Q){$I=array();$Qf=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($Q)."$Qf ORDER BY column_id")as$J){$T=$J["DATA_TYPE"];$ye="$J[DATA_PRECISION],$J[DATA_SCALE]";if($ye==",")$ye=$J["CHAR_COL_DECL_LENGTH"];$I[$J["COLUMN_NAME"]]=array("field"=>$J["COLUMN_NAME"],"full_type"=>$T.($ye?"($ye)":""),"type"=>strtolower($T),"length"=>$ye,"default"=>$J["DATA_DEFAULT"],"null"=>($J["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);}return$I;}function
indexes($Q,$h=null){$I=array();$Qf=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($Q)."$Qf
ORDER BY ac.constraint_type, aic.column_position",$h)as$J){$Od=$J["INDEX_NAME"];$rb=$J["DATA_DEFAULT"];$rb=($rb?trim($rb,'"'):$J["COLUMN_NAME"]);$I[$Od]["type"]=($J["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($J["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$I[$Od]["columns"][]=$rb;$I[$Od]["lengths"][]=($J["CHAR_LENGTH"]&&$J["CHAR_LENGTH"]!=$J["COLUMN_LENGTH"]?$J["CHAR_LENGTH"]:null);$I[$Od]["descs"][]=($J["DESCEND"]&&$J["DESCEND"]=="DESC"?'1':null);}return$I;}function
view($D){$dj=views_table("view_name, text");$K=get_rows('SELECT text "select" FROM '.$dj.' WHERE view_name = '.q($D));return
reset($K);}function
collations(){return
array();}function
information_schema($k){return
false;}function
adminer_error(){global$g;return
h($g->error);}function
explain($g,$G){$g->query("EXPLAIN PLAN FOR $G");return$g->query("SELECT * FROM plan_table");}function
found_rows($R,$Z){}function
auto_increment(){return"";}function
alter_table($Q,$D,$o,$jd,$ub,$Bc,$nb,$Ma,$Zf){$c=$nc=array();$Kf=($Q?fields($Q):array());foreach($o
as$n){$X=$n[1];if($X&&$n[0]!=""&&idf_escape($n[0])!=$X[0])queries("ALTER TABLE ".table($Q)." RENAME COLUMN ".idf_escape($n[0])." TO $X[0]");$Jf=$Kf[$n[0]];if($X&&$Jf){$of=process_field($Jf,$Jf);if($X[2]==$of[2])$X[2]="";}if($X)$c[]=($Q!=""?($n[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($Q!=""?")":"");else$nc[]=idf_escape($n[0]);}if($Q=="")return
queries("CREATE TABLE ".table($D)." (\n".implode(",\n",$c)."\n)");return(!$c||queries("ALTER TABLE ".table($Q)."\n".implode("\n",$c)))&&(!$nc||queries("ALTER TABLE ".table($Q)." DROP (".implode(", ",$nc).")"))&&($Q==$D||queries("ALTER TABLE ".table($Q)." RENAME TO ".table($D)));}function
alter_indexes($Q,$c){$nc=array();$Ag=array();foreach($c
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$i=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($Ag,"ALTER TABLE ".table($Q).$i);}elseif($X[2]=="DROP")$nc[]=idf_escape($X[1]);else$Ag[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q)." (".implode(", ",$X[2]).")";}if($nc)array_unshift($Ag,"DROP INDEX ".implode(", ",$nc));foreach($Ag
as$G){if(!queries($G))return
false;}return
true;}function
foreign_keys($Q){$I=array();$G="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($Q);foreach(get_rows($G)as$J)$I[$J['NAME']]=array("db"=>$J['DEST_DB'],"table"=>$J['DEST_TABLE'],"source"=>array($J['SRC_COLUMN']),"target"=>array($J['DEST_COLUMN']),"on_delete"=>$J['ON_DELETE'],"on_update"=>null,);return$I;}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($ej){return
apply_queries("DROP VIEW",$ej);}function
drop_tables($S){return
apply_queries("DROP TABLE",$S);}function
last_id(){return
0;}function
schemas(){$I=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return($I?$I:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1"));}function
get_schema(){global$g;return$g->result("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($gh,$h=null){global$g;if(!$h)$h=$g;return$h->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($gh));}function
show_variables(){return
get_key_vals('SELECT name, display_value FROM v$parameter');}function
process_list(){return
get_rows('SELECT sess.process AS "process", sess.username AS "user", sess.schemaname AS "schema", sess.status AS "status", sess.wait_class AS "wait_class", sess.seconds_in_wait AS "seconds_in_wait", sql.sql_text AS "sql_text", sess.machine AS "machine", sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
show_status(){$K=get_rows('SELECT * FROM v$instance');return
reset($K);}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
support($Xc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$Xc);}function
driver_config(){$U=array();$Mh=array();foreach(array(lang(27)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(28)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(25)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(29)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),)as$y=>$X){$U+=$X;$Mh[$y]=array_keys($X);}return
array('possible_drivers'=>array("OCI8","PDO_OCI"),'jush'=>"oracle",'types'=>$U,'structured_types'=>$Mh,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL"),'functions'=>array("distinct","length","lower","round","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("date"=>"current_date","timestamp"=>"current_timestamp",),array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",)),);}}$mc["mssql"]="MS SQL (beta)";if(isset($_GET["mssql"])){define("DRIVER","mssql");if(extension_loaded("sqlsrv")){class
Min_DB{var$extension="sqlsrv",$_link,$_result,$server_info,$affected_rows,$errno,$error;function
_get_error(){$this->error="";foreach(sqlsrv_errors()as$m){$this->errno=$m["code"];$this->error.="$m[message]\n";}$this->error=rtrim($this->error);}function
connect($M,$V,$F){global$b;$k=$b->database();$Ab=array("UID"=>$V,"PWD"=>$F,"CharacterSet"=>"UTF-8");if($k!="")$Ab["Database"]=$k;$this->_link=@sqlsrv_connect(preg_replace('~:~',',',$M),$Ab);if($this->_link){$Vd=sqlsrv_server_info($this->_link);$this->server_info=$Vd['SQLServerVersion'];}else$this->_get_error();return(bool)$this->_link;}function
quote($P){return"'".str_replace("'","''",$P)."'";}function
select_db($Ub){return$this->query("USE ".idf_escape($Ub));}function
query($G,$Hi=false){$H=sqlsrv_query($this->_link,$G);$this->error="";if(!$H){$this->_get_error();return
false;}return$this->store_result($H);}function
multi_query($G){$this->_result=sqlsrv_query($this->_link,$G);$this->error="";if(!$this->_result){$this->_get_error();return
false;}return
true;}function
store_result($H=null){if(!$H)$H=$this->_result;if(!$H)return
false;if(sqlsrv_field_metadata($H))return
new
Min_Result($H);$this->affected_rows=sqlsrv_rows_affected($H);return
true;}function
next_result(){return$this->_result?sqlsrv_next_result($this->_result):null;}function
result($G,$n=0){$H=$this->query($G);if(!is_object($H))return
false;$J=$H->fetch_row();return$J[$n];}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;}function
_convert($J){foreach((array)$J
as$y=>$X){if(is_a($X,'DateTime'))$J[$y]=$X->format("Y-m-d H:i:s");}return$J;}function
fetch_assoc(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->_convert(sqlsrv_fetch_array($this->_result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->_fields)$this->_fields=sqlsrv_field_metadata($this->_result);$n=$this->_fields[$this->_offset++];$I=new
stdClass;$I->name=$n["Name"];$I->orgname=$n["Name"];$I->type=($n["Type"]==1?254:0);return$I;}function
seek($mf){for($s=0;$s<$mf;$s++)sqlsrv_fetch($this->_result);}function
__destruct(){sqlsrv_free_stmt($this->_result);}}}elseif(extension_loaded("mssql")){class
Min_DB{var$extension="MSSQL",$_link,$_result,$server_info,$affected_rows,$error;function
connect($M,$V,$F){$this->_link=@mssql_connect($M,$V,$F);if($this->_link){$H=$this->query("SELECT SERVERPROPERTY('ProductLevel'), SERVERPROPERTY('Edition')");if($H){$J=$H->fetch_row();$this->server_info=$this->result("sp_server_info 2",2)." [$J[0]] $J[1]";}}else$this->error=mssql_get_last_message();return(bool)$this->_link;}function
quote($P){return"'".str_replace("'","''",$P)."'";}function
select_db($Ub){return
mssql_select_db($Ub);}function
query($G,$Hi=false){$H=@mssql_query($G,$this->_link);$this->error="";if(!$H){$this->error=mssql_get_last_message();return
false;}if($H===true){$this->affected_rows=mssql_rows_affected($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
mssql_next_result($this->_result->_result);}function
result($G,$n=0){$H=$this->query($G);if(!is_object($H))return
false;return
mssql_result($H->_result,0,$n);}}class
Min_Result{var$_result,$_offset=0,$_fields,$num_rows;function
__construct($H){$this->_result=$H;$this->num_rows=mssql_num_rows($H);}function
fetch_assoc(){return
mssql_fetch_assoc($this->_result);}function
fetch_row(){return
mssql_fetch_row($this->_result);}function
num_rows(){return
mssql_num_rows($this->_result);}function
fetch_field(){$I=mssql_fetch_field($this->_result);$I->orgtable=$I->table;$I->orgname=$I->name;return$I;}function
seek($mf){mssql_data_seek($this->_result,$mf);}function
__destruct(){mssql_free_result($this->_result);}}}elseif(extension_loaded("pdo_dblib")){class
Min_DB
extends
Min_PDO{var$extension="PDO_DBLIB";function
connect($M,$V,$F){$this->dsn("dblib:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$M)),$V,$F);return
true;}function
select_db($Ub){return$this->query("USE ".idf_escape($Ub));}}}class
Min_Driver
extends
Min_SQL{function
insertUpdate($Q,$K,$qg){foreach($K
as$N){$Oi=array();$Z=array();foreach($N
as$y=>$X){$Oi[]="$y = $X";if(isset($qg[idf_unescape($y)]))$Z[]="$y = $X";}if(!queries("MERGE ".table($Q)." USING (VALUES(".implode(", ",$N).")) AS source (c".implode(", c",range(1,count($N))).") ON ".implode(" AND ",$Z)." WHEN MATCHED THEN UPDATE SET ".implode(", ",$Oi)." WHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($N)).") VALUES (".implode(", ",$N).");"))return
false;}return
true;}function
begin(){return
queries("BEGIN TRANSACTION");}}function
idf_escape($u){return"[".str_replace("]","]]",$u)."]";}function
table($u){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($u);}function
connect(){global$b;$g=new
Min_DB;$Nb=$b->credentials();if($g->connect($Nb[0],$Nb[1],$Nb[2]))return$g;return$g->error;}function
get_databases(){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($G,$Z,$z,$mf=0,$nh=" "){return($z!==null?" TOP (".($z+$mf).")":"")." $G$Z";}function
limit1($Q,$G,$Z,$nh="\n"){return
limit($G,$Z,1,0,$nh);}function
db_collation($k,$ob){global$g;return$g->result("SELECT collation_name FROM sys.databases WHERE name = ".q($k));}function
engines(){return
array();}function
logged_user(){global$g;return$g->result("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($j){global$g;$I=array();foreach($j
as$k){$g->select_db($k);$I[$k]=$g->result("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$I;}function
table_status($D=""){$I=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment FROM sys.all_objects AS ao WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($D!=""?"AND name = ".q($D):"ORDER BY name"))as$J){if($D!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($R){return$R["Engine"]=="VIEW";}function
fk_support($R){return
true;}function
fields($Q){$wb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($Q).", 'column', NULL)");$I=array();foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, CAST(d.definition as text) [default]
FROM sys.all_columns c
JOIN sys.all_objects o ON c.object_id = o.object_id
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.parent_column_id
WHERE o.schema_id = SCHEMA_ID(".q(get_schema()).") AND o.type IN ('S', 'U', 'V') AND o.name = ".q($Q))as$J){$T=$J["type"];$ye=(preg_match("~char|binary~",$T)?$J["max_length"]:($T=="decimal"?"$J[precision],$J[scale]":""));$I[$J["name"]]=array("field"=>$J["name"],"full_type"=>$T.($ye?"($ye)":""),"type"=>$T,"length"=>$ye,"default"=>$J["default"],"null"=>$J["is_nullable"],"auto_increment"=>$J["is_identity"],"collation"=>$J["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),"primary"=>$J["is_identity"],"comment"=>$wb[$J["name"]],);}return$I;}function
indexes($Q,$h=null){$I=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($Q),$h)as$J){$D=$J["name"];$I[$D]["type"]=($J["is_primary_key"]?"PRIMARY":($J["is_unique"]?"UNIQUE":"INDEX"));$I[$D]["lengths"]=array();$I[$D]["columns"][$J["key_ordinal"]]=$J["column_name"];$I[$D]["descs"][$J["key_ordinal"]]=($J["is_descending_key"]?'1':null);}return$I;}function
view($D){global$g;return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',$g->result("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($D))));}function
collations(){$I=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$nb)$I[preg_replace('~_.*~','',$nb)][]=$nb;return$I;}function
information_schema($k){return
false;}function
adminer_error(){global$g;return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',$g->error)));}function
create_database($k,$nb){return
queries("CREATE DATABASE ".idf_escape($k).(preg_match('~^[a-z0-9_]+$~i',$nb)?" COLLATE $nb":""));}function
drop_databases($j){return
queries("DROP DATABASE ".implode(", ",array_map('idf_escape',$j)));}function
rename_database($D,$nb){if(preg_match('~^[a-z0-9_]+$~i',$nb))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $nb");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($D));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($Q,$D,$o,$jd,$ub,$Bc,$nb,$Ma,$Zf){$c=array();$wb=array();foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$c["DROP"][]=" COLUMN $d";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$wb[$n[0]]=$X[5];unset($X[5]);if($n[0]=="")$c["ADD"][]="\n  ".implode("",$X).($Q==""?substr($jd[$X[0]],16+strlen($X[0])):"");else{unset($X[6]);if($d!=$X[0])queries("EXEC sp_rename ".q(table($Q).".$d").", ".q(idf_unescape($X[0])).", 'COLUMN'");$c["ALTER COLUMN ".implode("",$X)][]="";}}}if($Q=="")return
queries("CREATE TABLE ".table($D)." (".implode(",",(array)$c["ADD"])."\n)");if($Q!=$D)queries("EXEC sp_rename ".q(table($Q)).", ".q($D));if($jd)$c[""]=$jd;foreach($c
as$y=>$X){if(!queries("ALTER TABLE ".idf_escape($D)." $y".implode(",",$X)))return
false;}foreach($wb
as$y=>$X){$ub=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($D).", @level2type = N'Column', @level2name = ".q($y));queries("EXEC sp_addextendedproperty @name = N'MS_Description', @value = ".$ub.", @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($D).", @level2type = N'Column', @level2name = ".q($y));}return
true;}function
alter_indexes($Q,$c){$v=array();$nc=array();foreach($c
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$nc[]=idf_escape($X[1]);else$v[]=idf_escape($X[1])." ON ".table($Q);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($Q."_"))." ON ".table($Q):"ALTER TABLE ".table($Q)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$v||queries("DROP INDEX ".implode(", ",$v)))&&(!$nc||queries("ALTER TABLE ".table($Q)." DROP ".implode(", ",$nc)));}function
last_id(){global$g;return$g->result("SELECT SCOPE_IDENTITY()");}function
explain($g,$G){$g->query("SET SHOWPLAN_ALL ON");$I=$g->query($G);$g->query("SET SHOWPLAN_ALL OFF");return$I;}function
found_rows($R,$Z){}function
foreign_keys($Q){$I=array();foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($Q))as$J){$q=&$I[$J["FK_NAME"]];$q["db"]=$J["PKTABLE_QUALIFIER"];$q["table"]=$J["PKTABLE_NAME"];$q["source"][]=$J["FKCOLUMN_NAME"];$q["target"][]=$J["PKCOLUMN_NAME"];}return$I;}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($ej){return
queries("DROP VIEW ".implode(", ",array_map('table',$ej)));}function
drop_tables($S){return
queries("DROP TABLE ".implode(", ",array_map('table',$S)));}function
move_tables($S,$ej,$ci){return
apply_queries("ALTER SCHEMA ".idf_escape($ci)." TRANSFER",array_merge($S,$ej));}function
trigger($D){if($D=="")return
array();$K=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($D));$I=reset($K);if($I)$I["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$I["text"]);return$I;}function
triggers($Q){$I=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($Q))as$J)$I[$J["name"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){global$g;if($_GET["ns"]!="")return$_GET["ns"];return$g->result("SELECT SCHEMA_NAME()");}function
set_schema($fh){return
true;}function
use_sql($Ub){return"USE ".idf_escape($Ub);}function
show_variables(){return
array();}function
show_status(){return
array();}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
support($Xc){return
preg_match('~^(comment|columns|database|drop_col|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Xc);}function
driver_config(){$U=array();$Mh=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(28)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(25)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(29)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),)as$y=>$X){$U+=$X;$Mh[$y]=array_keys($X);}return
array('possible_drivers'=>array("SQLSRV","MSSQL","PDO_DBLIB"),'jush'=>"mssql",'types'=>$U,'structured_types'=>$Mh,'unsigned'=>array(),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL"),'functions'=>array("distinct","len","lower","round","upper"),'grouping'=>array("avg","count","count distinct","max","min","sum"),'edit_functions'=>array(array("date|time"=>"getdate",),array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",)),);}}$mc["mongo"]="MongoDB (alpha)";if(isset($_GET["mongo"])){define("DRIVER","mongo");if(class_exists('MongoDB')){class
Min_DB{var$extension="Mongo",$server_info=MongoClient::VERSION,$error,$last_id,$_link,$_db;function
connect($Pi,$Cf){try{$this->_link=new
MongoClient($Pi,$Cf);if($Cf["password"]!=""){$Cf["password"]="";try{new
MongoClient($Pi,$Cf);$this->error=lang(22);}catch(Exception$tc){}}}catch(Exception$tc){$this->error=$tc->getMessage();}}function
query($G){return
false;}function
select_db($Ub){try{$this->_db=$this->_link->selectDB($Ub);return
true;}catch(Exception$Jc){$this->error=$Jc->getMessage();return
false;}}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$he){$J=array();foreach($he
as$y=>$X){if(is_a($X,'MongoBinData'))$this->_charset[$y]=63;$J[$y]=(is_a($X,'MongoId')?"ObjectId(\"$X\")":(is_a($X,'MongoDate')?gmdate("Y-m-d H:i:s",$X->sec)." GMT":(is_a($X,'MongoBinData')?$X->bin:(is_a($X,'MongoRegex')?"$X":(is_object($X)?get_class($X):$X)))));}$this->_rows[]=$J;foreach($J
as$y=>$X){if(!isset($this->_rows[0][$y]))$this->_rows[0][$y]=null;}}$this->num_rows=count($this->_rows);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$y=>$X)$I[$y]=$J[$y];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$le=array_keys($this->_rows[0]);$D=$le[$this->_offset++];return(object)array('name'=>$D,'charsetnr'=>$this->_charset[$D],);}}class
Min_Driver
extends
Min_SQL{public$qg="_id";function
select($Q,$L,$Z,$ud,$Ef=array(),$z=1,$E=0,$sg=false){$L=($L==array("*")?array():array_fill_keys($L,true));$_h=array();foreach($Ef
as$X){$X=preg_replace('~ DESC$~','',$X,1,$Jb);$_h[$X]=($Jb?-1:1);}return
new
Min_Result($this->_conn->_db->selectCollection($Q)->find(array(),$L)->sort($_h)->limit($z!=""?+$z:0)->skip($E*$z));}function
insert($Q,$N){try{$I=$this->_conn->_db->selectCollection($Q)->insert($N);$this->_conn->errno=$I['code'];$this->_conn->error=$I['err'];$this->_conn->last_id=$N['_id'];return!$I['err'];}catch(Exception$Jc){$this->_conn->error=$Jc->getMessage();return
false;}}}function
get_databases($hd){global$g;$I=array();$Yb=$g->_link->listDBs();foreach($Yb['databases']as$k)$I[]=$k['name'];return$I;}function
count_tables($j){global$g;$I=array();foreach($j
as$k)$I[$k]=count($g->_link->selectDB($k)->getCollectionNames(true));return$I;}function
tables_list(){global$g;return
array_fill_keys($g->_db->getCollectionNames(true),'table');}function
drop_databases($j){global$g;foreach($j
as$k){$Rg=$g->_link->selectDB($k)->drop();if(!$Rg['ok'])return
false;}return
true;}function
indexes($Q,$h=null){global$g;$I=array();foreach($g->_db->selectCollection($Q)->getIndexInfo()as$v){$gc=array();foreach($v["key"]as$d=>$T)$gc[]=($T==-1?'1':null);$I[$v["name"]]=array("type"=>($v["name"]=="_id_"?"PRIMARY":($v["unique"]?"UNIQUE":"INDEX")),"columns"=>array_keys($v["key"]),"lengths"=>array(),"descs"=>$gc,);}return$I;}function
fields($Q){return
fields_from_edit();}function
found_rows($R,$Z){global$g;return$g->_db->selectCollection($_GET["select"])->count($Z);}$_f=array("=");$zf=null;}elseif(class_exists('MongoDB\Driver\Manager')){class
Min_DB{var$extension="MongoDB",$server_info=MONGODB_VERSION,$affected_rows,$error,$last_id;var$_link;var$_db,$_db_name;function
connect($Pi,$Cf){$ib='MongoDB\Driver\Manager';$this->_link=new$ib($Pi,$Cf);$this->executeCommand('admin',array('ping'=>1));}function
executeCommand($k,$sb){$ib='MongoDB\Driver\Command';try{return$this->_link->executeCommand($k,new$ib($sb));}catch(Exception$tc){$this->error=$tc->getMessage();return
array();}}function
executeBulkWrite($bf,$Ya,$Kb){try{$Ug=$this->_link->executeBulkWrite($bf,$Ya);$this->affected_rows=$Ug->$Kb();return
true;}catch(Exception$tc){$this->error=$tc->getMessage();return
false;}}function
query($G){return
false;}function
select_db($Ub){$this->_db_name=$Ub;return
true;}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows=array(),$_offset=0,$_charset=array();function
__construct($H){foreach($H
as$he){$J=array();foreach($he
as$y=>$X){if(is_a($X,'MongoDB\BSON\Binary'))$this->_charset[$y]=63;$J[$y]=(is_a($X,'MongoDB\BSON\ObjectID')?'MongoDB\BSON\ObjectID("'."$X\")":(is_a($X,'MongoDB\BSON\UTCDatetime')?$X->toDateTime()->format('Y-m-d H:i:s'):(is_a($X,'MongoDB\BSON\Binary')?$X->getData():(is_a($X,'MongoDB\BSON\Regex')?"$X":(is_object($X)||is_array($X)?json_encode($X,256):$X)))));}$this->_rows[]=$J;foreach($J
as$y=>$X){if(!isset($this->_rows[0][$y]))$this->_rows[0][$y]=null;}}$this->num_rows=count($this->_rows);}function
fetch_assoc(){$J=current($this->_rows);if(!$J)return$J;$I=array();foreach($this->_rows[0]as$y=>$X)$I[$y]=$J[$y];next($this->_rows);return$I;}function
fetch_row(){$I=$this->fetch_assoc();if(!$I)return$I;return
array_values($I);}function
fetch_field(){$le=array_keys($this->_rows[0]);$D=$le[$this->_offset++];return(object)array('name'=>$D,'charsetnr'=>$this->_charset[$D],);}}class
Min_Driver
extends
Min_SQL{public$qg="_id";function
select($Q,$L,$Z,$ud,$Ef=array(),$z=1,$E=0,$sg=false){global$g;$L=($L==array("*")?array():array_fill_keys($L,1));if(count($L)&&!isset($L['_id']))$L['_id']=0;$Z=where_to_query($Z);$_h=array();foreach($Ef
as$X){$X=preg_replace('~ DESC$~','',$X,1,$Jb);$_h[$X]=($Jb?-1:1);}if(isset($_GET['limit'])&&is_numeric($_GET['limit'])&&$_GET['limit']>0)$z=$_GET['limit'];$z=min(200,max(1,(int)$z));$xh=$E*$z;$ib='MongoDB\Driver\Query';try{return
new
Min_Result($g->_link->executeQuery("$g->_db_name.$Q",new$ib($Z,array('projection'=>$L,'limit'=>$z,'skip'=>$xh,'sort'=>$_h))));}catch(Exception$tc){$g->error=$tc->getMessage();return
false;}}function
update($Q,$N,$Bg,$z=0,$nh="\n"){global$g;$k=$g->_db_name;$Z=sql_query_where_parser($Bg);$ib='MongoDB\Driver\BulkWrite';$Ya=new$ib(array());if(isset($N['_id']))unset($N['_id']);$Og=array();foreach($N
as$y=>$Y){if($Y=='NULL'){$Og[$y]=1;unset($N[$y]);}}$Oi=array('$set'=>$N);if(count($Og))$Oi['$unset']=$Og;$Ya->update($Z,$Oi,array('upsert'=>false));return$g->executeBulkWrite("$k.$Q",$Ya,'getModifiedCount');}function
delete($Q,$Bg,$z=0){global$g;$k=$g->_db_name;$Z=sql_query_where_parser($Bg);$ib='MongoDB\Driver\BulkWrite';$Ya=new$ib(array());$Ya->delete($Z,array('limit'=>$z));return$g->executeBulkWrite("$k.$Q",$Ya,'getDeletedCount');}function
insert($Q,$N){global$g;$k=$g->_db_name;$ib='MongoDB\Driver\BulkWrite';$Ya=new$ib(array());if($N['_id']=='')unset($N['_id']);$Ya->insert($N);return$g->executeBulkWrite("$k.$Q",$Ya,'getInsertedCount');}}function
get_databases($hd){global$g;$I=array();foreach($g->executeCommand('admin',array('listDatabases'=>1))as$Yb){foreach($Yb->databases
as$k)$I[]=$k->name;}return$I;}function
count_tables($j){$I=array();return$I;}function
tables_list(){global$g;$pb=array();foreach($g->executeCommand($g->_db_name,array('listCollections'=>1))as$H)$pb[$H->name]='table';return$pb;}function
drop_databases($j){return
false;}function
indexes($Q,$h=null){global$g;$I=array();foreach($g->executeCommand($g->_db_name,array('listIndexes'=>$Q))as$v){$gc=array();$e=array();foreach(get_object_vars($v->key)as$d=>$T){$gc[]=($T==-1?'1':null);$e[]=$d;}$I[$v->name]=array("type"=>($v->name=="_id_"?"PRIMARY":(isset($v->unique)?"UNIQUE":"INDEX")),"columns"=>$e,"lengths"=>array(),"descs"=>$gc,);}return$I;}function
fields($Q){global$l;$o=fields_from_edit();if(!$o){$H=$l->select($Q,array("*"),null,null,array(),10);if($H){while($J=$H->fetch_assoc()){foreach($J
as$y=>$X){$J[$y]=null;$o[$y]=array("field"=>$y,"type"=>"string","null"=>($y!=$l->primary),"auto_increment"=>($y==$l->primary),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,),);}}}}return$o;}function
found_rows($R,$Z){global$g;$Z=where_to_query($Z);$si=$g->executeCommand($g->_db_name,array('count'=>$R['Name'],'query'=>$Z))->toArray();return$si[0]->n;}function
sql_query_where_parser($Bg){$Bg=preg_replace('~^\sWHERE \(?\(?(.+?)\)?\)?$~','\1',$Bg);$oj=explode(' AND ',$Bg);$pj=explode(') OR (',$Bg);$Z=array();foreach($oj
as$mj)$Z[]=trim($mj);if(count($pj)==1)$pj=array();elseif(count($pj)>1)$Z=array();return
where_to_query($Z,$pj);}function
where_to_query($kj=array(),$lj=array()){global$b;$Sb=array();foreach(array('and'=>$kj,'or'=>$lj)as$T=>$Z){if(is_array($Z)){foreach($Z
as$Pc){list($lb,$xf,$X)=explode(" ",$Pc,3);if($lb=="_id"&&preg_match('~^(MongoDB\\\\BSON\\\\ObjectID)\("(.+)"\)$~',$X,$C)){list(,$ib,$X)=$C;$X=new$ib($X);}if(!in_array($xf,$b->operators))continue;if(preg_match('~^\(f\)(.+)~',$xf,$C)){$X=(float)$X;$xf=$C[1];}elseif(preg_match('~^\(date\)(.+)~',$xf,$C)){$Vb=new
DateTime($X);$ib='MongoDB\BSON\UTCDatetime';$X=new$ib($Vb->getTimestamp()*1000);$xf=$C[1];}switch($xf){case'=':$xf='$eq';break;case'!=':$xf='$ne';break;case'>':$xf='$gt';break;case'<':$xf='$lt';break;case'>=':$xf='$gte';break;case'<=':$xf='$lte';break;case'regex':$xf='$regex';break;default:continue
2;}if($T=='and')$Sb['$and'][]=array($lb=>array($xf=>$X));elseif($T=='or')$Sb['$or'][]=array($lb=>array($xf=>$X));}}}return$Sb;}$_f=array("=","!=",">","<",">=","<=","regex","(f)=","(f)!=","(f)>","(f)<","(f)>=","(f)<=","(date)=","(date)!=","(date)>","(date)<","(date)>=","(date)<=",);$zf='regex';}function
table($u){return$u;}function
idf_escape($u){return$u;}function
table_status($D="",$Wc=false){$I=array();foreach(tables_list()as$Q=>$T){$I[$Q]=array("Name"=>$Q);if($D==$Q)return$I[$Q];}return$I;}function
create_database($k,$nb){return
true;}function
last_id(){global$g;return$g->last_id;}function
adminer_error(){global$g;return
h($g->error);}function
collations(){return
array();}function
logged_user(){global$b;$Nb=$b->credentials();return$Nb[1];}function
connect(){global$b;$g=new
Min_DB;list($M,$V,$F)=$b->credentials();$Cf=array();if($V.$F!=""){$Cf["username"]=$V;$Cf["password"]=$F;}$k=$b->database();if($k!="")$Cf["db"]=$k;if(($La=getenv("MONGO_AUTH_SOURCE")))$Cf["authSource"]=$La;$g->connect("mongodb://$M",$Cf);if($g->error)return$g->error;return$g;}function
alter_indexes($Q,$c){global$g;foreach($c
as$X){list($T,$D,$N)=$X;if($N=="DROP")$I=$g->_db->command(array("deleteIndexes"=>$Q,"index"=>$D));else{$e=array();foreach($N
as$d){$d=preg_replace('~ DESC$~','',$d,1,$Jb);$e[$d]=($Jb?-1:1);}$I=$g->_db->selectCollection($Q)->ensureIndex($e,array("unique"=>($T=="UNIQUE"),"name"=>$D,));}if($I['errmsg']){$g->error=$I['errmsg'];return
false;}}return
true;}function
support($Xc){return
preg_match("~database|indexes|descidx~",$Xc);}function
db_collation($k,$ob){}function
information_schema(){}function
is_view($R){}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
foreign_keys($Q){return
array();}function
fk_support($R){}function
engines(){return
array();}function
alter_table($Q,$D,$o,$jd,$ub,$Bc,$nb,$Ma,$Zf){global$g;if($Q==""){$g->_db->createCollection($D);return
true;}}function
drop_tables($S){global$g;foreach($S
as$Q){$Rg=$g->_db->selectCollection($Q)->drop();if(!$Rg['ok'])return
false;}return
true;}function
truncate_tables($S){global$g;foreach($S
as$Q){$Rg=$g->_db->selectCollection($Q)->remove();if(!$Rg['ok'])return
false;}return
true;}function
driver_config(){global$_f,$zf;return
array('possible_drivers'=>array("mongo","mongodb"),'jush'=>"mongo",'operators'=>$_f,'operator_regexp'=>$zf,'functions'=>array(),'grouping'=>array(),'edit_functions'=>array(array("json")),);}}$mc["elastic"]="Elasticsearch (beta)";if(isset($_GET["elastic"])){define("DRIVER","elastic");if(function_exists('json_decode')&&ini_bool('allow_url_fopen')){class
Min_DB{var$extension="JSON",$server_info,$errno,$error,$_url,$_db;function
rootQuery($dg,$Eb=array(),$Ue='GET'){@ini_set('track_errors',1);$bd=@file_get_contents("$this->_url/".ltrim($dg,'/'),false,stream_context_create(array('http'=>array('method'=>$Ue,'content'=>$Eb===null?$Eb:json_encode($Eb),'header'=>'Content-Type: application/json','ignore_errors'=>1,))));if(!$bd){$this->error=$php_errormsg;return$bd;}if(!preg_match('~^HTTP/[0-9.]+ 2~i',$http_response_header[0])){$this->error=lang(32)." $http_response_header[0]";return
false;}$I=json_decode($bd,true);if($I===null){$this->errno=json_last_error();if(function_exists('json_last_error_msg'))$this->error=json_last_error_msg();else{$Cb=get_defined_constants(true);foreach($Cb['json']as$D=>$Y){if($Y==$this->errno&&preg_match('~^JSON_ERROR_~',$D)){$this->error=$D;break;}}}}return$I;}function
query($dg,$Eb=array(),$Ue='GET'){return$this->rootQuery(($this->_db!=""?"$this->_db/":"/").ltrim($dg,'/'),$Eb,$Ue);}function
connect($M,$V,$F){preg_match('~^(https?://)?(.*)~',$M,$C);$this->_url=($C[1]?$C[1]:"http://")."$V:$F@$C[2]";$I=$this->query('');if($I)$this->server_info=$I['version']['number'];return(bool)$I;}function
select_db($Ub){$this->_db=$Ub;return
true;}function
quote($P){return$P;}}class
Min_Result{var$num_rows,$_rows;function
__construct($K){$this->num_rows=count($K);$this->_rows=$K;reset($this->_rows);}function
fetch_assoc(){$I=current($this->_rows);next($this->_rows);return$I;}function
fetch_row(){return
array_values($this->fetch_assoc());}}}class
Min_Driver
extends
Min_SQL{function
select($Q,$L,$Z,$ud,$Ef=array(),$z=1,$E=0,$sg=false){global$b;$Sb=array();$G="$Q/_search";if($L!=array("*"))$Sb["fields"]=$L;if($Ef){$_h=array();foreach($Ef
as$lb){$lb=preg_replace('~ DESC$~','',$lb,1,$Jb);$_h[]=($Jb?array($lb=>"desc"):$lb);}$Sb["sort"]=$_h;}if($z){$Sb["size"]=+$z;if($E)$Sb["from"]=($E*$z);}foreach($Z
as$X){list($lb,$xf,$X)=explode(" ",$X,3);if($lb=="_id")$Sb["query"]["ids"]["values"][]=$X;elseif($lb.$X!=""){$fi=array("term"=>array(($lb!=""?$lb:"_all")=>$X));if($xf=="=")$Sb["query"]["filtered"]["filter"]["and"][]=$fi;else$Sb["query"]["filtered"]["query"]["bool"]["must"][]=$fi;}}if($Sb["query"]&&!$Sb["query"]["filtered"]["query"]&&!$Sb["query"]["ids"])$Sb["query"]["filtered"]["query"]=array("match_all"=>array());$Ih=microtime(true);$hh=$this->_conn->query($G,$Sb);if($sg)echo$b->selectQuery("$G: ".json_encode($Sb),$Ih,!$hh);if(!$hh)return
false;$I=array();foreach($hh['hits']['hits']as$Gd){$J=array();if($L==array("*"))$J["_id"]=$Gd["_id"];$o=$Gd['_source'];if($L!=array("*")){$o=array();foreach($L
as$y)$o[$y]=$Gd['fields'][$y];}foreach($o
as$y=>$X){if($Sb["fields"])$X=$X[0];$J[$y]=(is_array($X)?json_encode($X):$X);}$I[]=$J;}return
new
Min_Result($I);}function
update($T,$Fg,$Bg,$z=0,$nh="\n"){$bg=preg_split('~ *= *~',$Bg);if(count($bg)==2){$t=trim($bg[1]);$G="$T/$t";return$this->_conn->query($G,$Fg,'POST');}return
false;}function
insert($T,$Fg){$t="";$G="$T/$t";$Rg=$this->_conn->query($G,$Fg,'POST');$this->_conn->last_id=$Rg['_id'];return$Rg['created'];}function
delete($T,$Bg,$z=0){$Kd=array();if(is_array($_GET["where"])&&$_GET["where"]["_id"])$Kd[]=$_GET["where"]["_id"];if(is_array($_POST['check'])){foreach($_POST['check']as$cb){$bg=preg_split('~ *= *~',$cb);if(count($bg)==2)$Kd[]=trim($bg[1]);}}$this->_conn->affected_rows=0;foreach($Kd
as$t){$G="{$T}/{$t}";$Rg=$this->_conn->query($G,'{}','DELETE');if(is_array($Rg)&&$Rg['found']==true)$this->_conn->affected_rows++;}return$this->_conn->affected_rows;}}function
connect(){global$b;$g=new
Min_DB;list($M,$V,$F)=$b->credentials();if($F!=""&&$g->connect($M,$V,""))return
lang(22);if($g->connect($M,$V,$F))return$g;return$g->error;}function
support($Xc){return
preg_match("~database|table|columns~",$Xc);}function
logged_user(){global$b;$Nb=$b->credentials();return$Nb[1];}function
get_databases(){global$g;$I=$g->rootQuery('_aliases');if($I){$I=array_keys($I);sort($I,SORT_STRING);}return$I;}function
collations(){return
array();}function
db_collation($k,$ob){}function
engines(){return
array();}function
count_tables($j){global$g;$I=array();$H=$g->query('_stats');if($H&&$H['indices']){$Sd=$H['indices'];foreach($Sd
as$Rd=>$Jh){$Qd=$Jh['total']['indexing'];$I[$Rd]=$Qd['index_total'];}}return$I;}function
tables_list(){global$g;if(min_version(6))return
array('_doc'=>'table');$I=$g->query('_mapping');if($I)$I=array_fill_keys(array_keys($I[$g->_db]["mappings"]),'table');return$I;}function
table_status($D="",$Wc=false){global$g;$hh=$g->query("_search",array("size"=>0,"aggregations"=>array("count_by_type"=>array("terms"=>array("field"=>"_type")))),"POST");$I=array();if($hh){$S=$hh["aggregations"]["count_by_type"]["buckets"];foreach($S
as$Q){$I[$Q["key"]]=array("Name"=>$Q["key"],"Engine"=>"table","Rows"=>$Q["doc_count"],);if($D!=""&&$D==$Q["key"])return$I[$D];}}return$I;}function
adminer_error(){global$g;return
h($g->error);}function
information_schema(){}function
is_view($R){}function
indexes($Q,$h=null){return
array(array("type"=>"PRIMARY","columns"=>array("_id")),);}function
fields($Q){global$g;$De=array();if(min_version(6)){$H=$g->query("_mapping");if($H)$De=$H[$g->_db]['mappings']['properties'];}else{$H=$g->query("$Q/_mapping");if($H){$De=$H[$Q]['properties'];if(!$De)$De=$H[$g->_db]['mappings'][$Q]['properties'];}}$I=array();if($De){foreach($De
as$D=>$n){$I[$D]=array("field"=>$D,"full_type"=>$n["type"],"type"=>$n["type"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1),);if($n["properties"]){unset($I[$D]["privileges"]["insert"]);unset($I[$D]["privileges"]["update"]);}}}return$I;}function
foreign_keys($Q){return
array();}function
table($u){return$u;}function
idf_escape($u){return$u;}function
convert_field($n){}function
unconvert_field($n,$I){return$I;}function
fk_support($R){}function
found_rows($R,$Z){return
null;}function
create_database($k){global$g;return$g->rootQuery(urlencode($k),null,'PUT');}function
drop_databases($j){global$g;return$g->rootQuery(urlencode(implode(',',$j)),array(),'DELETE');}function
alter_table($Q,$D,$o,$jd,$ub,$Bc,$nb,$Ma,$Zf){global$g;$yg=array();foreach($o
as$Uc){$Zc=trim($Uc[1][0]);$ad=trim($Uc[1][1]?$Uc[1][1]:"text");$yg[$Zc]=array('type'=>$ad);}if(!empty($yg))$yg=array('properties'=>$yg);return$g->query("_mapping/{$D}",$yg,'PUT');}function
drop_tables($S){global$g;$I=true;foreach($S
as$Q)$I=$I&&$g->query(urlencode($Q),array(),'DELETE');return$I;}function
last_id(){global$g;return$g->last_id;}function
driver_config(){$U=array();$Mh=array();foreach(array(lang(27)=>array("long"=>3,"integer"=>5,"short"=>8,"byte"=>10,"double"=>20,"float"=>66,"half_float"=>12,"scaled_float"=>21),lang(28)=>array("date"=>10),lang(25)=>array("string"=>65535,"text"=>65535),lang(29)=>array("binary"=>255),)as$y=>$X){$U+=$X;$Mh[$y]=array_keys($X);}return
array('possible_drivers'=>array("json + allow_url_fopen"),'jush'=>"elastic",'operators'=>array("=","query"),'functions'=>array(),'grouping'=>array(),'edit_functions'=>array(array("json")),'types'=>$U,'structured_types'=>$Mh,);}}class
Adminer{var$operators;function
name(){return"<a href='https://www.adminerevo.org/'".target_blank()." id='h1'>AdminerEvo</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($i=false){return
password_file($i);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($M){return
h($M);}function
database(){return
DB;}function
databases($hd=true){return
get_databases($hd);}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
headers(){}function
csp(){return
csp();}function
head(){return
true;}function
css(){$I=array();$p="adminer.css";if(file_exists($p))$I[]="$p?v=".crc32(file_get_contents($p));return$I;}function
loginForm(){global$mc;echo"<table cellspacing='0' class='layout'>\n",$this->loginFormField('driver','<tr><th>'.lang(33).'<td>',html_select("auth[driver]",$mc,DRIVER,"loginDriver(this);")."\n"),$this->loginFormField('server','<tr><th>'.lang(34).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'."\n"),$this->loginFormField('username','<tr><th>'.lang(35).'<td>','<input name="auth[username]" id="username" value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("focus(qs('#username')); qs('#username').form['auth[driver]'].onchange();")),$this->loginFormField('password','<tr><th>'.lang(36).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'."\n"),$this->loginFormField('db','<tr><th>'.lang(37).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'."\n"),"</table>\n","<p><input type='submit' value='".lang(38)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(39))."\n";}function
loginFormField($D,$Dd,$Y){return$Dd.$Y;}function
login($Be,$F){if($F=="")return
lang(40,target_blank());return
true;}function
tableName($Th){return
h($Th["Name"]);}function
fieldName($n,$Ef=0){return'<span title="'.h($n["full_type"]).'">'.h($n["field"]).'</span>';}function
selectLinks($Th,$N=""){global$x,$l;echo'<p class="links">';$xa=array("select"=>lang(41));if(support("table")||support("indexes"))$xa["table"]=lang(42);if(support("table")){if(is_view($Th))$xa["view"]=lang(43);else$xa["create"]=lang(44);}if($N!==null)$xa["edit"]=lang(45);$D=$Th["Name"];$A=[];foreach($xa
as$y=>$X)$A[]="<a href='".h(ME)."$y=".urlencode($D).($y=="edit"?$N:"")."'".bold(isset($_GET[$y])).">$X</a>";echo
generate_linksbar($A),adminer_doc_link(array($x=>$l->tableHelp($D)),"?"),"\n";}function
foreignKeys($Q){return
foreign_keys($Q);}function
backwardKeys($Q,$Sh){return
array();}function
backwardKeysPrint($Pa,$J){}function
selectQuery($G,$Ih,$Vc=false){global$x,$l;if(!$Vc&&($hj=$l->warnings())){$t="warnings";$I=", <a href='#$t'>".lang(46)."</a>".script("qsl('a').onclick = partial(toggle, '$t');","")."<div id='$t' class='hidden'>\n$hj</div>\n";}$A=[(support("sql")?"<a href='".h(ME)."sql=".urlencode($G)."'>".lang(10)."</a>":""),"<a href='#' class='copy-to-clipboard'>".lang(47)."</a>",];return"<code class='jush-$x copy-to-clipboard'>".h(str_replace("\n"," ",$G))."</code> <span class='time'>(".adminer_format_time($Ih).")</span>".generate_linksbar($A);}function
sqlCommandQuery($G){return
shorten_utf8(trim($G),1000);}function
rowDescription($Q){return"";}function
rowDescriptions($K,$kd){return$K;}function
selectLink($X,$n){}function
selectVal($X,$_,$n,$Mf){$I=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$n["type"])&&!preg_match("~var~",$n["type"])?"<code>$X</code>":$X));if(preg_match('~blob|bytea|raw|file~',$n["type"])&&!is_utf8($X))$I="<i>".lang(48,strlen($Mf))."</i>";if(preg_match('~json~',$n["type"]))$I="<code class='jush-js'>$I</code>";return($_?"<a href='".h($_)."'".(is_url($_)?target_blank():"").">$I</a>":$I);}function
editVal($X,$n){return$X;}function
tableStructurePrint($o){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr><th>".lang(49)."<td>".lang(50).(support("comment")?"<td>".lang(51):"")."</thead>\n";foreach($o
as$n){echo"<tr".odd()."><th>".h($n["field"]),"<td><span title='".h($n["collation"])."'>".h($n["full_type"])."</span>",($n["null"]?" <i>NULL</i>":""),($n["auto_increment"]?" <i>".lang(52)."</i>":""),(isset($n["default"])?" <span title='".lang(53)."'>[<b>".h($n["default"])."</b>]</span>":""),(support("comment")?"<td>".h($n["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint($w){echo"<table cellspacing='0'>\n";foreach($w
as$D=>$v){ksort($v["columns"]);$sg=array();foreach($v["columns"]as$y=>$X)$sg[]="<i>".h($X)."</i>".($v["lengths"][$y]?"(".$v["lengths"][$y].")":"").($v["descs"][$y]?" DESC":"");echo"<tr title='".h($D)."'><th>$v[type]<td>".implode(", ",$sg)."\n";}echo"</table>\n";}function
selectColumnsPrint($L,$e){global$rd,$xd;print_fieldset("select",lang(54),$L);$s=0;$L[""]=array();foreach($L
as$y=>$X){$X=$_GET["columns"][$y];$d=select_input(" name='columns[$s][col]'",$e,$X["col"],($y!==""?"selectFieldChange":"selectAddRow"));echo"<div>".($rd||$xd?"<select name='columns[$s][fun]'>".optionlist(array(-1=>"")+array_filter(array(lang(55)=>$rd,lang(56)=>$xd)),$X["fun"])."</select>".on_help("getTarget(event).value && getTarget(event).value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($y!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)."</div>\n";$s++;}echo"</div></fieldset>\n";}function
selectSearchPrint($Z,$e,$w){print_fieldset("search",lang(57),$Z);foreach($w
as$s=>$v){if($v["type"]=="FULLTEXT"){echo"<div>(<i>".implode("</i>, <i>",array_map('h',$v["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$s]' value='".h($_GET["fulltext"][$s])."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$s]",1,isset($_GET["boolean"][$s]),"BOOL"),"</div>\n";}}$ab="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$s=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators))){echo"<div>".select_input(" name='where[$s][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(58).")"),html_select("where[$s][op]",$this->operators,$X["op"],$ab),"<input type='search' name='where[$s][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $ab }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}}echo"</div></fieldset>\n";}function
selectOrderPrint($Ef,$e,$w){print_fieldset("sort",lang(59),$Ef);$s=0;foreach((array)$_GET["order"]as$y=>$X){if($X!=""){echo"<div>".select_input(" name='order[$s]'",$e,$X,"selectFieldChange"),checkbox("desc[$s]",1,isset($_GET["desc"][$y]),lang(60))."</div>\n";$s++;}}echo"<div>".select_input(" name='order[$s]'",$e,"","selectAddRow"),checkbox("desc[$s]",1,false,lang(60))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($z){echo"<fieldset><legend>".lang(61)."</legend><div>";echo"<input type='number' name='limit' class='size' value='".h($z)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($ii){if($ii!==null){echo"<fieldset><legend>".lang(62)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($ii)."'>","</div></fieldset>\n";}}function
selectActionPrint($w){echo"<fieldset><legend>".lang(63)."</legend><div>","<input type='submit' value='".lang(54)."'>"," <span id='noindex' title='".lang(64)."'></span>","<script".nonce().">\n","var indexColumns = ";$e=array();foreach($w
as$v){$Rb=reset($v["columns"]);if($v["type"]!="FULLTEXT"&&$Rb)$e[$Rb]=1;}$e[""]=1;foreach($e
as$y=>$X)json_row($y);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint($zc,$e){}function
selectColumnsProcess($e,$w){global$rd,$xd;$L=array();$ud=array();foreach((array)$_GET["columns"]as$y=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],$rd)||in_array($X["fun"],$xd)))){$L[$y]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],$xd))$ud[]=$L[$y];}}return
array($L,$ud);}function
selectSearchProcess($o,$w){global$g,$l;$I=array();foreach($w
as$s=>$v){if($v["type"]=="FULLTEXT"&&$_GET["fulltext"][$s]!="")$I[]="MATCH (".implode(", ",array_map('idf_escape',$v["columns"])).") AGAINST (".q($_GET["fulltext"][$s]).(isset($_GET["boolean"][$s])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$y=>$X){if("$X[col]$X[val]"!=""&&in_array($X["op"],$this->operators)){$og="";$xb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Nd=process_length($X["val"]);$xb.=" ".($Nd!=""?$Nd:"(NULL)");}elseif($X["op"]=="SQL")$xb=" $X[val]";elseif($X["op"]=="LIKE %%")$xb=" LIKE ".$this->processInput($o[$X["col"]],"%$X[val]%");elseif($X["op"]=="ILIKE %%")$xb=" ILIKE ".$this->processInput($o[$X["col"]],"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$og="$X[op](".q($X["val"]).", ";$xb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$xb.=" ".$this->processInput($o[$X["col"]],$X["val"]);if($X["col"]!="")$I[]=$og.$l->convertSearch(idf_escape($X["col"]),$X,$o[$X["col"]]).$xb;else{$qb=array();foreach($o
as$D=>$n){if((preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$n["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$n["type"]))&&(!preg_match('~date|timestamp~',$n["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"])))$qb[]=$og.$l->convertSearch(idf_escape($D),$X,$n).$xb;}$I[]=($qb?"(".implode(" OR ",$qb).")":"1 = 0");}}}return$I;}function
selectOrderProcess($o,$w){$I=array();foreach((array)$_GET["order"]as$y=>$X){if($X!="")$I[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$y])?" DESC":"");}return$I;}function
selectLimitProcess(){return(isset($_GET["limit"])?$_GET["limit"]:"50");}function
selectLengthProcess(){return(isset($_GET["text_length"])?$_GET["text_length"]:"100");}function
selectEmailProcess($Z,$kd){return
false;}function
selectQueryBuild($L,$Z,$ud,$Ef,$z,$E){return"";}function
messageQuery($G,$ji,$Vc=false){global$x,$l;restart_session();$Ed=&get_session("queries");if(!$Ed[$_GET["db"]])$Ed[$_GET["db"]]=array();if(strlen($G)>1e6)$G=preg_replace('~[\x80-\xFF]+$~','',substr($G,0,1e6))."\n…";$Ed[$_GET["db"]][]=array($G,time(),$ji);$Fh="sql-".count($Ed[$_GET["db"]]);$I="<a href='#$Fh' class='toggle'>".lang(65)."</a> <a href='#' class='copy-to-clipboard icon expand' data-expand-id='$Fh'></a>\n";if(!$Vc&&($hj=$l->warnings())){$t="warnings-".count($Ed[$_GET["db"]]);$I="<a href='#$t' class='toggle'>".lang(46)."</a>, $I<div id='$t' class='hidden'>\n$hj</div>\n";}$A=[];if(support("sql")){$A[]='<a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Ed[$_GET["db"]])-1)).'">'.lang(10).'</a>';$A[]='<a href="#" class="copy-to-clipboard">'.lang(47).'</a>';}return" <span class='time'>".@date("H:i:s")."</span>"." $I<div id='$Fh' class='hidden'><pre><code class='jush-$x copy-to-clipboard'>".shorten_utf8($G,1000)."</code></pre>".($ji?" <span class='time'>($ji)</span>":'').generate_linksbar($A).'</div>';}function
editRowPrint($Q,$o,$J,$Oi){}function
editFunctions($n){global$uc;$I=($n["null"]?"NULL/":"");$Oi=isset($_GET["select"])||where($_GET);foreach($uc
as$y=>$rd){if(!$y||(!isset($_GET["call"])&&$Oi)){foreach($rd
as$fg=>$X){if(!$fg||preg_match("~$fg~",$n["type"]))$I.="/$X";}}if($y&&!preg_match('~set|blob|bytea|raw|file|bool~',$n["type"]))$I.="/SQL";}if($n["auto_increment"]&&!$Oi)$I=lang(52);return
explode("/",$I);}function
editInput($Q,$n,$Ja,$Y){if($n["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$Ja value='-1' checked><i>".lang(8)."</i></label> ":"").($n["null"]?"<label><input type='radio'$Ja value=''".($Y!==null||isset($_GET["select"])?"":" checked")."><i>NULL</i></label> ":"").enum_input("radio",$Ja,$n,$Y,0);return"";}function
editHint($Q,$n,$Y){return"";}function
processInput($n,$Y,$r=""){if($r=="SQL")return$Y;$D=$n["field"];$I=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$r))$I="$r()";elseif(preg_match('~^current_(date|timestamp)$~',$r))$I=$r;elseif(preg_match('~^([+-]|\|\|)$~',$r))$I=idf_escape($D)." $r $I";elseif(preg_match('~^[+-] interval$~',$r))$I=idf_escape($D)." $r ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)?$Y:$I);elseif(preg_match('~^(addtime|subtime|concat)$~',$r))$I="$r(".idf_escape($D).", $I)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$r))$I="$r($I)";return
unconvert_field($n,$I);}function
dumpOutput(){$I=array('text'=>lang(66),'file'=>lang(67));if(function_exists('gzencode'))$I['gz']='gzip';return$I;}function
dumpFormat(){return
array('sql'=>'SQL','csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($k){}function
dumpTable($Q,$Nh,$ge=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($Nh)dump_csv(array_keys(fields($Q)));}else{if($ge==2){$o=array();foreach(fields($Q)as$D=>$n)$o[]=idf_escape($D)." $n[full_type]";$i="CREATE TABLE ".table($Q)." (".implode(", ",$o).")";}else$i=create_sql($Q,$_POST["auto_increment"],$Nh);set_utf8mb4($i);if($Nh&&$i){if($Nh=="DROP+CREATE"||$ge==1)echo"DROP ".($ge==2?"VIEW":"TABLE")." IF EXISTS ".table($Q).";\n";if($ge==1)$i=remove_definer($i);echo"$i;\n\n";}}}function
dumpData($Q,$Nh,$G){global$g,$x;$Je=($x=="sqlite"?0:1048576);if($Nh){if($_POST["format"]=="sql"){if($Nh=="TRUNCATE+INSERT")echo
truncate_sql($Q).";\n";$o=fields($Q);}$H=$g->query($G,1);if($H){$Zd="";$Xa="";$le=array();$Ph="";$Yc=($Q!=''?'fetch_assoc':'fetch_row');while($J=$H->$Yc()){if(!$le){$Zi=array();foreach($J
as$X){$n=$H->fetch_field();$le[]=$n->name;$y=idf_escape($n->name);$Zi[]="$y = VALUES($y)";}$Ph=($Nh=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$Zi):"").";\n";}if($_POST["format"]!="sql"){if($Nh=="table"){dump_csv($le);$Nh="INSERT";}dump_csv($J);}else{if(!$Zd)$Zd="INSERT INTO ".table($Q)." (".implode(", ",array_map('idf_escape',$le)).") VALUES";foreach($J
as$y=>$X){$n=$o[$y];$J[$y]=($X!==null?unconvert_field($n,preg_match(number_type(),$n["type"])&&!preg_match('~\[~',$n["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$dh=($Je?"\n":" ")."(".implode(",\t",$J).")";if(!$Xa)$Xa=$Zd.$dh;elseif(strlen($Xa)+4+strlen($dh)+strlen($Ph)<$Je)$Xa.=",$dh";else{echo$Xa.$Ph;$Xa=$Zd.$dh;}}}if($Xa)echo$Xa.$Ph;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",$g->error)."\n";}}function
dumpFilename($Jd){return
friendly_url($Jd!=""?$Jd:(SERVER!=""?SERVER:"localhost"));}function
dumpHeaders($Jd,$Xe=false){$Pf=$_POST["output"];$Qc=(preg_match('~sql~',$_POST["format"])?"sql":($Xe?"tar":"csv"));header("Content-Type: ".($Pf=="gz"?"application/x-gzip":($Qc=="tar"?"application/x-tar":($Qc=="sql"||$Pf!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($Pf=="gz")ob_start('ob_gzencode',1e6);return$Qc;}function
importServerPath(){return"adminer.sql";}function
homepage(){$A=[];if($_GET["ns"]==""&&support("database"))$A[]='<a href="'.h(ME).'database=">'.lang(68).'</a>';if(support("scheme"))$A[]="<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(69):lang(70))."</a>";if($_GET["ns"]!=="")$A[]='<a href="'.h(ME).'schema=">'.lang(71).'</a>';if(support("privileges"))$A[]="<a href='".h(ME)."privileges='>".lang(72)."</a>";echo
generate_linksbar($A);return
true;}function
navigation($We){global$ia,$x,$mc,$g;echo'<h1>
',$this->name(),' <span class="version">',$ia,'</span>
</h1>
';if($We=="auth"){$Pf="";foreach((array)$_SESSION["pwds"]as$bj=>$rh){foreach($rh
as$M=>$Wi){foreach($Wi
as$V=>$F){if($F!==null){$Yb=$_SESSION["db"][$bj][$M][$V];foreach(($Yb?array_keys($Yb):array(""))as$k)$Pf.="<li><a href='".h(auth_url($bj,$M,$V,$k))."'>($mc[$bj]) ".h($V.($M!=""?"@".$this->serverName($M):"").($k!=""?" - $k":""))."</a>\n";}}}}if($Pf)echo"<ul id='logins'>\n$Pf</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$S=array();if($_GET["ns"]!==""&&!$We&&DB!=""){$g->select_db(DB);$S=table_status('',true);}echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=4.8.3");if(support("sql")){echo'<script',nonce(),'>
';if($S){$A=array();foreach($S
as$Q=>$T)$A[]=preg_quote($Q,'/');echo"var jushLinks = { $x: [ '".js_escape(ME).(support("table")?"table=":"select=")."\$&', /\\b(".implode("|",$A).")\\b/g ] };\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.$x;\n";}$qh=$g->server_info;echo'bodyLoad(\'',(is_object($g)?preg_replace('~^(\d\.?\d).*~s','\1',$qh):""),'\'',(preg_match('~MariaDB~',$qh)?", true":""),');
</script>
';}$this->databasesPrint($We);$A=[];if(DB==""||!$We){if(support("sql")){$A[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(65)."</a>";$A[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(73)."</a>";}if(support("dump"))$A[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(74)."</a>";}echo
generate_linksbar($A);if($_GET["ns"]!==""&&!$We&&DB!=""){echo
generate_linksbar(['<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(75)."</a>"]);if(!$S)echo"<p class='message'>".lang(9)."\n";else$this->tablesPrint($S);}}}function
databasesPrint($We){global$b,$g;$j=$this->databases();if(DB&&$j&&!in_array(DB,$j))array_unshift($j,DB);echo'<form action="">
',"<table id='dbs'><tr><td width=1>";hidden_fields_get();$Wb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<label title='".lang(76)."' for='menu_db'>".lang(77)."</label>:</td><td>".($j?"<select name='db' id='menu_db'>".optionlist(array(""=>"")+$j,DB)."</select>$Wb":"<input name='db' id='menu_db' value='".h(DB)."' autocapitalize='off'>\n"),"</td></tr>";if(support("scheme")){if($We!="db"&&DB!=""&&$g->select_db(DB)){echo"<tr><td><label for='menu_ns'>".lang(78).":</label></td>","<td><select name='ns' id='menu_ns'>".optionlist(array(""=>"")+$b->schemas(),$_GET["ns"])."</select>$Wb";if($_GET["ns"]!="")set_schema($_GET["ns"]);echo"</td></tr>";}}echo"<tr".($j?" class='hidden'":"")."><td colspan=2><input type='submit' value='".lang(20)."'></td></tr>\n","</table>";foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo"<input type='hidden' name='$X' value=''>";break;}}}function
tablesPrint($S){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($S
as$Q=>$O){$D=$this->tableName($O);if($D!=""){echo'<li><a href="'.h(ME).'select='.urlencode($Q).'"'.bold($_GET["select"]==$Q||$_GET["edit"]==$Q,"select")." title='".lang(41)."'>".lang(79)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($Q).'"'.bold(in_array($Q,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"],$_GET["select"])),(is_view($O)?"view":"structure"))." title='".lang(42)."'>$D</a>":"<span>$D</span>")."\n";}}echo"</ul>\n";}}$b=(function_exists('adminer_object')?adminer_object():new
Adminer);$mc=array("server"=>"MySQL")+$mc;if(!defined("DRIVER")){define("DRIVER","server");if(extension_loaded("mysqli")){class
Min_DB
extends
MySQLi{var$extension="MySQLi";function
__construct(){parent::init();}function
connect($M="",$V="",$F="",$Ub=null,$jg=null,$zh=null){global$b;mysqli_report(MYSQLI_REPORT_OFF);list($Hd,$jg)=explode(":",$M,2);$Hh=$b->connectSsl();if($Hh)$this->ssl_set($Hh['key'],$Hh['cert'],$Hh['ca'],'','');$I=@$this->real_connect(($M!=""?$Hd:ini_get("mysqli.default_host")),($M.$V!=""?$V:ini_get("mysqli.default_user")),($M.$V.$F!=""?$F:ini_get("mysqli.default_pw")),$Ub,(is_numeric($jg)?$jg:ini_get("mysqli.default_port")),(!is_numeric($jg)?$jg:$zh),($Hh?64:0));$this->options(MYSQLI_OPT_LOCAL_INFILE,false);return$I;}function
set_charset($bb){if(parent::set_charset($bb))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $bb");}function
result($G,$n=0){$H=$this->query($G);if(!$H)return
false;$J=$H->fetch_array();return$J[$n];}function
quote($P){return"'".$this->escape_string($P)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Min_DB{var$extension="MySQL",$server_info,$affected_rows,$errno,$error,$_link,$_result;function
connect($M,$V,$F){if(ini_bool("mysql.allow_local_infile")){$this->error=lang(80,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");return
false;}$this->_link=@mysql_connect(($M!=""?$M:ini_get("mysql.default_host")),("$M$V"!=""?$V:ini_get("mysql.default_user")),("$M$V$F"!=""?$F:ini_get("mysql.default_password")),true,131072);if($this->_link)$this->server_info=mysql_get_server_info($this->_link);else$this->error=mysql_error();return(bool)$this->_link;}function
set_charset($bb){if(function_exists('mysql_set_charset')){if(mysql_set_charset($bb,$this->_link))return
true;mysql_set_charset('utf8',$this->_link);}return$this->query("SET NAMES $bb");}function
quote($P){return"'".mysql_real_escape_string($P,$this->_link)."'";}function
select_db($Ub){return
mysql_select_db($Ub,$this->_link);}function
query($G,$Hi=false){$H=@($Hi?mysql_unbuffered_query($G,$this->_link):mysql_query($G,$this->_link));$this->error="";if(!$H){$this->errno=mysql_errno($this->_link);$this->error=mysql_error($this->_link);return
false;}if($H===true){$this->affected_rows=mysql_affected_rows($this->_link);$this->info=mysql_info($this->_link);return
true;}return
new
Min_Result($H);}function
multi_query($G){return$this->_result=$this->query($G);}function
store_result(){return$this->_result;}function
next_result(){return
false;}function
result($G,$n=0){$H=$this->query($G);if(!$H||!$H->num_rows)return
false;return
mysql_result($H->_result,0,$n);}}class
Min_Result{var$num_rows,$_result,$_offset=0;function
__construct($H){$this->_result=$H;$this->num_rows=mysql_num_rows($H);}function
fetch_assoc(){return
mysql_fetch_assoc($this->_result);}function
fetch_row(){return
mysql_fetch_row($this->_result);}function
fetch_field(){$I=mysql_fetch_field($this->_result,$this->_offset++);$I->orgtable=$I->table;$I->orgname=$I->name;$I->charsetnr=($I->blob?63:0);return$I;}function
__destruct(){mysql_free_result($this->_result);}}}elseif(extension_loaded("pdo_mysql")){class
Min_DB
extends
Min_PDO{var$extension="PDO_MySQL";function
connect($M,$V,$F){global$b;$Cf=array(PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$Hh=$b->connectSsl();if($Hh){if(!empty($Hh['key']))$Cf[PDO::MYSQL_ATTR_SSL_KEY]=$Hh['key'];if(!empty($Hh['cert']))$Cf[PDO::MYSQL_ATTR_SSL_CERT]=$Hh['cert'];if(!empty($Hh['ca']))$Cf[PDO::MYSQL_ATTR_SSL_CA]=$Hh['ca'];}$this->dsn("mysql:charset=utf8;host=".str_replace(":",";unix_socket=",preg_replace('~:(\d)~',';port=\1',$M)),$V,$F,$Cf);return
true;}function
set_charset($bb){$this->query("SET NAMES $bb");}function
select_db($Ub){return$this->query("USE ".idf_escape($Ub));}function
query($G,$Hi=false){$this->pdo->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$Hi);return
parent::query($G,$Hi);}}}class
Min_Driver
extends
Min_SQL{function
insert($Q,$N){return($N?parent::insert($Q,$N):queries("INSERT INTO ".table($Q)." ()\nVALUES ()"));}function
insertUpdate($Q,$K,$qg){$e=array_keys(reset($K));$og="INSERT INTO ".table($Q)." (".implode(", ",$e).") VALUES\n";$Zi=array();foreach($e
as$y)$Zi[$y]="$y = VALUES($y)";$Ph="\nON DUPLICATE KEY UPDATE ".implode(", ",$Zi);$Zi=array();$ye=0;foreach($K
as$N){$Y="(".implode(", ",$N).")";if($Zi&&(strlen($og)+$ye+strlen($Y)+strlen($Ph)>1e6)){if(!queries($og.implode(",\n",$Zi).$Ph))return
false;$Zi=array();$ye=0;}$Zi[]=$Y;$ye+=strlen($Y)+2;}return
queries($og.implode(",\n",$Zi).$Ph);}function
slowQuery($G,$ki){if(min_version('5.7.8','10.1.2')){if(preg_match('~MariaDB~',$this->_conn->server_info))return"SET STATEMENT max_statement_time=$ki FOR $G";elseif(preg_match('~^(SELECT\b)(.+)~is',$G,$C))return"$C[1] /*+ MAX_EXECUTION_TIME(".($ki*1000).") */ $C[2]";}}function
convertSearch($u,$X,$n){return(preg_match('~char|text|enum|set~',$n["type"])&&!preg_match("~^utf8~",$n["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($u USING ".charset($this->_conn).")":$u);}function
warnings(){$H=$this->_conn->query("SHOW WARNINGS");if($H&&$H->num_rows){ob_start();select($H);return
ob_get_clean();}}function
tableHelp($D){$Ee=preg_match('~MariaDB~',$this->_conn->server_info);if(information_schema(DB))return
strtolower(($Ee?"information-schema-$D-table/":str_replace("_","-",$D)."-table.html"));if(DB=="mysql")return($Ee?"mysql$D-table/":"system-database.html");}}function
idf_escape($u){return"`".str_replace("`","``",$u)."`";}function
table($u){return
idf_escape($u);}function
connect(){global$b,$U,$Mh;$g=new
Min_DB;$Nb=$b->credentials();if($g->connect($Nb[0],$Nb[1],$Nb[2])){$g->set_charset(charset($g));$g->query("SET sql_quote_show_create = 1, autocommit = 1");if(min_version('5.7.8',10.2,$g)){$Mh[lang(25)][]="json";$U["json"]=4294967295;}return$g;}$I=$g->error;if(function_exists('iconv')&&!is_utf8($I)&&strlen($dh=iconv("windows-1250","utf-8",$I))>strlen($I))$I=$dh;return$I;}function
get_databases($hd){$I=get_session("dbs");if($I===null){$G=(min_version(5)?"SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME":"SHOW DATABASES");$I=($hd?slow_query($G):get_vals($G));restart_session();set_session("dbs",$I);stop_session();}return$I;}function
limit($G,$Z,$z,$mf=0,$nh=" "){return" $G$Z".($z!==null?$nh."LIMIT $z".($mf?" OFFSET $mf":""):"");}function
limit1($Q,$G,$Z,$nh="\n"){return
limit($G,$Z,1,0,$nh);}function
db_collation($k,$ob){global$g;$I=null;$i=$g->result("SHOW CREATE DATABASE ".idf_escape($k),1);if(preg_match('~ COLLATE ([^ ]+)~',$i,$C))$I=$C[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$i,$C))$I=$ob[$C[1]][-1];return$I;}function
engines(){$I=array();foreach(get_rows("SHOW ENGINES")as$J){if(preg_match("~YES|DEFAULT~",$J["Support"]))$I[]=$J["Engine"];}return$I;}function
logged_user(){global$g;return$g->result("SELECT USER()");}function
tables_list(){return
get_key_vals(min_version(5)?"SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME":"SHOW TABLES");}function
count_tables($j){$I=array();foreach($j
as$k)$I[$k]=count(get_vals("SHOW TABLES IN ".idf_escape($k)));return$I;}function
table_status($D="",$Wc=false){$I=array();foreach(get_rows($Wc&&min_version(5)?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($D!=""?"AND TABLE_NAME = ".q($D):"ORDER BY Name"):"SHOW TABLE STATUS".($D!=""?" LIKE ".q(addcslashes($D,"%_\\")):""))as$J){if($J["Engine"]=="InnoDB")$J["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$J["Comment"]);if(!isset($J["Engine"]))$J["Comment"]="";if($D!="")return$J;$I[$J["Name"]]=$J;}return$I;}function
is_view($R){return$R["Engine"]===null;}function
fk_support($R){return
preg_match('~InnoDB|IBMDB2I~i',$R["Engine"])||(preg_match('~NDB~i',$R["Engine"])&&min_version(5.6));}function
fields($Q){$I=array();foreach(get_rows("SHOW FULL COLUMNS FROM ".table($Q))as$J){preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$J["Type"],$C);$I[$J["Field"]]=array("field"=>$J["Field"],"full_type"=>$J["Type"],"type"=>$C[1],"length"=>$C[2],"unsigned"=>ltrim($C[3].$C[4]),"default"=>($J["Default"]!=""||preg_match("~char|set~",$C[1])?(preg_match('~text~',$C[1])?stripslashes(preg_replace("~^'(.*)'\$~",'\1',$J["Default"])):$J["Default"]):null),"null"=>($J["Null"]=="YES"),"auto_increment"=>($J["Extra"]=="auto_increment"),"on_update"=>(preg_match('~^on update (.+)~i',$J["Extra"],$C)?$C[1]:""),"collation"=>$J["Collation"],"privileges"=>array_flip(preg_split('~, *~',$J["Privileges"])),"comment"=>$J["Comment"],"primary"=>($J["Key"]=="PRI"),"generated"=>preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$J["Extra"]),);}return$I;}function
indexes($Q,$h=null){$I=array();foreach(get_rows("SHOW INDEX FROM ".table($Q),$h)as$J){$D=$J["Key_name"];$I[$D]["type"]=($D=="PRIMARY"?"PRIMARY":($J["Index_type"]=="FULLTEXT"?"FULLTEXT":($J["Non_unique"]?($J["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$I[$D]["columns"][]=$J["Column_name"];$I[$D]["lengths"][]=($J["Index_type"]=="SPATIAL"?null:$J["Sub_part"]);$I[$D]["descs"][]=null;}return$I;}function
foreign_keys($Q){global$g,$uf;static$fg='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$I=array();$Lb=$g->result("SHOW CREATE TABLE ".table($Q),1);if($Lb){preg_match_all("~CONSTRAINT ($fg) FOREIGN KEY ?\\(((?:$fg,? ?)+)\\) REFERENCES ($fg)(?:\\.($fg))? \\(((?:$fg,? ?)+)\\)(?: ON DELETE ($uf))?(?: ON UPDATE ($uf))?~",$Lb,$He,PREG_SET_ORDER);foreach($He
as$C){preg_match_all("~$fg~",$C[2],$Ah);preg_match_all("~$fg~",$C[5],$ci);$I[idf_unescape($C[1])]=array("db"=>idf_unescape($C[4]!=""?$C[3]:$C[4]),"table"=>idf_unescape($C[4]!=""?$C[4]:$C[3]),"source"=>array_map('idf_unescape',$Ah[0]),"target"=>array_map('idf_unescape',$ci[0]),"on_delete"=>($C[6]?$C[6]:"RESTRICT"),"on_update"=>($C[7]?$C[7]:"RESTRICT"),);}}return$I;}function
view($D){global$g;return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',$g->result("SHOW CREATE VIEW ".table($D),1)));}function
collations(){$I=array();foreach(get_rows("SHOW COLLATION")as$J){if($J["Default"])$I[$J["Charset"]][-1]=$J["Collation"];else$I[$J["Charset"]][]=$J["Collation"];}ksort($I);foreach($I
as$y=>$X)asort($I[$y]);return$I;}function
information_schema($k){return(min_version(5)&&$k=="information_schema")||(min_version(5.5)&&$k=="performance_schema");}function
adminer_error(){global$g;return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",$g->error));}function
create_database($k,$nb){return
queries("CREATE DATABASE ".idf_escape($k).($nb?" COLLATE ".q($nb):""));}function
drop_databases($j){$I=apply_queries("DROP DATABASE",$j,'idf_escape');restart_session();set_session("dbs",null);return$I;}function
rename_database($D,$nb){$I=false;if(create_database($D,$nb)){$S=array();$ej=array();foreach(tables_list()as$Q=>$T){if($T=='VIEW')$ej[]=$Q;else$S[]=$Q;}$I=(!$S&&!$ej)||move_tables($S,$ej,$D);drop_databases($I?array(DB):array());}return$I;}function
auto_increment(){$Na=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$v){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$v["columns"],true)){$Na="";break;}if($v["type"]=="PRIMARY")$Na=" UNIQUE";}}return" AUTO_INCREMENT$Na";}function
alter_table($Q,$D,$o,$jd,$ub,$Bc,$nb,$Ma,$Zf){$c=array();foreach($o
as$n)$c[]=($n[1]?($Q!=""?($n[0]!=""?"CHANGE ".idf_escape($n[0]):"ADD"):" ")." ".implode($n[1]).($Q!=""?$n[2]:""):"DROP ".idf_escape($n[0]));$c=array_merge($c,$jd);$O=($ub!==null?" COMMENT=".q($ub):"").($Bc?" ENGINE=".q($Bc):"").($nb?" COLLATE ".q($nb):"").($Ma!=""?" AUTO_INCREMENT=$Ma":"");if($Q=="")return
queries("CREATE TABLE ".table($D)." (\n".implode(",\n",$c)."\n)$O$Zf");if($Q!=$D)$c[]="RENAME TO ".table($D);if($O)$c[]=ltrim($O);return($c||$Zf?queries("ALTER TABLE ".table($Q)."\n".implode(",\n",$c).$Zf):true);}function
alter_indexes($Q,$c){foreach($c
as$y=>$X)$c[$y]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($Q).implode(",",$c));}function
truncate_tables($S){return
apply_queries("TRUNCATE TABLE",$S);}function
drop_views($ej){return
queries("DROP VIEW ".implode(", ",array_map('table',$ej)));}function
drop_tables($S){return
queries("DROP TABLE ".implode(", ",array_map('table',$S)));}function
move_tables($S,$ej,$ci){global$g;$Pg=array();foreach($S
as$Q)$Pg[]=table($Q)." TO ".idf_escape($ci).".".table($Q);if(!$Pg||queries("RENAME TABLE ".implode(", ",$Pg))){$dc=array();foreach($ej
as$Q)$dc[table($Q)]=view($Q);$g->select_db($ci);$k=idf_escape(DB);foreach($dc
as$D=>$dj){if(!queries("CREATE VIEW $D AS ".str_replace(" $k."," ",$dj["select"]))||!queries("DROP VIEW $k.$D"))return
false;}return
true;}return
false;}function
copy_tables($S,$ej,$ci){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($S
as$Q){$D=($ci==DB?table("copy_$Q"):idf_escape($ci).".".table($Q));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $D"))||!queries("CREATE TABLE $D LIKE ".table($Q))||!queries("INSERT INTO $D SELECT * FROM ".table($Q)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$J){$Bi=$J["Trigger"];if(!queries("CREATE TRIGGER ".($ci==DB?idf_escape("copy_$Bi"):idf_escape($ci).".".idf_escape($Bi))." $J[Timing] $J[Event] ON $D FOR EACH ROW\n$J[Statement];"))return
false;}}foreach($ej
as$Q){$D=($ci==DB?table("copy_$Q"):idf_escape($ci).".".table($Q));$dj=view($Q);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $D"))||!queries("CREATE VIEW $D AS $dj[select]"))return
false;}return
true;}function
trigger($D){if($D=="")return
array();$K=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($D));return
reset($K);}function
triggers($Q){$I=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")))as$J)$I[$J["Trigger"]]=array($J["Timing"],$J["Event"]);return$I;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($D,$T){global$g,$Dc,$Xd,$U;$Da=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$Bh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Gi="((".implode("|",array_merge(array_keys($U),$Da)).")\\b(?:\\s*\\(((?:[^'\")]|$Dc)++)\\))?\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$fg="$Bh*(".($T=="FUNCTION"?"":$Xd).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$Gi";$i=$g->result("SHOW CREATE $T ".idf_escape($D),2);preg_match("~\\(((?:$fg\\s*,?)*)\\)\\s*".($T=="FUNCTION"?"RETURNS\\s+$Gi\\s+":"")."(.*)~is",$i,$C);$o=array();preg_match_all("~$fg\\s*,?~is",$C[1],$He,PREG_SET_ORDER);foreach($He
as$Tf)$o[]=array("field"=>str_replace("``","`",$Tf[2]).$Tf[3],"type"=>strtolower($Tf[5]),"length"=>preg_replace_callback("~$Dc~s",'normalize_enum',$Tf[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$Tf[8] $Tf[7]"))),"null"=>1,"full_type"=>$Tf[4],"inout"=>strtoupper($Tf[1]),"collation"=>strtolower($Tf[9]),);if($T!="FUNCTION")return
array("fields"=>$o,"definition"=>$C[11]);return
array("fields"=>$o,"returns"=>array("type"=>$C[12],"length"=>$C[13],"unsigned"=>$C[15],"collation"=>$C[16]),"definition"=>$C[17],"language"=>"SQL",);}function
routines(){return
get_rows("SELECT ROUTINE_NAME AS SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = ".q(DB));}function
routine_languages(){return
array();}function
routine_id($D,$J){return
idf_escape($D);}function
last_id(){global$g;return$g->result("SELECT LAST_INSERT_ID()");}function
explain($g,$G){return$g->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$G);}function
found_rows($R,$Z){return($Z||$R["Engine"]!="InnoDB"?null:$R["Rows"]);}function
types(){return
array();}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($fh,$h=null){return
true;}function
create_sql($Q,$Ma,$Nh){global$g;$I=$g->result("SHOW CREATE TABLE ".table($Q),1);if(!$Ma)$I=preg_replace('~ AUTO_INCREMENT=\d+~','',$I);return$I;}function
truncate_sql($Q){return"TRUNCATE ".table($Q);}function
use_sql($Ub){return"USE ".idf_escape($Ub);}function
trigger_sql($Q){$I="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($Q,"%_\\")),null,"-- ")as$J)$I.="\nCREATE TRIGGER ".idf_escape($J["Trigger"])." $J[Timing] $J[Event] ON ".table($J["Table"])." FOR EACH ROW\n$J[Statement];;\n";return$I;}function
show_variables(){return
get_key_vals("SHOW VARIABLES");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
show_status(){return
get_key_vals("SHOW STATUS");}function
convert_field($n){if(preg_match("~binary~",$n["type"]))return"HEX(".idf_escape($n["field"]).")";if($n["type"]=="bit")return"BIN(".idf_escape($n["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($n["field"]).")";}function
unconvert_field($n,$I){if(preg_match("~binary~",$n["type"]))$I="UNHEX($I)";if($n["type"]=="bit")$I="CONV($I, 2, 10) + 0";if(preg_match("~geometry|point|linestring|polygon~",$n["type"])){$og=(min_version(8)?"ST_":"");$I=$og."GeomFromText($I, $og"."SRID($n[field]))";}return$I;}function
support($Xc){return!preg_match("~scheme|sequence|type|view_trigger|materializedview".(min_version(8)?"":"|descidx".(min_version(5.1)?"":"|event|partitioning".(min_version(5)?"":"|routine|trigger|view")))."~",$Xc);}function
kill_process($X){return
queries("KILL ".number($X));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){global$g;return$g->result("SELECT @@max_connections");}function
driver_config(){$U=array();$Mh=array();foreach(array(lang(27)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(28)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(25)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(81)=>array("enum"=>65535,"set"=>64),lang(29)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(31)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),)as$y=>$X){$U+=$X;$Mh[$y]=array_keys($X);}return
array('possible_drivers'=>array("MySQLi","MySQL","PDO_MySQL"),'jush'=>"sql",'types'=>$U,'structured_types'=>$Mh,'unsigned'=>array("unsigned","zerofill","unsigned zerofill"),'operators'=>array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL"),'functions'=>array("char_length","date","distinct","from_unixtime","unix_timestamp","lower","round","floor","ceil","sec_to_time","time_to_sec","upper"),'operator_regexp'=>'REGEXP','grouping'=>array("avg","count","count distinct","group_concat","max","min","sum"),'edit_functions'=>array(array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",),array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",)),);}}$yb=driver_config();$ng=$yb['possible_drivers'];$x=$yb['jush'];$U=$yb['types'];$Mh=$yb['structured_types'];$Ni=$yb['unsigned'];$_f=$yb['operators'];$zf=isset($yb['operator_regexp'])&&in_array($yb['operator_regexp'],$_f)?$yb['operator_regexp']:null;$rd=$yb['functions'];$xd=$yb['grouping'];$uc=$yb['edit_functions'];if($b->operators===null){$b->operators=$_f;$b->operator_regexp=$zf;}define("SERVER",$_GET[DRIVER]);define("DB",$_GET["db"]);define("ME",preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));$ia="4.8.3";function
page_header($mi,$m="",$Wa=array(),$ni=""){global$ca,$ia,$b,$mc,$x;page_headers();if(is_ajax()&&$m){page_messages($m);exit;}$oi=$mi.($ni!=""?": $ni":"");$pi=strip_tags($oi.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".$b->name());echo'<!DOCTYPE html>
<html lang="',$ca,'" dir="',lang(82),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<title>',$pi,'</title>
<link rel="stylesheet" type="text/css" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=4.8.3"),'">
',script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=4.8.3");if($b->head()){echo'<link rel="shortcut icon" type="image/x-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.3"),'">
<link rel="apple-touch-icon" href="',h(preg_replace("~\\?.*~","",ME)."?file=favicon.ico&version=4.8.3"),'">
';foreach($b->css()as$Pb){echo'<link rel="stylesheet" type="text/css" href="',h($Pb),'">
';}}echo'
<body class="',lang(82),' nojs">
';$p=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($p)&&filemtime($p)+86400>time()){$cj=unserialize(file_get_contents($p));$zg="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($cj["version"],base64_decode($cj["signature"]),$zg)==1)$_COOKIE["adminer_version"]=$cj["version"];}echo'<script',nonce(),'>
mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick',(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '$ia', '".js_escape(ME)."', '".get_token()."')");?>});
document.body.className = document.body.className.replace(/ nojs/, ' js');
var offlineMessage = '<?php echo
js_escape(lang(83)),'\';
var thousandsSeparator = \'',js_escape(lang(5)),'\';
</script>

<div id="help" class="jush-',$x,' jsonly hidden"></div>
',script("mixin(qs('#help'), {onmouseover: function () { helpOpen = 1; }, onmouseout: helpMouseout});"),'
<div id="content">
';if($Wa!==null){$_=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($_?$_:".").'">'.$mc[DRIVER].'</a> &raquo; ';$_=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$M=$b->serverName(SERVER);$M=($M!=""?$M:lang(34));if($Wa===false)echo"$M\n";else{echo"<a href='".h($_)."' accesskey='1' title='Alt+Shift+1'>$M</a> &raquo; ";if($_GET["ns"]!=""||(DB!=""&&is_array($Wa)))echo'<a href="'.h($_."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> &raquo; ';if(is_array($Wa)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> &raquo; ';foreach($Wa
as$y=>$X){$fc=(is_array($X)?$X[1]:h($X));if($fc!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$fc</a> &raquo; ";}}echo"$mi\n";}}echo"<h2>$oi</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($m);$j=&get_session("dbs");if(DB!=""&&$j&&!in_array(DB,$j,true))$j=null;stop_session();define("PAGE_HEADER",1);}function
page_headers(){global$b;header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach($b->csp()as$Ob){$Cd=array();foreach($Ob
as$y=>$X)$Cd[]="$y $X";header("Content-Security-Policy: ".implode("; ",$Cd));}$b->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$gf;if(!$gf)$gf=base64_encode(rand_string());return$gf;}function
page_messages($m){$Pi=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$Te=$_SESSION["messages"][$Pi];if($Te){echo"<div class='message'>".implode("</div>\n<div class='message'>",$Te)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Pi]);}if($m)echo"<div class='error'>$m</div>\n";}function
page_footer($We=""){global$b,$ti;echo'</div>

';switch_lang();if($We!="auth"){echo'<form action="" method="post">
<p class="logout">
<input type="submit" name="logout" value="',lang(84),'" id="logout">
<input type="hidden" name="token" value="',$ti,'">
</p>
</form>
';}echo'<div id="menu">
';$b->navigation($We);echo'</div>
',script("setupSubmitHighlight(document);"),script("setupCopyToClipboard(document);"),"</body>\n</html>";}function
int32($Ze){while($Ze>=2147483648)$Ze-=4294967296;while($Ze<=-2147483649)$Ze+=4294967296;return(int)$Ze;}function
long2str($W,$gj){$dh='';foreach($W
as$X)$dh.=pack('V',$X);if($gj)return
substr($dh,0,end($W));return$dh;}function
str2long($dh,$gj){$W=array_values(unpack('V*',str_pad($dh,4*ceil(strlen($dh)/4),"\0")));if($gj)$W[]=strlen($dh);return$W;}function
xxtea_mx($sj,$rj,$Qh,$je){return
int32((($sj>>5&0x7FFFFFF)^$rj<<2)+(($rj>>3&0x1FFFFFFF)^$sj<<4))^int32(($Qh^$rj)+($je^$sj));}function
encrypt_string($Lh,$y){if($Lh=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Lh,true);$Ze=count($W)-1;$sj=$W[$Ze];$rj=$W[0];$_g=floor(6+52/($Ze+1));$Qh=0;while($_g-->0){$Qh=int32($Qh+0x9E3779B9);$tc=$Qh>>2&3;for($Rf=0;$Rf<$Ze;$Rf++){$rj=$W[$Rf+1];$Ye=xxtea_mx($sj,$rj,$Qh,$y[$Rf&3^$tc]);$sj=int32($W[$Rf]+$Ye);$W[$Rf]=$sj;}$rj=$W[0];$Ye=xxtea_mx($sj,$rj,$Qh,$y[$Rf&3^$tc]);$sj=int32($W[$Ze]+$Ye);$W[$Ze]=$sj;}return
long2str($W,false);}function
decrypt_string($Lh,$y){if($Lh=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($Lh,false);$Ze=count($W)-1;$sj=$W[$Ze];$rj=$W[0];$_g=floor(6+52/($Ze+1));$Qh=int32($_g*0x9E3779B9);while($Qh){$tc=$Qh>>2&3;for($Rf=$Ze;$Rf>0;$Rf--){$sj=$W[$Rf-1];$Ye=xxtea_mx($sj,$rj,$Qh,$y[$Rf&3^$tc]);$rj=int32($W[$Rf]-$Ye);$W[$Rf]=$rj;}$sj=$W[$Ze];$Ye=xxtea_mx($sj,$rj,$Qh,$y[$Rf&3^$tc]);$rj=int32($W[0]-$Ye);$W[0]=$rj;$Qh=int32($Qh-0x9E3779B9);}return
long2str($W,true);}$g='';$Bd=$_SESSION["token"];if(!$Bd)$_SESSION["token"]=rand(1,1e6);$ti=get_token();$hg=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$hg[$y]=$X;}}function
add_invalid_login(){global$b;$pd=file_open_lock(get_temp_dir()."/adminer.invalid");if(!$pd)return;$ce=unserialize(stream_get_contents($pd));$ji=time();if($ce){foreach($ce
as$de=>$X){if($X[0]<$ji)unset($ce[$de]);}}$be=&$ce[$b->bruteForceKey()];if(!$be)$be=array($ji+30*60,0);$be[1]++;file_write_unlock($pd,serialize($ce));}function
check_invalid_login(){global$b;$ce=unserialize(@file_get_contents(get_temp_dir()."/adminer.invalid"));$be=($ce?$ce[$b->bruteForceKey()]:array());$ff=($be[1]>29?$be[0]-time():0);if($ff>0)auth_error(lang(85,ceil($ff/60)));}$Ka=$_POST["auth"];if($Ka){session_regenerate_id();$bj=$Ka["driver"];$M=$Ka["server"];$V=$Ka["username"];$F=(string)$Ka["password"];$k=$Ka["db"];set_password($bj,$M,$V,$F);$_SESSION["db"][$bj][$M][$V][$k]=true;if($Ka["permanent"]){$y=base64_encode($bj)."-".base64_encode($M)."-".base64_encode($V)."-".base64_encode($k);$tg=$b->permanentLogin(true);$hg[$y]="$y:".base64_encode($tg?encrypt_string($F,$tg):"");cookie("adminer_permanent",implode(" ",$hg));}if(count($_POST)==1||DRIVER!=$bj||SERVER!=$M||$_GET["username"]!==$V||DB!=$k)adminer_redirect(auth_url($bj,$M,$V,$k));}elseif($_POST["logout"]&&(!$Bd||verify_token())){foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent();adminer_redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(86).'.');}elseif($hg&&!$_SESSION["pwds"]){session_regenerate_id();$tg=$b->permanentLogin();foreach($hg
as$y=>$X){list(,$hb)=explode(":",$X);list($bj,$M,$V,$k)=array_map('base64_decode',explode("-",$y));set_password($bj,$M,$V,decrypt_string(base64_decode($hb),$tg));$_SESSION["db"][$bj][$M][$V][$k]=true;}}function
unset_permanent(){global$hg;foreach($hg
as$y=>$X){list($bj,$M,$V,$k)=array_map('base64_decode',explode("-",$y));if($bj==DRIVER&&$M==SERVER&&$V==$_GET["username"]&&$k==DB)unset($hg[$y]);}cookie("adminer_permanent",implode(" ",$hg));}function
auth_error($m){global$b,$Bd;$sh=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$sh]||$_GET[$sh])&&!$Bd)$m=lang(87);else{restart_session();add_invalid_login();$F=get_password();if($F!==null){if($F===false)$m.=($m?'<br>':'').lang(88,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent();}}if(!$_COOKIE[$sh]&&$_GET[$sh]&&ini_bool("session.use_only_cookies"))$m=lang(89);$Uf=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?$_COOKIE["adminer_key"]:rand_string()),$Uf["lifetime"]);page_header(lang(38),$m,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(90)."\n";echo"</div>\n";$b->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists("Min_DB")){unset($_SESSION["pwds"][DRIVER]);unset_permanent();page_header(lang(91),lang(92,implode(", ",$ng)),false);page_footer("auth");exit;}stop_session(true);if(isset($_GET["username"])){list($Hd,$jg)=explode(":",SERVER,2);if(preg_match('~^\s*([-+]?\d+)~',$jg,$C)&&($C[1]<1024||$C[1]>65535))auth_error(lang(93));check_invalid_login();$g=connect();$l=new
Min_Driver($g);}$Be=null;if(!is_object($g)||($Be=$b->login($_GET["username"],get_password()))!==true){$m=(is_string($g)?h($g):(is_string($Be)?$Be:lang(32)));auth_error($m.(preg_match('~^ | $~',get_password())?'<br>'.lang(94):''));}if($_POST["logout"]&&$Bd&&!verify_token()){page_header(lang(84),lang(95));page_footer("db");exit;}if($Ka&&$_POST["token"])$_POST["token"]=$ti;$m='';if($_POST){if(!verify_token()){$Wd="max_input_vars";$Ne=ini_get($Wd);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$Ne||$X<$Ne)){$Wd=$y;$Ne=$X;}}}$m=(!$_POST["token"]&&$Ne?lang(96,"'$Wd'"):lang(95).' '.lang(97));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$m=lang(98,"'post_max_size'");if(isset($_GET["sql"]))$m.=' '.lang(99);}function
select($H,$h=null,$Hf=array(),$z=0){global$x;$A=array();$w=array();$e=array();$Ua=array();$U=array();$I=array();odd('');for($s=0;(!$z||$s<$z)&&($J=$H->fetch_row());$s++){if(!$s){echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap'>\n","<thead><tr>";for($ie=0;$ie<count($J);$ie++){$n=$H->fetch_field();$D=$n->name;$Gf=$n->orgtable;$Ff=$n->orgname;$I[$n->table]=$Gf;if($Hf&&$x=="sql")$A[$ie]=($D=="table"?"table=":($D=="possible_keys"?"indexes=":null));elseif($Gf!=""){if(!isset($w[$Gf])){$w[$Gf]=array();foreach(indexes($Gf,$h)as$v){if($v["type"]=="PRIMARY"){$w[$Gf]=array_flip($v["columns"]);break;}}$e[$Gf]=$w[$Gf];}if(isset($e[$Gf][$Ff])){unset($e[$Gf][$Ff]);$w[$Gf][$Ff]=$ie;$A[$ie]=$Gf;}}if($n->charsetnr==63)$Ua[$ie]=true;$U[$ie]=$n->type;echo"<th".($Gf!=""||$n->name!=$Ff?" title='".h(($Gf!=""?"$Gf.":"").$Ff)."'":"").">".h($D).($Hf?adminer_doc_link(array('sql'=>"explain-output.html#explain_".strtolower($D),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr".odd().">";foreach($J
as$y=>$X){$_="";if(isset($A[$y])&&!$e[$A[$y]]){if($Hf&&$x=="sql"){$Q=$J[array_search("table=",$A)];$_=ME.$A[$y].urlencode($Hf[$Q]!=""?$Hf[$Q]:$Q);}else{$_=ME."edit=".urlencode($A[$y]);foreach($w[$A[$y]]as$lb=>$ie)$_.="&where".urlencode("[".bracket_escape($lb)."]")."=".urlencode($J[$ie]);}}elseif(is_url($X))$_=$X;if($X===null)$X="<i>NULL</i>";elseif($Ua[$y]&&!is_utf8($X))$X="<i>".lang(48,strlen($X))."</i>";else{$X=h($X);if($U[$y]==254)$X="<code>$X</code>";}if($_)$X="<a href='".h($_)."'".(is_url($_)?target_blank():'').">$X</a>";echo"<td>$X";}}echo($s?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$I;}function
referencable_primary($lh){$I=array();foreach(table_status('',true)as$Uh=>$Q){if($Uh!=$lh&&fk_support($Q)){foreach(fields($Uh)as$n){if($n["primary"]){if($I[$Uh]){unset($I[$Uh]);break;}$I[$Uh]=$n;}}}}return$I;}function
adminer_settings(){parse_str($_COOKIE["adminer_settings"],$uh);return$uh;}function
adminer_setting($y){$uh=adminer_settings();return$uh[$y];}function
set_adminer_settings($uh){return
cookie("adminer_settings",http_build_query($uh+adminer_settings()));}function
textarea($D,$Y,$K=10,$qb=80){global$x;echo"<textarea name='".h($D)."' rows='$K' cols='$qb' class='sqlarea jush-$x' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
edit_type($y,$n,$ob,$ld=array(),$Tc=array()){global$Mh,$U,$Ni,$uf;$T=$n["type"];echo'<td><select name="',h($y),'[type]" class="type" aria-labelledby="label-type">';if($T&&!isset($U[$T])&&!isset($ld[$T])&&!in_array($T,$Tc))$Tc[]=$T;if($ld)$Mh[lang(100)]=$ld;echo
optionlist(array_merge($Tc,$Mh),$T),'</select><td><input name="',h($y),'[length]" value="',h($n["length"]),'" size="3"',(!$n["length"]&&preg_match('~var(char|binary)$~',$T)?" class='required'":"");echo' aria-labelledby="label-length"><td class="options">',"<select name='".h($y)."[collation]'".(preg_match('~(char|text|enum|set)$~',$T)?"":" class='hidden'").'><option value="">('.lang(101).')'.optionlist($ob,$n["collation"]).'</select>',($Ni?"<select name='".h($y)."[unsigned]'".(!$T||preg_match(number_type(),$T)?"":" class='hidden'").'><option>'.optionlist($Ni,$n["unsigned"]).'</select>':''),(isset($n['on_update'])?"<select name='".h($y)."[on_update]'".(preg_match('~timestamp|datetime~',$T)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(102).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"CURRENT_TIMESTAMP":$n["on_update"])).'</select>':''),($ld?"<select name='".h($y)."[on_delete]'".(preg_match("~`~",$T)?"":" class='hidden'")."><option value=''>(".lang(103).")".optionlist(explode("|",$uf),$n["on_delete"])."</select> ":" ");}function
process_length($ye){global$Dc;return(preg_match("~^\\s*\\(?\\s*$Dc(?:\\s*,\\s*$Dc)*+\\s*\\)?\\s*\$~",$ye)&&preg_match_all("~$Dc~",$ye,$He)?"(".implode(",",$He[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$ye)));}function
process_type($n,$mb="COLLATE"){global$Ni;return" $n[type]".process_length($n["length"]).(preg_match(number_type(),$n["type"])&&in_array($n["unsigned"],$Ni)?" $n[unsigned]":"").(preg_match('~char|text|enum|set~',$n["type"])&&$n["collation"]?" $mb ".q($n["collation"]):"");}function
process_field($n,$Fi){return
array(idf_escape(trim($n["field"])),process_type($Fi),($n["null"]?" NULL":" NOT NULL"),default_value($n),(preg_match('~timestamp|datetime~',$n["type"])&&$n["on_update"]?" ON UPDATE $n[on_update]":""),(support("comment")&&$n["comment"]!=""?" COMMENT ".q($n["comment"]):""),($n["auto_increment"]?auto_increment():null),);}function
default_value($n){$ac=$n["default"];return($ac===null?"":" DEFAULT ".(preg_match('~char|binary|text|enum|set~',$n["type"])||preg_match('~^(?![a-z])~i',$ac)?q($ac):$ac));}function
type_class($T){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$y=>$X){if(preg_match("~$y|$X~",$T))return" class='$y'";}}function
edit_fields($o,$ob,$T="TABLE",$ld=array()){global$Xd;$o=array_values($o);$bc=(($_POST?$_POST["defaults"]:adminer_setting("defaults"))?"":" class='hidden'");$vb=(($_POST?$_POST["comments"]:adminer_setting("comments"))?"":" class='hidden'");echo'<thead><tr>
';if($T=="PROCEDURE"){echo'<td>';}echo'<th id="label-name">',($T=="TABLE"?lang(104):lang(105)),'<td id="label-type">',lang(50),'<textarea id="enum-edit" rows="4" cols="12" wrap="off" style="display: none;"></textarea>',script("qs('#enum-edit').onblur = editingLengthBlur;"),'<td id="label-length">',lang(106),'<td>',lang(107);if($T=="TABLE"){echo'<td id="label-null">NULL
<td><input type="radio" name="auto_increment_col" value=""><acronym id="label-ai" title="',lang(52),'">AI</acronym>',adminer_doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype.html#DATATYPE-SERIAL",'mssql'=>"ms186775.aspx",)),'<td id="label-default"',$bc,'>',lang(53),(support("comment")?"<td id='label-comment'$vb>".lang(51):"");}echo'<td>',"<input type='image' class='icon' name='add[".(support("move_col")?0:count($o))."]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.3")."' alt='+' title='".lang(108)."'>".script("row_count = ".count($o).";"),'</thead>
<tbody>
',script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($o
as$s=>$n){$s++;$If=$n[($_POST?"orig":"field")];$jc=(isset($_POST["add"][$s-1])||(isset($n["field"])&&!$_POST["drop_col"][$s]))&&(support("drop_col")||$If=="");echo'<tr',($jc?"":" style='display: none;'"),'>
',($T=="PROCEDURE"?"<td>".html_select("fields[$s][inout]",explode("|",$Xd),$n["inout"]):""),'<th>';if($jc){echo'<input name="fields[',$s,'][field]" value="',h($n["field"]),'" data-maxlength="64" autocapitalize="off" aria-labelledby="label-name">';}echo'<input type="hidden" name="fields[',$s,'][orig]" value="',h($If),'">';edit_type("fields[$s]",$n,$ob,$ld);if($T=="TABLE"){echo'<td>',checkbox("fields[$s][null]",1,$n["null"],"","","block","label-null"),'<td><label class="block"><input type="radio" name="auto_increment_col" value="',$s,'"';if($n["auto_increment"]){echo' checked';}echo' aria-labelledby="label-ai"></label><td',$bc,'>',checkbox("fields[$s][has_default]",1,$n["has_default"],"","","","label-default"),'<input name="fields[',$s,'][default]" value="',h($n["default"]),'" aria-labelledby="label-default">',(support("comment")?"<td$vb><input name='fields[$s][comment]' value='".h($n["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");}echo"<td>",(support("move_col")?"<input type='image' class='icon' name='add[$s]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.3")."' alt='+' title='".lang(108)."'> "."<input type='image' class='icon' name='up[$s]' src='".h(preg_replace("~\\?.*~","",ME)."?file=up.gif&version=4.8.3")."' alt='↑' title='".lang(109)."'> "."<input type='image' class='icon' name='down[$s]' src='".h(preg_replace("~\\?.*~","",ME)."?file=down.gif&version=4.8.3")."' alt='↓' title='".lang(110)."'> ":""),($If==""||support("drop_col")?"<input type='image' class='icon' name='drop_col[$s]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.3")."' alt='x' title='".lang(111)."'>":"");}}function
process_fields(&$o){$mf=0;if($_POST["up"]){$se=0;foreach($o
as$y=>$n){if(key($_POST["up"])==$y){unset($o[$y]);array_splice($o,$se,0,array($n));break;}if(isset($n["field"]))$se=$mf;$mf++;}}elseif($_POST["down"]){$nd=false;foreach($o
as$y=>$n){if(isset($n["field"])&&$nd){unset($o[key($_POST["down"])]);array_splice($o,$mf,0,array($nd));break;}if(key($_POST["down"])==$y)$nd=$n;$mf++;}}elseif($_POST["add"]){$o=array_values($o);array_splice($o,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum($C){return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($C[0][0].$C[0][0],$C[0][0],substr($C[0],1,-1))),'\\'))."'";}function
grant($sd,$vg,$e,$tf){if(!$vg)return
true;if($vg==array("ALL PRIVILEGES","GRANT OPTION"))return($sd=="GRANT"?queries("$sd ALL PRIVILEGES$tf WITH GRANT OPTION"):queries("$sd ALL PRIVILEGES$tf")&&queries("$sd GRANT OPTION$tf"));return
queries("$sd ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$vg).$e).$tf);}function
drop_create($nc,$i,$oc,$gi,$qc,$B,$Se,$Qe,$Re,$qf,$df){if($_POST["drop"])query_redirect($nc,$B,$Se);elseif($qf=="")query_redirect($i,$B,$Re);elseif($qf!=$df){$Mb=queries($i);queries_redirect($B,$Qe,$Mb&&queries($nc));if($Mb)queries($oc);}else
queries_redirect($B,$Qe,queries($gi)&&queries($qc)&&queries($nc)&&queries($i));}function
create_trigger($tf,$J){global$x;$li=" $J[Timing] $J[Event]".(preg_match('~ OF~',$J["Event"])?" $J[Of]":"");return"CREATE TRIGGER ".idf_escape($J["Trigger"]).($x=="mssql"?$tf.$li:$li.$tf).rtrim(" $J[Type]\n$J[Statement]",";").";";}function
create_routine($Zg,$J){global$Xd,$x;$N=array();$o=(array)$J["fields"];ksort($o);foreach($o
as$n){if($n["field"]!="")$N[]=(preg_match("~^($Xd)\$~",$n["inout"])?"$n[inout] ":"").idf_escape($n["field"]).process_type($n,"CHARACTER SET");}$cc=rtrim("\n$J[definition]",";");return"CREATE $Zg ".idf_escape(trim($J["name"]))." (".implode(", ",$N).")".(isset($_GET["function"])?" RETURNS".process_type($J["returns"],"CHARACTER SET"):"").($J["language"]?" LANGUAGE $J[language]":"").($x=="pgsql"?" AS ".q($cc):"$cc;");}function
remove_definer($G){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$G);}function
format_foreign_key($q){global$uf;$k=$q["db"];$hf=$q["ns"];return" FOREIGN KEY (".implode(", ",array_map('idf_escape',$q["source"])).") REFERENCES ".($k!=""&&$k!=$_GET["db"]?idf_escape($k).".":"").($hf!=""&&$hf!=$_GET["ns"]?idf_escape($hf).".":"").table($q["table"])." (".implode(", ",array_map('idf_escape',$q["target"])).")".(preg_match("~^($uf)\$~",$q["on_delete"])?" ON DELETE $q[on_delete]":"").(preg_match("~^($uf)\$~",$q["on_update"])?" ON UPDATE $q[on_update]":"");}function
tar_file($p,$qi){$I=pack("a100a8a8a8a12a12",$p,644,0,0,decoct($qi->size),decoct(time()));$gb=8*32;for($s=0;$s<strlen($I);$s++)$gb+=ord($I[$s]);$I.=sprintf("%06o",$gb)."\0 ";echo$I,str_repeat("\0",512-strlen($I));$qi->send();echo
str_repeat("\0",511-($qi->size+511)%512);}function
ini_bytes($Wd){$X=ini_get($Wd);switch(strtolower(substr($X,-1))){case'g':$X*=1024;case'm':$X*=1024;case'k':$X*=1024;}return$X;}function
adminer_doc_link($eg,$hi="<sup>?</sup>"){global$x,$g;$qh=$g->server_info;$cj=preg_replace('~^(\d\.?\d).*~s','\1',$qh);$Ri=array('sql'=>"https://dev.mysql.com/doc/refman/$cj/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/$cj/",'mssql'=>"https://msdn.microsoft.com/library/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$qh)."&id=",);if(preg_match('~MariaDB~',$qh)){$Ri['sql']="https://mariadb.com/kb/en/library/";$eg['sql']=(isset($eg['mariadb'])?$eg['mariadb']:str_replace(".html","/",$eg['sql']));}return($eg[$x]?"<a href='".h($Ri[$x].$eg[$x])."'".target_blank().">$hi</a>":"");}function
ob_gzencode($P){return
gzencode($P);}function
db_size($k){global$g;if(!$g->select_db($k))return"?";$I=0;foreach(table_status()as$R)$I+=$R["Data_length"]+$R["Index_length"];return
format_number($I);}function
set_utf8mb4($i){global$g;static$N=false;if(!$N&&preg_match('~\butf8mb4~i',$i)){$N=true;echo"SET NAMES ".charset($g).";\n\n";}}function
connect_error(){global$b,$g,$ti,$m,$mc;if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(37).": ".h(DB),lang(112),true);}else{if($_POST["db"]&&!$m)queries_redirect(substr(ME,0,-1),lang(113),drop_databases($_POST["db"]));page_header(lang(114),$m,false);$xa=['database'=>lang(115),'privileges'=>lang(72),'processlist'=>lang(116),'variables'=>lang(117),'status'=>lang(118),];$A=[];foreach($xa
as$y=>$X){if(support($y))$A[]="<a href='".h(ME)."$y='>$X</a>";}echo
generate_linksbar($A),"<p>".lang(119,$mc[DRIVER],"<b>".h($g->server_info)."</b>","<b>$g->extension</b>")."\n","<p>".lang(120,"<b>".h(logged_user())."</b>")."\n";$j=$b->databases();if($j){$gh=support("scheme");$ob=collations();echo"<form action='' method='post'>\n","<table cellspacing='0' class='checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(37)." - <a href='".h(ME)."refresh=1'>".lang(121)."</a>"."<td>".lang(122)."<td>".lang(123)."<td>".lang(124)." - <a href='".h(ME)."dbsize=1'>".lang(125)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$j=($_GET["dbsize"]?count_tables($j):array_flip($j));foreach($j
as$k=>$S){$Yg=h(ME)."db=".urlencode($k);$t=h("Db-".$k);echo"<tr".odd().">".(support("database")?"<td>".checkbox("db[]",$k,in_array($k,(array)$_POST["db"]),"","","",$t):""),"<th><a href='$Yg' id='$t'>".h($k)."</a>";$nb=h(db_collation($k,$ob));echo"<td>".(support("database")?"<a href='$Yg".($gh?"&amp;ns=":"")."&amp;database=' title='".lang(68)."'>$nb</a>":$nb),"<td align='right'><a href='$Yg&amp;schema=' id='tables-".h($k)."' title='".lang(71)."'>".($_GET["dbsize"]?$S:"?")."</a>","<td align='right' id='size-".h($k)."'>".($_GET["dbsize"]?db_size($k):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(126)." <span id='selected'></span></legend><div>\n"."<input type='hidden' name='all' value=''>".script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(127)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),"<input type='hidden' name='token' value='$ti'>\n","</form>\n",script("tableCheck();");}}page_footer("db");}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?$g->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}connect_error();exit;}if(support("scheme")){if(DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))adminer_redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(78).": ".h($_GET["ns"]),lang(128),true);page_footer("ns");exit;}}}$uf="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";class
TmpFile{var$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($Fb){$this->size+=strlen($Fb);fwrite($this->handler,$Fb);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}$Dc="'(?:''|[^'\\\\]|\\\\.)*'";$Xd="IN|OUT|INOUT";if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$o=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$L=array(idf_escape($_GET["field"]));$H=$l->select($a,$L,array(where($_GET,$o)),$L);$J=($H?$H->fetch_row():array());echo$l->value($J[0],$o[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$o=fields($a);if(!$o)$m=adminer_error();$R=table_status1($a,true);$D=$b->tableName($R);page_header(($o&&is_view($R)?$R['Engine']=='materialized view'?lang(129):lang(130):lang(131)).": ".($D!=""?$D:h($a)),$m);$b->selectLinks($R);$ub=$R["Comment"];if($ub!="")echo"<p class='nowrap'>".lang(51).": ".h($ub)."\n";if($o)$b->tableStructurePrint($o);if(!is_view($R)){if(support("indexes")){echo"<h3 id='indexes'>".lang(132)."</h3>\n";$w=indexes($a);if($w)$b->tableIndexesPrint($w);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(133)."</a>\n";}if(fk_support($R)){echo"<h3 id='foreign-keys'>".lang(100)."</h3>\n";$ld=foreign_keys($a);if($ld){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(134)."<td>".lang(135)."<td>".lang(103)."<td>".lang(102)."<td></thead>\n";foreach($ld
as$D=>$q){echo"<tr title='".h($D)."'>","<th><i>".implode("</i>, <i>",array_map('h',$q["source"]))."</i>","<td><a href='".h($q["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($q["db"]),ME):($q["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($q["ns"]),ME):ME))."table=".urlencode($q["table"])."'>".($q["db"]!=""?"<b>".h($q["db"])."</b>.":"").($q["ns"]!=""?"<b>".h($q["ns"])."</b>.":"").h($q["table"])."</a>","(<i>".implode("</i>, <i>",array_map('h',$q["target"]))."</i>)","<td>".h($q["on_delete"])."\n","<td>".h($q["on_update"])."\n",'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($D)).'">'.lang(136).'</a>';}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(137)."</a>\n";}}if(support(is_view($R)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(138)."</h3>\n";$Ei=triggers($a);if($Ei){echo"<table cellspacing='0'>\n";foreach($Ei
as$y=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($y)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($y))."'>".lang(136)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(139)."</a>\n";}}elseif(isset($_GET["schema"])){page_header(lang(71),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$Wh=array();$Xh=array();$ea=($_GET["schema"]?$_GET["schema"]:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$ea,$He,PREG_SET_ORDER);foreach($He
as$s=>$C){$Wh[$C[1]]=array($C[2],$C[3]);$Xh[]="\n\t'".js_escape($C[1])."': [ $C[2], $C[3] ]";}$ui=0;$Ra=-1;$fh=array();$Kg=array();$we=array();foreach(table_status('',true)as$Q=>$R){if(is_view($R))continue;$kg=0;$fh[$Q]["fields"]=array();foreach(fields($Q)as$D=>$n){$kg+=1.25;$n["pos"]=$kg;$fh[$Q]["fields"][$D]=$n;}$fh[$Q]["pos"]=($Wh[$Q]?$Wh[$Q]:array($ui,0));foreach($b->foreignKeys($Q)as$X){if(!$X["db"]){$ue=$Ra;if($Wh[$Q][1]||$Wh[$X["table"]][1])$ue=min(floatval($Wh[$Q][1]),floatval($Wh[$X["table"]][1]))-1;else$Ra-=.1;while($we[(string)$ue])$ue-=.0001;$fh[$Q]["references"][$X["table"]][(string)$ue]=array($X["source"],$X["target"]);$Kg[$X["table"]][$Q][(string)$ue]=$X["target"];$we[(string)$ue]=true;}}$ui=max($ui,$fh[$Q]["pos"][0]+2.5+$kg);}echo'<div id="schema" style="height: ',$ui,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = function () { return false; };
var tablePos = {',implode(",",$Xh)."\n",'};
var em = qs(\'#schema\').offsetHeight / ',$ui,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($fh
as$D=>$Q){echo"<div class='table' style='top: ".$Q["pos"][0]."em; left: ".$Q["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($D).'"><b>'.h($D)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($Q["fields"]as$n){$X='<span'.type_class($n["type"]).' title="'.h($n["full_type"].($n["null"]?" NULL":'')).'">'.h($n["field"]).'</span>';echo"<br>".($n["primary"]?"<i>$X</i>":$X);}foreach((array)$Q["references"]as$di=>$Lg){foreach($Lg
as$ue=>$Hg){$ve=$ue-$Wh[$D][1];$s=0;foreach($Hg[0]as$Ah)echo"\n<div class='references' title='".h($di)."' id='refs$ue-".($s++)."' style='left: $ve"."em; top: ".$Q["fields"][$Ah]["pos"]."em; padding-top: .5em;'><div style='border-top: 1px solid Gray; width: ".(-$ve)."em;'></div></div>";}}foreach((array)$Kg[$D]as$di=>$Lg){foreach($Lg
as$ue=>$e){$ve=$ue-$Wh[$D][1];$s=0;foreach($e
as$ci)echo"\n<div class='references' title='".h($di)."' id='refd$ue-".($s++)."' style='left: $ve"."em; top: ".$Q["fields"][$ci]["pos"]."em; height: 1.25em; background: url(".h(preg_replace("~\\?.*~","",ME)."?file=arrow.gif) no-repeat right center;&version=4.8.3")."'><div style='height: .5em; border-bottom: 1px solid Gray; width: ".(-$ve)."em;'></div></div>";}}echo"\n</div>\n";}foreach($fh
as$D=>$Q){foreach((array)$Q["references"]as$di=>$Lg){foreach($Lg
as$ue=>$Hg){$Ve=$ui;$Le=-10;foreach($Hg[0]as$y=>$Ah){$lg=$Q["pos"][0]+$Q["fields"][$Ah]["pos"];$mg=$fh[$di]["pos"][0]+$fh[$di]["fields"][$Hg[1][$y]]["pos"];$Ve=min($Ve,$lg,$mg);$Le=max($Le,$lg,$mg);}echo"<div class='references' id='refl$ue' style='left: $ue"."em; top: $Ve"."em; padding: .5em 0;'><div style='border-right: 1px solid Gray; margin-top: 1px; height: ".($Le-$Ve)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($ea)),'" id="schema-link">',lang(140),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$m){$Ib="";foreach(array("output","format","db_style","routines","events","table_style","auto_increment","triggers","data_style")as$y)$Ib.="&$y=".urlencode($_POST[$y]);cookie("adminer_export",substr($Ib,1));$S=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Qc=dump_headers((count($S)==1?key($S):DB),(DB==""||count($S)>1));$fe=preg_match('~sql~',$_POST["format"]);if($fe){echo"-- Adminer $ia ".$mc[DRIVER]." ".str_replace("\n"," ",$g->server_info)." dump\n\n";if($x=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";$g->query("SET time_zone = '+00:00'");$g->query("SET sql_mode = ''");}}$Nh=$_POST["db_style"];$j=array(DB);if(DB==""){$j=$_POST["databases"];if(is_string($j))$j=explode("\n",rtrim(str_replace("\r","",$j),"\n"));}foreach((array)$j
as$k){$b->dumpDatabase($k);if($g->select_db($k)){if($fe&&preg_match('~CREATE~',$Nh)&&($i=$g->result("SHOW CREATE DATABASE ".idf_escape($k),1))){set_utf8mb4($i);if($Nh=="DROP+CREATE")echo"DROP DATABASE IF EXISTS ".idf_escape($k).";\n";echo"$i;\n";}if($fe){if($Nh)echo
use_sql($k).";\n\n";$Of="";if($_POST["routines"]){foreach(array("FUNCTION","PROCEDURE")as$Zg){foreach(get_rows("SHOW $Zg STATUS WHERE Db = ".q($k),null,"-- ")as$J){$i=remove_definer($g->result("SHOW CREATE $Zg ".idf_escape($J["Name"]),2));set_utf8mb4($i);$Of.=($Nh!='DROP+CREATE'?"DROP $Zg IF EXISTS ".idf_escape($J["Name"]).";;\n":"")."$i;;\n\n";}}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$J){$i=remove_definer($g->result("SHOW CREATE EVENT ".idf_escape($J["Name"]),3));set_utf8mb4($i);$Of.=($Nh!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($J["Name"]).";;\n":"")."$i;;\n\n";}}if($Of)echo"DELIMITER ;;\n\n$Of"."DELIMITER ;\n\n";}if($_POST["table_style"]||$_POST["data_style"]){$ej=array();foreach(table_status('',true)as$D=>$R){$Q=(DB==""||in_array($D,(array)$_POST["tables"]));$Sb=(DB==""||in_array($D,(array)$_POST["data"]));if($Q||$Sb){if($Qc=="tar"){$qi=new
TmpFile;ob_start(array($qi,'write'),1e5);}$b->dumpTable($D,($Q?$_POST["table_style"]:""),(is_view($R)?2:0));if(is_view($R))$ej[]=$D;elseif($Sb){$o=fields($D);$b->dumpData($D,$_POST["data_style"],"SELECT *".convert_fields($o,$o)." FROM ".table($D));}if($fe&&$_POST["triggers"]&&$Q&&($Ei=trigger_sql($D)))echo"\nDELIMITER ;;\n$Ei\nDELIMITER ;\n";if($Qc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$k/")."$D.csv",$qi);}elseif($fe)echo"\n";}}if(function_exists('foreign_keys_sql')){foreach(table_status('',true)as$D=>$R){$Q=(DB==""||in_array($D,(array)$_POST["tables"]));if($Q&&!is_view($R))echo
foreign_keys_sql($D);}}foreach($ej
as$dj)$b->dumpTable($dj,$_POST["table_style"],1);if($Qc=="tar")echo
pack("x512");}}}if($fe)echo"-- ".$g->result("SELECT NOW()")."\n";exit;}page_header(lang(74),$m,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
';$Xb=array('','USE','DROP+CREATE','CREATE');$Yh=array('','DROP+CREATE','CREATE');$Tb=array('','TRUNCATE+INSERT','INSERT');if($x=="sql")$Tb[]='INSERT+UPDATE';parse_str($_COOKIE["adminer_export"],$J);if(!$J)$J=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($J["events"])){$J["routines"]=$J["events"]=($_GET["dump"]=="");$J["triggers"]=$J["table_style"];}echo"<tr><th>".lang(141)."<td>".html_select("output",$b->dumpOutput(),$J["output"],0)."\n";echo"<tr><th>".lang(142)."<td>".html_select("format",$b->dumpFormat(),$J["format"],0)."\n";echo($x=="sqlite"?"":"<tr><th>".lang(37)."<td>".html_select('db_style',$Xb,$J["db_style"]).(support("routine")?checkbox("routines",1,$J["routines"],lang(143)):"").(support("event")?checkbox("events",1,$J["events"],lang(144)):"")),"<tr><th>".lang(123)."<td>".html_select('table_style',$Yh,$J["table_style"]).checkbox("auto_increment",1,$J["auto_increment"],lang(52)).(support("trigger")?checkbox("triggers",1,$J["triggers"],lang(138)):""),"<tr><th>".lang(145)."<td>".html_select('data_style',$Tb,$J["data_style"]),'</table>
<p><input type="submit" value="',lang(74),'">
<input type="hidden" name="token" value="',$ti,'">

<table cellspacing="0">
',script("qsl('table').onclick = dumpClick;");$pg=array();if(DB!=""){$eb=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$eb>".lang(123)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(145)."<input type='checkbox' id='check-data'$eb></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$ej="";$Zh=tables_list();foreach($Zh
as$D=>$T){$og=preg_replace('~_.*~','',$D);$eb=($a==""||$a==(substr($a,-1)=="%"?"$og%":$D));$sg="<tr><td>".checkbox("tables[]",$D,$eb,$D,"","block");if($T!==null&&!preg_match('~table~i',$T))$ej.="$sg\n";else
echo"$sg<td align='right'><label class='block'><span id='Rows-".h($D)."'></span>".checkbox("data[]",$D,$eb)."</label>\n";$pg[$og]++;}echo$ej;if($Zh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(37)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$j=$b->databases();if($j){foreach($j
as$k){if(!information_schema($k)){$og=preg_replace('~_.*~','',$k);echo"<tr><td>".checkbox("databases[]",$k,$a==""||$a=="$og%",$k,"","block")."\n";$pg[$og]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$dd=true;foreach($pg
as$y=>$X){if($y!=""&&$X>1){echo($dd?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$y%")."'>".h($y)."</a>";$dd=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(72));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(146)."</a>";$H=$g->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$sd=$H;if(!$H)$H=$g->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo"<input type='hidden' name='db' value='".h(DB)."'>\n",($sd?"":"<input type='hidden' name='grant' value=''>\n"),"<table cellspacing='0'>\n","<thead><tr><th>".lang(35)."<th>".lang(34)."<th></thead>\n";while($J=$H->fetch_assoc())echo'<tr'.odd().'><td>'.h($J["User"])."<td>".h($J["Host"]).'<td><a href="'.h(ME.'user='.urlencode($J["User"]).'&host='.urlencode($J["Host"])).'">'.lang(10)."</a>\n";if(!$sd||DB!="")echo"<tr".odd()."><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$m&&$_POST["export"]){dump_headers("sql");$b->dumpTable("","");$b->dumpData("","table",$_POST["query"]);exit;}restart_session();$Fd=&get_session("queries");$Ed=&$Fd[DB];if(!$m&&$_POST["clear"]){$Ed=array();adminer_redirect(remove_from_uri("history"));}page_header((isset($_GET["import"])?lang(73):lang(65)),$m);if(!$m&&$_POST){$pd=false;if(!isset($_GET["import"]))$G=$_POST["query"];elseif($_POST["webfile"]){$Eh=$b->importServerPath();$pd=@fopen((file_exists($Eh)?$Eh:"compress.zlib://$Eh.gz"),"rb");$G=($pd?fread($pd,1e6):false);}else$G=get_file("sql_file",true);if(is_string($G)){if(function_exists('memory_get_usage'))@ini_set("memory_limit",max(ini_bytes("memory_limit"),2*strlen($G)+memory_get_usage()+8e6));if($G!=""&&strlen($G)<1e6){$_g=$G.(preg_match("~;[ \t\r\n]*\$~",$G)?"":";");if(!$Ed||reset(end($Ed))!=$_g){restart_session();$Ed[]=array($_g,time());set_session("queries",$Fd);stop_session();}}$Bh="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$ec=";";$mf=0;$Ac=true;$h=connect();if(is_object($h)&&DB!=""){$h->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$h);}$tb=0;$Fc=array();$Vf='[\'"'.($x=="sql"?'`#':($x=="sqlite"?'`[':($x=="mssql"?'[':''))).']|/\*|-- |$'.($x=="pgsql"?'|\$[^$]*\$':'');$vi=microtime(true);parse_str($_COOKIE["adminer_export"],$za);$sc=$b->dumpFormat();unset($sc["sql"]);while($G!=""){if(!$mf&&preg_match("~^$Bh*+DELIMITER\\s+(\\S+)~i",$G,$C)){$ec=$C[1];$G=substr($G,strlen($C[0]));}else{preg_match('('.preg_quote($ec)."\\s*|$Vf)",$G,$C,PREG_OFFSET_CAPTURE,$mf);list($nd,$kg)=$C[0];if(!$nd&&$pd&&!feof($pd))$G.=fread($pd,1e5);else{if(!$nd&&rtrim($G)=="")break;$mf=$kg+strlen($nd);if($nd&&rtrim($nd)!=$ec){while(preg_match('('.($nd=='/*'?'\*/':($nd=='['?']':(preg_match('~^-- |^#~',$nd)?"\n":preg_quote($nd)."|\\\\."))).'|$)s',$G,$C,PREG_OFFSET_CAPTURE,$mf)){$dh=$C[0][0];if(!$dh&&$pd&&!feof($pd))$G.=fread($pd,1e5);else{$mf=$C[0][1]+strlen($dh);if($dh[0]!="\\")break;}}}else{$Ac=false;$_g=substr($G,0,$kg);$tb++;$sg="<pre id='sql-$tb'><code class='jush-$x'>".$b->sqlCommandQuery($_g)."</code></pre>\n";$sg.=generate_linksbar(["<a href='#' class='copy-to-clipboard'>".lang(47)."</a>"]);if($x=="sqlite"&&preg_match("~^$Bh*+ATTACH\\b~i",$_g,$C)){echo$sg,"<p class='error'>".lang(147)."\n";$Fc[]=" <a href='#sql-$tb'>$tb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$sg;ob_flush();flush();}$Ih=microtime(true);if($g->multi_query($_g)&&is_object($h)&&preg_match("~^$Bh*+USE\\b~i",$_g))$h->query($_g);do{$H=$g->store_result();if($g->error){echo($_POST["only_errors"]?$sg:""),"<p class='error'>".lang(148).($g->errno?" ($g->errno)":"").": ".adminer_error()."\n";$Fc[]=" <a href='#sql-$tb'>$tb</a>";if($_POST["error_stops"])break
2;}else{$ji=" <span class='time'>(".adminer_format_time($Ih).")</span>".(strlen($_g)<1000?" <a href='".h(ME)."sql=".urlencode(trim($_g))."'>".lang(10)."</a>":"");$Aa=$g->affected_rows;$hj=($_POST["only_errors"]?"":$l->warnings());$ij="warnings-$tb";if($hj)$ji.=", <a href='#$ij'>".lang(46)."</a>".script("qsl('a').onclick = partial(toggle, '$ij');","");$Nc=null;$Oc="explain-$tb";if(is_object($H)){$z=$_POST["limit"];$Hf=select($H,$h,array(),$z);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$if=$H->num_rows;echo"<p>".($if?($z&&$if>$z?lang(149,$z):"").lang(150,$if):""),$ji;if($h&&preg_match("~^($Bh|\\()*+SELECT\\b~i",$_g)&&($Nc=explain($h,$_g)))echo", <a href='#$Oc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Oc');","");$t="export-$tb";echo", <a href='#$t'>".lang(74)."</a>".script("qsl('a').onclick = partial(toggle, '$t');","")."<span id='$t' class='hidden'>: ".html_select("output",$b->dumpOutput(),$za["output"])." ".html_select("format",$sc,$za["format"])."<input type='hidden' name='query' value='".h($_g)."'>"." <input type='submit' name='export' value='".lang(74)."'><input type='hidden' name='token' value='$ti'></span>\n"."</form>\n";}}else{if(preg_match("~^$Bh*+(CREATE|DROP|ALTER)$Bh++(DATABASE|SCHEMA)\\b~i",$_g)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h($g->info)."'>".lang(151,$Aa)."$ji\n";}echo($hj?"<div id='$ij' class='hidden'>\n$hj</div>\n":"");if($Nc){echo"<div id='$Oc' class='hidden'>\n";select($Nc,$h,$Hf);echo"</div>\n";}}$Ih=microtime(true);}while($g->next_result());}$G=substr($G,$mf);$mf=0;}}}}if($Ac)echo"<p class='message'>".lang(152)."\n";elseif($_POST["only_errors"]){echo"<p class='message'>".lang(153,$tb-count($Fc))," <span class='time'>(".adminer_format_time($vi).")</span>\n";}elseif($Fc&&$tb>1)echo"<p class='error'>".lang(148).": ".implode("",$Fc)."\n";}else
echo"<p class='error'>".upload_error($G)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Lc="<input type='submit' value='".lang(154)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$_g=$_GET["sql"];if($_POST)$_g=$_POST["query"];elseif($_GET["history"]=="all")$_g=$Ed;elseif($_GET["history"]!="")$_g=$Ed[$_GET["history"]][0];echo"<p>";textarea("query",$_g,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>$Lc\n",lang(155).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(156)."</legend><div>";$yd=(extension_loaded("zlib")?"[.gz]":"");echo(ini_bool("file_uploads")?"SQL$yd (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n$Lc":lang(157)),"</div></fieldset>\n";$Md=$b->importServerPath();if($Md){echo"<fieldset><legend>".lang(158)."</legend><div>",lang(159,"<code>".h($Md)."$yd</code>"),' <input type="submit" name="webfile" value="'.lang(160).'">',"</div></fieldset>\n";}echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(161))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(162))."\n","<input type='hidden' name='token' value='$ti'>\n";if(!isset($_GET["import"])&&$Ed){print_fieldset("history",lang(163),$_GET["history"]!="");for($X=end($Ed);$X;$X=prev($Ed)){$y=key($Ed);list($_g,$ji,$wc)=$X;echo'<a href="'.h(ME."sql=&history=$y").'" class="edit" title="'.lang(10).'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$ji)."'>".@date("H:i:s",$ji)."</span>"." <code class='jush-$x'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace('~^(#|-- ).*~m','',$_g)))),80,"</code>").($wc?" <span class='time'>($wc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(164)."'>\n","<a href='".h(ME."sql=&history=all")."' class='edit-all' title='".lang(165)."'>".lang(165)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$o=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$o):""):where($_GET,$o));$Oi=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($o
as$D=>$n){if(!isset($n["privileges"][$Oi?"update":"insert"])||$b->fieldName($n)==""||$n["generated"])unset($o[$D]);}if($_POST&&!$m&&!isset($_GET["select"])){$B=$_POST["referer"];if($_POST["insert"])$B=($Oi?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$B))$B=ME."select=".urlencode($a);$w=indexes($a);$Ji=unique_array($_GET["where"],$w);$Cg="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($B,lang(166),$l->delete($a,$Cg,!$Ji));else{$N=array();foreach($o
as$D=>$n){$X=process_input($n);if($X!==false&&$X!==null)$N[idf_escape($D)]=$X;}if($Oi){if(!$N)adminer_redirect($B);queries_redirect($B,lang(167),$l->update($a,$N,$Cg,!$Ji));if(is_ajax()){page_headers();page_messages($m);exit;}}else{$H=$l->insert($a,$N);$te=($H?last_id():0);queries_redirect($B,lang(168,($te?" $te":"")),$H);}}}$J=null;if($_POST["save"])$J=(array)$_POST["fields"];elseif($Z){$L=array();foreach($o
as$D=>$n){if(isset($n["privileges"]["select"])){$Ha=convert_field($n);if($_POST["clone"]&&$n["auto_increment"])$Ha="''";if($x=="sql"&&preg_match("~enum|set~",$n["type"]))$Ha="1*".idf_escape($D);$L[]=($Ha?"$Ha AS ":"").idf_escape($D);}}$J=array();if(!support("table"))$L=array("*");if($L){$H=$l->select($a,$L,array($Z),$L,array(),(isset($_GET["select"])?2:1));if(!$H)$m=adminer_error();else{$J=$H->fetch_assoc();if(!$J)$J=false;}if(isset($_GET["select"])&&(!$J||$H->fetch_assoc()))$J=null;}}if(!support("table")&&!$o){if(!$Z){$H=$l->select($a,array("*"),$Z,array("*"));$J=($H?$H->fetch_assoc():false);if(!$J)$J=array($l->primary=>"");}if($J){foreach($J
as$y=>$X){if(!$Z)$J[$y]=null;$o[$y]=array("field"=>$y,"null"=>($y!=$l->primary),"auto_increment"=>($y==$l->primary));}}}edit_form($a,$o,$J,$Oi);}elseif(isset($_GET["create"])){$a=$_GET["create"];$Xf=array();foreach(array('HASH','LINEAR HASH','KEY','LINEAR KEY','RANGE','LIST')as$y)$Xf[$y]=$y;$Jg=referencable_primary($a);$ld=array();foreach($Jg
as$Uh=>$n)$ld[str_replace("`","``",$Uh)."`".str_replace("`","``",$n["field"])]=$Uh;$Kf=array();$R=array();if($a!=""){$Kf=fields($a);$R=table_status($a);if(!$R)$m=lang(9);}$J=$_POST;$J["fields"]=(array)$J["fields"];if($J["auto_increment_col"])$J["fields"][$J["auto_increment_col"]]["auto_increment"]=true;if($_POST)set_adminer_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($J["fields"])&&!$m){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(169),drop_tables(array($a)));else{$o=array();$Ea=array();$Si=false;$jd=array();$Jf=reset($Kf);$Ca=" FIRST";foreach($J["fields"]as$y=>$n){$q=$ld[$n["type"]];$Fi=($q!==null?$Jg[$q]:$n);if($n["field"]!=""){if(!$n["has_default"])$n["default"]=null;if($y==$J["auto_increment_col"])$n["auto_increment"]=true;$xg=process_field($n,$Fi);$Ea[]=array($n["orig"],$xg,$Ca);if(!$Jf||$xg!=process_field($Jf,$Jf)){$o[]=array($n["orig"],$xg,$Ca);if($n["orig"]!=""||$Ca)$Si=true;}if($q!==null)$jd[idf_escape($n["field"])]=($a!=""&&$x!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$ld[$n["type"]],'source'=>array($n["field"]),'target'=>array($Fi["field"]),'on_delete'=>$n["on_delete"],));$Ca=" AFTER ".idf_escape($n["field"]);}elseif($n["orig"]!=""){$Si=true;$o[]=array($n["orig"]);}if($n["orig"]!=""){$Jf=next($Kf);if(!$Jf)$Ca="";}}$Zf="";if($Xf[$J["partition_by"]]){$ag=array();if($J["partition_by"]=='RANGE'||$J["partition_by"]=='LIST'){foreach(array_filter($J["partition_names"])as$y=>$X){$Y=$J["partition_values"][$y];$ag[]="\n  PARTITION ".idf_escape($X)." VALUES ".($J["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$Zf.="\nPARTITION BY $J[partition_by]($J[partition])".($ag?" (".implode(",",$ag)."\n)":($J["partitions"]?" PARTITIONS ".(+$J["partitions"]):""));}elseif(support("partitioning")&&preg_match("~partitioned~",$R["Create_options"]))$Zf.="\nREMOVE PARTITIONING";$Pe=lang(170);if($a==""){cookie("adminer_engine",$J["Engine"]);$Pe=lang(171);}$D=trim($J["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($D),$Pe,alter_table($a,$D,($x=="sqlite"&&($Si||$jd)?$Ea:$o),$jd,($J["Comment"]!=$R["Comment"]?$J["Comment"]:null),($J["Engine"]&&$J["Engine"]!=$R["Engine"]?$J["Engine"]:""),($J["Collation"]&&$J["Collation"]!=$R["Collation"]?$J["Collation"]:""),($J["Auto_increment"]!=""?number($J["Auto_increment"]):""),$Zf));}}page_header(($a!=""?lang(44):lang(75)),$m,array("table"=>$a),h($a));if(!$_POST){$J=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($U["int"])?"int":(isset($U["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$J=$R;$J["name"]=$a;$J["fields"]=array();if(!$_GET["auto_increment"])$J["Auto_increment"]="";foreach($Kf
as$n){$n["has_default"]=isset($n["default"]);$J["fields"][]=$n;}if(support("partitioning")){$qd="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($a);$H=$g->query("SELECT PARTITION_METHOD, PARTITION_ORDINAL_POSITION, PARTITION_EXPRESSION $qd ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");list($J["partition_by"],$J["partitions"],$J["partition"])=$H->fetch_row();$ag=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $qd AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$ag[""]="";$J["partition_names"]=array_keys($ag);$J["partition_values"]=array_values($ag);}}}$ob=collations();$Cc=engines();foreach($Cc
as$Bc){if(!strcasecmp($Bc,$J["Engine"])){$J["Engine"]=$Bc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(172),': <input name="name" data-maxlength="64" value="',h($J["name"]),'" autocapitalize="off">
';if($a==""&&!$_POST)echo
script("focus(qs('#form')['name']);");echo($Cc?"<select name='Engine'>".optionlist(array(""=>"(".lang(173).")")+$Cc,$J["Engine"])."</select>".on_help("getTarget(event).value",1).script("qsl('select').onchange = helpClose;"):""),' ',($ob&&!preg_match("~sqlite|mssql~",$x)?html_select("Collation",array(""=>"(".lang(101).")")+$ob,$J["Collation"]):""),' <input type="submit" value="',lang(14),'">
';}echo'
';if(support("columns")){echo'<div class="scrollable">
<table cellspacing="0" id="edit-fields" class="nowrap">
';edit_fields($J["fields"],$ob,"TABLE",$ld);echo'</table>
',script("editFields();"),'</div>
<p>
',lang(52),': <input type="number" name="Auto_increment" size="6" value="',h($J["Auto_increment"]),'">
',checkbox("defaults",1,($_POST?$_POST["defaults"]:adminer_setting("defaults")),lang(174),"columnShow(this.checked, 5)","jsonly");$wb=($_POST?$_POST["comments"]:adminer_setting("comments"));echo(support("comment")?checkbox("comments",1,$wb,lang(51),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$J["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($wb?"":" class='hidden'").">".h($J["Comment"])."</textarea>":'<input name="Comment" value="'.h($J["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($wb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$a));}if(support("partitioning")){$Yf=preg_match('~RANGE|LIST~',$J["partition_by"]);print_fieldset("partition",lang(176),$J["partition_by"]);echo'<p>
',"<select name='partition_by'>".optionlist(array(""=>"")+$Xf,$J["partition_by"])."</select>".on_help("getTarget(event).value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),'(<input name="partition" value="',h($J["partition"]),'">)
',lang(177),': <input type="number" name="partitions" class="size',($Yf||!$J["partition_by"]?" hidden":""),'" value="',h($J["partitions"]),'">
<table cellspacing="0" id="partition-table"',($Yf?"":" class='hidden'"),'>
<thead><tr><th>',lang(178),'<th>',lang(179),'</thead>
';foreach($J["partition_names"]as$y=>$X){echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($y==count($J["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h($J["partition_values"][$y]).'">';}echo'</table>
</div></fieldset>
';}echo'<input type="hidden" name="token" value="',$ti,'">
</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$Pd=array("PRIMARY","UNIQUE","INDEX");$R=table_status($a,true);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$R["Engine"]))$Pd[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$R["Engine"]))$Pd[]="SPATIAL";$w=indexes($a);$qg=array();if($x=="mongo"){$qg=$w["_id_"];unset($Pd[0]);unset($w["_id_"]);}$J=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["drop_col"]){$c=array();foreach($J["indexes"]as$v){$D=$v["name"];if(in_array($v["type"],$Pd)){$e=array();$ze=array();$gc=array();$N=array();ksort($v["columns"]);foreach($v["columns"]as$y=>$d){if($d!=""){$ye=$v["lengths"][$y];$fc=$v["descs"][$y];$N[]=idf_escape($d).($ye?"(".(+$ye).")":"").($fc?" DESC":"");$e[]=$d;$ze[]=($ye?$ye:null);$gc[]=$fc;}}if($e){$Mc=$w[$D];if($Mc){ksort($Mc["columns"]);ksort($Mc["lengths"]);ksort($Mc["descs"]);if($v["type"]==$Mc["type"]&&array_values($Mc["columns"])===$e&&(!$Mc["lengths"]||array_values($Mc["lengths"])===$ze)&&array_values($Mc["descs"])===$gc){unset($w[$D]);continue;}}$c[]=array($v["type"],$D,$N);}}}foreach($w
as$D=>$Mc)$c[]=array($Mc["type"],$D,"DROP");if(!$c)adminer_redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(180),alter_indexes($a,$c));}page_header(lang(132),$m,array("table"=>$a),h($a));$o=array_keys(fields($a));if($_POST["add"]){foreach($J["indexes"]as$y=>$v){if($v["columns"][count($v["columns"])]!="")$J["indexes"][$y]["columns"][]="";}$v=end($J["indexes"]);if($v["type"]||array_filter($v["columns"],'strlen'))$J["indexes"][]=array("columns"=>array(1=>""));}if(!$J){foreach($w
as$y=>$v){$w[$y]["name"]=$y;$w[$y]["columns"][]="";}$w[]=array("columns"=>array(1=>""));$J["indexes"]=$w;}echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
<thead><tr>
<th id="label-type">',lang(181),'<th><input type="submit" class="wayoff">',lang(182),'<th id="label-name">',lang(183),'<th><noscript>',"<input type='image' class='icon' name='add[0]' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.3")."' alt='+' title='".lang(108)."'>",'</noscript>
</thead>
';if($qg){echo"<tr><td>PRIMARY<td>";foreach($qg["columns"]as$y=>$d){echo
select_input(" disabled",$o,$d),"<label><input disabled type='checkbox'>".lang(60)."</label> ";}echo"<td><td>\n";}$ie=1;foreach($J["indexes"]as$v){if(!$_POST["drop_col"]||$ie!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$ie][type]",array(-1=>"")+$Pd,$v["type"],($ie==count($J["indexes"])?"indexesAddRow.call(this);":1),"label-type"),"<td>";ksort($v["columns"]);$s=1;foreach($v["columns"]as$y=>$d){echo"<span>".select_input(" name='indexes[$ie][columns][$s]' title='".lang(49)."'",($o?array_combine($o,$o):$o),$d,"partial(".($s==count($v["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape($x=="sql"?"":$_GET["indexes"]."_")."')"),($x=="sql"||$x=="mssql"?"<input type='number' name='indexes[$ie][lengths][$s]' class='size' value='".h($v["lengths"][$y])."' title='".lang(106)."'>":""),(support("descidx")?checkbox("indexes[$ie][descs][$s]",1,$v["descs"][$y],lang(60)):"")," </span>";$s++;}echo"<td><input name='indexes[$ie][name]' value='".h($v["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n","<td><input type='image' class='icon' name='drop_col[$ie]' src='".h(preg_replace("~\\?.*~","",ME)."?file=cross.gif&version=4.8.3")."' alt='x' title='".lang(111)."'>".script("qsl('input').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$ie++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
<input type="hidden" name="token" value="',$ti,'">
</form>
';}elseif(isset($_GET["database"])){$J=$_POST;if($_POST&&!$m&&!isset($_POST["add_x"])){$D=trim($J["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(184),drop_databases(array(DB)));}elseif(DB!==$D){if(DB!=""){$_GET["db"]=$D;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($D),lang(185),rename_database($D,$J["collation"]));}else{$j=explode("\n",str_replace("\r","",$D));$Oh=true;$se="";foreach($j
as$k){if(count($j)==1||$k!=""){if(!create_database($k,$J["collation"]))$Oh=false;$se=$k;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($se),lang(186),$Oh);}}else{if(!$J["collation"])adminer_redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($D).(preg_match('~^[a-z0-9_]+$~i',$J["collation"])?" COLLATE $J[collation]":""),substr(ME,0,-1),lang(187));}}page_header(DB!=""?lang(68):lang(115),$m,array(),h(DB));$ob=collations();$D=DB;if($_POST)$D=$J["name"];elseif(DB!="")$J["collation"]=db_collation(DB,$ob);elseif($x=="sql"){foreach(get_vals("SHOW GRANTS")as$sd){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$sd,$C)&&$C[1]){$D=stripcslashes(idf_unescape("`$C[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add_x"]||strpos($D,"\n")?'<textarea id="name" name="name" rows="10" cols="40">'.h($D).'</textarea><br>':'<input name="name" id="name" value="'.h($D).'" data-maxlength="64" autocapitalize="off">')."\n".($ob?html_select("collation",array(""=>"(".lang(101).")")+$ob,$J["collation"]).adminer_doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"ms187963.aspx",)):""),script("focus(qs('#name'));"),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(127)."'>".confirm(lang(175,DB))."\n";elseif(!$_POST["add_x"]&&$_GET["db"]=="")echo"<input type='image' class='icon' name='add' src='".h(preg_replace("~\\?.*~","",ME)."?file=plus.gif&version=4.8.3")."' alt='+' title='".lang(108)."'>\n";echo'<input type="hidden" name="token" value="',$ti,'">
</form>
';}elseif(isset($_GET["scheme"])){$J=$_POST;if($_POST&&!$m){$_=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$_,lang(188));else{$D=trim($J["name"]);$_.=urlencode($D);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($D),$_,lang(189));elseif($_GET["ns"]!=$D)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($D),$_,lang(190));else
adminer_redirect($_);}}page_header($_GET["ns"]!=""?lang(69):lang(70),$m);if(!$J)$J["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" id="name" value="',h($J["name"]),'" autocapitalize="off">
',script("focus(qs('#name'));"),'<input type="submit" value="',lang(14),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(127)."'>".confirm(lang(175,$_GET["ns"]))."\n";echo'<input type="hidden" name="token" value="',$ti,'">
</form>
';}elseif(isset($_GET["call"])){$da=($_GET["name"]?$_GET["name"]:$_GET["call"]);page_header(lang(191).": ".h($da),$m);$Zg=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Nd=array();$Of=array();foreach($Zg["fields"]as$s=>$n){if(substr($n["inout"],-3)=="OUT")$Of[$s]="@".idf_escape($n["field"])." AS ".idf_escape($n["field"]);if(!$n["inout"]||substr($n["inout"],0,2)=="IN")$Nd[]=$s;}if(!$m&&$_POST){$Za=array();foreach($Zg["fields"]as$y=>$n){if(in_array($y,$Nd)){$X=process_input($n);if($X===false)$X="''";if(isset($Of[$y]))$g->query("SET @".idf_escape($n["field"])." = $X");}$Za[]=(isset($Of[$y])?"@".idf_escape($n["field"]):$X);}$G=(isset($_GET["callf"])?"SELECT":"CALL")." ".table($da)."(".implode(", ",$Za).")";$Ih=microtime(true);$H=$g->multi_query($G);$Aa=$g->affected_rows;echo$b->selectQuery($G,$Ih,!$H);if(!$H)echo"<p class='error'>".adminer_error()."\n";else{$h=connect();if(is_object($h))$h->select_db(DB);do{$H=$g->store_result();if(is_object($H))select($H,$h);else
echo"<p class='message'>".lang(192,$Aa)." <span class='time'>".@date("H:i:s")."</span>\n";}while($g->next_result());if($Of)select($g->query("SELECT ".implode(", ",$Of)));}}echo'
<form action="" method="post">
';if($Nd){echo"<table cellspacing='0' class='layout'>\n";foreach($Nd
as$y){$n=$Zg["fields"][$y];$D=$n["field"];echo"<tr><th>".$b->fieldName($n);$Y=$_POST["fields"][$D];if($Y!=""){if($n["type"]=="enum")$Y=+$Y;if($n["type"]=="set")$Y=array_sum($Y);}input($n,$Y,(string)$_POST["function"][$D]);echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(191),'">
<input type="hidden" name="token" value="',$ti,'">
</form>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$D=$_GET["name"];$J=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){$Pe=($_POST["drop"]?lang(193):($D!=""?lang(194):lang(195)));$B=ME."table=".urlencode($a);if(!$_POST["drop"]){$J["source"]=array_filter($J["source"],'strlen');ksort($J["source"]);$ci=array();foreach($J["source"]as$y=>$X)$ci[$y]=$J["target"][$y];$J["target"]=$ci;}if($x=="sqlite")queries_redirect($B,$Pe,recreate_table($a,$a,array(),array(),array(" $D"=>($_POST["drop"]?"":" ".format_foreign_key($J)))));else{$c="ALTER TABLE ".table($a);$nc="\nDROP ".($x=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($D);if($_POST["drop"])query_redirect($c.$nc,$B,$Pe);else{query_redirect($c.($D!=""?"$nc,":"")."\nADD".format_foreign_key($J),$B,$Pe);$m=lang(196)."<br>$m";}}}page_header(lang(197),$m,array("table"=>$a),h($a));if($_POST){ksort($J["source"]);if($_POST["add"])$J["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$J["target"]=array();}elseif($D!=""){$ld=foreign_keys($a);$J=$ld[$D];$J["source"][]="";}else{$J["table"]=$a;$J["source"]=array("");}echo'
<form action="" method="post">
';$Ah=array_keys(fields($a));if($J["db"]!="")$g->select_db($J["db"]);if($J["ns"]!="")set_schema($J["ns"]);$Ig=array_keys(array_filter(table_status('',true),'fk_support'));$ci=array_keys(fields(in_array($J["table"],$Ig)?$J["table"]:reset($Ig)));$vf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p>".lang(198).": ".html_select("table",$Ig,$J["table"],$vf)."\n";if($x=="pgsql")echo
lang(78).": ".html_select("ns",$b->schemas(),$J["ns"]!=""?$J["ns"]:$_GET["ns"],$vf);elseif($x!="sqlite"){$Yb=array();foreach($b->databases()as$k){if(!information_schema($k))$Yb[]=$k;}echo
lang(77).": ".html_select("db",$Yb,$J["db"]!=""?$J["db"]:$_GET["db"],$vf);}echo'<input type="hidden" name="change-js" value="">
<noscript><p><input type="submit" name="change" value="',lang(199),'"></noscript>
<table cellspacing="0">
<thead><tr><th id="label-source">',lang(134),'<th id="label-target">',lang(135),'</thead>
';$ie=0;foreach($J["source"]as$y=>$X){echo"<tr>","<td>".html_select("source[".(+$y)."]",array(-1=>"")+$Ah,$X,($ie==count($J["source"])-1?"foreignAddRow.call(this);":1),"label-source"),"<td>".html_select("target[".(+$y)."]",$ci,$J["target"][$y],1,"label-target");$ie++;}echo'</table>
<p>
',lang(103),': ',html_select("on_delete",array(-1=>"")+explode("|",$uf),$J["on_delete"]),' ',lang(102),': ',html_select("on_update",array(-1=>"")+explode("|",$uf),$J["on_update"]),adminer_doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"ms174979.aspx",'oracle'=>"https://docs.oracle.com/cd/B19306_01/server.102/b14200/clauses002.htm#sthref2903",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(200),'"></noscript>
';if($D!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$D));}echo'<input type="hidden" name="token" value="',$ti,'">
</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$J=$_POST;$Lf="VIEW";if($x=="pgsql"&&$a!=""){$O=table_status($a);$Lf=strtoupper($O["Engine"]);}if($_POST&&!$m){$D=trim($J["name"]);$Ha=" AS\n$J[select]";$B=ME."table=".urlencode($D);$Pe=lang(201);$T=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$D&&$x!="sqlite"&&$T=="VIEW"&&$Lf=="VIEW")query_redirect(($x=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($D).$Ha,$B,$Pe);else{$ei=$D."_adminer_".uniqid();drop_create("DROP $Lf ".table($a),"CREATE $T ".table($D).$Ha,"DROP $T ".table($D),"CREATE $T ".table($ei).$Ha,"DROP $T ".table($ei),($_POST["drop"]?substr(ME,0,-1):$B),lang(202),$Pe,lang(203),$a,$D);}}if(!$_POST&&$a!=""){$J=view($a);$J["name"]=$a;$J["materialized"]=($Lf!="VIEW");if(!$m)$m=adminer_error();}page_header(($a!=""?lang(43):lang(204)),$m,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(183),': <input name="name" value="',h($J["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$J["materialized"],lang(129)):""),'<p>';textarea("select",$J["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$a));}echo'<input type="hidden" name="token" value="',$ti,'">
</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$ae=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$Kh=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$J=$_POST;if($_POST&&!$m){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(205));elseif(in_array($J["INTERVAL_FIELD"],$ae)&&isset($Kh[$J["STATUS"]])){$eh="\nON SCHEDULE ".($J["INTERVAL_VALUE"]?"EVERY ".q($J["INTERVAL_VALUE"])." $J[INTERVAL_FIELD]".($J["STARTS"]?" STARTS ".q($J["STARTS"]):"").($J["ENDS"]?" ENDS ".q($J["ENDS"]):""):"AT ".q($J["STARTS"]))." ON COMPLETION".($J["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(206):lang(207)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$eh.($aa!=$J["EVENT_NAME"]?"\nRENAME TO ".idf_escape($J["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($J["EVENT_NAME"]).$eh)."\n".$Kh[$J["STATUS"]]." COMMENT ".q($J["EVENT_COMMENT"]).rtrim(" DO\n$J[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(208).": ".h($aa):lang(209)),$m);if(!$J&&$aa!=""){$K=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$J=reset($K);}echo'
<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(183),'<td><input name="EVENT_NAME" value="',h($J["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(210),'<td><input name="STARTS" value="',h("$J[EXECUTE_AT]$J[STARTS]"),'">
<tr><th title="datetime">',lang(211),'<td><input name="ENDS" value="',h($J["ENDS"]),'">
<tr><th>',lang(212),'<td><input type="number" name="INTERVAL_VALUE" value="',h($J["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$ae,$J["INTERVAL_FIELD"]),'<tr><th>',lang(118),'<td>',html_select("STATUS",$Kh,$J["STATUS"]),'<tr><th>',lang(51),'<td><input name="EVENT_COMMENT" value="',h($J["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$J["ON_COMPLETION"]=="PRESERVE",lang(213)),'</table>
<p>';textarea("EVENT_DEFINITION",$J["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$aa));}echo'<input type="hidden" name="token" value="',$ti,'">
</form>
';}elseif(isset($_GET["procedure"])){$da=($_GET["name"]?$_GET["name"]:$_GET["procedure"]);$Zg=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$J=$_POST;$J["fields"]=(array)$J["fields"];if($_POST&&!process_fields($J["fields"])&&!$m){$If=routine($_GET["procedure"],$Zg);$ei="$J[name]_adminer_".uniqid();drop_create("DROP $Zg ".routine_id($da,$If),create_routine($Zg,$J),"DROP $Zg ".routine_id($J["name"],$J),create_routine($Zg,array("name"=>$ei)+$J),"DROP $Zg ".routine_id($ei,$J),substr(ME,0,-1),lang(214),lang(215),lang(216),$da,$J["name"]);}page_header(($da!=""?(isset($_GET["function"])?lang(217):lang(218)).": ".h($da):(isset($_GET["function"])?lang(219):lang(220))),$m);if(!$_POST&&$da!=""){$J=routine($_GET["procedure"],$Zg);$J["name"]=$da;}$ob=get_vals("SHOW CHARACTER SET");sort($ob);$ah=routine_languages();echo'
<form action="" method="post" id="form">
<p>',lang(183),': <input name="name" value="',h($J["name"]),'" data-maxlength="64" autocapitalize="off">
',($ah?lang(19).": ".html_select("language",$ah,$J["language"])."\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table cellspacing="0" class="nowrap">
';edit_fields($J["fields"],$ob,$Zg);if(isset($_GET["function"])){echo"<tr><td>".lang(221);edit_type("returns",$J["returns"],$ob,array(),($x=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$J["definition"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($da!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$da));}echo'<input type="hidden" name="token" value="',$ti,'">
</form>
';}elseif(isset($_GET["sequence"])){$fa=$_GET["sequence"];$J=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);$D=trim($J["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($fa),$_,lang(222));elseif($fa=="")query_redirect("CREATE SEQUENCE ".idf_escape($D),$_,lang(223));elseif($fa!=$D)query_redirect("ALTER SEQUENCE ".idf_escape($fa)." RENAME TO ".idf_escape($D),$_,lang(224));else
adminer_redirect($_);}page_header($fa!=""?lang(225).": ".h($fa):lang(226),$m);if(!$J)$J["name"]=$fa;echo'
<form action="" method="post">
<p><input name="name" value="',h($J["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($fa!="")echo"<input type='submit' name='drop' value='".lang(127)."'>".confirm(lang(175,$fa))."\n";echo'<input type="hidden" name="token" value="',$ti,'">
</form>
';}elseif(isset($_GET["type"])){$ga=$_GET["type"];$J=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($ga),$_,lang(227));else
query_redirect("CREATE TYPE ".idf_escape(trim($J["name"]))." $J[as]",$_,lang(228));}page_header($ga!=""?lang(229).": ".h($ga):lang(230),$m);if(!$J)$J["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($ga!="")echo"<input type='submit' name='drop' value='".lang(127)."'>".confirm(lang(175,$ga))."\n";else{echo"<input name='name' value='".h($J['name'])."' autocapitalize='off'>\n";textarea("as",$J["as"]);echo"<p><input type='submit' value='".lang(14)."'>\n";}echo'<input type="hidden" name="token" value="',$ti,'">
</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$D=$_GET["name"];$Di=trigger_options();$J=(array)trigger($D,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$m&&in_array($_POST["Timing"],$Di["Timing"])&&in_array($_POST["Event"],$Di["Event"])&&in_array($_POST["Type"],$Di["Type"])){$tf=" ON ".table($a);$nc="DROP TRIGGER ".idf_escape($D).($x=="pgsql"?$tf:"");$B=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($nc,$B,lang(231));else{if($D!="")queries($nc);queries_redirect($B,($D!=""?lang(232):lang(233)),queries(create_trigger($tf,$_POST)));if($D!="")queries(create_trigger($tf,$J+array("Type"=>reset($Di["Type"]))));}}$J=$_POST;}page_header(($D!=""?lang(234).": ".h($D):lang(235)),$m,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table cellspacing="0" class="layout">
<tr><th>',lang(236),'<td>',html_select("Timing",$Di["Timing"],$J["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(237),'<td>',html_select("Event",$Di["Event"],$J["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$Di["Event"])?" <input name='Of' value='".h($J["Of"])."' class='hidden'>":""),'<tr><th>',lang(50),'<td>',html_select("Type",$Di["Type"],$J["Type"]),'</table>
<p>',lang(183),': <input name="Trigger" value="',h($J["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$J["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($D!=""){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,$D));}echo'<input type="hidden" name="token" value="',$ti,'">
</form>
';}elseif(isset($_GET["user"])){$ha=$_GET["user"];$vg=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$J){foreach(explode(",",($J["Privilege"]=="Grant option"?"":$J["Context"]))as$Gb)$vg[$Gb][$J["Privilege"]]=$J["Comment"];}$vg["Server Admin"]+=$vg["File access on server"];$vg["Databases"]["Create routine"]=$vg["Procedures"]["Create routine"];unset($vg["Procedures"]["Create routine"]);$vg["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$vg["Columns"][$X]=$vg["Tables"][$X];unset($vg["Server Admin"]["Usage"]);foreach($vg["Tables"]as$y=>$X)unset($vg["Databases"][$y]);$cf=array();if($_POST){foreach($_POST["objects"]as$y=>$X)$cf[$X]=(array)$cf[$X]+(array)$_POST["grants"][$y];}$td=array();$rf="";if(isset($_GET["host"])&&($H=$g->query("SHOW GRANTS FOR ".q($ha)."@".q($_GET["host"])))){while($J=$H->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$J[0],$C)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$C[1],$He,PREG_SET_ORDER)){foreach($He
as$X){if($X[1]!="USAGE")$td["$C[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$J[0]))$td["$C[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$J[0],$C))$rf=$C[1];}}if($_POST&&!$m){$sf=(isset($_GET["host"])?q($ha)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $sf",ME."privileges=",lang(238));else{$ef=q($_POST["user"])."@".q($_POST["host"]);$cg=$_POST["pass"];if($cg!=''&&!$_POST["hashed"]&&!min_version(8)){$cg=$g->result("SELECT PASSWORD(".q($cg).")");$m=!$cg;}$Mb=false;if(!$m){if($sf!=$ef){$Mb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $ef IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($cg));$m=!$Mb;}elseif($cg!=$rf)queries("SET PASSWORD FOR $ef = ".q($cg));}if(!$m){$Wg=array();foreach($cf
as$kf=>$sd){if(isset($_GET["grant"]))$sd=array_filter($sd);$sd=array_keys($sd);if(isset($_GET["grant"]))$Wg=array_diff(array_keys(array_filter($cf[$kf],'strlen')),$sd);elseif($sf==$ef){$pf=array_keys((array)$td[$kf]);$Wg=array_diff($pf,$sd);$sd=array_diff($sd,$pf);unset($td[$kf]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$kf,$C)&&(!grant("REVOKE",$Wg,$C[2]," ON $C[1] FROM $ef")||!grant("GRANT",$sd,$C[2]," ON $C[1] TO $ef"))){$m=true;break;}}}if(!$m&&isset($_GET["host"])){if($sf!=$ef)queries("DROP USER $sf");elseif(!isset($_GET["grant"])){foreach($td
as$kf=>$Wg){if(preg_match('~^(.+)(\(.*\))?$~U',$kf,$C))grant("REVOKE",array_keys($Wg),$C[2]," ON $C[1] FROM $ef");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(239):lang(240)),!$m);if($Mb)$g->query("DROP USER $ef");}}page_header((isset($_GET["host"])?lang(35).": ".h("$ha@$_GET[host]"):lang(146)),$m,array("privileges"=>array('',lang(72))));if($_POST){$J=$_POST;$td=$cf;}else{$J=$_GET+array("host"=>$g->result("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$J["pass"]=$rf;if($rf!="")$J["hashed"]=true;$td[(DB==""||$td?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table cellspacing="0" class="layout">
<tr><th>',lang(34),'<td><input name="host" data-maxlength="60" value="',h($J["host"]),'" autocapitalize="off">
<tr><th>',lang(35),'<td><input name="user" data-maxlength="80" value="',h($J["user"]),'" autocapitalize="off">
<tr><th>',lang(36),'<td><input name="pass" id="pass" value="',h($J["pass"]),'" autocomplete="new-password">
';if(!$J["hashed"])echo
script("typePassword(qs('#pass'));");echo(min_version(8)?"":checkbox("hashed",1,$J["hashed"],lang(241),"typePassword(this.form['pass'], this.checked);")),'</table>

';echo"<table cellspacing='0'>\n","<thead><tr><th colspan='2'>".lang(72).adminer_doc_link(array('sql'=>"grant.html#priv_level"));$s=0;foreach($td
as$kf=>$sd){echo'<th>'.($kf!="*.*"?"<input name='objects[$s]' value='".h($kf)."' size='10' autocapitalize='off'>":"<input type='hidden' name='objects[$s]' value='*.*' size='10'>*.*");$s++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(34),"Databases"=>lang(37),"Tables"=>lang(131),"Columns"=>lang(49),"Procedures"=>lang(242),)as$Gb=>$fc){foreach((array)$vg[$Gb]as$ug=>$ub){echo"<tr".odd()."><td".($fc?">$fc<td":" colspan='2'").' lang="en" title="'.h($ub).'">'.h($ug);$s=0;foreach($td
as$kf=>$sd){$D="'grants[$s][".h(strtoupper($ug))."]'";$Y=$sd[strtoupper($ug)];if($Gb=="Server Admin"&&$kf!=(isset($td["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$D><option><option value='1'".($Y?" selected":"").">".lang(243)."<option value='0'".($Y=="0"?" selected":"").">".lang(244)."</select>";else{echo"<td align='center'><label class='block'>","<input type='checkbox' name=$D value='1'".($Y?" checked":"").($ug=="All privileges"?" id='grants-$s-all'>":">".($ug=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$s-all'); };"))),"</label>";}$s++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"])){echo'<input type="submit" name="drop" value="',lang(127),'">',confirm(lang(175,"$ha@$_GET[host]"));}echo'<input type="hidden" name="token" value="',$ti,'">
</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$m){$ne=0;foreach((array)$_POST["kill"]as$X){if(kill_process($X))$ne++;}queries_redirect(ME."processlist=",lang(245,$ne),$ne||!$_POST["kill"]);}}page_header(lang(116),$m);echo'
<form action="" method="post">
<div class="scrollable">
<table cellspacing="0" class="nowrap checkable">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$s=-1;foreach(process_list()as$s=>$J){if(!$s){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($J
as$y=>$X)echo"<th>$y".adminer_doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($y),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",));echo"</thead>\n";}echo"<tr".odd().">".(support("kill")?"<td>".checkbox("kill[]",$J[$x=="sql"?"Id":"pid"],0):"");foreach($J
as$y=>$X)echo"<td>".(($x=="sql"&&$y=="Info"&&preg_match("~Query|Killed~",$J["Command"])&&$X!="")||($x=="pgsql"&&$y=="current_query"&&$X!="<IDLE>")||($x=="oracle"&&$y=="sql_text"&&$X!="")?"<code class='jush-$x'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($J["db"]!=""?"db=".urlencode($J["db"])."&":"")."sql=".urlencode($X)).'">'.lang(246).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill")){echo($s+1)."/".lang(247,max_connections()),"<p><input type='submit' value='".lang(248)."'>\n";}echo'<input type="hidden" name="token" value="',$ti,'">
</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$R=table_status1($a);$w=indexes($a);$o=fields($a);$ld=column_foreign_keys($a);$nf=$R["Oid"];parse_str($_COOKIE["adminer_import"],$_a);$Xg=array();$e=array();$ii=null;foreach($o
as$y=>$n){$D=$b->fieldName($n);if(isset($n["privileges"]["select"])&&$D!=""){$e[$y]=html_entity_decode(strip_tags($D),ENT_QUOTES);if(is_shortable($n))$ii=$b->selectLengthProcess();}$Xg+=$n["privileges"];}list($L,$ud)=$b->selectColumnsProcess($e,$w);$ee=count($ud)<count($L)||strstr($L[0],"DISTINCT");$Z=$b->selectSearchProcess($o,$w);$Ef=$b->selectOrderProcess($o,$w);$z=$b->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$Ki=>$J){$Ha=convert_field($o[key($J)]);$L=array($Ha?$Ha:idf_escape(key($J)));$Z[]=where_check($Ki,$o);$I=$l->select($a,$L,$Z,$L);if($I)echo
reset($I->fetch_row());}exit;}$qg=$Mi=null;foreach($w
as$v){if($v["type"]=="PRIMARY"){$qg=array_flip($v["columns"]);$Mi=($L?$qg:array());foreach($Mi
as$y=>$X){if(in_array(idf_escape($y),$L))unset($Mi[$y]);}break;}}if($nf&&!$qg){$qg=$Mi=array($nf=>0);$w[]=array("type"=>"PRIMARY","columns"=>array($nf));}if($_POST&&!$m){$nj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$fb=array();foreach($_POST["check"]as$cb)$fb[]=where_check($cb,$o);$nj[]="((".implode(") OR (",$fb)."))";}$nj=($nj?"\nWHERE ".implode(" AND ",$nj):"");if($_POST["export"]){cookie("adminer_import","output=".urlencode($_POST["output"])."&format=".urlencode($_POST["format"]));dump_headers($a);$b->dumpTable($a,"");$qd=($L?implode(", ",$L):"*").convert_fields($e,$o,$L)."\nFROM ".table($a);$wd=($ud&&$ee?"\nGROUP BY ".implode(", ",$ud):"").($Ef?"\nORDER BY ".implode(", ",$Ef):"");if(!is_array($_POST["check"])||$qg)$G="SELECT $qd$nj$wd";else{$Ii=array();foreach($_POST["check"]as$X)$Ii[]="(SELECT".limit($qd,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o).$wd,1).")";$G=implode(" UNION ALL ",$Ii);}$b->dumpData($a,"table",$G);exit;}if(!$b->selectEmailProcess($Z,$ld)){if($_POST["save"]||$_POST["delete"]){$H=true;$Aa=0;$N=array();if(!$_POST["delete"]){foreach($e
as$D=>$X){$X=process_input($o[$D]);if($X!==null&&($_POST["clone"]||$X!==false))$N[idf_escape($D)]=($X!==false?$X:idf_escape($D));}}if($_POST["delete"]||$N){if($_POST["clone"])$G="INTO ".table($a)." (".implode(", ",array_keys($N)).")\nSELECT ".implode(", ",$N)."\nFROM ".table($a);if($_POST["all"]||($qg&&is_array($_POST["check"]))||$ee){$H=($_POST["delete"]?$l->delete($a,$nj):($_POST["clone"]?queries("INSERT $G$nj"):$l->update($a,$N,$nj)));$Aa=$g->affected_rows;}else{foreach((array)$_POST["check"]as$X){$jj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o);$H=($_POST["delete"]?$l->delete($a,$jj,1):($_POST["clone"]?queries("INSERT".limit1($a,$G,$jj)):$l->update($a,$N,$jj,1)));if(!$H)break;$Aa+=$g->affected_rows;}}}$Pe=lang(249,$Aa);if($_POST["clone"]&&$H&&$Aa==1){$te=last_id();if($te)$Pe=lang(168," $te");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$Pe,$H);if(!$_POST["delete"]){edit_form($a,$o,(array)$_POST["fields"],!$_POST["clone"]);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$m=lang(250);else{$H=true;$Aa=0;foreach($_POST["val"]as$Ki=>$J){$N=array();foreach($J
as$y=>$X){$y=bracket_escape($y,1);$N[idf_escape($y)]=(preg_match('~char|text~',$o[$y]["type"])||$X!=""?$b->processInput($o[$y],$X):"NULL");}$H=$l->update($a,$N," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($Ki,$o),!$ee&&!$qg," ");if(!$H)break;$Aa+=$g->affected_rows;}queries_redirect(remove_from_uri(),lang(249,$Aa),$H);}}elseif(!is_string($bd=get_file("csv_file",true)))$m=upload_error($bd);elseif(!preg_match('~~u',$bd))$m=lang(251);else{cookie("adminer_import","output=".urlencode($_a["output"])."&format=".urlencode($_POST["separator"]));$H=true;$qb=array_keys($o);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$bd,$He);$Aa=count($He[0]);$l->begin();$nh=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$K=array();foreach($He[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$nh]*)$nh~",$X.$nh,$Ie);if(!$y&&!array_diff($Ie[1],$qb)){$qb=$Ie[1];$Aa--;}else{$N=array();foreach($Ie[1]as$s=>$lb)$N[idf_escape($qb[$s])]=($lb==""&&$o[$qb[$s]]["null"]?"NULL":q(str_replace('""','"',preg_replace('~^"|"$~','',$lb))));$K[]=$N;}}$H=(!$K||$l->insertUpdate($a,$K,$qg));if($H)$H=$l->commit();queries_redirect(remove_from_uri("page"),lang(252,$Aa),$H);$l->rollback();}}}$Uh=$b->tableName($R);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(54).": $Uh",$m);$N=null;if(isset($Xg["insert"])||!support("table")){$N="";foreach((array)$_GET["where"]as$X){if($ld[$X["col"]]&&count($ld[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&!preg_match('~[_%]~',$X["val"]))))$N.="&set".urlencode("[".bracket_escape($X["col"])."]")."=".urlencode($X["val"]);}}$b->selectLinks($R,$N);if(!$e&&support("table"))echo"<p class='error'>".lang(253).($o?".":": ".adminer_error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?'<input type="hidden" name="db" value="'.h(DB).'">'.(isset($_GET["ns"])?'<input type="hidden" name="ns" value="'.h($_GET["ns"]).'">':""):"");echo'<input type="hidden" name="select" value="'.h($a).'">',"</div>\n";$b->selectColumnsPrint($L,$e);$b->selectSearchPrint($Z,$e,$w);$b->selectOrderPrint($Ef,$e,$w);$b->selectLimitPrint($z);$b->selectLengthPrint($ii);$b->selectActionPrint($w);echo"</form>\n";$E=$_GET["page"];if($E=="last"){$od=$g->result(count_rows($a,$Z,$ee,$ud));$E=floor(max(0,$od-1)/$z);}$ih=$L;$vd=$ud;if(!$ih){$ih[]="*";$Hb=convert_fields($e,$o,$L);if($Hb)$ih[]=substr($Hb,2);}foreach($L
as$y=>$X){$n=$o[idf_unescape($X)];if($n&&($Ha=convert_field($n)))$ih[$y]="$Ha AS $X";}if(!$ee&&$Mi){foreach($Mi
as$y=>$X){$ih[]=idf_escape($y);if($vd)$vd[]=idf_escape($y);}}$H=$l->select($a,$ih,$Z,$vd,$Ef,$z,$E,true);if(!$H)echo"<p class='error'>".adminer_error()."\n";else{if($x=="mssql"&&$E)$H->seek($z*$E);$_c=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$K=array();while($J=$H->fetch_assoc()){if($E&&$x=="oracle")unset($J["RNUM"]);$K[]=$J;}if($_GET["page"]!="last"&&$z!=""&&$ud&&$ee&&$x=="sql")$od=$g->result(" SELECT FOUND_ROWS()");if(!$K)echo"<p class='message'>".lang(12)."\n";else{$Qa=$b->backwardKeys($a,$Uh);echo"<div class='scrollable'>","<table id='table' cellspacing='0' class='nowrap checkable'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$ud&&$L?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."' title='".lang(254)."' class='edit-all'>".lang(254)."</a>");$af=array();$rd=array();reset($L);$Eg=1;foreach($K[0]as$y=>$X){if(!isset($Mi[$y])){$X=$_GET["columns"][key($L)];$n=$o[$L?($X?$X["col"]:current($L)):$y];$D=($n?$b->fieldName($n,$Eg):($X["fun"]?"*":$y));if($D!=""){$Eg++;$af[$y]=$D;$d=idf_escape($y);$Id=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$fc="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($y))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});",""),'<a href="'.h($Id.($Ef[0]==$d||$Ef[0]==$y||(!$Ef&&$ee&&$ud[0]==$d)?$fc:'')).'">';echo
apply_sql_function($X["fun"],$D)."</a>";echo"<span class='column hidden'>","<a href='".h($Id.$fc)."' title='".lang(60)."' class='text'> ↓</a>";if(!$X["fun"]){echo'<a href="#fieldset-search" title="'.lang(57).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");}echo"</span>";}$rd[$y]=$X["fun"];next($L);}}$ze=array();if($_GET["modify"]){foreach($K
as$J){foreach($J
as$y=>$X)$ze[$y]=max($ze[$y],min(40,strlen(utf8_decode($X))));}}echo($Qa?"<th>".lang(255):"")."</thead>\n";if(is_ajax()){if($z%2==1&&$E%2==1)odd();ob_end_clean();}foreach($b->rowDescriptions($K,$ld)as$Ze=>$J){$Ji=unique_array($K[$Ze],$w);if(!$Ji){$Ji=array();foreach($K[$Ze]as$y=>$X){if(!preg_match('~^(COUNT\((\*|(DISTINCT )?`(?:[^`]|``)+`)\)|(AVG|GROUP_CONCAT|MAX|MIN|SUM)\(`(?:[^`]|``)+`\))$~',$y))$Ji[$y]=$X;}}$Ki="";foreach($Ji
as$y=>$X){if(($x=="sql"||$x=="pgsql")&&preg_match('~char|text|enum|set~',$o[$y]["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".($x!='sql'||preg_match("~^utf8~",$o[$y]["collation"])?$y:"CONVERT($y USING ".charset($g).")").")";$X=md5($X);}$Ki.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($y));}echo"<tr".odd().">".(!$ud&&$L?"":"<td>".checkbox("check[]",substr($Ki,1),in_array(substr($Ki,1),(array)$_POST["check"])).($ee||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$Ki)."' class='edit' title='".lang(256)."'>".lang(256)."</a>"));foreach($J
as$y=>$X){if(isset($af[$y])){$n=$o[$y];$X=$l->value($X,$n);if($X!=""&&(!isset($_c[$y])||$_c[$y]!=""))$_c[$y]=(is_mail($X)?$af[$y]:"");$_="";if(preg_match('~blob|bytea|raw|file~',$n["type"])&&$X!="")$_=ME.'download='.urlencode($a).'&field='.urlencode($y).$Ki;if(!$_&&$X!==null){foreach((array)$ld[$y]as$q){if(count($ld[$y])==1||end($q["source"])==$y){$_="";foreach($q["source"]as$s=>$Ah)$_.=where_link($s,$q["target"][$s],$K[$Ze][$Ah]);$_=($q["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($q["db"]),ME):ME).'select='.urlencode($q["table"]).$_;if($q["ns"])$_=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($q["ns"]),$_);if(count($q["source"])==1)break;}}}if($y=="COUNT(*)"){$_=ME."select=".urlencode($a);$s=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$Ji))$_.=where_link($s++,$W["col"],$W["val"],$W["op"]);}foreach($Ji
as$je=>$W)$_.=where_link($s++,$je,$W);}$X=select_value($X,$_,$n,$ii);$t=h("val[$Ki][".bracket_escape($y)."]");$Y=$_POST["val"][$Ki][bracket_escape($y)];$vc=!is_array($J[$y])&&is_utf8($X)&&$K[$Ze][$y]==$J[$y]&&!$rd[$y];$hi=preg_match('~text|lob~',$n["type"]);echo"<td id='$t'";if(($_GET["modify"]&&$vc)||$Y!==null){$zd=h($Y!==null?$Y:$J[$y]);echo">".($hi?"<textarea name='$t' cols='30' rows='".(substr_count($J[$y],"\n")+1)."'>$zd</textarea>":"<input name='$t' value='$zd' size='$ze[$y]'>");}else{$Ce=strpos($X,"<i>…</i>");echo" data-text='".($Ce?2:($hi?1:0))."'".($vc?"":" data-warning='".h(lang(257))."'").">$X</td>";}}}if($Qa)echo"<td>";$b->backwardKeysPrint($Qa,$K[$Ze]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($K||$E){$Kc=true;if($_GET["page"]!="last"){if($z==""||(count($K)<$z&&($K||!$E)))$od=($E?$E*$z:0)+count($K);elseif($x!="sql"||!$ee){$od=($ee?false:found_rows($R,$Z));if($od<max(1e4,2*($E+1)*$z))$od=reset(slow_query(count_rows($a,$Z,$ee,$ud)));else$Kc=false;}}$Sf=($z!=""&&($od===false||$od>$z||$E));if($Sf){echo(($od===false?count($K)+1:$od-$E*$z)>$z?'<p><a href="'.h(remove_from_uri("page")."&page=".($E+1)).'" class="loadmore">'.lang(258).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, ".(+$z).", '".lang(259)."…');",""):''),"\n";}}echo"<div class='footer'><div>\n";if($K||$E){if($Sf){$Ke=($od===false?$E+(count($K)>=$z?2:1):floor(($od-1)/$z));echo"<fieldset>";if($x!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(260)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(260)."', '".($E+1)."')); return false; };"),pagination(0,$E).($E>5?" …":"");for($s=max(1,$E-4);$s<min($Ke,$E+5);$s++)echo
pagination($s,$E);if($Ke>0){echo($E+5<$Ke?" …":""),($Kc&&$od!==false?pagination($Ke,$E):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$Ke'>".lang(261)."</a>");}}else{echo"<legend>".lang(260)."</legend>",pagination(0,$E).($E>1?" …":""),($E?pagination($E,$E):""),($Ke>$E?pagination($E+1,$E).($Ke>$E+1?" …":""):"");}echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(262)."</legend>";$kc=($Kc?"":"~ ").$od;echo
checkbox("all",1,0,($od!==false?($Kc?"":"~ ").lang(150,$od):""),"var checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$kc' : checked); selectCount('selected2', this.checked || !checked ? '$kc' : checked);")."\n","</fieldset>\n";if($b->selectCommandPrint()){echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(254),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(250).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(126),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(246),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';}$md=$b->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($md['sql']);break;}}if($md){print_fieldset("export",lang(74)." <span id='selected2'></span>");$Pf=$b->dumpOutput();echo($Pf?html_select("output",$Pf,$_a["output"])." ":""),html_select("format",$md,$_a["format"])," <input type='submit' name='export' value='".lang(74)."'>\n","</div></fieldset>\n";}$b->selectEmailPrint(array_filter($_c,'strlen'),$e);}echo"</div></div>\n";if($b->selectImportPrint()){echo"<div>","<a href='#import'>".lang(73)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import' class='hidden'>: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$_a["format"],1);echo" <input type='submit' name='import' value='".lang(73)."'>","</span>","</div>";}echo"<input type='hidden' name='token' value='$ti'>\n","</form>\n",(!$ud&&$L?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$O=isset($_GET["status"]);page_header($O?lang(118):lang(117));$aj=($O?show_status():show_variables());if(!$aj)echo"<p class='message'>".lang(12)."\n";else{echo"<table cellspacing='0'>\n";foreach($aj
as$y=>$X){echo"<tr>","<th><code class='jush-".$x.($O?"status":"set")."'>".h($y)."</code>","<td>".h($X);}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$Rh=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$D=>$R){json_row("Comment-$D",h($R["Comment"]));if(!is_view($R)){foreach(array("Engine","Collation")as$y)json_row("$y-$D",h($R[$y]));foreach($Rh+array("Auto_increment"=>0,"Rows"=>0)as$y=>$X){if($R[$y]!=""){$X=format_number($R[$y]);json_row("$y-$D",($y=="Rows"&&$X&&$R["Engine"]==($x=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($Rh[$y]))$Rh[$y]+=($R["Engine"]!="InnoDB"||$y!="Data_free"?$R[$y]:0);}elseif(array_key_exists($y,$R))json_row("$y-$D");}}}foreach($Rh
as$y=>$X)json_row("sum-$y",format_number($X));json_row("");}elseif($_GET["script"]=="kill")$g->query("KILL ".number($_POST["kill"]));else{foreach(count_tables($b->databases())as$k=>$X){json_row("tables-$k",$X);json_row("size-$k",db_size($k));}json_row("");}exit;}else{$ai=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($ai&&!$m&&!$_POST["search"]){$H=true;$Pe="";if($x=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$H=truncate_tables($_POST["tables"]);$Pe=lang(263);}elseif($_POST["move"]){$H=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Pe=lang(264);}elseif($_POST["copy"]){$H=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$Pe=lang(265);}elseif($_POST["drop"]){if($_POST["views"])$H=drop_views($_POST["views"]);if($H&&$_POST["tables"])$H=drop_tables($_POST["tables"]);$Pe=lang(266);}elseif($x!="sql"){$H=($x=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$Pe=lang(267);}elseif(!$_POST["tables"])$Pe=lang(9);elseif($H=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('idf_escape',$_POST["tables"])))){while($J=$H->fetch_assoc())$Pe.="<b>".h($J["Table"])."</b>: ".h($J["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$Pe,$H);}page_header(($_GET["ns"]==""?lang(37).": ".h(DB):lang(78).": ".h($_GET["ns"])),$m,true);if($b->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(268)."</h3>\n";$Zh=tables_list();if(!$Zh)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(269)." <span id='selected2'></span></legend><div>","<input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(57)."'>\n";if($b->operator_regexp!==null){echo"<p><label><input type='checkbox' name='regexp' value='1'".(empty($_POST['regexp'])?'':' checked').'>'.lang(270).'</label>',adminer_doc_link(array('sql'=>'regexp.html','pgsql'=>'functions-matching.html#FUNCTIONS-POSIX-REGEXP'))."</p>\n";}echo"</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=$b->operator_regexp===null||empty($_POST['regexp'])?"LIKE %%":$b->operator_regexp;search_tables();}}echo"<div class='scrollable'>\n","<table cellspacing='0' class='nowrap checkable'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(131),'<td>'.lang(271).adminer_doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(122).adminer_doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(272).adminer_doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286')),'<td>'.lang(273).adminer_doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT')),'<td>'.lang(274).adminer_doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(52).adminer_doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(275).adminer_doc_link(array('sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286')),(support("comment")?'<td>'.lang(51).adminer_doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE')):''),"</thead>\n";$S=0;foreach($Zh
as$D=>$T){$dj=($T!==null&&!preg_match('~table|sequence~i',$T));$t=h("Table-".$D);echo'<tr'.odd().'><td>'.checkbox(($dj?"views[]":"tables[]"),$D,in_array($D,$ai,true),"","","",$t),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($D)."' title='".lang(42)."' id='$t'>".h($D).'</a>':h($D));if($dj){echo'<td colspan="6"><a href="'.h(ME)."view=".urlencode($D).'" title="'.lang(43).'">'.(preg_match('~materialized~i',$T)?lang(129):lang(130)).'</a>','<td align="right"><a href="'.h(ME)."select=".urlencode($D).'" title="'.lang(41).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(44)),"Index_length"=>array("indexes",lang(133)),"Data_free"=>array("edit",lang(45)),"Auto_increment"=>array("auto_increment=1&create",lang(44)),"Rows"=>array("select",lang(41)),)as$y=>$_){$t=" id='$y-".h($D)."'";echo($_?"<td align='right'>".(support("table")||$y=="Rows"||(support("indexes")&&$y!="Data_length")?"<a href='".h(ME."$_[0]=").urlencode($D)."'$t title='$_[1]'>?</a>":"<span$t>?</span>"):"<td id='$y-".h($D)."'>");}$S++;}echo(support("comment")?"<td id='Comment-".h($D)."'>":"");}echo"<tr><td><th>".lang(247,count($Zh)),"<td>".h($x=="sql"?$g->result("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$y)echo"<td align='right' id='sum-$y'>";echo"</table>\n","</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$Xi="<input type='submit' value='".lang(276)."'> ".on_help("'VACUUM'");$Af="<input type='submit' name='optimize' value='".lang(277)."'> ".on_help($x=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(126)." <span id='selected'></span></legend><div>".($x=="sqlite"?$Xi:($x=="pgsql"?$Xi.$Af:($x=="sql"?"<input type='submit' value='".lang(278)."'> ".on_help("'ANALYZE TABLE'").$Af."<input type='submit' name='check' value='".lang(279)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(280)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(281)."'> ".on_help($x=="sqlite"?"'DELETE'":"'TRUNCATE".($x=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(127)."'>".on_help("'DROP TABLE'").confirm()."\n";$j=(support("scheme")?$b->schemas():$b->databases());if(count($j)!=1&&$x!="sqlite"){$k=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo"<p>".lang(282).": ",($j?html_select("target",$j,$k):'<input name="target" value="'.h($k).'" autocapitalize="off">')," <input type='submit' name='move' value='".lang(283)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(284)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(285)):""),"\n";}echo"<input type='hidden' name='all' value=''>";echo
script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $S);":"")." }"),"<input type='hidden' name='token' value='$ti'>\n","</div></fieldset>\n","</div></div>\n";}echo"</form>\n",script("tableCheck();");}$A=[];$A[]="<a href='".h(ME)."create='>".lang(75)."</a>";if(support("view"))$A[]="<a href='".h(ME)."view='>".lang(204)."</a>";echo
generate_linksbar($A);if(support("routine")){echo"<h3 id='routines'>".lang(143)."</h3>\n";$bh=routines();if($bh){echo"<table cellspacing='0'>\n",'<thead><tr><th>'.lang(183).'<td>'.lang(50).'<td>'.lang(221)."<td></thead>\n";odd('');foreach($bh
as$J){$D=($J["SPECIFIC_NAME"]==$J["ROUTINE_NAME"]?"":"&name=".urlencode($J["ROUTINE_NAME"]));echo'<tr'.odd().'>','<th><a href="'.h(ME.($J["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($J["SPECIFIC_NAME"]).$D).'">'.h($J["ROUTINE_NAME"]).'</a>','<td>'.h($J["ROUTINE_TYPE"]),'<td>'.h($J["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($J["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($J["SPECIFIC_NAME"]).$D).'">'.lang(136)."</a>";}echo"</table>\n";}$A=[];if(support('procedure'))$A[]="<a href='".h(ME)."procedure='>".lang(220)."</a>";$A[]="<a href='".h(ME)."function='>".lang(219)."</a>";echo
generate_linksbar($A);}if(support("sequence")){echo"<h3 id='sequences'>".lang(286)."</h3>\n";$ph=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($ph){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(183)."</thead>\n";odd('');foreach($ph
as$X)echo"<tr".odd()."><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo
generate_linksbar(["<a href='".h(ME)."sequence='>".lang(226)."</a>"]);}if(support("type")){echo"<h3 id='user-types'>".lang(26)."</h3>\n";$Vi=types();if($Vi){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(183)."</thead>\n";odd('');foreach($Vi
as$X)echo"<tr".odd()."><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo
generate_linksbar(["<a href='".h(ME)."type='>".lang(230)."</a>"]);}if(support("event")){echo"<h3 id='events'>".lang(144)."</h3>\n";$K=get_rows("SHOW EVENTS");if($K){echo"<table cellspacing='0'>\n","<thead><tr><th>".lang(183)."<td>".lang(287)."<td>".lang(210)."<td>".lang(211)."<td></thead>\n";foreach($K
as$J){echo"<tr>","<th>".h($J["Name"]),"<td>".($J["Execute at"]?lang(288)."<td>".$J["Execute at"]:lang(212)." ".$J["Interval value"]." ".$J["Interval field"]."<td>$J[Starts]"),"<td>$J[Ends]",'<td><a href="'.h(ME).'event='.urlencode($J["Name"]).'">'.lang(136).'</a>';}echo"</table>\n";$Ic=$g->result("SELECT @@event_scheduler");if($Ic&&$Ic!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Ic)."\n";}echo
generate_linksbar(["<a href='".h(ME)."event='>".lang(209)."</a>"]);}if($Zh)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}}}page_footer();