/**
 * Controls a section of the overview page in the message drawer.
 *
 * @module     core_message/message_drawer_view_overview_section
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/message_drawer_view_overview_section",["jquery","core/custom_interaction_events","core/notification","core/pubsub","core/str","core/pending","core/templates","core/user_date","core_message/message_repository","core_message/message_drawer_events","core_message/message_drawer_router","core_message/message_drawer_routes","core_message/message_drawer_lazy_load_list","core_message/message_drawer_view_conversation_constants"],(function($,CustomEvents,Notification,PubSub,Str,Pending,Templates,UserDate,MessageRepository,MessageDrawerEvents,MessageDrawerRouter,MessageDrawerRoutes,LazyLoadList,MessageDrawerViewConversationContants){var SELECTORS_CONVERSATION="[data-conversation-id]",SELECTORS_BLOCKED_ICON_CONTAINER='[data-region="contact-icon-blocked"]',SELECTORS_MUTED_ICON_CONTAINER='[data-region="muted-icon-container"]',SELECTORS_UNREAD_COUNT='[data-region="unread-count"]',SELECTORS_SECTION_TOTAL_COUNT='[data-region="section-total-count"]',SELECTORS_SECTION_TOTAL_COUNT_CONTAINER='[data-region="section-total-count-container"]',SELECTORS_SECTION_UNREAD_COUNT='[data-region="section-unread-count"]',SELECTORS_SECTION_UNREAD_COUNT_CONTAINER='[data-region="section-unread-count-container"]',SELECTORS_PLACEHOLDER_CONTAINER='[data-region="placeholder-container"]',TEMPLATES_CONVERSATIONS_LIST="core_message/message_drawer_conversations_list",TEMPLATES_CONVERSATIONS_LIST_ITEMS_PLACEHOLDER="core_message/message_drawer_conversations_list_items_placeholder",loadedConversationsById={},deletedConversationsById={},loadedTotalCounts=!1,loadedUnreadCounts=!1,isVisible=function(root){return LazyLoadList.getRoot(root).hasClass("show")},setExpanded=function(root){root.addClass("expanded")},renderUnreadCount=function(root,count){var container=root.find(SELECTORS_SECTION_UNREAD_COUNT_CONTAINER);container.find(SELECTORS_SECTION_UNREAD_COUNT).text(count),Str.get_string("unreadconversations","core_message",count).done((function(string){$("#"+container.attr("aria-labelledby")).text(string)})),count>0?container.removeClass("hidden"):container.addClass("hidden")},formatConversationFromEvent=function(conversation){var recursivelyLowercaseKeys=function(object){return Object.keys(object).reduce((function(carry,key){return $.isArray(object[key])?carry[key.toLowerCase()]=object[key].map(recursivelyLowercaseKeys):carry[key.toLowerCase()]=object[key],carry}),{})},formatted=recursivelyLowercaseKeys(conversation);return formatted.messages=formatted.messages.map((function(message){return message.useridfrom=message.userfrom.id,message})),formatted},render=function(conversations,userId){var pending=new Pending,mapPromises=conversations.map((function(conversation){var lastMessage=conversation.messages.length?conversation.messages[conversation.messages.length-1]:null;return async function(lastMessage){if(!lastMessage)return null;var tmpElement=document.createElement("element");if(tmpElement.innerHTML=lastMessage.text.replace(/<img /g,"<noimg "),!tmpElement.querySelector("[src]")){var messagePreview=tmpElement.textContent||tmpElement.innerText||"";if(messagePreview&&-1==messagePreview.indexOf("<"))return messagePreview}var pix="i/messagecontentmultimediageneral",label="messagecontentmultimediageneral";lastMessage.text.includes("<img")?(pix="i/messagecontentimage",label="messagecontentimage"):lastMessage.text.includes("<video")?(pix="i/messagecontentvideo",label="messagecontentvideo"):lastMessage.text.includes("<audio")&&(pix="i/messagecontentaudio",label="messagecontentaudio");try{var labelString=await Str.get_string(label,"core_message");return await Templates.renderPix(pix,"core",labelString)+" "+labelString}catch(error){return Notification.exception(error),null}}(lastMessage).then((function(messagePreview){var formattedConversation={id:conversation.id,imageurl:conversation.imageurl,name:conversation.name,subname:conversation.subname,unreadcount:conversation.unreadcount,ismuted:conversation.ismuted,lastmessagedate:lastMessage?lastMessage.timecreated:null,sentfromcurrentuser:lastMessage?lastMessage.useridfrom==userId:null,lastmessage:messagePreview},otherUser=null;return conversation.type==MessageDrawerViewConversationContants.CONVERSATION_TYPES.SELF?otherUser=conversation.members[0]:conversation.type==MessageDrawerViewConversationContants.CONVERSATION_TYPES.PRIVATE&&(otherUser=conversation.members.reduce((function(carry,member){return carry||member.id==userId||(carry=member),carry}),null)),null!==otherUser&&(formattedConversation.userid=otherUser.id,formattedConversation.showonlinestatus=otherUser.showonlinestatus,formattedConversation.isonline=otherUser.isonline,formattedConversation.isblocked=otherUser.isblocked),conversation.type==MessageDrawerViewConversationContants.CONVERSATION_TYPES.PUBLIC&&(formattedConversation.lastsendername=conversation.members.reduce((function(carry,member){return!carry&&lastMessage&&member.id==lastMessage.useridfrom&&(carry=member.fullname),carry}),null)),formattedConversation})).catch(Notification.exception)}));return Promise.all(mapPromises).then((function(formattedConversations){return formattedConversations.forEach((function(conversation){(new Date).toDateString()==new Date(1e3*conversation.lastmessagedate).toDateString()&&(conversation.istoday=!0)})),Templates.render(TEMPLATES_CONVERSATIONS_LIST,{conversations:formattedConversations})})).then((function(html,js){return pending.resolve(),$.Deferred().resolve(html,js)})).catch((function(error){pending.resolve(),Notification.exception(error)}))},getTotalConversationCountElement=function(root){return root.find(SELECTORS_SECTION_TOTAL_COUNT)},decrementTotalUnreadConversationCount=function(root){if(loadedUnreadCounts){var element=function(root){return root.find(SELECTORS_SECTION_UNREAD_COUNT)}(root),count=parseInt(element.text());renderUnreadCount(root,count-=1)}},getConversationElement=function(root,conversationId){return root.find('[data-conversation-id="'+conversationId+'"]')},getConversationElementFromUserId=function(root,userId){return root.find('[data-user-id="'+userId+'"]')},createNewConversationFromEvent=function(root,conversation,userId){if(!root.find(SELECTORS_CONVERSATION).length){var listRoot=LazyLoadList.getRoot(root);LazyLoadList.showContent(listRoot),LazyLoadList.hideEmptyMessage(listRoot)}return loadedConversationsById[conversation.id]=conversation,render([conversation],userId).then((function(html){return LazyLoadList.getContentContainer(root).prepend(html)})).then((function(){return function(root){if(loadedTotalCounts){var element=getTotalConversationCountElement(root),count=parseInt(element.text());count+=1,element.text(count)}}(root)})).catch(Notification.exception)},deleteConversation=function(root,conversationElement){if(conversationElement.remove(),function(root){if(loadedTotalCounts){var element=getTotalConversationCountElement(root),count=parseInt(element.text());count-=1,element.text(count)}}(root),!root.find(SELECTORS_CONVERSATION).length){var listRoot=LazyLoadList.getRoot(root);LazyLoadList.hideContent(listRoot),LazyLoadList.showEmptyMessage(listRoot)}},registerEventListeners=function(namespace,root,loadCallback,types,includeFavourites,fromPanel){var listRoot=LazyLoadList.getRoot(root),conversationBelongsToThisSection=function(conversation){var conversationType=parseInt(conversation.type,10);return!(types&&types.indexOf(conversationType)<0||includeFavourites&&!conversation.isFavourite||!includeFavourites&&conversation.isFavourite)};root.on("show.bs.collapse",(function(){setExpanded(root),LazyLoadList.show(listRoot,loadCallback,(function(contentContainer,conversations,userId){return render(conversations,userId).then((function(html){return contentContainer.append(html),html})).catch(Notification.exception)}))})),root.on("hidden.bs.collapse",(function(){!function(root){root.removeClass("expanded")}(root)})),PubSub.subscribe(MessageDrawerEvents.CONTACT_BLOCKED,(function(userId){var conversationElement=getConversationElementFromUserId(root,userId);conversationElement.length&&function(conversationElement){conversationElement.find(SELECTORS_BLOCKED_ICON_CONTAINER).removeClass("hidden")}(conversationElement)})),PubSub.subscribe(MessageDrawerEvents.CONTACT_UNBLOCKED,(function(userId){var conversationElement=getConversationElementFromUserId(root,userId);conversationElement.length&&function(conversationElement){conversationElement.find(SELECTORS_BLOCKED_ICON_CONTAINER).addClass("hidden")}(conversationElement)})),PubSub.subscribe(MessageDrawerEvents.CONVERSATION_SET_MUTED,(function(conversation){var conversationId=conversation.id,conversationElement=getConversationElement(root,conversationId);conversationElement.length&&function(conversationElement){conversationElement.find(SELECTORS_MUTED_ICON_CONTAINER).removeClass("hidden")}(conversationElement)})),PubSub.subscribe(MessageDrawerEvents.CONVERSATION_UNSET_MUTED,(function(conversation){var conversationId=conversation.id,conversationElement=getConversationElement(root,conversationId);conversationElement.length&&function(conversationElement){conversationElement.find(SELECTORS_MUTED_ICON_CONTAINER).addClass("hidden")}(conversationElement)})),PubSub.subscribe(MessageDrawerEvents.CONVERSATION_NEW_LAST_MESSAGE,(function(conversation){if(conversationBelongsToThisSection(conversation)){var pendingPromise=new Pending("core_message/message_drawer_view_overview_section:new"),loggedInUserId=conversation.loggedInUserId,conversationId=conversation.id,element=getConversationElement(root,conversationId);if(conversation=formatConversationFromEvent(conversation),element.length){var contentContainer=LazyLoadList.getContentContainer(root);render([conversation],loggedInUserId).then((function(html){deletedConversationsById[conversationId]&&conversation.messages[0].timeadded<deletedConversationsById[conversationId]||(contentContainer.prepend(html),element.remove())})).then(pendingPromise.resolve).catch(Notification.exception)}else conversation.messages.length?createNewConversationFromEvent(root,conversation,loggedInUserId).then(pendingPromise.resolve).catch():pendingPromise.resolve()}})),PubSub.subscribe(MessageDrawerEvents.CONVERSATION_DELETED,(function(conversationId){var conversationElement=getConversationElement(root,conversationId);delete loadedConversationsById[conversationId],deletedConversationsById[conversationId]=new Date,conversationElement.length&&deleteConversation(root,conversationElement)})),PubSub.subscribe(MessageDrawerEvents.CONVERSATION_READ,(function(conversationId){var conversationElement=getConversationElement(root,conversationId);conversationElement.length&&function(root,conversationElement){var unreadCount=conversationElement.find(SELECTORS_UNREAD_COUNT);unreadCount.text("0"),unreadCount.addClass("hidden"),decrementTotalUnreadConversationCount(root)}(root,conversationElement)})),PubSub.subscribe(MessageDrawerEvents.CONVERSATION_SET_FAVOURITE,(function(conversation){var conversationElement=null;conversationBelongsToThisSection(conversation)?(conversationElement=getConversationElement(root,conversation.id)).length||createNewConversationFromEvent(root,formatConversationFromEvent(conversation),conversation.loggedInUserId):(conversationElement=getConversationElement(root,conversation.id)).length&&deleteConversation(root,conversationElement)})),PubSub.subscribe(MessageDrawerEvents.CONVERSATION_UNSET_FAVOURITE,(function(conversation){var conversationElement=null;conversationBelongsToThisSection(conversation)?(conversationElement=getConversationElement(root,conversation.id)).length||createNewConversationFromEvent(root,formatConversationFromEvent(conversation),conversation.loggedInUserId):(conversationElement=getConversationElement(root,conversation.id)).length&&deleteConversation(root,conversationElement)})),CustomEvents.define(root,[CustomEvents.events.activate]),root.on(CustomEvents.events.activate,SELECTORS_CONVERSATION,(function(e,data){var conversationId=$(e.target).closest(SELECTORS_CONVERSATION).attr("data-conversation-id"),conversation=loadedConversationsById[conversationId];MessageDrawerRouter.go(namespace,MessageDrawerRoutes.VIEW_CONVERSATION,conversation,fromPanel),data.originalEvent.preventDefault()}))};return{show:function(namespace,header,body,footer,types,includeFavourites,totalCountPromise,unreadCountPromise,fromPanel){var root=$(body);if(!root.attr("data-init")){var loadCallback=function(types,includeFavourites,offset){var type=null,includeSelfConversations=!0;if(types&&types.length){var nonSelfConversationTypes=types.filter((function(candidate){return candidate!=MessageDrawerViewConversationContants.CONVERSATION_TYPES.SELF}));includeSelfConversations=types.length!=nonSelfConversationTypes.length,type=nonSelfConversationTypes[0]}return function(root,userId){return MessageRepository.getConversations(userId,type,51,offset,includeFavourites,includeSelfConversations).then((function(response){var conversations=response.conversations;return conversations.length>50?conversations=conversations.slice(0,-1):LazyLoadList.setLoadedAll(root,!0),offset+=50,conversations.forEach((function(conversation){loadedConversationsById[conversation.id]=conversation})),conversations})).catch(Notification.exception)}}(types,includeFavourites,0);if(registerEventListeners(namespace,root,loadCallback,types,includeFavourites,fromPanel),isVisible(root)){setExpanded(root);var listRoot=LazyLoadList.getRoot(root);LazyLoadList.show(listRoot,loadCallback,(function(contentContainer,conversations,userId){return render(conversations,userId).then((function(html){return contentContainer.append(html),html})).catch(Notification.exception)}))}totalCountPromise.then((function(count){!function(root,count){var container=root.find(SELECTORS_SECTION_TOTAL_COUNT_CONTAINER);container.find(SELECTORS_SECTION_TOTAL_COUNT).text(count),container.removeClass("hidden"),Str.get_string("totalconversations","core_message",count).done((function(string){$("#"+container.attr("aria-labelledby")).text(string)}));var numPlaceholders=count>20?20:count,placeholders=Array.apply(null,Array(numPlaceholders)).map((function(){return!0}));Templates.render(TEMPLATES_CONVERSATIONS_LIST_ITEMS_PLACEHOLDER,{placeholders:placeholders}).then((function(html){root.find(SELECTORS_PLACEHOLDER_CONTAINER).html(html)})).catch((function(){}))}(root,count),loadedTotalCounts=!0})).catch((function(){})),unreadCountPromise.then((function(count){renderUnreadCount(root,count),loadedUnreadCounts=!0})).catch((function(){})),root.attr("data-init",!0)}},isVisible:isVisible}}));

//# sourceMappingURL=message_drawer_view_overview_section.min.js.map